/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.provider;

import android.util.Base64;
import androidx.annotation.ArrayRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.util.Preconditions;
import java.util.List;

public final class FontRequest {
    private final String mProviderAuthority;
    private final String mProviderPackage;
    private final String mQuery;
    private final List<List<byte[]>> mCertificates;
    private final int mCertificatesArray;
    private final String mIdentifier;

    public FontRequest(@NonNull String providerAuthority, @NonNull String providerPackage, @NonNull String query, @NonNull List<List<byte[]>> certificates) {
        this.mProviderAuthority = Preconditions.checkNotNull(providerAuthority);
        this.mProviderPackage = Preconditions.checkNotNull(providerPackage);
        this.mQuery = Preconditions.checkNotNull(query);
        this.mCertificates = Preconditions.checkNotNull(certificates);
        this.mCertificatesArray = 0;
        this.mIdentifier = this.createIdentifier(providerAuthority, providerPackage, query);
    }

    public FontRequest(@NonNull String providerAuthority, @NonNull String providerPackage, @NonNull String query, @ArrayRes int certificates) {
        this.mProviderAuthority = Preconditions.checkNotNull(providerAuthority);
        this.mProviderPackage = Preconditions.checkNotNull(providerPackage);
        this.mQuery = Preconditions.checkNotNull(query);
        this.mCertificates = null;
        Preconditions.checkArgument(certificates != 0);
        this.mCertificatesArray = certificates;
        this.mIdentifier = this.createIdentifier(providerAuthority, providerPackage, query);
    }

    private String createIdentifier(@NonNull String providerAuthority, @NonNull String providerPackage, @NonNull String query) {
        return providerAuthority + "-" + providerPackage + "-" + query;
    }

    @NonNull
    public String getProviderAuthority() {
        return this.mProviderAuthority;
    }

    @NonNull
    public String getProviderPackage() {
        return this.mProviderPackage;
    }

    @NonNull
    public String getQuery() {
        return this.mQuery;
    }

    @Nullable
    public List<List<byte[]>> getCertificates() {
        return this.mCertificates;
    }

    @ArrayRes
    public int getCertificatesArrayResId() {
        return this.mCertificatesArray;
    }

    @Deprecated
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public String getIdentifier() {
        return this.mIdentifier;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    String getId() {
        return this.mIdentifier;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FontRequest {mProviderAuthority: " + this.mProviderAuthority + ", mProviderPackage: " + this.mProviderPackage + ", mQuery: " + this.mQuery + ", mCertificates:");
        for (int i = 0; i < this.mCertificates.size(); ++i) {
            builder.append(" [");
            List<byte[]> set = this.mCertificates.get(i);
            for (int j = 0; j < set.size(); ++j) {
                builder.append(" \"");
                byte[] array = set.get(j);
                builder.append(Base64.encodeToString((byte[])array, (int)0));
                builder.append("\"");
            }
            builder.append(" ]");
        }
        builder.append("}");
        builder.append("mCertificatesArray: " + this.mCertificatesArray);
        return builder.toString();
    }
}

