/*
 * Decompiled with CFR 0.152.
 */
package tk.tcl.wish;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import java.lang.reflect.Method;
import java.util.List;
import java.util.UUID;
import tk.tcl.wish.BLE_API21;

public class BLEClient
extends BluetoothGattCallback
implements BluetoothAdapter.LeScanCallback {
    protected long id;
    protected int connected = 0;
    protected int rssi;
    protected int mtu;
    private Context context;
    private BluetoothAdapter btadap;
    private BluetoothGatt gatt;
    private Method wrchr33;
    private Method wrdesc33;

    public BLEClient(Context context, long id, String bdaddr, int autoConnect) {
        this.mtu = 23;
        this.rssi = -150;
        this.context = context;
        this.btadap = BluetoothAdapter.getDefaultAdapter();
        this.gatt = null;
        if (Build.VERSION.SDK_INT < 18) {
            throw new RuntimeException("unsupported API, need >= 18");
        }
        int state = this.btadap.getState();
        if (state != 12 && state != 11) {
            Log.e((String)"BLEClient", (String)"<init>: Bluetooth disabled");
            throw new RuntimeException("can't connect, Bluetooth disabled");
        }
        BluetoothDevice dev = null;
        try {
            dev = this.btadap.getRemoteDevice(bdaddr);
            this.id = id;
            this.gatt = dev.connectGatt(context, autoConnect != 0, (BluetoothGattCallback)this);
        }
        catch (Exception e) {
            Log.e((String)"BLEClient", (String)("<init>: " + e));
            this.gatt = null;
            this.connected = 0;
            this.id = 0L;
            throw new RuntimeException("can't connect");
        }
        Log.i((String)"BLEClient", (String)("<init>: " + bdaddr));
        if (this.connected == 1) {
            if (this.gatt.discoverServices()) {
                Log.i((String)"BLEClient", (String)"start discovery");
            } else {
                this.gatt.disconnect();
                this.connected = 0;
                Log.i((String)"BLEClient", (String)"no discovery, disconnect");
            }
        }
        this.wrchr33 = null;
        this.wrdesc33 = null;
        if (Build.VERSION.SDK_INT >= 33) {
            Class[] c;
            try {
                c = new Class[]{BluetoothGattCharacteristic.class, byte[].class, Integer.TYPE};
                this.wrchr33 = BluetoothGatt.class.getMethod("writeCharacteristic", c);
            }
            catch (Exception we) {
                Log.e((String)"BLEClient", (String)("API33 wrchr: " + we.toString()));
            }
            try {
                c = new Class[]{BluetoothGattDescriptor.class, byte[].class};
                this.wrdesc33 = BluetoothGatt.class.getMethod("writeDescriptor", c);
            }
            catch (Exception we) {
                Log.e((String)"BLEClient", (String)("API33 wrdesc: " + we.toString()));
            }
        }
    }

    public BLEClient(Context context, long id) {
        this.rssi = -150;
        this.context = context;
        this.btadap = BluetoothAdapter.getDefaultAdapter();
        this.gatt = null;
        if (Build.VERSION.SDK_INT < 18) {
            throw new RuntimeException("unsupported API, need >= 18");
        }
        this.id = id;
        Log.i((String)"BLEClient", (String)"<init>: for scanning");
    }

    public void disconnect() {
        if (this.gatt != null) {
            this.gatt.disconnect();
            this.connected = 0;
            Log.i((String)"BLEClient", (String)"disconnect");
        }
    }

    public void connect() {
        if (this.gatt != null && this.connected == 0) {
            int state = this.btadap.getState();
            if (state != 12 && state != 11) {
                Log.e((String)"BLEClient", (String)"connect: Bluetooth disabled");
                return;
            }
            this.gatt.connect();
            Log.i((String)"BLEClient", (String)"connect");
        }
    }

    public void close() {
        this.id = 0L;
        if (this.gatt != null) {
            this.gatt.disconnect();
            this.connected = 0;
            this.gatt.close();
            this.gatt = null;
            Log.i((String)"BLEClient", (String)"close");
        }
        this.stopScan();
    }

    public void startScan() {
        if (this.connected != 0 || this.gatt != null) {
            return;
        }
        int state = this.btadap.getState();
        if (state != 12 && state != 11) {
            Log.e((String)"BLEClient", (String)"not starting scanning: Bluetooth disabled");
            return;
        }
        if (this.btadap.startLeScan((BluetoothAdapter.LeScanCallback)this)) {
            this.connected = 3;
            Log.i((String)"BLEClient", (String)"start scanning");
            BLEClient.nativeNotify(this.id, 3, 0, 0);
        }
    }

    public void stopScan() {
        if (this.connected != 3 || this.gatt != null) {
            return;
        }
        this.btadap.stopLeScan((BluetoothAdapter.LeScanCallback)this);
        this.connected = 0;
        Log.i((String)"BLEClient", (String)"stop scanning");
        BLEClient.nativeNotify(this.id, 0, 0, 0);
    }

    public int requestMTU(int mtu) {
        boolean ret = false;
        if (Build.VERSION.SDK_INT >= 21) {
            ret = BLE_API21.requestMTU(this.gatt, mtu);
        }
        return ret ? 1 : 0;
    }

    public int getMTU() {
        return this.mtu;
    }

    public static int devpairing(int op, String bdaddr) {
        BluetoothAdapter btadap = BluetoothAdapter.getDefaultAdapter();
        if (btadap == null) {
            Log.e((String)"BLEClient", (String)"device pairing: no Bluetooth adapter");
            return -1;
        }
        BluetoothDevice dev = null;
        try {
            dev = btadap.getRemoteDevice(bdaddr);
        }
        catch (Exception e) {
            Log.e((String)"BLEClient", (String)("device pairing: no device for " + bdaddr));
            return -2;
        }
        if (dev == null) {
            Log.e((String)"BLEClient", (String)("device pairing: no device for " + bdaddr));
            return -3;
        }
        String name = op > 0 ? "createBond" : "removeBond";
        try {
            Method meth = dev.getClass().getMethod(name, null);
            meth.invoke((Object)dev, (Object[])null);
        }
        catch (Exception e) {
            Log.e((String)"BLEClient", (String)("device pairing: " + name + " on " + bdaddr + " failed"));
            return -4;
        }
        return 1;
    }

    static byte[] UUID2BA(UUID uuid) {
        int i;
        int k = 0;
        byte[] ba = new byte[16];
        long l = uuid.getMostSignificantBits();
        for (i = 56; i >= 0; i -= 8) {
            ba[k++] = (byte)(l >> i);
        }
        l = uuid.getLeastSignificantBits();
        for (i = 56; i >= 0; i -= 8) {
            ba[k++] = (byte)(l >> i);
        }
        return ba;
    }

    static UUID BA2UUID(byte[] ba) {
        long m = 0L;
        long l = 0L;
        int i = 0;
        while (i < 8) {
            m = m << 8 | (long)(ba[i++] & 0xFF);
        }
        while (i < 16) {
            l = l << 8 | (long)(ba[i++] & 0xFF);
        }
        return new UUID(m, l);
    }

    BluetoothGattCharacteristic findCharacteristic(byte[] svc_uuid, int svc_inst, byte[] chr_uuid, int chr_inst) {
        List chrs;
        if (svc_uuid == null || chr_uuid == null) {
            return null;
        }
        UUID suuid = BLEClient.BA2UUID(svc_uuid);
        UUID cuuid = BLEClient.BA2UUID(chr_uuid);
        List svcs = this.gatt.getServices();
        for (BluetoothGattService svc : svcs) {
            if (!svc.getUuid().equals(suuid) || svc.getInstanceId() != svc_inst) continue;
            chrs = svc.getCharacteristics();
            for (BluetoothGattCharacteristic chr : chrs) {
                if (!chr.getUuid().equals(cuuid) || chr.getInstanceId() != chr_inst) continue;
                return chr;
            }
            if (chr_inst != 0) continue;
            for (BluetoothGattCharacteristic chr : chrs) {
                if (!chr.getUuid().equals(cuuid)) continue;
                return chr;
            }
        }
        if (svc_inst == 0) {
            for (BluetoothGattService svc : svcs) {
                if (!svc.getUuid().equals(suuid)) continue;
                chrs = svc.getCharacteristics();
                for (BluetoothGattCharacteristic chr : chrs) {
                    if (!chr.getUuid().equals(cuuid)) continue;
                    return chr;
                }
            }
        }
        return null;
    }

    BluetoothGattDescriptor findDescriptor(byte[] svc_uuid, int svc_inst, byte[] chr_uuid, int chr_inst, byte[] desc_uuid) {
        if (desc_uuid == null) {
            return null;
        }
        BluetoothGattCharacteristic chr = this.findCharacteristic(svc_uuid, svc_inst, chr_uuid, chr_inst);
        if (chr == null) {
            return null;
        }
        UUID duuid = BLEClient.BA2UUID(desc_uuid);
        List descs = chr.getDescriptors();
        for (BluetoothGattDescriptor desc : descs) {
            if (!desc.getUuid().equals(duuid)) continue;
            return desc;
        }
        return null;
    }

    public int readCharacteristic(byte[] svc_uuid, int svc_inst, byte[] chr_uuid, int chr_inst) {
        if (this.gatt == null) {
            Log.e((String)"BLEClient", (String)"read chr, no gatt");
            return -1;
        }
        BluetoothGattCharacteristic chr = this.findCharacteristic(svc_uuid, svc_inst, chr_uuid, chr_inst);
        if (chr != null) {
            if (!this.gatt.readCharacteristic(chr)) {
                Log.e((String)"BLEClient", (String)"read chr, not done");
                return 0;
            }
            return 1;
        }
        Log.e((String)"BLEClient", (String)"read chr, no chr");
        return -1;
    }

    public int writeCharacteristic(byte[] svc_uuid, int svc_inst, byte[] chr_uuid, int chr_inst, byte[] value) {
        if (this.gatt == null) {
            Log.e((String)"BLEClient", (String)"write chr, no gatt");
            return -1;
        }
        BluetoothGattCharacteristic chr = this.findCharacteristic(svc_uuid, svc_inst, chr_uuid, chr_inst);
        if (chr != null) {
            if (this.wrchr33 != null) {
                try {
                    Integer r = (Integer)this.wrchr33.invoke((Object)this.gatt, chr, value, chr.getWriteType());
                    int i = r;
                    if (i == 0) {
                        return 1;
                    }
                    Log.e((String)"BLEClient", (String)("write chr, error " + i));
                    return 0;
                }
                catch (Exception e) {
                    Log.e((String)"BLEClient", (String)"write chr, no API33");
                }
            }
            chr.setValue(value);
            if (!this.gatt.writeCharacteristic(chr)) {
                Log.e((String)"BLEClient", (String)"write chr, not done");
                return 0;
            }
            return 1;
        }
        Log.e((String)"BLEClient", (String)"write chr, no chr");
        return -1;
    }

    public int writeCharacteristicWithType(byte[] svc_uuid, int svc_inst, byte[] chr_uuid, int chr_inst, int wrtype, byte[] value) {
        if (this.gatt == null) {
            Log.e((String)"BLEClient", (String)"write chr/type, no gatt");
            return -1;
        }
        BluetoothGattCharacteristic chr = this.findCharacteristic(svc_uuid, svc_inst, chr_uuid, chr_inst);
        if (chr != null) {
            if (this.wrchr33 != null) {
                try {
                    Integer r = (Integer)this.wrchr33.invoke((Object)this.gatt, chr, value, wrtype);
                    int i = r;
                    if (i == 0) {
                        return 1;
                    }
                    Log.e((String)"BLEClient", (String)("write chr/type, error " + i));
                    return 0;
                }
                catch (Exception e) {
                    Log.e((String)"BLEClient", (String)"write chr, no API33");
                }
            }
            chr.setWriteType(wrtype);
            chr.setValue(value);
            if (!this.gatt.writeCharacteristic(chr)) {
                Log.e((String)"BLEClient", (String)"write chr/type, not done");
                return 0;
            }
            return 1;
        }
        Log.e((String)"BLEClient", (String)"write chr/type, no chr");
        return -1;
    }

    public int notifyCharacteristic(byte[] svc_uuid, int svc_inst, byte[] chr_uuid, int chr_inst, int flag) {
        if (this.gatt == null) {
            Log.e((String)"BLEClient", (String)"notify chr, no gatt");
            return -1;
        }
        BluetoothGattCharacteristic chr = this.findCharacteristic(svc_uuid, svc_inst, chr_uuid, chr_inst);
        if (chr != null) {
            boolean ok = this.gatt.setCharacteristicNotification(chr, flag != 0);
            if (ok) {
                BluetoothGattDescriptor conf = chr.getDescriptor(UUID.fromString("00002902-0000-1000-8000-00805F9B34FB"));
                byte[] v = flag == 2 ? BluetoothGattDescriptor.ENABLE_INDICATION_VALUE : (flag != 0 ? BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE : BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE);
                if (conf != null) {
                    if (this.wrdesc33 != null) {
                        try {
                            Integer r = (Integer)this.wrdesc33.invoke((Object)this.gatt, conf, v);
                            int i = r;
                            boolean bl = ok = i == 0;
                            if (i != 0) {
                                Log.e((String)"BLEClient", (String)("notify chr, error " + i));
                            }
                            return ok ? 1 : 0;
                        }
                        catch (Exception e) {
                            Log.e((String)"BLEClient", (String)"notify chr, no API33");
                        }
                    }
                    if (ok = conf.setValue(v)) {
                        ok = this.gatt.writeDescriptor(conf);
                    }
                }
            }
            if (!ok) {
                Log.e((String)"BLEClient", (String)"notify chr, not done");
            }
            return ok ? 1 : 0;
        }
        Log.e((String)"BLEClient", (String)"notify chr, no chr");
        return -1;
    }

    public int readDescriptor(byte[] svc_uuid, int svc_inst, byte[] chr_uuid, int chr_inst, byte[] desc_uuid) {
        if (this.gatt == null) {
            Log.e((String)"BLEClient", (String)"read desc, no gatt");
            return -1;
        }
        BluetoothGattDescriptor desc = this.findDescriptor(svc_uuid, svc_inst, chr_uuid, chr_inst, desc_uuid);
        if (desc != null) {
            if (!this.gatt.readDescriptor(desc)) {
                Log.e((String)"BLEClient", (String)"read desc, not done");
                return 0;
            }
            return 1;
        }
        Log.e((String)"BLEClient", (String)"read desc, no desc");
        return -1;
    }

    public int writeDescriptor(byte[] svc_uuid, int svc_inst, byte[] chr_uuid, int chr_inst, byte[] desc_uuid, byte[] value) {
        if (this.gatt == null) {
            Log.e((String)"BLEClient", (String)"write desc, no gatt");
            return -1;
        }
        BluetoothGattDescriptor desc = this.findDescriptor(svc_uuid, svc_inst, chr_uuid, chr_inst, desc_uuid);
        if (desc != null) {
            if (this.wrdesc33 != null) {
                try {
                    Integer r = (Integer)this.wrdesc33.invoke((Object)this.gatt, desc, value);
                    int i = r;
                    if (i == 0) {
                        return 1;
                    }
                    Log.e((String)"BLEClient", (String)("write desc, error " + i));
                    return 0;
                }
                catch (Exception e) {
                    Log.e((String)"BLEClient", (String)"write desc, no API33");
                }
            }
            desc.setValue(value);
            if (!this.gatt.writeDescriptor(desc)) {
                Log.e((String)"BLEClient", (String)"write desc, not done");
                return 0;
            }
            return 1;
        }
        Log.e((String)"BLEClient", (String)"write desc, no desc");
        return -1;
    }

    public int writeTransaction(int op) {
        if (this.gatt == null || this.connected != 2) {
            return -1;
        }
        boolean ret = false;
        switch (op) {
            case 0: {
                ret = this.gatt.beginReliableWrite();
                break;
            }
            case 1: {
                ret = this.gatt.executeReliableWrite();
                break;
            }
            case 2: {
                this.gatt.abortReliableWrite();
                ret = true;
            }
            case 3: {
                ret = this.gatt.readRemoteRssi();
                break;
            }
            default: {
                return -1;
            }
        }
        return ret ? 1 : 0;
    }

    public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic chr, byte[] v) {
        BluetoothGattService svc = chr.getService();
        int len = v == null ? 0 : v.length;
        BLEClient.nativeSetCharacteristic(this.id, BLEClient.UUID2BA(svc.getUuid()), svc.getInstanceId(), BLEClient.UUID2BA(chr.getUuid()), chr.getInstanceId(), chr.getPermissions(), chr.getProperties(), chr.getWriteType(), 99, v, len, 0);
    }

    public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic chr) {
        BluetoothGattService svc = chr.getService();
        byte[] v = chr.getValue();
        int len = v == null ? 0 : v.length;
        BLEClient.nativeSetCharacteristic(this.id, BLEClient.UUID2BA(svc.getUuid()), svc.getInstanceId(), BLEClient.UUID2BA(chr.getUuid()), chr.getInstanceId(), chr.getPermissions(), chr.getProperties(), chr.getWriteType(), 99, v, len, 0);
    }

    public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic chr, byte[] v, int status) {
        BluetoothGattService svc = chr.getService();
        int len = v == null ? 0 : v.length;
        BLEClient.nativeSetCharacteristic(this.id, BLEClient.UUID2BA(svc.getUuid()), svc.getInstanceId(), BLEClient.UUID2BA(chr.getUuid()), chr.getInstanceId(), chr.getPermissions(), chr.getProperties(), chr.getWriteType(), 114, v, len, status);
    }

    public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic chr, int status) {
        BluetoothGattService svc = chr.getService();
        byte[] v = chr.getValue();
        int len = v == null ? 0 : v.length;
        BLEClient.nativeSetCharacteristic(this.id, BLEClient.UUID2BA(svc.getUuid()), svc.getInstanceId(), BLEClient.UUID2BA(chr.getUuid()), chr.getInstanceId(), chr.getPermissions(), chr.getProperties(), chr.getWriteType(), 114, v, len, status);
    }

    public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic chr, int status) {
        BluetoothGattService svc = chr.getService();
        byte[] v = chr.getValue();
        int len = v == null ? 0 : v.length;
        BLEClient.nativeSetCharacteristic(this.id, BLEClient.UUID2BA(svc.getUuid()), svc.getInstanceId(), BLEClient.UUID2BA(chr.getUuid()), chr.getInstanceId(), chr.getPermissions(), chr.getProperties(), chr.getWriteType(), 119, v, len, status);
    }

    public void onDescriptorRead(BluetoothGatt gatt, BluetoothGattDescriptor desc, int status, byte[] v) {
        BluetoothGattCharacteristic chr = desc.getCharacteristic();
        BluetoothGattService svc = chr.getService();
        int len = v == null ? 0 : v.length;
        BLEClient.nativeSetDescriptor(this.id, BLEClient.UUID2BA(svc.getUuid()), svc.getInstanceId(), BLEClient.UUID2BA(chr.getUuid()), chr.getInstanceId(), BLEClient.UUID2BA(desc.getUuid()), desc.getPermissions(), 114, v, len, status);
    }

    public void onDescriptorRead(BluetoothGatt gatt, BluetoothGattDescriptor desc, int status) {
        BluetoothGattCharacteristic chr = desc.getCharacteristic();
        BluetoothGattService svc = chr.getService();
        byte[] v = desc.getValue();
        int len = v == null ? 0 : v.length;
        BLEClient.nativeSetDescriptor(this.id, BLEClient.UUID2BA(svc.getUuid()), svc.getInstanceId(), BLEClient.UUID2BA(chr.getUuid()), chr.getInstanceId(), BLEClient.UUID2BA(desc.getUuid()), desc.getPermissions(), 114, v, len, status);
    }

    public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor desc, int status) {
        BluetoothGattCharacteristic chr = desc.getCharacteristic();
        BluetoothGattService svc = chr.getService();
        byte[] v = desc.getValue();
        int len = v == null ? 0 : v.length;
        BLEClient.nativeSetDescriptor(this.id, BLEClient.UUID2BA(svc.getUuid()), svc.getInstanceId(), BLEClient.UUID2BA(chr.getUuid()), chr.getInstanceId(), BLEClient.UUID2BA(desc.getUuid()), desc.getPermissions(), 119, v, len, status);
    }

    public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
        if (status != 0) {
            Log.e((String)"BLEClient", (String)("connection state change with error (" + status + "," + newState + ")"));
        }
        if (newState == 2) {
            this.connected = 1;
            if (gatt != null) {
                if (gatt.discoverServices()) {
                    Log.i((String)"BLEClient", (String)"connected, start discovery");
                } else {
                    this.disconnect();
                    this.connected = 0;
                    Log.i((String)"BLEClient", (String)"connected, disconnecting");
                }
            } else {
                Log.i((String)"BLEClient", (String)"connected");
            }
            BLEClient.nativeNotify(this.id, this.connected, this.rssi, status);
        } else if (newState == 0) {
            this.disconnect();
            BLEClient.nativeNotify(this.id, 0, this.rssi, status);
            Log.i((String)"BLEClient", (String)"disconnected");
        }
    }

    private void dumpChrDescr(BluetoothGattService svc, byte[] svc_uuid) {
        List chrs = svc.getCharacteristics();
        for (BluetoothGattCharacteristic chr : chrs) {
            byte[] chr_uuid = BLEClient.UUID2BA(chr.getUuid());
            byte[] v = chr.getValue();
            int len = v == null ? 0 : v.length;
            BLEClient.nativeSetCharacteristic(this.id, svc_uuid, svc.getInstanceId(), chr_uuid, chr.getInstanceId(), chr.getPermissions(), chr.getProperties(), chr.getWriteType(), 100, v, len, 0);
            List descs = chr.getDescriptors();
            for (BluetoothGattDescriptor desc : descs) {
                v = desc.getValue();
                len = v == null ? 0 : v.length;
                BLEClient.nativeSetDescriptor(this.id, svc_uuid, svc.getInstanceId(), chr_uuid, chr.getInstanceId(), BLEClient.UUID2BA(desc.getUuid()), desc.getPermissions(), 100, v, len, 0);
            }
        }
    }

    public void onServicesDiscovered(BluetoothGatt gatt, int status) {
        if (status == 0) {
            Log.i((String)"BLEClient", (String)"discovery finished");
            List svcs = gatt.getServices();
            for (BluetoothGattService svc : svcs) {
                byte[] svc_uuid = BLEClient.UUID2BA(svc.getUuid());
                BLEClient.nativeSetService(this.id, svc_uuid, svc.getInstanceId(), svc.getType());
                this.dumpChrDescr(svc, svc_uuid);
                for (BluetoothGattService subsvc : svc.getIncludedServices()) {
                    svc_uuid = BLEClient.UUID2BA(subsvc.getUuid());
                    BLEClient.nativeSetService(this.id, svc_uuid, subsvc.getInstanceId(), subsvc.getType());
                    this.dumpChrDescr(subsvc, svc_uuid);
                }
            }
            this.connected = 2;
        }
        BLEClient.nativeNotify(this.id, 2, this.rssi, status);
    }

    public void onReliableWriteCompleted(BluetoothGatt gatt, int status) {
        if (status == 0) {
            BLEClient.nativeNotify(this.id, 50, 0, status);
        } else {
            BLEClient.nativeNotify(this.id, 51, 0, status);
        }
    }

    public void onReadRemoteRssi(BluetoothGatt gatt, int rssi, int status) {
        this.rssi = rssi;
        BLEClient.nativeNotify(this.id, 4, this.rssi, status);
    }

    public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
        if (device != null) {
            Log.i((String)"BLEClient", (String)("scan callback: " + device.getAddress() + " " + device.getName()));
            int scanLen = scanRecord == null ? 0 : scanRecord.length;
            BLEClient.nativeScanResult(this.id, device.getAddress(), device.getName(), device.getType(), rssi, scanLen, scanRecord);
        }
    }

    public void onMtuChanged(BluetoothGatt gatt, int mtu, int status) {
        if (status == 0) {
            this.mtu = mtu;
            Log.i((String)"BLEClient", (String)("mtu changed: " + mtu + ", success"));
        } else {
            Log.i((String)"BLEClient", (String)("mtu changed: " + mtu + ", status: " + status));
        }
    }

    public void onPhyRead(BluetoothGatt gatt, int txphy, int rxphy, int status) {
        if (status == 0) {
            Log.i((String)"BLEClient", (String)("phy read: tx=" + txphy + " rx=" + rxphy));
        } else {
            Log.i((String)"BLEClient", (String)("phy read: failed=" + status));
        }
    }

    public void onPhyUpdate(BluetoothGatt gatt, int txphy, int rxphy, int status) {
        if (status == 0) {
            Log.i((String)"BLEClient", (String)("phy update: tx=" + txphy + " rx=" + rxphy));
        } else {
            Log.i((String)"BLEClient", (String)("phy update: failed=" + status));
        }
    }

    public void onServiceChanged(BluetoothGatt gatt) {
        if (gatt.discoverServices()) {
            Log.i((String)"BLEClient", (String)"start discovery");
        }
    }

    public static native void nativeNotify(long var0, int var2, int var3, int var4);

    public static native void nativeSetService(long var0, byte[] var2, int var3, int var4);

    public static native void nativeSetCharacteristic(long var0, byte[] var2, int var3, byte[] var4, int var5, int var6, int var7, int var8, int var9, byte[] var10, int var11, int var12);

    public static native void nativeSetDescriptor(long var0, byte[] var2, int var3, byte[] var4, int var5, byte[] var6, int var7, int var8, byte[] var9, int var10, int var11);

    public static native void nativeScanResult(long var0, String var2, String var3, int var4, int var5, int var6, byte[] var7);
}

