/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import tcl.lang.AssocData;
import tcl.lang.CObject;
import tcl.lang.Command;
import tcl.lang.Notifier;
import tcl.lang.PackageNameException;
import tcl.lang.TclBoolean;
import tcl.lang.TclClassLoader;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;
import tcl.lang.VarTrace;

public class Interp {
    private static boolean shlib_loaded = false;
    long interpPtr;
    HashMap reflectObjTable = new HashMap();
    long reflectObjCount = 0L;
    HashMap reflectConflictTable = new HashMap();
    private Notifier notifier;
    HashMap assocDataTab;
    HashMap[] importTable = new HashMap[]{new HashMap(), new HashMap()};
    ArrayList cobjCleanup = new ArrayList();
    Throwable pendingException = null;
    private Thread cThread;
    TclClassLoader classLoader = null;

    private static final synchronized void shlib_load() throws UnsatisfiedLinkError {
        System.loadLibrary("tclJBlend");
        Interp.commandComplete("");
        Interp.initName();
        shlib_loaded = true;
    }

    private static final native void initName();

    private Interp(long l) {
        if (!shlib_loaded) {
            Interp.shlib_load();
        }
        this.interpPtr = l;
        this.cThread = Thread.currentThread();
        this.notifier = Notifier.getNotifierForThread(this.cThread);
        this.notifier.preserve();
    }

    public Interp() {
        if (!shlib_loaded) {
            Interp.shlib_load();
        }
        this.interpPtr = this.create();
        this.cThread = Thread.currentThread();
        this.notifier = Notifier.getNotifierForThread(this.cThread);
        this.notifier.preserve();
        if (this.init(this.interpPtr) != 0) {
            String result = this.getResult().toString();
            this.dispose();
            throw new TclRuntimeError(result);
        }
    }

    private final native long create();

    public void dispose() {
        if (Thread.currentThread() != this.cThread) {
            throw new TclRuntimeError("Interp.dispose() invoked in thread other than the one it was created in");
        }
        if (this.assocDataTab != null) {
            Iterator iter = this.assocDataTab.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                AssocData data = (AssocData)entry.getValue();
                data.disposeAssocData(this);
                iter.remove();
            }
            this.assocDataTab = null;
        }
        if (this.notifier != null) {
            this.notifier.release();
            this.notifier = null;
        }
        if (this.interpPtr != 0L) {
            Interp.doDispose(this.interpPtr);
            this.interpPtr = 0L;
        }
        Notifier.finalizeThreadCheck();
    }

    protected void finalize() throws Throwable {
        if (this.notifier != null) {
            System.err.println("finalized interp has not been disposed");
        }
        super.finalize();
    }

    File getWorkingDir() {
        return new File(Util.getCwd());
    }

    public final native TclObject setVar(String var1, String var2, TclObject var3, int var4) throws TclException;

    public final TclObject setVar(String name, TclObject value, int flags) throws TclException {
        return this.setVar(name, null, value, flags | 0x400);
    }

    public final TclObject setVar(String name1, String name2, String strValue, int flags) throws TclException {
        return this.setVar(name1, name2, TclString.newInstance(strValue), flags);
    }

    public final TclObject setVar(String name1, String name2, int intValue, int flags) throws TclException {
        return this.setVar(name1, name2, TclInteger.newInstance(intValue), flags);
    }

    public final TclObject setVar(String name1, String name2, double dValue, int flags) throws TclException {
        return this.setVar(name1, name2, TclDouble.newInstance(dValue), flags);
    }

    public final TclObject setVar(String name1, String name2, boolean bValue, int flags) throws TclException {
        return this.setVar(name1, name2, TclBoolean.newInstance(bValue), flags);
    }

    public final native TclObject getVar(String var1, String var2, int var3) throws TclException;

    public final TclObject getVar(String name, int flags) throws TclException {
        return this.getVar(name, null, flags | 0x400);
    }

    public final void unsetVar(String name, int flags) throws TclException {
        this.unsetVar(name, null, flags | 0x400);
    }

    public final native void unsetVar(String var1, String var2, int var3) throws TclException;

    public void traceVar(String name, VarTrace trace, int flags) throws TclException {
        this.traceVar(name, null, trace, flags | 0x400);
    }

    public native void traceVar(String var1, String var2, VarTrace var3, int var4) throws TclException;

    public void untraceVar(String name, VarTrace trace, int flags) throws TclException {
        this.untraceVar(name, null, trace, flags | 0x400);
    }

    public native void untraceVar(String var1, String var2, VarTrace var3, int var4) throws TclException;

    public native void createCommand(String var1, Command var2);

    public native int deleteCommand(String var1);

    public native Command getCommand(String var1);

    public static native boolean commandComplete(String var0);

    public final native TclObject getResult();

    public final native void setResult(TclObject var1);

    public final void setResult(String r) {
        this.setResult(TclString.newInstance(r));
    }

    public final void setResult(double r) {
        this.setResult(TclDouble.newInstance(r));
    }

    public final native void setResult(int var1);

    public final native void setResult(boolean var1);

    public final native void resetResult();

    private native int evalString(String var1, int var2);

    private native int evalTclObject(long var1, String var3, int var4);

    public void eval(String script, int flags) throws TclException {
        this.pendingException = null;
        int ccode = this.evalString(script, flags);
        this.checkPendingException(ccode);
    }

    public void eval(String script) throws TclException {
        this.eval(script, 0);
    }

    public void eval(TclObject tobj, int flags) throws TclException {
        long objPtr = tobj.getCObjectPtr();
        String str = null;
        if (objPtr == 0L) {
            str = tobj.toString();
        }
        this.pendingException = null;
        tobj.preserve();
        int ccode = this.evalTclObject(objPtr, str, flags);
        tobj.release();
        this.checkPendingException(ccode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int callCommand(Command cmd, TclObject[] objv) {
        boolean debug = false;
        try {
            CObject.cleanupPush(this);
            this.pendingException = null;
            cmd.cmdProc(this, objv);
            int n = 0;
            return n;
        }
        catch (TclException e) {
            int ccode;
            this.pendingException = e;
            int n = ccode = e.getCompletionCode();
            return n;
        }
        catch (RuntimeException e) {
            this.pendingException = e;
            int n = 1;
            return n;
        }
        finally {
            CObject.cleanupPop(this);
        }
    }

    private void checkPendingException(int ccode) throws TclException, RuntimeException {
        boolean debug = false;
        if (this.pendingException != null) {
            if (this.pendingException instanceof TclException) {
                if (ccode != 0) {
                    TclException te = (TclException)this.pendingException;
                    this.pendingException = null;
                    throw te;
                }
            } else {
                if (this.pendingException instanceof RuntimeException) {
                    RuntimeException re = (RuntimeException)this.pendingException;
                    this.pendingException = null;
                    throw re;
                }
                this.pendingException = null;
                throw new TclRuntimeError("expected TclException or RuntimeException but got " + this.pendingException.getClass().getName() + ": " + this.pendingException.getMessage());
            }
        }
        if (ccode != 0) {
            String msg = this.getResult().toString();
            throw new TclException(null, msg, ccode);
        }
    }

    public native void setErrorCode(TclObject var1);

    public native void addErrorInfo(String var1);

    public native void backgroundError();

    public Notifier getNotifier() {
        return this.notifier;
    }

    public void setAssocData(String name, AssocData data) {
        if (this.assocDataTab == null) {
            this.assocDataTab = new HashMap();
        }
        this.assocDataTab.put(name, data);
    }

    public void deleteAssocData(String name) {
        if (this.assocDataTab == null) {
            return;
        }
        this.assocDataTab.remove(name);
    }

    public AssocData getAssocData(String name) {
        if (this.assocDataTab == null) {
            return null;
        }
        return (AssocData)this.assocDataTab.get(name);
    }

    private final native int init(long var1);

    private static final native void doDispose(long var0);

    public final native void pkgProvide(String var1, String var2);

    public final native String pkgRequire(String var1, String var2, boolean var3);

    native void createBTestCommand();

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            ClassLoader ctx = Thread.currentThread().getContextClassLoader();
            if (ctx == null) {
                ctx = Interp.class.getClassLoader();
            }
            if (ctx == null) {
                ctx = ClassLoader.getSystemClassLoader();
            }
            if (ctx == null) {
                throw new TclRuntimeError("could not locate parent class loader");
            }
            this.classLoader = new TclClassLoader(this, null, ctx);
        }
        return this.classLoader;
    }

    InputStream getResourceAsStream(String resName) {
        if (this.classLoader == null) {
            this.getClassLoader();
        }
        try {
            return this.classLoader.getResourceAsStream(resName);
        }
        catch (PackageNameException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }
}

