/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import tcl.lang.ClassRep;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.JavaInfoCmd;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

class JavaListifyCmd
implements Command {
    JavaListifyCmd() {
    }

    private static boolean isBasic(Class cls) {
        return cls == Integer.class || cls == Long.class || cls == Short.class || cls == Byte.class || cls == Double.class || cls == Float.class || cls == Boolean.class || cls == Character.class || cls == String.class;
    }

    @Override
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        Object collectionObj;
        boolean conversionToBasic;
        Class forcedCastTo = null;
        switch (argv.length) {
            case 2: {
                conversionToBasic = true;
                forcedCastTo = null;
                collectionObj = ReflectObject.get(interp, argv[1]);
                break;
            }
            case 3: {
                conversionToBasic = false;
                String arg1 = argv[1].toString();
                forcedCastTo = "-noconvert".equals(arg1) ? null : ClassRep.get(interp, argv[1]);
                collectionObj = ReflectObject.get(interp, argv[2]);
                break;
            }
            default: {
                throw new TclNumArgsException(interp, 1, argv, "?-noconvert|class? collectionObject");
            }
        }
        TclObject resultListObj = TclList.newInstance();
        if (collectionObj == null) {
            interp.setResult(resultListObj);
            return;
        }
        boolean isCollection = collectionObj instanceof Collection;
        boolean isEnumeration = collectionObj instanceof Enumeration;
        if (!isCollection && !isEnumeration) {
            throw new TclException(interp, "passed argument of type " + JavaInfoCmd.getNameFromClass(collectionObj.getClass()) + " which does not implement the Collection nor the Enumeration interface");
        }
        Iterator iterator = null;
        if (isCollection) {
            iterator = ((Collection)collectionObj).iterator();
        }
        try {
            boolean hasNext;
            while (hasNext = isCollection ? iterator.hasNext() : ((Enumeration)collectionObj).hasMoreElements()) {
                TclObject tclObj;
                Object elem = isCollection ? iterator.next() : ((Enumeration)collectionObj).nextElement();
                if (elem == null) {
                    tclObj = conversionToBasic ? TclString.newInstance("") : ReflectObject.newInstance(interp, null, null);
                } else {
                    Class cls = elem.getClass();
                    if (conversionToBasic && JavaListifyCmd.isBasic(cls)) {
                        tclObj = TclString.newInstance(elem.toString());
                    } else {
                        if (forcedCastTo != null) {
                            cls = forcedCastTo;
                        }
                        tclObj = ReflectObject.newInstance(interp, cls, elem);
                    }
                }
                TclList.append(interp, resultListObj, tclObj);
            }
        }
        catch (TclException e) {
            resultListObj.release();
            throw e;
        }
        interp.setResult(resultListObj);
    }
}

