/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.HashMap;
import tcl.lang.EventDeleter;
import tcl.lang.TclEvent;
import tcl.lang.TclRuntimeError;

public class Notifier
implements EventDeleter {
    private static Notifier globalNotifier;
    private TclEvent firstEvent;
    private TclEvent lastEvent;
    private TclEvent markerEvent;
    private TclEvent servicedEvent = null;
    Thread primaryThread;
    int refCount;
    private static HashMap notifierTable;
    private long tclThreadId;

    private Notifier(Thread primaryTh) {
        this.primaryThread = primaryTh;
        this.firstEvent = null;
        this.lastEvent = null;
        this.markerEvent = null;
        this.tclThreadId = this.init();
        this.refCount = 0;
    }

    public static synchronized Notifier getNotifierForThread(Thread thread) {
        Notifier notifier = (Notifier)notifierTable.get(thread);
        if (notifier == null) {
            notifier = new Notifier(thread);
            notifierTable.put(thread, notifier);
        }
        return notifier;
    }

    public synchronized void preserve() {
        if (this.refCount < 0) {
            throw new TclRuntimeError("Attempting to preserve a freed Notifier");
        }
        ++this.refCount;
    }

    public synchronized void release() {
        if (this.refCount == 0 && this.primaryThread != null) {
            throw new TclRuntimeError("Attempting to release a Notifier before it's preserved");
        }
        if (this.refCount <= 0) {
            throw new TclRuntimeError("Attempting to release a freed Notifier");
        }
        --this.refCount;
        if (this.refCount == 0) {
            notifierTable.remove(this.primaryThread);
            this.primaryThread = null;
            this.dispose();
        }
    }

    public synchronized void queueEvent(TclEvent evt, int position) {
        evt.notifier = this;
        if (position == 0) {
            evt.next = null;
            if (this.firstEvent == null) {
                this.firstEvent = evt;
            } else {
                this.lastEvent.next = evt;
            }
            this.lastEvent = evt;
        } else if (position == 1) {
            evt.next = this.firstEvent;
            if (this.firstEvent == null) {
                this.lastEvent = evt;
            }
            this.firstEvent = evt;
        } else if (position == 2) {
            if (this.markerEvent == null) {
                evt.next = this.firstEvent;
                this.firstEvent = evt;
            } else {
                evt.next = this.markerEvent.next;
                this.markerEvent.next = evt;
            }
            this.markerEvent = evt;
            if (evt.next == null) {
                this.lastEvent = evt;
            }
        } else {
            throw new TclRuntimeError("wrong position \"" + position + "\", must be TCL.QUEUE_HEAD, TCL.QUEUE_TAIL or TCL.QUEUE_MARK");
        }
        if (Thread.currentThread() != this.primaryThread) {
            this.alertNotifier(this.tclThreadId);
        }
    }

    public synchronized void deleteEvents(EventDeleter deleter) {
        TclEvent servicedEvent = null;
        if (deleter == this) {
            servicedEvent = this.servicedEvent;
            if (servicedEvent == null) {
                throw new TclRuntimeError("servicedEvent was not set by serviceEvent()");
            }
            this.servicedEvent = null;
        }
        TclEvent prev = null;
        TclEvent evt = this.firstEvent;
        while (evt != null) {
            if (servicedEvent == null && deleter.deleteEvent(evt) == 1 || evt == servicedEvent) {
                if (evt == this.firstEvent) {
                    this.firstEvent = evt.next;
                } else {
                    prev.next = evt.next;
                }
                if (evt.next == null) {
                    this.lastEvent = prev;
                }
                if (evt == this.markerEvent) {
                    this.markerEvent = prev;
                }
                if (evt == servicedEvent) {
                    servicedEvent = null;
                    break;
                }
            } else {
                prev = evt;
            }
            evt = evt.next;
        }
        if (servicedEvent != null) {
            throw new TclRuntimeError("servicedEvent was not removed from the queue");
        }
    }

    @Override
    public int deleteEvent(TclEvent evt) {
        throw new TclRuntimeError("The Notifier.deleteEvent() method should not be called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int serviceEvent(int flags) {
        if ((flags & 0xFFFFFFFD) == 0) {
            flags |= 0xFFFFFFFD;
        }
        TclEvent evt = null;
        while ((evt = this.getAvailableEvent(evt)) != null) {
            evt.isProcessing = true;
            if (evt.processEvent(flags) != 0) {
                evt.isProcessed = true;
                if (evt.needsNotify) {
                    TclEvent tclEvent = evt;
                    synchronized (tclEvent) {
                        evt.notifyAll();
                    }
                }
                this.servicedEvent = evt;
                this.deleteEvents(this);
                return 1;
            }
            evt.isProcessing = false;
        }
        return 0;
    }

    private synchronized TclEvent getAvailableEvent(TclEvent skipEvent) {
        TclEvent evt = this.firstEvent;
        while (evt != null) {
            if (!evt.isProcessing && !evt.isProcessed && evt != skipEvent) {
                return evt;
            }
            evt = evt.next;
        }
        return null;
    }

    public native int doOneEvent(int var1);

    private final native void alertNotifier(long var1);

    private final native long init();

    final native void dispose();

    private final boolean hasEvents() {
        boolean result = this.getAvailableEvent(null) != null;
        return result;
    }

    static final native void finalizeThreadCheck();

    static {
        notifierTable = new HashMap();
    }
}

