/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.Util;

public class TclBoolean
implements InternalRep {
    private static final TclBoolean trueRep = new TclBoolean(true);
    private static final TclBoolean falseRep = new TclBoolean(false);
    private final boolean value;

    private TclBoolean(boolean b) {
        this.value = b;
    }

    @Override
    public InternalRep duplicate() {
        return this;
    }

    @Override
    public void dispose() {
    }

    public String toString() {
        if (this.value) {
            return "1";
        }
        return "0";
    }

    public static TclObject newInstance(boolean b) {
        return new TclObject(b ? trueRep : falseRep);
    }

    private static void setBooleanFromAny(Interp interp, TclObject tobj) throws TclException {
        String string = tobj.toString();
        if (tobj.isIntType()) {
            int i = TclInteger.get(interp, tobj);
            if (i == 0) {
                tobj.setInternalRep(falseRep);
            } else {
                tobj.setInternalRep(trueRep);
            }
        } else if (tobj.isDoubleType()) {
            double d = TclDouble.get(interp, tobj);
            if (d == 0.0) {
                tobj.setInternalRep(falseRep);
            } else {
                tobj.setInternalRep(trueRep);
            }
        } else {
            boolean b;
            boolean badBoolean;
            block19: {
                string = string.toLowerCase();
                String lowerCase = string.toLowerCase();
                badBoolean = false;
                try {
                    b = Util.getBoolean(interp, lowerCase);
                }
                catch (TclException te) {
                    badBoolean = true;
                    b = false;
                    if (interp != null) {
                        interp.resetResult();
                    }
                    try {
                        b = Util.getInt(interp, lowerCase) != 0;
                        badBoolean = false;
                    }
                    catch (TclException tclException) {
                        // empty catch block
                    }
                    if (!badBoolean) break block19;
                    try {
                        b = Util.getDouble(interp, lowerCase) != 0.0;
                        badBoolean = false;
                    }
                    catch (TclException tclException) {
                        // empty catch block
                    }
                }
            }
            if (badBoolean) {
                if (interp != null) {
                    interp.resetResult();
                }
                throw new TclException(interp, "expected boolean value but got \"" + string + "\"");
            }
            if (b) {
                tobj.setInternalRep(trueRep);
            } else {
                tobj.setInternalRep(falseRep);
            }
        }
    }

    public static boolean get(Interp interp, TclObject tobj) throws TclException {
        TclBoolean tbool;
        InternalRep rep;
        if (tobj.isIntType()) {
            int ival = tobj.ivalue;
            if (ival == 0) {
                return false;
            }
            if (ival == 1) {
                return true;
            }
        }
        if (!((rep = tobj.getInternalRep()) instanceof TclBoolean)) {
            TclBoolean.setBooleanFromAny(interp, tobj);
            tbool = (TclBoolean)tobj.getInternalRep();
        } else {
            tbool = (TclBoolean)rep;
        }
        return tbool.value;
    }
}

