/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;

public class TclInteger
implements InternalRep {
    static final TclInteger dummy = new TclInteger();
    private static final boolean validate = false;

    private TclInteger() {
    }

    @Override
    public InternalRep duplicate() {
        throw new TclRuntimeError("TclInteger.duplicate() should not be invoked");
    }

    @Override
    public void dispose() {
    }

    public String toString() {
        throw new TclRuntimeError("TclInteger.toString() should not be invoked");
    }

    public static TclObject newInstance(int i) {
        return new TclObject(i);
    }

    private static void setIntegerFromAny(Interp interp, TclObject tobj) throws TclException {
        int ivalue = Util.getInt(interp, tobj.toString());
        tobj.setInternalRep(dummy);
        tobj.ivalue = ivalue;
    }

    public static int get(Interp interp, TclObject tobj) throws TclException {
        if (!tobj.isIntType()) {
            TclInteger.setIntegerFromAny(interp, tobj);
        }
        return tobj.ivalue;
    }

    public static void set(TclObject tobj, int i) {
        if (!tobj.isIntType()) {
            tobj.setInternalRep(dummy);
        }
        tobj.invalidateStringRep();
        tobj.ivalue = i;
    }

    static void incr(Interp interp, TclObject tobj, int incrAmount) throws TclException {
        if (!tobj.isIntType()) {
            TclInteger.setIntegerFromAny(interp, tobj);
        }
        tobj.invalidateStringRep();
        tobj.ivalue += incrAmount;
    }

    static void exprSetInternalRep(TclObject tobj, int i) {
        tobj.setInternalRep(dummy);
        tobj.ivalue = i;
    }
}

