/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.CObject;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;

public class TclList
extends CObject {
    protected TclList() {
    }

    protected TclList(long objPtr) {
        super(objPtr);
    }

    public static TclObject newInstance() {
        return new TclObject(new TclList());
    }

    private static TclObject newInstance(long objPtr) {
        return new TclObject(new TclList(objPtr));
    }

    private static void setListFromAny(Interp interp, TclObject tobj) throws TclException {
        InternalRep rep = tobj.getInternalRep();
        if (!tobj.isListType()) {
            TclList tlist;
            long interpPtr;
            long l = interpPtr = interp == null ? 0L : interp.interpPtr;
            if (rep instanceof CObject) {
                CObject cobj = (CObject)rep;
                TclList.listLength(interpPtr, cobj.objPtr);
                tlist = new TclList(cobj.objPtr);
            } else {
                tlist = new TclList(TclList.splitList(interpPtr, tobj.toString()));
                TclList.cleanupAdd(interp, tlist);
            }
            tobj.setInternalRep(tlist);
        } else {
            TclList tlist = (TclList)rep;
            if (interp != null && tlist.emptyNeedsCleanup) {
                TclList.cleanupAdd(interp, tlist);
                tlist.emptyNeedsCleanup = false;
            }
        }
    }

    public static final void append(Interp interp, TclObject tobj, TclObject elemObj) throws TclException {
        if (tobj.isShared()) {
            throw new TclRuntimeError("TclList.append() called with shared object");
        }
        TclList.setListFromAny(interp, tobj);
        tobj.invalidateStringRep();
        TclList tlist = (TclList)tobj.getInternalRep();
        long newPtr = TclList.append(tlist.objPtr, elemObj);
        if (tlist.objPtr != newPtr) {
            TclList newList = new TclList(newPtr);
            tobj.setInternalRep(newList);
            TclList.cleanupAdd(interp, newList);
        }
    }

    public static final int getLength(Interp interp, TclObject tobj) throws TclException {
        long interpPtr = interp == null ? 0L : interp.interpPtr;
        TclList.setListFromAny(interp, tobj);
        TclList tlist = (TclList)tobj.getInternalRep();
        return TclList.listLength(interpPtr, tlist.objPtr);
    }

    public static TclObject[] getElements(Interp interp, TclObject tobj) throws TclException {
        TclList.setListFromAny(interp, tobj);
        TclList tlist = (TclList)tobj.getInternalRep();
        return TclList.getElements(tlist.objPtr);
    }

    public static final TclObject index(Interp interp, TclObject tobj, int index) throws TclException {
        TclList.setListFromAny(interp, tobj);
        TclList tlist = (TclList)tobj.getInternalRep();
        return TclList.index(tlist.objPtr, index);
    }

    public static final void replace(Interp interp, TclObject tobj, int index, int count, TclObject[] elements, int from, int to) throws TclException {
        if (tobj.isShared()) {
            throw new TclRuntimeError("TclList.replace() called with shared object");
        }
        TclList.setListFromAny(interp, tobj);
        tobj.invalidateStringRep();
        TclList tlist = (TclList)tobj.getInternalRep();
        long newPtr = TclList.replace(tlist.objPtr, index, count, elements, from, to);
        if (tlist.objPtr != newPtr) {
            TclList newList = new TclList(newPtr);
            tobj.setInternalRep(newList);
            TclList.cleanupAdd(interp, newList);
        }
    }

    private static final native long append(long var0, TclObject var2);

    private static final native TclObject[] getElements(long var0);

    private static final native TclObject index(long var0, int var2);

    private static final native int listLength(long var0, long var2) throws TclException;

    private static final native long replace(long var0, int var2, int var3, TclObject[] var4, int var5, int var6);

    private static final native long splitList(long var0, String var2);
}

