/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;

public class TdbcHelper {
    private ResultSet rs;

    public TdbcHelper(ResultSet rs) {
        this.rs = rs;
    }

    public Vector getColumns() throws SQLException {
        ResultSetMetaData md = this.rs.getMetaData();
        int ncols = md.getColumnCount();
        Vector<String> ret = new Vector<String>(ncols);
        for (int i = 1; i <= ncols; ++i) {
            ret.addElement(md.getColumnLabel(i));
        }
        return ret;
    }

    public Vector getRowData() throws SQLException {
        ResultSetMetaData md = this.rs.getMetaData();
        int ncols = md.getColumnCount();
        Vector<String> ret = new Vector<String>(ncols);
        for (int i = 1; i <= ncols; ++i) {
            String str = null;
            switch (md.getColumnType(i)) {
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    byte[] b = this.rs.getBytes(i);
                    if (b == null) break;
                    try {
                        str = new String(b, "UTF-8");
                    }
                    catch (Exception exception) {}
                    break;
                }
                default: {
                    str = this.rs.getString(i);
                }
            }
            if (str == null || this.rs.wasNull()) {
                str = "";
            }
            ret.addElement(str);
        }
        return ret;
    }
}

