/*
 * Decompiled with CFR 0.152.
 */
package tk.tcl.wish;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.BluetoothSocket;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.util.UUID;
import tk.tcl.wish.BTClient;

public class BTServer
extends Thread {
    private FileDescriptor fd;
    private BluetoothServerSocket sock;
    private BluetoothSocket newsock;
    private Object lock;
    private Thread thread;

    public BTServer(FileDescriptor fd, String name, String uuid, int unused) {
        BluetoothAdapter bt = BluetoothAdapter.getDefaultAdapter();
        this.lock = new Object();
        try {
            this.sock = bt.listenUsingRfcommWithServiceRecord(name, UUID.fromString(uuid));
            this.fd = fd;
            this.thread = new Thread(this);
            this.thread.start();
        }
        catch (Exception e) {
            Log.e((String)"BTServer", (String)("<init>: " + e));
            this.sock = null;
            throw new RuntimeException("can't listen");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        FileOutputStream out = new FileOutputStream(this.fd);
        try {
            while (true) {
                Object object = this.lock;
                synchronized (object) {
                    this.newsock = this.sock.accept();
                    out.write(65);
                    this.lock.wait(15000L);
                    if (this.newsock != null) {
                        this.newsock.close();
                        this.newsock = null;
                    }
                }
            }
        }
        catch (Exception e) {
            Log.e((String)"BTServer", (String)("run: " + e));
            try {
                this.sock.close();
                out.close();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BTClient accept(FileDescriptor fd) {
        BTClient client = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.newsock != null) {
                client = new BTClient(fd, this.newsock);
                this.newsock = null;
                this.lock.notifyAll();
            }
        }
        return client;
    }

    public void close() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        try {
            this.sock.close();
            this.sock = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.thread != null) {
                this.thread.join();
                this.thread = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

