/*
 * Decompiled with CFR 0.152.
 */
package tk.tcl.wish;

import android.content.Context;
import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.os.Build;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import java.io.IOException;
import java.util.List;
import tk.tcl.wish.Callbacks;

public class ImageCapture {
    public static String TAG = "ImageCapture";
    private static ImageCapture mCapture;
    private final Context mContext;
    public int mCameraId;
    public Camera mCamera;
    public boolean mPreviewing;
    public boolean mTakingPicture;
    public final Callbacks mCallbacks;
    public Point mCameraRes;
    public boolean mReopen;
    public boolean mRestart;
    public String mSavedParameters;
    public int mSavedRotation;
    private SurfaceTexture mSurfaceTexture;

    private int createTexture() {
        int error;
        int[] textures = new int[1];
        GLES20.glActiveTexture((int)33984);
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        while ((error = GLES20.glGetError()) != 0) {
            Log.e((String)TAG, (String)("glGenTextures: glError " + GLUtils.getEGLErrorString((int)error)));
        }
        GLES20.glBindTexture((int)36197, (int)textures[0]);
        while ((error = GLES20.glGetError()) != 0) {
            Log.e((String)TAG, (String)("glBindTexture: glError " + GLUtils.getEGLErrorString((int)error)));
        }
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        return textures[0];
    }

    public Point getCameraResolution(Point desiredRes) {
        if (this.mCamera != null) {
            Camera.Parameters cp = this.mCamera.getParameters();
            List sizes = cp.getSupportedPreviewSizes();
            int minDiff = 99999;
            int minIndex = -1;
            WindowManager manager = (WindowManager)this.mContext.getSystemService("window");
            Display display = manager.getDefaultDisplay();
            Point screenRes = new Point(display.getWidth(), display.getHeight());
            float screenAR = (float)screenRes.x / (float)screenRes.y;
            for (int i = 0; i < sizes.size(); ++i) {
                int diff = Math.abs(((Camera.Size)sizes.get((int)i)).width - desiredRes.x) + Math.abs(((Camera.Size)sizes.get((int)i)).height - desiredRes.y);
                if (diff >= minDiff) continue;
                minDiff = diff;
                minIndex = i;
            }
            float desiredTotSize = desiredRes.x * desiredRes.y;
            float bestARdiff = 100.0f;
            for (int i = 0; i < sizes.size(); ++i) {
                float resAR = (float)((Camera.Size)sizes.get((int)i)).width / (float)((Camera.Size)sizes.get((int)i)).height;
                float totSize = ((Camera.Size)sizes.get((int)i)).width * ((Camera.Size)sizes.get((int)i)).height;
                float diff = totSize >= desiredTotSize ? totSize / desiredTotSize : desiredTotSize / totSize;
                float ARdiff = resAR >= screenAR ? resAR / screenAR : screenAR / resAR;
                if (!((double)diff < 1.1) || !(ARdiff < bestARdiff)) continue;
                bestARdiff = ARdiff;
                minIndex = i;
            }
            return new Point(((Camera.Size)sizes.get((int)minIndex)).width, ((Camera.Size)sizes.get((int)minIndex)).height);
        }
        return null;
    }

    public static void init(Context context) {
        if (mCapture == null) {
            mCapture = new ImageCapture(context);
        }
    }

    public static ImageCapture get() {
        return mCapture;
    }

    public void onPause() {
        this.mReopen = this.mCamera != null;
        this.mRestart = this.mPreviewing;
        if (this.mReopen) {
            this.mSavedRotation = this.mCallbacks.getRotation();
            this.mSavedParameters = this.getParameters();
            this.stopPreview();
            this.close();
        }
    }

    public void onResume() {
        if (this.mReopen && this.open(this.mCameraId, this.mSavedParameters, this.mSavedRotation) && this.mRestart) {
            this.startPreview();
        }
    }

    public void onDestroy() {
        this.stopPreview();
        this.close();
    }

    public byte[] lastImage(int[] info) {
        return this.mCallbacks.getLastImage(info);
    }

    public byte[] lastPicture() {
        return this.mCallbacks.getLastPicture();
    }

    public synchronized int getState() {
        if (this.mCamera == null) {
            return 0;
        }
        if (this.mPreviewing) {
            return 2;
        }
        return 1;
    }

    public synchronized String getParameters() {
        if (this.mCamera != null) {
            return this.mCamera.getParameters().flatten();
        }
        return null;
    }

    public synchronized String setParameters(String parameters) {
        if (this.mCamera != null) {
            Camera.Parameters cp = this.mCamera.getParameters();
            Camera.Size ps = cp.getPreviewSize();
            int pf = cp.getPreviewFormat();
            cp.unflatten(cp.flatten() + ";" + parameters);
            cp.setPreviewFormat(pf);
            if (this.mPreviewing) {
                cp.setPreviewSize(ps.width, ps.height);
            }
            try {
                this.mCamera.setParameters(cp);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("setParameters: " + e.toString()));
            }
            cp = this.mCamera.getParameters();
            ps = cp.getPreviewSize();
            this.mCameraRes = new Point(ps.width, ps.height);
            return cp.flatten();
        }
        return null;
    }

    private ImageCapture(Context context) {
        Log.v((String)TAG, (String)"Create ImageCapture");
        this.mContext = context;
        this.mCallbacks = new Callbacks(this);
    }

    private synchronized boolean open(int cameraId, String params, int rotation) {
        int n = Camera.getNumberOfCameras();
        if (n <= 0) {
            Log.e((String)TAG, (String)"No camera(s) available");
            return false;
        }
        if (Build.VERSION.SDK_INT < 11) {
            Log.e((String)TAG, (String)"borg camera needs at least API11");
            return false;
        }
        if (cameraId < 0 || cameraId >= n) {
            cameraId = 0;
        }
        if (this.mCamera == null) {
            Log.v((String)TAG, (String)"Camera opening ...");
            this.mSurfaceTexture = new SurfaceTexture(this.createTexture());
            try {
                this.mCamera = Camera.open((int)cameraId);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Camera open failed: " + e.toString()));
                this.mCamera = null;
            }
            if (this.mCamera == null) {
                if (this.mSurfaceTexture != null) {
                    this.mSurfaceTexture.release();
                }
                return false;
            }
            Log.v((String)TAG, (String)"... success");
            try {
                this.mCamera.setPreviewDisplay(null);
            }
            catch (IOException ioe) {
                Log.e((String)TAG, (String)("setPreviewDisplay: " + ioe.toString()));
                this.mCamera.release();
                this.mCamera = null;
                if (this.mSurfaceTexture != null) {
                    this.mSurfaceTexture.release();
                }
                return false;
            }
            this.mCameraId = cameraId;
            if (rotation < 0) {
                this.setCameraDisplayOrientation(rotation);
            } else {
                Log.v((String)TAG, (String)("restore rotation " + rotation));
                this.mCallbacks.setRotation(rotation);
            }
            if (this.mSurfaceTexture != null) {
                try {
                    this.mCamera.setPreviewTexture(this.mSurfaceTexture);
                }
                catch (IOException ioe) {
                    Log.e((String)TAG, (String)("setPreviewTexture: " + ioe.toString()));
                    this.mCamera.release();
                    this.mCamera = null;
                    this.mSurfaceTexture.release();
                    this.mSurfaceTexture = null;
                    return false;
                }
            } else {
                Log.e((String)TAG, (String)"Camera texture is NULL");
            }
            if (params != null) {
                Log.v((String)TAG, (String)("Camera parameters: " + this.setParameters(params)));
            } else {
                String vs2;
                this.mCameraRes = this.getCameraResolution(new Point(640, 480));
                Log.v((String)TAG, (String)("Setting preview size: " + this.mCameraRes));
                Camera.Parameters cp = this.mCamera.getParameters();
                cp.setPreviewSize(this.mCameraRes.x, this.mCameraRes.y);
                try {
                    vs2 = cp.get("anti-shake");
                    if (vs2 != null) {
                        cp.set("anti-shake", "1");
                    }
                }
                catch (Exception vs2) {
                    // empty catch block
                }
                try {
                    vs2 = cp.get("preview-fps-range");
                    if (vs2 != null) {
                        Log.d((String)TAG, (String)"Setting fps preview range");
                        cp.set("preview-fps-range", "30000,30000");
                    }
                }
                catch (Exception vs3) {
                    // empty catch block
                }
                try {
                    vs2 = cp.get("video-stabilization");
                    if (vs2 != null) {
                        cp.set("video-stabilization", "true");
                    }
                }
                catch (Exception vs4) {
                    // empty catch block
                }
                try {
                    vs2 = cp.get("video-stabilization-ocr");
                    if (vs2 != null) {
                        cp.set("video-stabilization-ocr", "true");
                    }
                }
                catch (Exception vs5) {
                    // empty catch block
                }
                try {
                    vs2 = cp.get("touch-af-aec-values");
                    if (vs2 != null) {
                        cp.set("touch-af-aec-values", "touch-on");
                    }
                }
                catch (Exception vs6) {
                    // empty catch block
                }
                try {
                    vs2 = cp.get("metering-areas");
                    if (vs2 != null) {
                        cp.set("metering-areas", "(-200,-10,200,50,1)");
                    }
                }
                catch (Exception vs7) {
                    // empty catch block
                }
                try {
                    vs2 = cp.get("focus-areas");
                    if (vs2 != null) {
                        cp.set("focus-areas", "(-200,-10,200,50,1)");
                    }
                }
                catch (Exception vs8) {
                    // empty catch block
                }
                try {
                    cp.setFocusMode("continuous-picture");
                    this.mCamera.setParameters(cp);
                }
                catch (Exception e) {
                    try {
                        cp.setFocusMode("auto");
                        this.mCamera.setParameters(cp);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                cp = this.mCamera.getParameters();
                Camera.Size ps = cp.getPreviewSize();
                this.mCameraRes = new Point(ps.width, ps.height);
                Log.v((String)TAG, (String)("Camera parameters: " + cp.flatten()));
            }
            return true;
        }
        Log.v((String)TAG, (String)"Camera already opened");
        return false;
    }

    public boolean open(int cameraId) {
        return this.open(cameraId, null, -1);
    }

    public synchronized boolean close() {
        this.stopPreview();
        if (this.mSurfaceTexture != null) {
            this.mSurfaceTexture.release();
            this.mSurfaceTexture = null;
        }
        if (this.mCamera != null) {
            Log.v((String)TAG, (String)"Camera close");
            this.mCamera.release();
            this.mCamera = null;
            this.mCallbacks.clear();
            return true;
        }
        return false;
    }

    public synchronized int getID(boolean current) {
        if (current) {
            if (this.mCamera != null) {
                return this.mCameraId;
            }
            return -1;
        }
        return Camera.getNumberOfCameras();
    }

    public synchronized boolean startPreview() {
        if (this.mCamera != null && !this.mPreviewing) {
            Log.v((String)TAG, (String)"Start preview");
            this.mCamera.setPreviewCallback((Camera.PreviewCallback)this.mCallbacks);
            this.mCallbacks.clear();
            this.mCamera.startPreview();
            this.mPreviewing = true;
            this.mTakingPicture = false;
            return true;
        }
        return false;
    }

    public synchronized boolean stopPreview() {
        if (this.mCamera != null && this.mPreviewing) {
            Log.v((String)TAG, (String)"Stop preview");
            this.mCamera.setPreviewCallback(null);
            this.mCamera.stopPreview();
            this.mTakingPicture = false;
            this.mPreviewing = false;
            return true;
        }
        return false;
    }

    public synchronized boolean takePicture() {
        if (this.mCamera != null && this.mPreviewing) {
            if (this.mTakingPicture) {
                return false;
            }
            this.mTakingPicture = true;
            this.mCamera.takePicture((Camera.ShutterCallback)this.mCallbacks, null, (Camera.PictureCallback)this.mCallbacks);
            return true;
        }
        return false;
    }

    public int getDisplayOrientation(int cameraId) {
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)info);
        Log.v((String)TAG, (String)("Camera Orientation: " + info.orientation));
        WindowManager manager = (WindowManager)this.mContext.getSystemService("window");
        Display d = manager.getDefaultDisplay();
        int rotation = d.getRotation();
        Log.v((String)TAG, (String)("Display Rotation: " + rotation));
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        degrees = info.facing == 1 ? (degrees += info.orientation) : (degrees -= info.orientation - 360);
        Log.v((String)TAG, (String)("Image must be rotated to: " + (degrees %= 360)));
        return degrees;
    }

    public synchronized int setCameraDisplayOrientation(int degrees) {
        int result;
        if (this.mCamera == null) {
            return -1;
        }
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)this.mCameraId, (Camera.CameraInfo)info);
        if (degrees < 0) {
            degrees = this.getDisplayOrientation(this.mCameraId);
        } else {
            degrees = info.facing == 1 ? (degrees += info.orientation) : (degrees -= info.orientation - 360);
            degrees = (degrees %= 360) < 45 ? 0 : (degrees < 135 ? 90 : (degrees < 225 ? 180 : (degrees < 315 ? 270 : 0)));
        }
        if (info.facing == 1) {
            result = (360 + degrees - info.orientation) % 360;
            degrees = (360 - degrees) % 360;
        } else {
            result = (degrees + info.orientation) % 360;
        }
        this.mCallbacks.setRotation(degrees);
        return result;
    }

    public synchronized String getInfo() {
        if (this.mCamera == null) {
            return null;
        }
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)this.mCameraId, (Camera.CameraInfo)info);
        return "" + info.orientation + " " + (info.facing == 1 ? "1" : "0");
    }

    public static native void nativeTriggerImageCapture(int var0);
}

