/*
 * Decompiled with CFR 0.152.
 */
package tk.tcl.wish;

import android.media.AudioTrack;
import android.os.Process;
import android.util.Log;

public class Muzic {
    static final String TAG = "tclMuzic";
    AudioTrack mOut;

    public Muzic(AudioTrack out) {
        this.mOut = out;
    }

    public static Muzic open(int nChan, int rate, int bufSize) {
        int conf = nChan > 1 ? 12 : 4;
        int n = AudioTrack.getMinBufferSize((int)rate, (int)conf, (int)2);
        Log.v((String)TAG, (String)("channels: " + nChan));
        Log.v((String)TAG, (String)("sample rate: " + rate));
        Log.v((String)TAG, (String)("midi bufsize: " + bufSize));
        Log.v((String)TAG, (String)("play bufsize: " + n));
        if (n <= 0) {
            return null;
        }
        AudioTrack out = new AudioTrack(3, rate, conf, 2, n * 2, 1);
        if (out.getState() != 1) {
            Log.e((String)TAG, (String)"play not in STATE_INITIALIZED");
            out = null;
            return null;
        }
        Process.setThreadPriority((int)-19);
        return new Muzic(out);
    }

    public void close() {
        Log.v((String)TAG, (String)"close");
        this.mOut.pause();
        this.mOut.flush();
        this.mOut.release();
        this.mOut = null;
    }

    public int write(short[] buffer, int count) {
        if (this.mOut == null) {
            return -1;
        }
        if (this.mOut.getPlayState() != 3) {
            this.mOut.play();
        }
        return this.mOut.write(buffer, 0, count);
    }
}

