/*
 * Decompiled with CFR 0.152.
 */
package tk.tcl.wish;

import android.location.GpsStatus;
import tk.tcl.wish.AndroWish;

class NmeaInfo
implements GpsStatus.NmeaListener {
    AndroWish mAW;
    long mTime0;
    long mTime1;
    StringBuilder mNmeaBuf;
    String mNmeaStr;

    public NmeaInfo(AndroWish aw) {
        this.mAW = aw;
        this.mTime0 = System.currentTimeMillis() / 1000L;
        this.mTime1 = 0L;
        this.mNmeaBuf = new StringBuilder(4096);
        this.mNmeaStr = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNmeaReceived(long time, String nmea) {
        boolean trigger = false;
        time /= 1000L;
        NmeaInfo nmeaInfo = this;
        synchronized (nmeaInfo) {
            if (this.mTime0 != time && this.mNmeaBuf.length() > 0) {
                this.mTime1 = this.mTime0;
                this.mNmeaStr = new String(this.mNmeaBuf);
                trigger = true;
            }
        }
        if (trigger) {
            NmeaInfo nmeaInfo2 = this;
            nmeaInfo2.mAW.nativeTriggerNmeaUpdate();
            this.mTime0 = time;
            this.mNmeaBuf.setLength(0);
        }
        this.mNmeaBuf.append(nmea);
    }

    public void clear() {
        this.mTime0 = System.currentTimeMillis() / 1000L;
        this.mNmeaBuf.setLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInfo() {
        long time;
        String nmea = null;
        NmeaInfo nmeaInfo = this;
        synchronized (nmeaInfo) {
            time = this.mTime1;
            if (this.mNmeaStr != null && this.mNmeaStr.length() > 0) {
                nmea = this.mNmeaStr;
            }
        }
        if (nmea != null) {
            StringBuilder sb = new StringBuilder(nmea.length() + 64);
            sb.append("time ").append(time);
            sb.append(" nmea ").append(this.mAW.toElement(nmea));
            return sb.toString();
        }
        return null;
    }
}

