/*
 * Decompiled with CFR 0.152.
 */
package tk.tcl.wish;

import android.media.AudioRecord;
import android.os.Process;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import tk.tcl.wish.AudioIO;

class RecordThread
extends Thread
implements AudioIO {
    static final String TAG = "SnackAudio/R";
    static final int CMD_CLOSE = -1;
    static final int CMD_IDLE = 0;
    static final int CMD_REC = 1;
    static final int CMD_STOP = 2;
    static final int STAT_INIT = -1;
    static final int STAT_STOP = 0;
    static final int STAT_REC = 1;
    AudioRecord mIn;
    FileOutputStream mOs;
    int mCommand;
    int mStatus;
    int mBufSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordThread(FileDescriptor fd, AudioRecord in, int n, int r) {
        this.mIn = in;
        this.mBufSize = 512 * (1 + r / 10000);
        this.mOs = new FileOutputStream(fd);
        this.mCommand = 0;
        this.mStatus = -1;
        this.start();
        RecordThread recordThread = this;
        synchronized (recordThread) {
            while (this.mStatus < 0) {
                try {
                    this.wait();
                }
                catch (Exception e) {
                    // empty catch block
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAudio() {
        Log.v((String)TAG, (String)"stopAudio");
        RecordThread recordThread = this;
        synchronized (recordThread) {
            this.mCommand = 2;
            this.notifyAll();
            while (this.mStatus > 0) {
                try {
                    this.wait();
                }
                catch (Exception e) {
                    // empty catch block
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startAudio() {
        Log.v((String)TAG, (String)"startAudio");
        RecordThread recordThread = this;
        synchronized (recordThread) {
            if (this.mIn.getRecordingState() != 3) {
                this.mCommand = 1;
                this.notifyAll();
            }
            while (this.mStatus == 0) {
                try {
                    this.wait();
                }
                catch (Exception e) {
                    // empty catch block
                    break;
                }
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public int played() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Log.v((String)TAG, (String)"close");
        RecordThread recordThread = this;
        synchronized (recordThread) {
            while (this.mCommand >= 0) {
                this.mCommand = -1;
                this.notifyAll();
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.mIn.release();
        this.mIn = null;
        try {
            this.mOs.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mOs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean done = false;
        byte[] buffer = new byte[this.mBufSize];
        RecordThread recordThread = this;
        synchronized (recordThread) {
            this.mStatus = 0;
            this.notifyAll();
            done = this.mCommand == -1;
        }
        Process.setThreadPriority((int)-19);
        Log.v((String)TAG, (String)"thread start");
        while (!done) {
            int n;
            int docmd;
            RecordThread recordThread2 = this;
            synchronized (recordThread2) {
                while (this.mCommand == 0) {
                    try {
                        this.wait();
                    }
                    catch (Exception e) {
                        // empty catch block
                        break;
                    }
                }
                docmd = this.mCommand;
                if (this.mCommand < 0) {
                    done = true;
                    continue;
                }
                this.mCommand = 0;
            }
            if (docmd != 1) continue;
            try {
                this.mIn.startRecording();
            }
            catch (Exception e) {
                RecordThread recordThread3 = this;
                synchronized (recordThread3) {
                    this.mStatus = -1;
                    this.notifyAll();
                    continue;
                }
            }
            RecordThread e = this;
            synchronized (e) {
                this.mStatus = 1;
                this.notifyAll();
            }
            while ((n = this.mIn.read(buffer, 0, buffer.length)) >= 0) {
                if (n > 0) {
                    try {
                        this.mOs.write(buffer, 0, n);
                    }
                    catch (IOException ioe) {
                        Log.e((String)TAG, (String)("I/O error: " + ioe));
                    }
                }
                recordThread2 = this;
                synchronized (recordThread2) {
                    if (this.mCommand < 0) {
                        done = true;
                        break;
                    }
                    if (this.mCommand == 2) {
                        this.mCommand = 0;
                        break;
                    }
                }
            }
            this.mIn.stop();
            recordThread2 = this;
            synchronized (recordThread2) {
                this.mStatus = 0;
                this.notifyAll();
            }
        }
        Log.v((String)TAG, (String)"thread exiting");
    }
}

