/*
 * Decompiled with CFR 0.152.
 */
package tk.tcl.wish;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import java.util.List;
import tk.tcl.wish.AndroWish;
import tk.tcl.wish.SensorItem;

class Sensors
implements SensorEventListener {
    AndroWish mAW;
    SensorManager mSensorManager;
    SensorItem[] mSensors;

    public Sensors(AndroWish aw) {
        this.mAW = aw;
        this.mSensorManager = (SensorManager)this.mAW.getSystemService("sensor");
        List l = this.mSensorManager.getSensorList(-1);
        this.mSensors = new SensorItem[26];
        int i = 0;
        for (Sensor s : l) {
            if (s.getType() == 17) continue;
            this.mSensors[i++] = new SensorItem(s);
            if (i < this.mSensors.length) continue;
            break;
        }
    }

    void pause() {
        this.mSensorManager.unregisterListener((SensorEventListener)this);
    }

    void resume() {
        for (int i = 0; i < this.mSensors.length; ++i) {
            SensorItem si = this.mSensors[i];
            if (si == null || !si.mEnabled) continue;
            this.mSensorManager.registerListener((SensorEventListener)this, si.mSensor, 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSensorChanged(SensorEvent event) {
        float[] I;
        float[] R2;
        SensorItem sensorItem;
        SensorItem si;
        int i;
        int ti = -1;
        SensorItem sa = null;
        SensorItem sm = null;
        SensorItem st = null;
        for (i = 0; i < this.mSensors.length; ++i) {
            si = this.mSensors[i];
            if (si == null || si.mSensor != event.sensor) continue;
            boolean doRM = false;
            if (si.mEnabled) {
                if (si.mType == 1) {
                    sa = si;
                } else if (si.mType == 2) {
                    sm = si;
                }
                if (si.mType == 11 || si.mType == 15 || si.mType == 20) {
                    doRM = true;
                }
            }
            sensorItem = si;
            synchronized (sensorItem) {
                si.mAccuracy = event.accuracy;
                if (si.mValues == null || si.mValues.length != event.values.length) {
                    si.mValues = new float[event.values.length];
                }
                System.arraycopy(event.values, 0, si.mValues, 0, event.values.length);
                if (doRM) {
                    if (si.mRotationMatrix == null) {
                        si.mRotationMatrix = new float[16];
                    }
                    SensorManager.getRotationMatrixFromVector((float[])si.mRotationMatrix, (float[])event.values);
                }
                if (si.mEnabled) {
                    st = si;
                    ti = i;
                }
                break;
            }
        }
        if (sa != null || sm != null) {
            if (sa == null) {
                for (i = 0; i < this.mSensors.length; ++i) {
                    si = this.mSensors[i];
                    if (si == null || si.mType != 1) continue;
                    if (!si.mEnabled || si.mValues == null) break;
                    sa = si;
                    break;
                }
            } else {
                for (i = 0; i < this.mSensors.length; ++i) {
                    si = this.mSensors[i];
                    if (si == null || si.mType != 2) continue;
                    if (!si.mEnabled || si.mValues == null) break;
                    sm = si;
                    break;
                }
            }
        }
        if (sa != null && sm != null && SensorManager.getRotationMatrix((float[])(R2 = new float[9]), (float[])(I = new float[9]), (float[])sa.mValues, (float[])sm.mValues)) {
            sensorItem = sm;
            synchronized (sensorItem) {
                if (sm.mOrientation == null) {
                    sm.mOrientation = new float[3];
                }
                SensorManager.getOrientation((float[])R2, (float[])sm.mOrientation);
                sm.mInclination = SensorManager.getInclination((float[])I);
            }
        }
        if (st != null) {
            SensorItem sensorItem2 = st;
            synchronized (sensorItem2) {
                if (st.mTrigger < 4) {
                    if (AndroWish.nativeTriggerSensor(ti) > 0) {
                        ++st.mTrigger;
                    } else {
                        ++st.mOverflow;
                    }
                } else {
                    ++st.mOverflow;
                }
                if (st.mOverflow > 64) {
                    this.mSensorManager.unregisterListener((SensorEventListener)this, st.mSensor);
                    st.mEnabled = false;
                    st.mOverflow = 0;
                    st.mOrientation = null;
                    st.mRotationMatrix = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAccuracyChanged(Sensor sensor, int accuracy) {
        for (int i = 0; i < this.mSensors.length; ++i) {
            SensorItem si = this.mSensors[i];
            if (si == null || si.mSensor != sensor) continue;
            SensorItem sensorItem = si;
            synchronized (sensorItem) {
                si.mAccuracy = accuracy;
                if (si.mEnabled) {
                    if (si.mTrigger < 4) {
                        if (AndroWish.nativeTriggerSensor(i) > 0) {
                            ++si.mTrigger;
                        } else {
                            ++si.mOverflow;
                        }
                    } else {
                        ++si.mOverflow;
                    }
                }
                if (si.mOverflow > 64) {
                    this.mSensorManager.unregisterListener((SensorEventListener)this, si.mSensor);
                    si.mEnabled = false;
                    si.mOverflow = 0;
                    si.mOrientation = null;
                    si.mRotationMatrix = null;
                }
                continue;
            }
        }
    }

    public String[] getList() {
        int n;
        int i = 0;
        for (n = 0; n < this.mSensors.length; ++n) {
            if (this.mSensors[n] == null) continue;
            ++i;
        }
        if (i == 0) {
            return null;
        }
        String[] ret = new String[i];
        i = 0;
        for (n = 0; n < this.mSensors.length; ++n) {
            if (this.mSensors[n] == null) continue;
            Sensor s = this.mSensors[n].mSensor;
            StringBuilder sb = new StringBuilder(256);
            sb.append("index ").append(i).append(" name ");
            sb.append(this.mAW.toElement(s.getName()));
            sb.append(" type ");
            switch (this.mSensors[n].mType) {
                case 1: {
                    sb.append("accelerometer");
                    break;
                }
                case 7: 
                case 13: {
                    sb.append("temperature");
                    break;
                }
                case 15: {
                    sb.append("game_rotation_vector");
                    break;
                }
                case 20: {
                    sb.append("geomagnetic_rotation_vector");
                    break;
                }
                case 9: {
                    sb.append("gravity");
                    break;
                }
                case 4: {
                    sb.append("gyroscope");
                    break;
                }
                case 16: {
                    sb.append("gyroscope_uncalibrated");
                    break;
                }
                case 5: {
                    sb.append("light");
                    break;
                }
                case 10: {
                    sb.append("linear_acceleration");
                    break;
                }
                case 2: {
                    sb.append("magnetic_field");
                    break;
                }
                case 14: {
                    sb.append("magnetic_field_uncalibrated");
                    break;
                }
                case 3: {
                    sb.append("orientation");
                    break;
                }
                case 6: {
                    sb.append("pressure");
                    break;
                }
                case 8: {
                    sb.append("proximity");
                    break;
                }
                case 12: {
                    sb.append("relative_humidity");
                    break;
                }
                case 11: {
                    sb.append("rotation_vector");
                    break;
                }
                case 17: {
                    sb.append("significant_motion");
                    break;
                }
                case 19: {
                    sb.append("step_counter");
                    break;
                }
                case 18: {
                    sb.append("step_detector");
                    break;
                }
                default: {
                    sb.append("unknown");
                }
            }
            int mindelay = s.getMinDelay();
            if (mindelay > 0) {
                if ((mindelay /= 1000) <= 0) {
                    mindelay = 1;
                }
            } else {
                mindelay = 0;
            }
            sb.append(" mindelay ").append(mindelay);
            sb.append(" maxrange ").append(s.getMaximumRange());
            sb.append(" resolution ").append(s.getResolution());
            sb.append(" power ").append(s.getPower());
            ret[i++] = sb.toString();
        }
        return ret;
    }

    public int getState(int op, int n) {
        if (n < 0 || n > this.mSensors.length) {
            return 0;
        }
        if (this.mSensors[n] == null) {
            return 0;
        }
        final SensorItem si = this.mSensors[n];
        final Sensors s = this;
        switch (op) {
            case 0: {
                if (!si.mEnabled) {
                    final SensorManager sensorManager = this.mSensorManager;
                    Runnable doit = new Runnable(){

                        @Override
                        public void run() {
                            if (sensorManager.registerListener((SensorEventListener)s, si.mSensor, 3)) {
                                si.mEnabled = true;
                            }
                        }
                    };
                    this.mAW.runOnUiThread(doit);
                }
                n = 1;
                break;
            }
            case 1: {
                if (si.mEnabled) {
                    final SensorManager sensorManager = this.mSensorManager;
                    Runnable doit = new Runnable(){

                        @Override
                        public void run() {
                            sensorManager.unregisterListener((SensorEventListener)s, si.mSensor);
                            si.mEnabled = false;
                            si.mOrientation = null;
                        }
                    };
                    this.mAW.runOnUiThread(doit);
                }
                n = 1;
                break;
            }
            default: {
                n = si.mEnabled ? 1 : 0;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getData(int n) {
        if (n < 0 || n > this.mSensors.length) {
            return null;
        }
        if (this.mSensors[n] == null) {
            return null;
        }
        SensorItem si = this.mSensors[n];
        StringBuilder sb = new StringBuilder(256);
        sb.append("index ").append(n);
        sb.append(" enabled ").append(si.mEnabled ? 1 : 0);
        sb.append(" maxrange ").append(si.mSensor.getMaximumRange());
        sb.append(" resolution ").append(si.mSensor.getResolution());
        SensorItem sensorItem = si;
        synchronized (sensorItem) {
            sb.append(" accuracy ").append(si.mAccuracy).append(" values {");
            if (si.mValues != null) {
                for (n = 0; n < si.mValues.length; ++n) {
                    if (n > 0) {
                        sb.append(" ");
                    }
                    sb.append(si.mValues[n]);
                }
            }
            sb.append("}");
            if (si.mType == 2 && si.mOrientation != null) {
                sb.append(" orientation {");
                for (n = 0; n < si.mOrientation.length; ++n) {
                    if (n > 0) {
                        sb.append(" ");
                    }
                    sb.append(si.mOrientation[n]);
                }
                sb.append("} inclination ").append(si.mInclination);
            } else if (si.mType == 6 && si.mValues != null) {
                sb.append(" altitude ");
                sb.append(SensorManager.getAltitude((float)1013.25f, (float)si.mValues[0]));
            }
            if (si.mRotationMatrix != null && si.mRotationMatrix.length > 0) {
                sb.append(" rotation_matrix {");
                for (n = 0; n < si.mRotationMatrix.length; ++n) {
                    if (n > 0) {
                        sb.append(" ");
                    }
                    sb.append(si.mRotationMatrix[n]);
                }
                sb.append("}");
            }
            si.mOverflow = 0;
            si.mTrigger = 0;
        }
        return sb.toString();
    }
}

