/*
 * Decompiled with CFR 0.152.
 */
package tk.tcl.wish;

import android.media.AudioRecord;
import android.media.AudioTrack;
import android.util.Log;
import java.io.FileDescriptor;
import tk.tcl.wish.AudioIO;
import tk.tcl.wish.PlayThread;
import tk.tcl.wish.RecordThread;

public class SnackAudio {
    static final String TAG = "SnackAudio";
    AudioIO mAio;

    public SnackAudio(FileDescriptor fd, AudioRecord in, int n, int r) {
        this.mAio = new RecordThread(fd, in, n, r);
    }

    public SnackAudio(FileDescriptor fd, AudioTrack out, int n) {
        this.mAio = new PlayThread(fd, out, n);
    }

    public void stop() {
        if (this.mAio != null) {
            this.mAio.stopAudio();
        }
    }

    public void start() {
        if (this.mAio != null) {
            this.mAio.startAudio();
        }
    }

    public void flush() {
        if (this.mAio != null) {
            this.mAio.flush();
        }
    }

    public int played() {
        if (this.mAio != null) {
            return this.mAio.played();
        }
        return 0;
    }

    public void close() {
        if (this.mAio != null) {
            this.mAio.close();
        }
        this.mAio = null;
    }

    public static SnackAudio open(boolean recording, FileDescriptor fd, int srcsink, int rate, int conf) {
        if (recording) {
            int n = AudioRecord.getMinBufferSize((int)rate, (int)conf, (int)2);
            Log.v((String)TAG, (String)("record bufsize: " + n));
            if (n <= 0) {
                return null;
            }
            AudioRecord in = new AudioRecord(srcsink, rate, conf, 2, n * (1 + rate / 10000));
            if (in.getState() != 1) {
                Log.e((String)TAG, (String)"record not in STATE_INITIALIZED");
                in = null;
                return null;
            }
            return new SnackAudio(fd, in, n, rate);
        }
        int n = AudioTrack.getMinBufferSize((int)rate, (int)conf, (int)2);
        Log.v((String)TAG, (String)("play bufsize: " + n));
        if (n <= 0) {
            return null;
        }
        AudioTrack out = new AudioTrack(3, rate, conf, 2, n * 2, 1);
        if (out.getState() != 1) {
            Log.e((String)TAG, (String)"play not in STATE_INITIALIZED");
            out = null;
            return null;
        }
        return new SnackAudio(fd, out, n);
    }
}

