/*
 * Decompiled with CFR 0.152.
 */
package tk.tcl.wish;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.speech.RecognitionListener;
import android.speech.SpeechRecognizer;
import android.util.Log;
import tk.tcl.wish.AndroWish;

class SpeechRec
implements RecognitionListener {
    private static final String TAG = "AndroWish";
    AndroWish mAW;
    SpeechRecognizer mSpeechRecognizer;

    public SpeechRec(AndroWish aw) {
        this.mAW = aw;
        this.mSpeechRecognizer = SpeechRecognizer.createSpeechRecognizer((Context)this.mAW);
    }

    public void onBeginningOfSpeech() {
        this.speechCallback("begin");
    }

    public void onBufferReceived(byte[] buffer) {
    }

    public void onEndOfSpeech() {
        this.speechCallback("end");
    }

    public void onError(int error) {
        this.speechCallback("error", error);
    }

    public void onEvent(int eventType, Bundle params) {
        this.speechCallback("event", eventType, params);
    }

    public void onPartialResults(Bundle partialResults) {
        this.speechCallback("partialresult", partialResults);
    }

    public void onReadyForSpeech(Bundle params) {
        this.speechCallback("ready", params);
    }

    public void onResults(Bundle results) {
        this.speechCallback("result", results);
    }

    public void onRmsChanged(float rmsdB) {
        this.speechCallback("rms", rmsdB);
    }

    void speechCallback(String op) {
        int k = 0;
        String[] args = new String[2];
        args[k++] = "type";
        args[k++] = op;
        Log.v((String)TAG, (String)("nativeTriggerSpeech: " + op + " " + args));
        AndroWish.nativeTriggerSpeech(args);
    }

    void speechCallback(String op, Bundle data) {
        String[] args;
        boolean k = false;
        if (data != null) {
            String[] addargs = new String[]{"type", op};
            args = this.mAW.formatBundle(data, addargs);
        } else {
            args = new String[]{"type", op};
        }
        Log.v((String)TAG, (String)("nativeTriggerSpeech: " + op + " " + args));
        AndroWish.nativeTriggerSpeech(args);
    }

    void speechCallback(String op, int num, Bundle data) {
        String[] args;
        boolean k = false;
        if (data != null) {
            String[] addargs = new String[]{"type", op, "value", "" + num};
            args = this.mAW.formatBundle(data, addargs);
        } else {
            args = new String[]{"type", op, "value", "" + num};
        }
        Log.v((String)TAG, (String)("nativeTriggerSpeech: " + op + " " + args));
        AndroWish.nativeTriggerSpeech(args);
    }

    void speechCallback(String op, int data) {
        String[] args = new String[]{"type", op, "value", "" + data};
        Log.v((String)TAG, (String)("nativeTriggerSpeech: " + op + " " + args));
        AndroWish.nativeTriggerSpeech(args);
    }

    void speechCallback(String op, float data) {
        String[] args = new String[]{"type", op, "value", "" + data};
        Log.v((String)TAG, (String)("nativeTriggerSpeech: " + op + " " + args));
        AndroWish.nativeTriggerSpeech(args);
    }

    public void cancel() {
        if (this.mSpeechRecognizer != null) {
            this.mSpeechRecognizer.cancel();
        }
    }

    public void stop() {
        if (this.mSpeechRecognizer != null) {
            this.mSpeechRecognizer.stopListening();
        }
    }

    public void start(Intent i) {
        if (this.mSpeechRecognizer != null) {
            this.mSpeechRecognizer.cancel();
            this.mSpeechRecognizer.setRecognitionListener((RecognitionListener)this);
            this.mSpeechRecognizer.startListening(i);
        }
    }

    public void destroy() {
        if (this.mSpeechRecognizer != null) {
            this.mSpeechRecognizer.cancel();
            this.mSpeechRecognizer.destroy();
            this.mSpeechRecognizer = null;
        }
    }
}

