/*
 * Decompiled with CFR 0.152.
 */
package tk.tcl.wish;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.util.Log;
import java.util.concurrent.CountDownLatch;
import tk.tcl.wish.AndroWish;

class UsbPermissionTest {
    AndroWish mAW;
    UsbDevice mDev;
    boolean mGranted;
    final String USB_PERMISSION = "tk.tcl.wish.UsbPermission";

    public UsbPermissionTest(AndroWish aw) {
        this.mAW = aw;
        this.mDev = null;
        this.mGranted = false;
    }

    public int ask(UsbDevice dev) {
        this.mDev = dev;
        this.mGranted = false;
        final CountDownLatch lock = new CountDownLatch(1);
        BroadcastReceiver recvr = new BroadcastReceiver(){

            public void onReceive(Context ctx, Intent i) {
                String a = i.getAction();
                if (a.equals("tk.tcl.wish.UsbPermission")) {
                    UsbDevice d = (UsbDevice)i.getParcelableExtra("device");
                    if (i.getBooleanExtra("permission", false)) {
                        if (d != null && d.getDeviceName().equals(UsbPermissionTest.this.mDev.getDeviceName())) {
                            UsbPermissionTest.this.mGranted = true;
                        }
                    } else {
                        Log.e((String)"AndroWish", (String)("permission denied for device " + d.getDeviceName()));
                    }
                    lock.countDown();
                }
            }
        };
        UsbPermissionTest usbPermissionTest = this;
        Context ctx = usbPermissionTest.mAW.getContext();
        PendingIntent pi = PendingIntent.getBroadcast((Context)ctx, (int)0, (Intent)new Intent("tk.tcl.wish.UsbPermission"), (int)0);
        IntentFilter filter = new IntentFilter("tk.tcl.wish.UsbPermission");
        ctx.registerReceiver(recvr, filter);
        AndroWish.mUsbManager.requestPermission(dev, pi);
        try {
            lock.await();
        }
        catch (InterruptedException ie) {
            pi.cancel();
        }
        ctx.unregisterReceiver(recvr);
        return this.mGranted ? 1 : 0;
    }
}

