/*
 * Decompiled with CFR 0.152.
 */
package tk.tcl.wish;

import android.database.Cursor;
import android.util.Base64;

public class WrappedCursor {
    private Cursor mCursor;

    public WrappedCursor(Cursor cursor) {
        this.mCursor = cursor;
    }

    public String getType(int index) {
        String type = "unknown";
        switch (this.mCursor.getType(index)) {
            case 4: {
                type = "blob";
                break;
            }
            case 2: {
                type = "double";
                break;
            }
            case 1: {
                type = "int";
                break;
            }
            case 0: {
                type = "null";
                break;
            }
            case 3: {
                type = "string";
            }
        }
        return type;
    }

    public void close() {
        this.mCursor.close();
    }

    public String getBlob(int index) {
        byte[] blob = this.mCursor.getBlob(index);
        if (blob == null) {
            return null;
        }
        return Base64.encodeToString((byte[])blob, (int)0);
    }

    public int getColumnCount() {
        return this.mCursor.getColumnCount();
    }

    public String[] getColumnNames() {
        return this.mCursor.getColumnNames();
    }

    public int getCount() {
        return this.mCursor.getCount();
    }

    public double getDouble(int index) {
        return this.mCursor.getDouble(index);
    }

    public long getLong(int index) {
        return this.mCursor.getLong(index);
    }

    public int getPosition() {
        return this.mCursor.getPosition();
    }

    public String getString(int index) {
        return new String(this.mCursor.getString(index));
    }

    public boolean isNull(int index) {
        return this.mCursor.isNull(index);
    }

    public boolean move(int offset) {
        return this.mCursor.move(offset);
    }

    public boolean moveToPosition(int position) {
        return this.mCursor.moveToPosition(position);
    }

    public String[] getRow() {
        String[] names;
        String[] ret = null;
        if (!this.mCursor.isBeforeFirst() && !this.mCursor.isAfterLast() && (names = this.getColumnNames()).length > 0) {
            ret = new String[names.length * 2];
            for (int i = 0; i < names.length; ++i) {
                ret[i * 2] = names[i];
                ret[i * 2 + 1] = this.isNull(i) ? null : (this.mCursor.getType(i) == 4 ? this.getBlob(i) : this.getString(i));
            }
        }
        return ret;
    }
}

