/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.driver;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.util.Log;
import com.hoho.android.usbserial.driver.CommonUsbSerialDriver;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtdiSerialDriver
extends CommonUsbSerialDriver {
    public static final int USB_TYPE_STANDARD = 0;
    public static final int USB_TYPE_CLASS = 0;
    public static final int USB_TYPE_VENDOR = 0;
    public static final int USB_TYPE_RESERVED = 0;
    public static final int USB_RECIP_DEVICE = 0;
    public static final int USB_RECIP_INTERFACE = 1;
    public static final int USB_RECIP_ENDPOINT = 2;
    public static final int USB_RECIP_OTHER = 3;
    public static final int USB_ENDPOINT_IN = 128;
    public static final int USB_ENDPOINT_OUT = 0;
    public static final int USB_WRITE_TIMEOUT_MILLIS = 5000;
    public static final int USB_READ_TIMEOUT_MILLIS = 5000;
    private static final int SIO_RESET_REQUEST = 0;
    private static final int SIO_MODEM_CTRL_REQUEST = 1;
    private static final int SIO_SET_FLOW_CTRL_REQUEST = 2;
    private static final int SIO_SET_BAUD_RATE_REQUEST = 3;
    private static final int SIO_SET_DATA_REQUEST = 4;
    private static final int SIO_RESET_SIO = 0;
    private static final int SIO_RESET_PURGE_RX = 1;
    private static final int SIO_RESET_PURGE_TX = 2;
    public static final int FTDI_DEVICE_OUT_REQTYPE = 64;
    public static final int FTDI_DEVICE_IN_REQTYPE = 192;
    private static final int MODEM_STATUS_HEADER_LENGTH = 2;
    private final String TAG = FtdiSerialDriver.class.getSimpleName();
    private DeviceType mType = null;
    private int mInterface = 0;
    private int mMaxPacketSize = 64;
    private static final boolean ENABLE_ASYNC_READS = false;

    private final int filterStatusBytes(byte[] src, byte[] dest, int totalBytesRead, int maxPacketSize) {
        int packetsCount = totalBytesRead / maxPacketSize + 1;
        for (int packetIdx = 0; packetIdx < packetsCount; ++packetIdx) {
            int count;
            int n = count = packetIdx == packetsCount - 1 ? totalBytesRead % maxPacketSize - 2 : maxPacketSize - 2;
            if (count <= 0) continue;
            System.arraycopy(src, packetIdx * maxPacketSize + 2, dest, packetIdx * (maxPacketSize - 2), count);
        }
        return totalBytesRead - packetsCount * 2;
    }

    public FtdiSerialDriver(UsbDevice usbDevice, UsbDeviceConnection usbConnection) {
        super(usbDevice, usbConnection);
    }

    public void reset() throws IOException {
        int result = this.mConnection.controlTransfer(64, 0, 0, 0, null, 0, 5000);
        if (result != 0) {
            throw new IOException("Reset failed: result=" + result);
        }
        this.mType = DeviceType.TYPE_R;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws IOException {
        boolean opened = false;
        try {
            for (int i = 0; i < this.mDevice.getInterfaceCount(); ++i) {
                if (!this.mConnection.claimInterface(this.mDevice.getInterface(i), true)) {
                    throw new IOException("Error claiming interface " + i);
                }
                Log.d((String)this.TAG, (String)("claimInterface " + i + " SUCCESS"));
            }
            this.reset();
            opened = true;
        }
        finally {
            if (!opened) {
                this.close();
            }
        }
    }

    @Override
    public void close() {
        this.mConnection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] dest, int timeoutMillis) throws IOException {
        UsbEndpoint endpoint = this.mDevice.getInterface(0).getEndpoint(0);
        Object object = this.mReadBufferLock;
        synchronized (object) {
            int readAmt = Math.min(dest.length, this.mReadBuffer.length);
            int totalBytesRead = this.mConnection.bulkTransfer(endpoint, this.mReadBuffer, readAmt, timeoutMillis);
            if (totalBytesRead < 2) {
                throw new IOException("Expected at least 2 bytes");
            }
            return this.filterStatusBytes(this.mReadBuffer, dest, totalBytesRead, endpoint.getMaxPacketSize());
        }
    }

    @Override
    public int write(byte[] src, int timeoutMillis) throws IOException {
        return this.write(src, 0, src.length, timeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(byte[] src, int offset, int length, int timeoutMillis) throws IOException {
        UsbEndpoint endpoint = this.mDevice.getInterface(0).getEndpoint(1);
        int count = 0;
        while (offset < src.length && length > 0) {
            int amtWritten;
            int writeLength;
            Object object = this.mWriteBufferLock;
            synchronized (object) {
                byte[] writeBuffer;
                writeLength = Math.min(length, this.mWriteBuffer.length);
                if (offset == 0) {
                    writeBuffer = src;
                } else {
                    System.arraycopy(src, offset, this.mWriteBuffer, 0, writeLength);
                    writeBuffer = this.mWriteBuffer;
                }
                amtWritten = this.mConnection.bulkTransfer(endpoint, writeBuffer, writeLength, timeoutMillis);
            }
            if (amtWritten <= 0) {
                throw new IOException("Error writing " + writeLength + " bytes at offset " + offset + " length=" + src.length);
            }
            Log.d((String)this.TAG, (String)("Wrote amtWritten=" + amtWritten + " attempted=" + writeLength));
            offset += amtWritten;
            count += amtWritten;
            length -= amtWritten;
        }
        return count;
    }

    private int setBaudRate(int baudRate) throws IOException {
        long[] vals = this.convertBaudrate(baudRate);
        long actualBaudrate = vals[0];
        long value = vals[2];
        long index = vals[1];
        int result = this.mConnection.controlTransfer(64, 3, (int)value, (int)index, null, 0, 5000);
        if (result != 0) {
            throw new IOException("Setting baudrate failed: result=" + result);
        }
        return (int)actualBaudrate;
    }

    @Override
    public void setParameters(int baudRate, int dataBits, int stopBits, int parity) throws IOException {
        this.setBaudRate(baudRate);
        int config = dataBits;
        switch (parity) {
            case 0: {
                config |= 0;
                break;
            }
            case 1: {
                config |= 0x100;
                break;
            }
            case 2: {
                config |= 0x200;
                break;
            }
            case 3: {
                config |= 0x300;
                break;
            }
            case 4: {
                config |= 0x400;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown parity value: " + parity);
            }
        }
        switch (stopBits) {
            case 1: {
                config |= 0;
                break;
            }
            case 3: {
                config |= 0x800;
                break;
            }
            case 2: {
                config |= 0x1000;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown stopBits value: " + stopBits);
            }
        }
        int result = this.mConnection.controlTransfer(64, 4, config, 0, null, 0, 5000);
        if (result != 0) {
            throw new IOException("Setting parameters failed: result=" + result);
        }
    }

    private long[] convertBaudrate(int baudrate) {
        long index;
        long encodedDivisor;
        int divisor = 24000000 / baudrate;
        int bestDivisor = 0;
        int bestBaud = 0;
        int bestBaudDiff = 0;
        int[] fracCode = new int[]{0, 3, 2, 4, 1, 5, 6, 7};
        for (int i = 0; i < 2; ++i) {
            int tryDivisor = divisor + i;
            if (tryDivisor <= 8) {
                tryDivisor = 8;
            } else if (this.mType != DeviceType.TYPE_AM && tryDivisor < 12) {
                tryDivisor = 12;
            } else if (divisor < 16) {
                tryDivisor = 16;
            } else if (this.mType != DeviceType.TYPE_AM && tryDivisor > 131071) {
                tryDivisor = 131071;
            }
            int baudEstimate = (24000000 + tryDivisor / 2) / tryDivisor;
            int baudDiff = baudEstimate < baudrate ? baudrate - baudEstimate : baudEstimate - baudrate;
            if (i != 0 && baudDiff >= bestBaudDiff) continue;
            bestDivisor = tryDivisor;
            bestBaud = baudEstimate;
            bestBaudDiff = baudDiff;
            if (baudDiff == 0) break;
        }
        if ((encodedDivisor = (long)(bestDivisor >> 3 | fracCode[bestDivisor & 7] << 14)) == 1L) {
            encodedDivisor = 0L;
        } else if (encodedDivisor == 16385L) {
            encodedDivisor = 1L;
        }
        long value = encodedDivisor & 0xFFFFL;
        if (this.mType == DeviceType.TYPE_2232C || this.mType == DeviceType.TYPE_2232H || this.mType == DeviceType.TYPE_4232H) {
            index = encodedDivisor >> 8 & 0xFFFFL;
            index &= 0xFF00L;
            index |= 0L;
        } else {
            index = encodedDivisor >> 16 & 0xFFFFL;
        }
        return new long[]{bestBaud, index, value};
    }

    @Override
    public boolean getCD() throws IOException {
        return false;
    }

    @Override
    public boolean getCTS() throws IOException {
        return false;
    }

    @Override
    public boolean getDSR() throws IOException {
        return false;
    }

    @Override
    public boolean getDTR() throws IOException {
        return false;
    }

    @Override
    public void setDTR(boolean value) throws IOException {
    }

    @Override
    public boolean getRI() throws IOException {
        return false;
    }

    @Override
    public boolean getRTS() throws IOException {
        return false;
    }

    @Override
    public void setRTS(boolean value) throws IOException {
    }

    @Override
    public boolean purgeHwBuffers(boolean purgeReadBuffers, boolean purgeWriteBuffers) throws IOException {
        int result;
        if (purgeReadBuffers && (result = this.mConnection.controlTransfer(64, 0, 1, 0, null, 0, 5000)) != 0) {
            throw new IOException("Flushing RX failed: result=" + result);
        }
        if (purgeWriteBuffers && (result = this.mConnection.controlTransfer(64, 0, 2, 0, null, 0, 5000)) != 0) {
            throw new IOException("Flushing RX failed: result=" + result);
        }
        return true;
    }

    public static Map<Integer, int[]> getSupportedDevices() {
        LinkedHashMap<Integer, int[]> supportedDevices = new LinkedHashMap<Integer, int[]>();
        supportedDevices.put(1027, new int[]{24577, 24597});
        return supportedDevices;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DeviceType {
        TYPE_BM,
        TYPE_AM,
        TYPE_2232C,
        TYPE_R,
        TYPE_2232H,
        TYPE_4232H;

    }
}

