/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.driver;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbManager;
import com.hoho.android.usbserial.driver.CdcAcmSerialDriver;
import com.hoho.android.usbserial.driver.Ch34xSerialDriver;
import com.hoho.android.usbserial.driver.Cp2102SerialDriver;
import com.hoho.android.usbserial.driver.FtdiSerialDriver;
import com.hoho.android.usbserial.driver.ProlificSerialDriver;
import com.hoho.android.usbserial.driver.UsbSerialDriver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum UsbSerialProber {
    FTDI_SERIAL{

        @Override
        public List<UsbSerialDriver> probe(UsbManager manager, UsbDevice usbDevice) {
            if (!UsbSerialProber.testIfSupported(usbDevice, FtdiSerialDriver.getSupportedDevices())) {
                return Collections.emptyList();
            }
            UsbDeviceConnection connection = manager.openDevice(usbDevice);
            if (connection == null) {
                return Collections.emptyList();
            }
            FtdiSerialDriver driver = new FtdiSerialDriver(usbDevice, connection);
            return Collections.singletonList(driver);
        }
    }
    ,
    CDC_ACM_SERIAL{

        @Override
        public List<UsbSerialDriver> probe(UsbManager manager, UsbDevice usbDevice) {
            if (!UsbSerialProber.testIfSupported(usbDevice, CdcAcmSerialDriver.getSupportedDevices())) {
                return Collections.emptyList();
            }
            UsbDeviceConnection connection = manager.openDevice(usbDevice);
            if (connection == null) {
                return Collections.emptyList();
            }
            CdcAcmSerialDriver driver = new CdcAcmSerialDriver(usbDevice, connection);
            return Collections.singletonList(driver);
        }
    }
    ,
    SILABS_SERIAL{

        @Override
        public List<UsbSerialDriver> probe(UsbManager manager, UsbDevice usbDevice) {
            if (!UsbSerialProber.testIfSupported(usbDevice, Cp2102SerialDriver.getSupportedDevices())) {
                return Collections.emptyList();
            }
            UsbDeviceConnection connection = manager.openDevice(usbDevice);
            if (connection == null) {
                return Collections.emptyList();
            }
            Cp2102SerialDriver driver = new Cp2102SerialDriver(usbDevice, connection);
            return Collections.singletonList(driver);
        }
    }
    ,
    PROLIFIC_SERIAL{

        @Override
        public List<UsbSerialDriver> probe(UsbManager manager, UsbDevice usbDevice) {
            if (!UsbSerialProber.testIfSupported(usbDevice, ProlificSerialDriver.getSupportedDevices())) {
                return Collections.emptyList();
            }
            UsbDeviceConnection connection = manager.openDevice(usbDevice);
            if (connection == null) {
                return Collections.emptyList();
            }
            ProlificSerialDriver driver = new ProlificSerialDriver(usbDevice, connection);
            return Collections.singletonList(driver);
        }
    }
    ,
    QINHENG_SERIAL{

        @Override
        public List<UsbSerialDriver> probe(UsbManager manager, UsbDevice usbDevice) {
            if (!UsbSerialProber.testIfSupported(usbDevice, Ch34xSerialDriver.getSupportedDevices())) {
                return Collections.emptyList();
            }
            UsbDeviceConnection connection = manager.openDevice(usbDevice);
            if (connection == null) {
                return Collections.emptyList();
            }
            Ch34xSerialDriver driver = new Ch34xSerialDriver(usbDevice, connection);
            return Collections.singletonList(driver);
        }
    };


    protected abstract List<UsbSerialDriver> probe(UsbManager var1, UsbDevice var2);

    public static UsbSerialDriver findFirstDevice(UsbManager usbManager) {
        for (UsbDevice usbDevice : usbManager.getDeviceList().values()) {
            for (UsbSerialProber prober : UsbSerialProber.values()) {
                List<UsbSerialDriver> probedDevices = prober.probe(usbManager, usbDevice);
                if (probedDevices.isEmpty()) continue;
                return probedDevices.get(0);
            }
        }
        return null;
    }

    public static List<UsbSerialDriver> findAllDevices(UsbManager usbManager) {
        ArrayList<UsbSerialDriver> result = new ArrayList<UsbSerialDriver>();
        for (UsbDevice usbDevice : usbManager.getDeviceList().values()) {
            result.addAll(UsbSerialProber.probeSingleDevice(usbManager, usbDevice));
        }
        return result;
    }

    public static List<UsbSerialDriver> probeSingleDevice(UsbManager usbManager, UsbDevice usbDevice) {
        ArrayList<UsbSerialDriver> result = new ArrayList<UsbSerialDriver>();
        for (UsbSerialProber prober : UsbSerialProber.values()) {
            List<UsbSerialDriver> probedDevices = prober.probe(usbManager, usbDevice);
            result.addAll(probedDevices);
        }
        return result;
    }

    @Deprecated
    public static UsbSerialDriver acquire(UsbManager usbManager) {
        return UsbSerialProber.findFirstDevice(usbManager);
    }

    @Deprecated
    public static UsbSerialDriver acquire(UsbManager usbManager, UsbDevice usbDevice) {
        List<UsbSerialDriver> probedDevices = UsbSerialProber.probeSingleDevice(usbManager, usbDevice);
        if (!probedDevices.isEmpty()) {
            return probedDevices.get(0);
        }
        return null;
    }

    private static boolean testIfSupported(UsbDevice usbDevice, Map<Integer, int[]> supportedDevices) {
        int[] supportedProducts = supportedDevices.get(usbDevice.getVendorId());
        if (supportedProducts == null) {
            return false;
        }
        int productId = usbDevice.getProductId();
        for (int supportedProductId : supportedProducts) {
            if (productId != supportedProductId) continue;
            return true;
        }
        return false;
    }

    public static List<UsbDevice> findSupportedDevices(UsbManager usbManager) {
        ArrayList<UsbDevice> result = new ArrayList<UsbDevice>();
        for (UsbDevice usbDevice : usbManager.getDeviceList().values()) {
            if (!UsbSerialProber.testIfSupported(usbDevice, FtdiSerialDriver.getSupportedDevices()) && !UsbSerialProber.testIfSupported(usbDevice, CdcAcmSerialDriver.getSupportedDevices()) && !UsbSerialProber.testIfSupported(usbDevice, Cp2102SerialDriver.getSupportedDevices()) && !UsbSerialProber.testIfSupported(usbDevice, ProlificSerialDriver.getSupportedDevices()) && !UsbSerialProber.testIfSupported(usbDevice, Ch34xSerialDriver.getSupportedDevices())) continue;
            result.add(usbDevice);
        }
        return result;
    }
}

