/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.util;

import android.util.Log;
import com.hoho.android.usbserial.driver.UsbSerialDriver;
import java.io.IOException;
import java.nio.ByteBuffer;

public class SerialInputOutputManager
implements Runnable {
    private static final String TAG = SerialInputOutputManager.class.getSimpleName();
    private static final boolean DEBUG = true;
    private static final int READ_WAIT_MILLIS = 200;
    private static final int BUFSIZ = 4096;
    private final UsbSerialDriver mDriver;
    private final ByteBuffer mReadBuffer = ByteBuffer.allocate(4096);
    private final ByteBuffer mWriteBuffer = ByteBuffer.allocate(4096);
    private State mState = State.STOPPED;
    private Listener mListener;

    public SerialInputOutputManager(UsbSerialDriver driver) {
        this(driver, null);
    }

    public SerialInputOutputManager(UsbSerialDriver driver, Listener listener) {
        this.mDriver = driver;
        this.mListener = listener;
    }

    public synchronized void setListener(Listener listener) {
        this.mListener = listener;
    }

    public synchronized Listener getListener() {
        return this.mListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAsync(byte[] data) {
        ByteBuffer byteBuffer = this.mWriteBuffer;
        synchronized (byteBuffer) {
            this.mWriteBuffer.put(data);
        }
    }

    public synchronized void stop() {
        if (this.getState() == State.RUNNING) {
            Log.i((String)TAG, (String)"Stop requested");
            this.mState = State.STOPPING;
        }
    }

    private synchronized State getState() {
        return this.mState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        SerialInputOutputManager serialInputOutputManager = this;
        synchronized (serialInputOutputManager) {
            if (this.getState() != State.STOPPED) {
                throw new IllegalStateException("Already running.");
            }
            this.mState = State.RUNNING;
        }
        Log.i((String)TAG, (String)"Running ..");
        try {
            while (true) {
                if (this.getState() != State.RUNNING) {
                    Log.i((String)TAG, (String)("Stopping mState=" + (Object)((Object)this.getState())));
                    break;
                }
                this.step();
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("Run ending due to exception: " + e.getMessage()), (Throwable)e);
            Listener listener = this.getListener();
            if (listener != null) {
                listener.onRunError(e);
            }
        }
        finally {
            SerialInputOutputManager serialInputOutputManager2 = this;
            synchronized (serialInputOutputManager2) {
                this.mState = State.STOPPED;
                Log.i((String)TAG, (String)"Stopped.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void step() throws IOException {
        int len = this.mDriver.read(this.mReadBuffer.array(), 200);
        if (len > 0) {
            Log.d((String)TAG, (String)("Read data len=" + len));
            Listener listener = this.getListener();
            if (listener != null) {
                byte[] data = new byte[len];
                this.mReadBuffer.get(data, 0, len);
                listener.onNewData(data);
            }
            this.mReadBuffer.clear();
        }
        byte[] outBuff = null;
        ByteBuffer byteBuffer = this.mWriteBuffer;
        synchronized (byteBuffer) {
            if (this.mWriteBuffer.position() > 0) {
                len = this.mWriteBuffer.position();
                outBuff = new byte[len];
                this.mWriteBuffer.rewind();
                this.mWriteBuffer.get(outBuff, 0, len);
                this.mWriteBuffer.clear();
            }
        }
        if (outBuff != null) {
            Log.d((String)TAG, (String)("Writing data len=" + len));
            this.mDriver.write(outBuff, 200);
        }
    }

    public static interface Listener {
        public void onNewData(byte[] var1);

        public void onRunError(Exception var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        STOPPED,
        RUNNING,
        STOPPING;

    }
}

