#!../src/bltwish

package require BLT

# --------------------------------------------------------------------------
# Starting with Tcl 8.x, the BLT commands are stored in their own 
# namespace called "blt".  The idea is to prevent name clashes with
# Tcl commands and variables from other packages, such as a "table"
# command in two different packages.  
#
# You can access the BLT commands in a couple of ways.  You can prefix
# all the BLT commands with the namespace qualifier "blt::"
#  
#    blt::graph .g
#    blt::table . .g -resize both
# 
# or you can import all the command into the global namespace.
#
#    namespace import blt::*
#    graph .g
#    table . .g -resize both
#
# --------------------------------------------------------------------------

if { $tcl_version >= 8.0 } {
    namespace import blt::*
}

source [file join [file dirname [info script]] scripts demo.tcl]

set graph [graph .g]

source [file join [file dirname [info script]] scripts graph1.tcl]

proc MultiplexView { args } { 
    eval .g axis view y $args
    eval .g axis view y2 $args
}

scrollbar .xbar \
    -command { .g axis view x } \
    -orient horizontal -relief flat \
    -highlightthickness 0 -elementborderwidth 2 -bd 0
scrollbar .ybar \
    -command MultiplexView \
    -orient vertical -relief flat  -highlightthickness 0 -elementborderwidth 2
table . \
    0,0 .g -fill both -cspan 3 -rspan 3 \
    1,3 .ybar -fill y -padx 0 -pady 0 -rspan 2 \
    3,1 .xbar -fill x \

table configure . c3 r3 -resize none

.g postscript configure \
    -center yes \
    -maxpect yes \
    -landscape no \
    -preview yes

.g axis configure x \
    -scrollcommand { .xbar set } \
    -scrollmax 10 \
    -scrollmin 2 

.g axis configure y \
    -scrollcommand { .ybar set }

.g axis configure y2 \
    -scrollmin 0.0 -scrollmax 1.0 \
    -hide no \
    -title "Y2" 

.g legend configure \
    -activerelief flat \
    -activeborderwidth 1  \
    -position top -anchor ne

.g pen configure "activeLine" \
    -showvalues y
.g element bind all <Enter> {
    %W legend activate [%W element get current]
}
.g configure -plotpady { 1i 0 } 
.g element bind all <Leave> {
    %W legend deactivate [%W element get current]
}
.g axis bind all <Enter> {
    set axis [%W axis get current]
    %W axis configure $axis -background lightblue2
}
.g axis bind all <Leave> {
    set axis [%W axis get current]
    %W axis configure $axis -background "" 
}
.g configure -leftvariable left 
trace add variable left write "UpdateTable .g"
proc UpdateTable { graph p1 p2 how } {
    table configure . c0 -width [$graph extents leftmargin]
    table configure . c2 -width [$graph extents rightmargin]
    table configure . r0 -height [$graph extents topmargin]
    table configure . r2 -height [$graph extents bottommargin]
}

set sharky [file join [file dirname [info script]] bitmaps sharky.xbm]
.g element configure line2 -areapattern @$sharky
# -areaforeground blue -areabackground ""
.g configure -title [pwd]
