#!../src/bltwish

package require BLT
# --------------------------------------------------------------------------
# Starting with Tcl 8.x, the BLT commands are stored in their own 
# namespace called "blt".  The idea is to prevent name clashes with
# Tcl commands and variables from other packages, such as a "table"
# command in two different packages.  
#
# You can access the BLT commands in a couple of ways.  You can prefix
# all the BLT commands with the namespace qualifier "blt::"
#  
#    blt::graph .g
#    blt::table . .g -resize both
# 
# or you can import all the command into the global namespace.
#
#    namespace import blt::*
#    graph .g
#    table . .g -resize both
#
# --------------------------------------------------------------------------
if { $tcl_version >= 8.0 } {
    namespace import blt::*
}

source [file join [file dirname [info script]] scripts demo.tcl]
source [file join [file dirname [info script]] scripts stipples.tcl]

set visual [winfo screenvisual .]
if { $visual != "staticgray" && $visual != "grayscale" } {
    option add *Button.Background		red
    option add *TextMarker.Foreground	black
    option add *TextMarker.Background	yellow
    option add *LineMarker.Foreground	black
    option add *LineMarker.Background	yellow
    option add *PolyMarker.Fill		yellow2
    option add *PolyMarker.Outline	""
    option add *PolyMarker.Stipple	fdiagonal1
    option add *activeLine.Color	red4
    option add *activeLine.Fill		red2
    option add *Element.Color		purple
}

if {[tk windowingsystem] eq "win32"} {
    option add *Text.font		{Arial bold 14}
    option add *header.font		{Arial 14}
    option add *footer.font		{Arial 14}
} else {
    option add *Text.font		{Helvetica bold 14}
    option add *header.font		{Helvetica 14}
    option add *footer.font		{Helvetica 14}
}
option add *HighlightThickness		0

set graph [graph .g]
source [file join [file dirname [info script]] scripts graph3.tcl]

text .header \
    -wrap word \
    -width 0 \
    -height 3

set text {
This is an example of a bitmap marker.  Try zooming in on 
a region by clicking the left button, moving the pointer, 
and clicking again.  Notice that the bitmap scales too. 
To restore the last view, click on the right button.  
}
regsub -all "\n" $text "" text
.header insert end "$text\n"
.header configure -state disabled

table . \
    .header 0,0 -fill x -padx 4 -pady 4\
    $graph 1,0 -fill both

table configure . r0 -resize none

source [file join [file dirname [info script]] scripts ps.tcl]

bind $graph <Shift-ButtonPress-1> { 
    MakePsLayout $graph
}

