package require Tk
source [file join [file dirname [info script]] flexmenu.tcl]

set padx 3p
set pady 3p
set mode toplevel
set ar flat         ; # active relief
set sticky false
set ko false        ; # keep open
set yal 0 ; # y alignment
set xal 0 ; # x alignment
set abw 3p ; # active border width

flexmenu .mw  -keepopen $ko -pady $pady -padx $padx \
    -activerelief $ar -activeborderwidth $abw -mode $mode
ttk::combobox .mw.cb -values {aa bb cc dd ee ff gg} \
    -textvariable ::y -state readonly -width 4
.mw add widget -widget .mw.cb
ttk::entry .mw.e -textvariable ::z -width 10
.mw add widget -widget .mw.e

flexmenu .mtop -type menubar -keepopen $ko -stickycascade $sticky
.mtop add command -label Exit -underline 0 -command exit
.mtop add separator
.mtop add cascade -label Widgets -menu .mw -yalign $yal -xalign $xal
pack .mtop -side top -fill x -expand 1 -anchor nw

frame .f -width 200 -height 200
pack .f
lower .f
