package require Tk
source [file join [file dirname [info script]] flexmenu.tcl]

proc doclock { } {
  variable vars

  # this is not quite localized...
  if { 1 } {
    # 12 hour clock
    set vars(clock.disp) [clock format [clock seconds] \
        -format "%A %B %Oe  %r" -locale system]
  } else {
    set vars(clock.disp) [clock format [clock seconds] \
        -format "%A %B %Oe  %R" -locale system]
  }
  after 500 ::doclock
}

set padx 3p
set pady 3p
set mode toplevel
set ar flat         ; # active relief
set sticky false
set ko false        ; # keep open
set yal 0 ; # y alignment
set xal 0 ; # x alignment
set abw 3p ; # active border width

flexmenu .mtop -type menubar -keepopen $ko -stickycascade $sticky
.mtop add command -label Exit -underline 0 -command exit
set fc [ttk::style lookup TLabel -foreground]
set bc [ttk::style lookup TLabel -background]
ttk::style map Clock.TLabel \
    -foreground [list disabled $fc] -background [list disabled $bc]
ttk::label .mtop.clockdisp \
    -textvariable ::vars(clock.disp) \
    -anchor e \
    -style Clock.TLabel
.mtop add widget -widget .mtop.clockdisp \
    -hidemargin true -gap true -state disabled
pack .mtop -side top -fill x -expand 1 -anchor nw

frame .f -width 200 -height 200
pack .f
lower .f

doclock
