package require Tk
source [file join [file dirname [info script]] flexmenu.tcl]

proc doclock { } {
  variable vars

  # this is not quite localized...
  if { 1 } {
    # 12 hour clock
    set vars(clock.disp) [clock format [clock seconds] \
        -format "%r" -locale system]
  } else {
    set vars(clock.disp) [clock format [clock seconds] \
        -format "%R" -locale system]
  }
  after 500 ::doclock
}

set padx 3p
set pady 3p
set mode toplevel
set ar flat         ; # active relief
set sticky false
set ko false        ; # keep open
set yal 0 ; # y alignment
set xal 0 ; # x alignment
set abw 3p ; # active border width

flexmenu .mtop -type menubar -keepopen $ko -stickycascade $sticky
.mtop add command -label Exit -underline 0 -command exit
.mtop add command -label Help -underline 0
set fc [ttk::style lookup TLabel -foreground]
set bc [ttk::style lookup TLabel -background]
ttk::style map Clock.TLabel \
    -foreground [list disabled $fc] -background [list disabled $bc]
ttk::label .mtop.clockdisp \
    -textvariable ::vars(clock.disp) \
    -anchor e \
    -style Clock.TLabel
.mtop add widget -widget .mtop.clockdisp \
    -hidemargin true -gap true -state disabled
pack .mtop -side top -fill x -expand 1 -anchor nw

flexmenu .mcA -keepopen $ko -pady $pady -padx $padx \
    -activerelief $ar -activeborderwidth $abw -mode $mode
.mcA add command -label One -underline 1 -command { puts 1 }
.mcA add command -label Two -underline 0 -command { puts 2 }
.mcA add command -label Three -underline 1 -command { puts 3 }
.mcA add command -label Four -underline 2 -command { puts 4 }

flexmenu .mcB -keepopen $ko -pady $pady -padx $padx \
    -activerelief $ar -activeborderwidth $abw -mode $mode
.mcB add command -label Five -underline 1 -command { puts 5 }
.mcB add command -label Six -underline 0 -command { puts 6 }
.mcB add command -label Seven -underline 1 -command { puts 7 }
.mcB add command -label Eight -underline 2 -command { puts 8 }

flexmenu .mtopB -type menubar -keepopen $ko -stickycascade $sticky
.mtopB add cascade -label Multiple -menu .mcA
.mtopB add cascade -label Menus -menu .mcB
pack .mtopB -side top -fill x -expand 1 -anchor nw

frame .f -width 200 -height 200
pack .f
lower .f

doclock
