package require Tk
source [file join [file dirname [info script]] flexmenu.tcl]

set ::lsortcmd [list ::lsort]
try {
  package require collate
  set ::lsortcmd [list ::lsort -command collate]
} on error {err res} {
}

variable vars

proc attachmenu { pm dir } {
  if { [catch {$pm entrycget active -menu}] } {
    set m [mkmenu $dir]
    $pm entryconfigure active -menu $m
  } else {
    set m [$pm entrycget active -menu]
    refreshmenu $m $dir
  }
}

proc refreshmenu { nm dir } {
  variable vars

  set flist {}
  set tm [clock milliseconds]
  if { ! [info exists vars(cache.$dir)] ||
      ($tm - $vars(cache.ts.$dir)) > 60000 } {
    try {
      set flist [{*}$::lsortcmd [glob -directory $dir -tails *]]
    } on error {err res} {
    }
    set vars(cache.$dir) $flist
    set vars(cache.ts.$dir) [clock milliseconds]

    $nm delete 0 end

    set count 0
    foreach {f} $flist {
      set ff [file join $dir $f]
      if { [file isdirectory $ff] } {
        $nm add cascade \
            -label $f \
            -yalign menutop \
            -precommand [list ::attachmenu $nm $ff]
      } else {
        $nm add command -label $f
      }
      incr count
      if { $count > 20 } {
        break
      }
    }
  }
}

proc mkmenu { dir args } {
  variable vars

  set nm [flexmenu .m$vars(menu.counter) \
      -keepopen true \
      -padx 4p \
      -pady 4p \
      -maxheight 10 \
      -relief flat \
      {*}$args]
  refreshmenu $nm $dir
  set vars(dir.$nm) $dir
  incr vars(menu.counter)
  return $nm
}

proc main { } {
  variable vars

  set dir [lindex $::argv 0]
  if { $dir eq {} } {
    set dir /
  }
  set vars(menu.counter) 1

  set mm [mkmenu $dir -type menuleft]
  $mm configure
  grid $mm -sticky news
  grid rowconfigure . 0 -weight 1
  grid columnconfigure . 0 -weight 1

  ttk::frame .f -width 400 -height 300
  grid .f -sticky se -row 0 -column 1
  lower .f
  . configure -background [ttk::style lookup . -background]
  after 100 update
}

main
