namespace eval ::ttk::dialog::image {}

# Images for the configuration menu

image create photo ::ttk::dialog::image::blank16 -height 16 -width 16

image create photo ::ttk::dialog::image::tick16 -data {
R0lGODlhEAAQAMIAAExOTFRSVPz+/AQCBP///////////////yH5BAEKAAQALAAAAAAQABAA
AAM4CAHcvkEAQqu18uqat+4eFoTEwE3eYFLCWK2lelqyChMtbd84+sqX3IXH8pFwrmNPyRI4
n9CoIAEAOw==}

image create photo ::ttk::dialog::image::radio16 -data {
R0lGODlhEAAQAMIAAJyZi////83OxQAAAP///////////////yH5BAEKAAEALAAAAAAQABAA
AAMtGLrc/jCAOaNsAGYn3A5DuHTMFp4KuZjnkGJK6waq8qEvzGlNzQlAn2VILC4SADs=}

# Images for ttk::getOpenFile, ttk::getSaveFile, ttk::getAppendFile

image create photo ::ttk::dialog::image::next -data {
iVBORw0KGgoAAAANSUhEUgAAABYAAAAWCAYAAADEtGw7AAAABHNCSVQICAgIfAhkiAAAABl0
RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAM0SURBVDiNtZVbaB1VFIa/NbPn
5GLtRSkpKNYnb+2DhQo1idCCVgRBRa36IlKlFHxpSUkLgqJgUaQ+9EVQS2nMQ4haCiliSzSG
JqYqmhY1NMZL1KSxxgTTk+TMZc9ePpw5dZI20Yd0wc/MhjXf2v/ai9miqlyN8K4K9f+CG5uD
rvom8+CSg9WxeW3dLe83Nhd2LykYYMfDL1Svu3njq/fsNW9v2yb+koF9P+CRzdtrNq27/+nz
a03nludl2WL5Jr9oaA7+wFF3WXUjoXO2+sz5Tho3bK1asWxVw8d9bf2b9sqW06/ryJXAkh+3
hj2B7t/ZMidB1aEoTh1dQ60IHnesaWBsfNQd62r521p77+cH4v7/BL+y411O/dSeQRXFkboU
pw6nltRZUrXcVnc3Gnsc/eTwTCksPnXqDdsxx+X8SqmzRLZEZEvEaUhkQ5I0IklDYhsSpyGx
LfHN7ye4mI7x5AM7r1lx7eq2hj1B06Jg6xJKSZHJ2TEuFIcZn/6NqdKfhLZIQkgqEU5inMQM
XOhhaOILHrvvmdob6256ubHZHKxwzHxwMZxkeOJblHKLxAM/8PCd4Ac+BVPAMz7iBCcpaqLy
UxBEblgQnLhoDjSo8jCFsjwjeL4FLM4pt66sZ03hdj48cWR2anriUG9tumtBcD78wMMPPEyV
d6mAZwRPPNav2oo/u5y2jsOz01Mz+04fTN8B4KV5YBEJ6pvKy8c37EMAz0gZbgTfCCfH3qS2
poY7r3+I8ZEpPXa8ZWbyl+jZ79pdN1ALGBGJVDUxGdQABYXxt9r2r75s50bi3c+9WKj2l7Px
ukc59/25tPOzkxPDvbp9tM8NATX8OwgqImllxz7g9x2w64GqTNWV9/om0+tS5a6VT9DT3RN/
ffbLnwc+sLsujvAXUAAckGaygFm0x/kISyEffdoRDw4O9pw54l5LI2YWSXcVcL6anykGBMoj
0n68Nf71h9FDZ99zrVlukinOvsur3ApVtSJCBiJnzQImTfSrH/tHWgaOuu6skMtBKvAEKAGh
quqcf4WU6UHW24Dy1FQcSM6BznMZAZGq2kushS5TEfEpn7SfU8VN/rBSvQLkHy0nh7/z4dY0
AAAAAElFTkSuQmCC}

image create photo ::ttk::dialog::image::nextbw -data {
iVBORw0KGgoAAAANSUhEUgAAABYAAAAWCAYAAADEtGw7AAAAAXNSR0IArs4c6QAAAolJREFU
OMvdlD1v00AYx/9+SRqCEzWpEVLTDhm6RHwIkBhhZGsZ4AsYsbAyIDFGjKB2SG9A4isgIUSZ
+QBIIKS0SWO7ddzY9cvdPSw2ckzaBqkTlv7yDc/97v+83AH/5ccY+7S/v//gX/aoS8bdrdfr
Hxhjz64bjG63W2s2m68YY2/39va0awMrioL19fUb7Xb7cbVa/TgYDIxL40u1HAO4vSAu6vV6
tZOTEzQaDfi+nx4fH/8ions7OzvDZcDU6/UWOiAiOI4DAGg0GoiiSI5GI4+I7m9vb3+7shQ5
wHEc2LYN27YxmUxg2zaklBBC4PT0FLquqxsbG21N074wxh4uBZZSQko5ty7L8zxwzrG5uXmz
Uqm8Z4w9vxIshECSJIiiCHEcg3MOIQSIaE6+72M2m6HT6dRrtdpLxtibnKOXwZxzBEEwn5aq
/pkMVVWhKMqcESLK+9W50LGU8i9oDixCiQiGYcAwDBwdHYVRFO0qivLoQseLoEVw7rzZbAIA
hsNhyDl/4bruu4Xj1u/3K6ZpJt1ud+5SFGGTyQSqqmJ1dRVxHNNoNAriOH7q+/5nACmABEBs
WVaqZFAdwIppmj8B3FpgPtna2qo6joNWq4WzszNh27YbhuGTMAy/58CCzvNSaAA0x3HuAFjJ
VMvXpml+JSK0Wi24rpt4nvfD930rTVMHQBWABCAycQC6vuxbIYTAeDxOZrPZwXQ6fS2lDC4J
lzm4eJqWKcl6QABweHiYBEGwO51OWRabFurKSxLF5ulZ+lUAlcJfX1tbY2maDrImUZZ6Dsnh
KYBzAJFlWTT3CPX7fSWDreTQQgZKIQMqZRln08AXvm6lQ7TsAmkFIXNbbJawLIvK+38DjjNz
OyQohckAAAAASUVORK5CYII=}

image create photo ::ttk::dialog::image::previous -data {
iVBORw0KGgoAAAANSUhEUgAAABYAAAAWCAYAAADEtGw7AAAABHNCSVQICAgIfAhkiAAAABl0
RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAANNSURBVDiNtZVNaFxVGIaf75xz
782fUvsjGI00BY2IoILGmJks2igRqcH6H4pdSOmmK2sToS6iiBsRhIouTDetYnVRjSJCLbYb
FSKdKiiIQZRY04ihNmnoZGbuufdzMXeSMaZjXPTAyzmLj+d7v5d77hFV5Uosc0WogPs/xb37
gwERDoRtvv/UqPpGtWt23DcS7r1+U+eHRmzfWgz9J1heEpMbdm/e3HH7q3sGD7RY49K1GGnY
eWBYWnPixrtv3Zq/r/vRpsCFa2E2Buefl3bBneq/e0fnnV33Bt9Of07P5kGMo1JecIu5/cE/
6sUwG7T69lr2q4JzI+Ed1jSdGNy285rrNt1gJ6Y+BZQkTXhh11vNRgyCILKc5OjY7vXgHbA6
uPc5t721ue3ow1ufbjORMjH1CUYs1gR8MXkYIw4jBmssgkFEyG95vHEUueFg37qrN7y8o39X
y/nFKX4+ewZrApwJSDUlTROscRix+NRgMsdJGqMosho4P+IOtm/seGYg/1jL5PlvmJ77aRmo
CYGkpLZCRTyJxqDgCInsVXiNWXmDlx0b2jGIkhD7EmVfJBaLotgQwGNQjBXEVL1pqmgJiumF
f0WxlP5XzckT5/78/dBHJ9+9dNOGbrquvYeyL5KaEtgKLoKw2RK1WJpaLVFr9Rw0G1KpXB6s
o5p+/Zrf99fsheFjxw8X14cd9HQ+RBAE2MDgQkMQmSp8CWpxkcFYQYGFc8u8pShEJACiiTf8
B7c9VZwZT947cn/v9ra+zielMPsxaio8uOVZnHPYwKCqpF5JfHVHYOYMLSISq2rsMqgDwkzR
D+8n392Y55Hjfvyd3F3bNuZv2elOzx5DU3j90CvlcjGOVo4uMDd/FgOEIpLUHNtMrqbfvkz+
mP+VocSfPDh/cb4r1zMUaiLEZQ0KY/6B8kUWgHKmUrbXWK7hT2h+moXC28neQuH0yc9OjJcX
i6VG5fUrrTlOMvk69xVAfAktjKUvVoZ+mbxUPLKHNI3EUMxcxlmdX6FqFKrqRSSLqtqxrpED
3PdHk7HK4MyP6zbL7iRmLhvd18FjYBEoqapK/Y2RKj0Aomx3dRNIJs1UP2UZKKsuvypyucdU
RCzV79zWqTZNbaIESHQVyN9x5li6vCTOrQAAAABJRU5ErkJggg==}

image create photo ::ttk::dialog::image::previousbw -data {
iVBORw0KGgoAAAANSUhEUgAAABYAAAAWCAYAAADEtGw7AAAAAXNSR0IArs4c6QAAAqpJREFU
OMvVlD9r20AYxp/3zpacWMTYaoQtshQKhk79AG2XDvXQuVC8lA5dsohAl06FfgGRrp0qhdKl
dAwU2o/Q0bgkY4jBKecmVmTJ0l0XyZXjP2np1IMHIXj1u+ee9z0B/9uivyn2ff8hgJdE9KDb
7SbratlfQHcrlcpHAPcAlK6rv7bg4OCAKaXeGIbxdGdnZ7Pf76d/YmQt2PO8qlLqU71ev2tZ
VoUx9u8Ze55nE9FXy7Ju1mq18vn5ORqNBvr9fiil3FjyyZCI7Dz70oo87xDR51arVdd1nQsh
AABKKbTb7Q2iRT+9Xq+R8ZaDPc97xBh7b9u2QUQQQoCIQEQYDofIocWnaZrrM/Z9f69cLr+2
bXsziiIEQTCDFpUDiQhKKSilVoN939/Xdf1Zs9ncHI/HCMNwDpY3Tko5AxEROOfrwQBsIiKl
FKSUkFL+7nAh06v5xnGMNE1XXxAiejyZTN6enp4GhmHAMIwFd4wxMMbAOQfnfPa+zPEM3O12
5dnZ2V4cxy9OTk4uNU1Do9EAY2wujmXKT5EkCVuYY9d1ywB0AFqtVruvadq77e1tQ9M0Go1G
AIBWqzXXwGLjjo6O0vF43AzD8KfjOFPKoKUMOlO1Wr1VqVQ80zRvbG1tlYQQsCwLx8fHkZRS
XzL+P0aj0e0kSQIAYd48nqmUKwiCQRzHTwDsJ0nSNk1TyxyWhRCdNE0vAESZJtkzZ5XWXv7p
dHohhNgVQnwZDAbRsu6vWDJ3nGZKCu5jACSlVEKIV1LK72maPldK6QAuM5fTrC65opQDwOHh
oex0OqrQTAlAFTZLoij6BqDHOW+FYfhBKRUWooiyDUIAE8dx1Ny0u65LAPLpKGd55yegTKqw
ab5xBCByHCe59rfpui7P5pwXlJ9GFsCp4zgLN+QXtd89kPTevIwAAAAASUVORK5CYII=}

image create photo ::ttk::dialog::image::up -data {
iVBORw0KGgoAAAANSUhEUgAAABYAAAAWCAYAAADEtGw7AAAABHNCSVQICAgIfAhkiAAAABl0
RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAL/SURBVDiNtZRNaFxVFMd/5368
eZkxRmQsbTEGxbZC0IWMpU5SbCmxILapFCO2LgSlWbhLbFJBcKErP0BcCIqCdeEiUAviQoJI
wIgW3biwCoYGjTImTIXWTjsz7+O4yLzwUkuSgjlwuPdd7vmd/z33vCuqymaY2RTqZoLdRjfu
nXTvg2zfNh8PT01p8r+AByf9S9vv6DuGQWr627vA6Hox65ZiYMIdva1Ufvlg9WhpaM+RYs+t
5eN7J4IX1ouTtbpicCyoFEulmacOniidr8+SpBG7ynv4dPrjxpVW48i3b0Rf3rTiR8al13o3
/cSBZ0uLV+f46/IFapfmWLh8nsf2PVnyzp0ZnAx33RR4cFK6U2dnDu97pie1LS5c/BFnHNZ4
fl36nkZSZ6h6qBuNv6qOye0bAo+MiFXc54/uHundUt5qfln6Dmt8xx2I8MPCF5RuKcrAg0Nb
jHfTlVHx64Jrd9v3qv1Du/t3VPxPta+xYvHOUwgCfGBQ28Z45dzCWfruvMfdf+9D/V099vSa
4IEX/fh9d1WO7a8Mhz/XZjFOCMMCYVggCD2RaeAKQlAw4CPO/XmGygMPh33bdg5XJ/ypPGul
K6rj7vG+rTumnjt0qss5j5KikjAzf5pYWtSvzXMt+Wc5SuHwzpNoqmgKzXaLs9OfXK1f/OPp
2bfizyD3gxgr478vznW98sHzAFgvzVdPfBj6wNFoLxLZBt4bBFAF44R3PnqtGbc17CCKOBkD
VoNnX4/2X1cWNdbiA8+V1hK+YDAGEEFVsVaI2xp+82Yk19d3FfhGZozQiP9GbYwLBOMEEUFT
RewNeRsEi6WZXkIMGCs4bzBOiNspsjZ3dVfIsjkRKWRrzbgBCppCmihJpGgC6EpMUUQKIrJK
pMuAgO98u84cVTjQO4pKirEgIizfHqTpyhvTDcRAJCJxNne5BDYHdUD95NvHy2sfmHomImcK
JKKqmeI8NBuzZKbjHb2kHY+BJFMJtIG2qqb/eTY7SWzOM6jtbElz8CQHV83B/gXtSQriGSyg
6AAAAABJRU5ErkJggg==}

image create photo ::ttk::dialog::image::upbw -data {
iVBORw0KGgoAAAANSUhEUgAAABYAAAAWCAYAAADEtGw7AAAAAXNSR0IArs4c6QAAAmZJREFU
OMvtlDFr21AQx//3nuQochynTi0T40DW0I4le/dCCp0ay0uWDl1Es7TQD+Gp0A4B8zR1LJ1K
KfkKhUDokDF4EXawU8dW/HQdoufIbqiddu3BoXfi7nfv/k9PwH9LjRZNDMPwA4BqHMe7+/v7
el6+tSD0jeM4e0REAN4BeDGvRiwAfWbb9ttKpZL3PM+1bbsehuHLf5JCKfXIsqyjWq2W7/f7
YGasrKzg7OzsZ5IkT33f/3pnsFJqUwjxvVar3YvjGAacz+eRy+XQbrd7AHbq9fqPhaVQShWI
6GhjY6MIAIPBANfyAhcXF9Baw/O8AjN/U0qVFgIfHh5KIvpcqVQ2l5aWRL/fBxFNHADOz88h
paT19XWPiL60Wi17LjiXy70vlUo7q6urdhYqhIAQN+ndbheu61rFYvGBlLL1R3AYhgeFQmGv
XC47vV7vOkEISCkhhECSJJMmANDpdLC2tua4rrsbhuHrWw9PKfXEdd2PW1tby2ZkZkYURWBm
jEYjaH1zL6rVKpgZAKC1RrvdHgyHw+eNRuPT1AUhooPLy8vlk5MTEw+3t7cdIQTiOAYzT0lB
RDg9PR0ys5O+conoFYBpsO/7j2dkYaOv1noKaoyZHd/36c5X2kDN2jyZeRL/1b8iCzbxPOCt
4GazSQBk6gCAJElmx58cWlrjAtAAdBAE4ylwCrTT2ErXYGaUy+WpHWcbpFYAMAZw1Ww2x2Zt
ZRrIDNQCEB0fH9+fM3FkNpEdCoA24PHsdx1F0cNMM5E6pYVJ6uNUhjGAKwAxgDgIguS3k5jR
WWagRvckA9cZOAdBMNHnFwC59UF9xwcGAAAAAElFTkSuQmCC}

image create photo ::ttk::dialog::image::gohome -data {
iVBORw0KGgoAAAANSUhEUgAAABYAAAAWCAYAAADEtGw7AAAABmJLR0QA/wD/AP+gvaeTAAAA
CXBIWXMAAA3XAAAN1wFCKJt4AAAAB3RJTUUH1QoOFCMCb8BVTwAAAyVJREFUOMullcFvG0UU
h7+Z7Dq1G+NtnEBdRG0hVTSiqkAoNFIvHCCgKmotWVUiCMpf4FO1FQKVf2CFVEgFJyCIHIKg
0jpSLz330AMHGkI5EEEPkRM1iZ1CXLvx7gyHXa/WTZ1E6kij3Z2Z9703v3lvVnCINg85oBp+
vjkNv/G8bR7emge9Y9t6x7b1POjQ0b5NHAQFfi3adte46zgAJ6ZhrZetPAz00Z070XhtcZHQ
UXW/yOVB0Na9ewxks13zh4GL/aDeygrSMJCFQmf7FG2bzUoFKQSDFy/2lEX2gupqFZlOR9A/
Jy6w+uEUruMwdOkSntb7Ri5i0Gngx6Jto+v1YPLYMVzHofHxR2ycfo2XXjzOqfo2q1evUrRt
1isVEj0ij4N10bah2YTdXchkcB2HJ/YV/n35BCMjr5NKJmm1WqTW1nkwMxPAXZeElBF8OmQa
IfRIx4FuNhGDg7iOg/7CQWazvJEvkM/ng3kNu6+cxLx1i4VSialymXXX3XN4RvhMRdqE0L7v
v8UzTM6fG8OyrMhAaw2AZVlk795lYWyMqXL54HS7fvMX/LnvaBsGo6NvMzAwgO/7Xb3dbuP7
Pv3ZLOP377MwOxtPANml8e2zZ2ceLi3NnVv5i08/+2RPBDe++hqlFNe/nEWLPrTXQhhH0P4T
Pr92jUo6zdCZM+UPlpdvxKVgfGnph8uTpbkLg0ExjIycRgiBEIFv3/fRWqOFpK8wjreyiMi/
h35wG601lckShZOvfsPy8rOl6GiYSCQwTRPDMDBNE6VUBK9u7QDw+9+b+L6KbBzH0c/S2IiD
pZRIKUnIVQxRQymFUgqPBH/8swXAw/pjPNEf2RBkl4hL0QccjYM7EihyNFsBNJfL8c75Ud5P
HkXq47wrTTbWiIOzBAXiGaEHoxcY+kkmQSkFwKP6JmJ7q/tSqtX2VLIRG5AdbS3LIpPJIJAE
fMHw8DCNRoOJiYk9GZNKRWXQAHQHKEIp0pcnS7Xn+dv8/NNNE/DioXfk6A8P4IVQryEgGc75
4dqd8L0NbAP/ARvA49iarvtYPCWLAMzYrogZ6rD7YddPR/8/aWZWKFzoJj8AAAAASUVORK5C
YII=}

image create photo ::ttk::dialog::image::gohomebw -data {
iVBORw0KGgoAAAANSUhEUgAAABYAAAAWCAYAAADEtGw7AAAAAXNSR0IArs4c6QAAAo1JREFU
OMuVlc1q20AURs/V6MdRkLHcEkg3GcgqISSUvkWy9q7QJyj4UbQodNuSZfZ5CkO6SRYBg1Yu
JIu4pHYSy5K6iGaQ7MRxL4gZzXDP/fTNHSSsEWdnZ9vAqHr92Ov1fr2V46wB/QSMtNZorQEu
qkIrQ9aADiqgjTRNAT70er3f/624Dr2/v7fr4/HYKB+tUu68BX14eMD3/cb+OnBZBX16ekJE
8H3ffD5aa8bjMQCdTudVW5zXoFmW4TiOhXqex8bGBmma0ul0KMtypXKpQT8Dp1pr8jwHQClF
mqZEUYRSiiAIUEoxGo3QWnN3d4eIvKi8rvhUa01RFA1oHMf4vk8cx0RRRBAE7Ozs2L1F5Qbm
VmpbZqEsSwvd2tpCKUUYhoRhaBXkec7u7i7D4dAqXwy3Gm2WgW5vbyMidLtdPM9jsbDv++zv
73N1dcVin7/YbgYKEMcxSinKsnzx8TyPw8ND2zHV1zuNwzs/P/8ymUx+HBwccHl5uaTg6OgI
gOFwCEBRFDiOQ1EU7O3tMRgMCMPw68nJybeG4uPj45+mZwGiKCKKItrtNu1226oE2NzctKPj
PCNEBBH5vujxskfO8qU08NlsBsBkMqEoClvw+vq6XPI4SRLXJNdjPp83kkWE6XQKQJZliEg9
p5UkiVjFSZIoYLNxc+TZftd1bW+3Wi263a49UBHh8fGxnvYO+A3M3aqCuwiuFzAggNlsZoua
yLJs6Sa7tQXHgDzPa/SuiBAEAfP53LZiPZRSZjoByjp4Xi1ycXEBwO3tbSP55uZmnb/Yn36/
n1vpNTsCoAW0K7/eAxvVXl4l/63mGTAG7oFbYGqgDU/MadZsEcCrRrNnEsvqyYG83++Xi9L/
AQeKOvjuY6uLAAAAAElFTkSuQmCC}

image create photo ::ttk::dialog::image::reload -data {
iVBORw0KGgoAAAANSUhEUgAAABYAAAAWCAYAAADEtGw7AAAABHNCSVQICAgIfAhkiAAAABl0
RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAATmSURBVDiNtZVpTBRnGMf/7zsz
O7uzSzmWW+QQa5GgFkWoaBuPmiatMWnaEIKamKYC1k+2TROTJv3SNDE1adJaFCQ1toCkNGm1
sUdiPEqtCgRBWwVCPRAWAXGBved4n35gIRx+8Esn+WeSmWd+85tnnpmXERH+j40/S1FZWYv0
LHUb9jdnl77bkgAA7GnGJZXfrlAU9SMwbDVNK00QFIkzP+ds1BJ0QZBoERT4o6O20pi55qV9
p1MEp79MC1s76ysezAMzBlb6XnM9wMpffnGpbWVOsuxyquCcQdcNBEIGHjyatG70egIj4wGJ
MRz2c+ULl6Rz6LzdEmIFMZHVUbtnYB5444Hmk9lpcWV7Xl+tRQwLE/4wYjQVmqpA4gDjDKBp
A38wgkud98PX/x7SScCzqTBr2a3+EWNyIph37cSuQXkGWlT1XUmCS3t7e/Ey7euWdjHmDXLO
AWEREYOZ6naFSgoynIUvpEpEQMggbF2fay/Kz7D3P3wS82pRFuvqHTZ1IYl5L88uK9XPuVRn
/ZlOmgoYzGFXwpYQ31+rreAhjhTPiH/7uda+Hz79pjXY1jNMTlXC0HgITwIm1uenM0XmsCwB
2R6eDwbDawPDk8wdF+Ndnp16Q9dNLyA+B4CbNRXe9vqKtis15eWGbm38/Upf+4kfO4LxDo7M
JA2Xbo1CkTgsIVhkoTEJqJpDHcrMSK6N1ewNYLzPIpt34cS01VV06YZ5aCqgSzEOBUPjIQgA
doXDsogpQhYAMNtjS4hgosvxZYzD/rOuq48pwk7FLE2eWgguqmpcpcjS2eq3itSkeA1piU5s
LkiGqkgwBTGbtQDsSEvPOYvL4szeNwQAoHLFovkuqmpIY8R/syzSjra0R0gQiADC9F4IsulW
QABzPpDiqqYxBrgW0QAQwce42P7E5u5x+UYcT6sBAIWgtp/aO0oEkuccj2v4ZIdskzkABsaA
sG7i47rWyP2RyfevH9/dHa2LTNvXKUC8VlpQGHbH6PHd/z4sHRx9XEeExHmtABGz22RcuDUC
BkJpXhKazt+JDIz6jrYd39Ww0E4WzhRJFcdUh++nybBImvD7q2yybM2cnzNu05aGKZCR6AQD
0N0/RpyxVcXvNC9d9NwSnrMssWHSF9x9+97gh75AOJtx3J298awwiDEAa3LiMDgexJCX48iB
Lfam8z3bzl3p7ympbvpKWNQBYgNcsWQi6YhDVeJ67g5ttikSuWM1wzsRql8EnpZmCIZ05C+J
RcS00HnPi1cKM6Xi/HSt487wB57HvrBnzMfGJ4JOycaQ4taQl5OMxDgna/ylK6yZeuMiMGeM
3X80hUM1lyY4A9+xablty7osuzdgwiKgMC9NLrBSXYxN988QBNMUmPBH0PjrDb9lGAcvntwb
npUkIjDGpPWVDUas0xbo77q4w9Nx5lHulsqd7iW51aufT8vIz01RMlNjmdNhQ8QQMEwLkwEd
Xb0ecfXmQz04MXK4+/TBGgBhAGEi0mfA9nX7Grx+z+2y3nOf/QPAEY09fe3ONSkrt5UrWvxa
cKY6VcUIRkyJCBAR35+jfa3HBq42dQMIRRMkouAMmK3efezNmw37LwOwA1DnRIlGkpxuJSGj
ICHoHfYGRvu8APToXEeiUB+ACBHRoqWJMSbNgc1EBiBh+jdvRWNEowMwiciay/kPKWlcmnLc
32AAAAAASUVORK5CYII=}

image create photo ::ttk::dialog::image::folder_new -data {
iVBORw0KGgoAAAANSUhEUgAAABYAAAAWCAYAAADEtGw7AAAABmJLR0QAAAAAAAD5Q7t/AAAA
CXBIWXMAAA3XAAAN1wFCKJt4AAAAB3RJTUUH1QsRDwMVXP7WwgAAAtNJREFUOMvVlU1rE0Ec
xn8zO4lNNFWrNlRBhQpCTQ9aQRREv4E3ETz5dhJRz4LgF7AnERVvXop4qBc9qdCDoGhrqyVp
fUHUNmnaNG3eNtndGQ/ZjTFabRUPDjyzM/vf/c0z/52Zhf+tCIALF89f8bR7uTVYq9UA0J4+
duvm7YEVg8+dP2tOnTiz5EPXb1wjl8vtvTtw70VrzM0cEUAIcFR80PwA3r/vAOl0ekn48KuX
OI6DMaYhSxoOH4j1nz6aTwJhYBgYVvHBsgpe7OnZhZTWkuDNm7d817csQ+f6OUJ66GLN2ptF
tCulUx+FTve7mSMDKsjl+PgbHk0YRr4sJ4OGHfEFjh9MsWfnblx1bJOlOihVhtbPZO5f7o6n
XzQcJxK9XH08yqWTh7Ad75dYicvG6Du616WJRrqw1AaEkCgrQr4S7gbWNsCvX48BMF+qkV2s
/uaLa4pRxWq5FikmiVlDhEI7cZ2XvE+H6dtOTgLYtk0i0bvspWSQzFc28Wamj1R2K9nZp+Rz
A3yekzwc2Qow9YPj5RbPKGbLnRRr7XzKd7NKVbBUF28zYwAFBVAul+uOH4+ucH9JbDeK7UYB
WBNyqTpqUsUHjfxTxz8rCwsFpLtYrA/ZtCoAImGrKZf4mwG0MWgNWhu0Nni+3CaV7SrSeBMA
Kth9gWPX01RdDSYAg8BghN/BYBD1oDBgBAbDmjbFzPy8I71yCZANcCLRS1/yGdKSVB1dZwga
A7SC8Otgah0xSWZ2UUg7+wRQyj9AGBtP0r6uk3S+iu07DngNeHNtaIwciyiqjiabL3hq7jlA
WAFRgLauHrbFLJLTJQSgmxPdaPtpqNvHUDewKqT5PJkyhUKp8Ck5UQQiCqiMjo6d+XBn5Nbf
nu3F1IP+6anpqWAuFtAGxICI3w77K0Z8y/R3Z3hwzwCer5qvCrAomuDKV6gJSgtYtFy1H9OA
2yT9z/55XwFw92OAfbBE1wAAAABJRU5ErkJggg==}

image create photo ::ttk::dialog::image::configure -data {
iVBORw0KGgoAAAANSUhEUgAAABYAAAAWCAYAAADEtGw7AAAAAXNSR0IArs4c6QAAA9RJREFU
OMullHFMlGUcxz/vccKloIdhyhECbk6yQk4YLbib1Am1CHQuK5OVWCyr9YdjLWS4pzeJo/6h
rREjXWuO1TBX2rRNYqNasJFwp0vrUIluF+cJBxKBcndwb39473meB7X1/PV+nz3vZ9/n9/v+
HomoJYQQwDsh+TZgk2W5i/+7hBDK6DWP4vPNKg7Hb4oQQqmpqSkDpH/5VQI0qtDEOGBo+bgV
JRgkzWBg167nSUxMPAUoC8Hzq9tT3239Jphf3X40GiwJIXIBZFm+ChisTe/jm71JVlZWtKto
aC7gPrivHMMK1uRXt3epYKm+vl4G7EKIQyrcZDIhSXddKBjDsP3sJ7sZGBigqmiZxZihswBo
gSVxcXEHX9tXjSYu/i2gPicnh+zsDShKEEmS8Ptm+oQQubIsn4vhlqGhIVwuF+99OwNgCF+t
ra3tl20V5Q8tXXoPAb8fRVFQFCUMWK5PprHRCmAIlUqF2ntbnqXwjWPqUWP/4cpzYbAQIlWn
0/36ZKlF/8CDDyNJUrhXU5PXb8FX6Gm0NgEYTrvXrwbsP7e9MFfw6udaoKT/cGVXzGYIIXIz
MjKOOJ3OPHWvoKAgsHWrZcnff02iKArLkpbT0dFBS288P330DKY3j9/hMpIrLZLnVMAMdNTV
HWBi3MuFy3/ywQknXx8qo3j/iQWhgCL9h4HJBexrjWW0nr7El3VF1H3aT8XGAA7HoDGioWr9
YucyMvTeEZdb1Slp6XzfvJ09TZ1sN+p4rqKEhoYGtaGjwPyigY+E7izdwKaN6/B6J/iwvY+U
tHRqnk7FoNeyLiuTtPvTkWUZwBgdRc1i0Be3mQhOe0nS67EYl+MdceGw/YjZbEaXEM/42DVu
vVnY1cmNCVahr+zYxN4dW+g88x0/DAyCRsv83Fw4q7Isc++q1UiStCBcEw098LKJ3WWFHDvZ
xdmLwxSazTgcVwj4ZwGYmpry+v3+PFmWWZlyH0AYnpCQEIZr1Cnyjrjc8uuPsbM0j6PHzzDs
clNSVoHDcQW38zI9g0G0c6Prm5ubr1ut1ksej8ekOvf5/VRV7aG2thbAHm5e5lNWZX/lI7xU
8ShfnOym7/wg5sctd0ADozajEpzXuG1fjYUM/bFYTLXqR0ZmOvNBhdGR4bug0793Fnsd3YEQ
MHmBdzw2uKu7l/EpI1ueKOf8xdvQG87uIq+j2xvVkyCQDTgW4moBVq5J3Xyqx21TC3TzxjQ9
g0ESNDPFweS0ScAbkXs1+wqwChiLYfb2SG/e+5lxwnPVpurEpPi1FzpqPJFjGgGVosbYF9Jx
Ia38A2FguUpFCYd6AAAAAElFTkSuQmCC}

image create photo ::ttk::dialog::image::folder -data {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QAAAAAAAD5Q7t/AAAA
CXBIWXMAAA3XAAAN1wFCKJt4AAAAB3RJTUUH1QsKEjkN+d1wUAAAAX9JREFUOMulkU2IUlEY
hp9jKv5AposQWgRBtA6CmSCa5SzjYhG0qYggiP6Y3WxmtrMIol1QM84qRKRlSVC2bBcYRpuI
IigFC7F7j0fP/WZx7QriBc2XDw6cw/e8L+9Rly6XtorF4jZTMsYE58Dc2tvdf0KE1J17t+X6
1RszH7X2eLb3lF6vd6VaqT2PBJSci7Q+taJMeNt4M331qFqpPQCIA6TTGY7k8pEA50IpcFMK
pRS1F9X7QAAwxuB5Lq8/9ml2Msylww5nbjpSSOnPYYJmJ8PjjXW0sXMxUslD3H1YPxUH8DwX
gJ+/NV/af+cCnDiaBSCmtSadnjP6DMVc1w0T/BfgXwdLARZNYK2PHgZlh7+QiPkIICIopRAR
RMAXwVphaH3MSBiMLEMr5LLJCcDzXI7nBnT7hh9dD0ThI4wHERAEkTEYGFmZAH512pw+e44P
X/+MlwJ3EfARBAUiYaqVkwXqL1+R19/L6vy1nYabOLa2aHnZ4bf378qbqyyrA8KHtMqnsOL4
AAAAAElFTkSuQmCC}

image create photo ::ttk::dialog::image::file -data {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAA
CXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH1QQWFA84umAmQgAAANpJREFUOMutkj1uhDAQ
hb8HSLtbISGfgZ+zbJkix0HmFhwhUdocBnMBGvqtTIqIFSReWKK8aix73nwzHrVt+zEMwwvH
9FrX9TsA1trpqKy10+yUzME4jnjvAZB0LzXHkojjmDRNVyh3A+89zrlVwlKSqKrqVy/J8lAU
xSZBSMny4ZLgp54iyPM8UPHGNJ2IomibAKDv+9VlWZbABbgB5/0WQgSSkC4PF2JF4JzbHN43
0c4vhAm0TyCJruuClefph4yCBCGT3T3Isoy/KDHGfDZNcz2SZIx547/0BVRRX7n8uT/sAAAA
AElFTkSuQmCC}

# Images for ttk::chooseDirectory

image create photo ::ttk::dialog::image::dirclose -data {
R0lGODlhCQAJAKUAAFRWUlVXU1pcWP///1lbV2BiXt/i3Obo5O3u6/P08vj4911fW2NlYeHk
3+bp5Ovt6u/x7vDx72ZoZAAAAGNmYWpsZ93g2t7h2+Di3WdpZG1vatjb1dfb1Njb1Nfb09XZ
0WpsaHBybW1wa3N1cP//////////////////////////////////////////////////////
/////////////////////////////////////////////////////////yH5BAEKAD8ALAAA
AAAJAAkAAAY4QEBgSBwKBsjkgFAYGA6IhGKwYAwajgckMihIBpNweECpDCwXDOYyyGgGG07H
8xmAQsqkaMTv94MAOw==}

image create photo ::ttk::dialog::image::diropen -data {
R0lGODlhCQAJAKUAAFRWUlVXU1pcWP///1lbV2BiXt/i3Obo5AAAAPP08vj4911fW2NlYeHk
3+bp5O/x7vDx72ZoZGNmYWpsZ93g2t7h2+Di3WdpZG1vatjb1dfb1Nfb09XZ0WpsaHBybW1w
a3N1cP//////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////yH5BAEKAD8ALAAA
AAAJAAkAAAY4QEBgSBwKBsjkgFAYGA6IhGKwYAwaDsQDMihEBohweCCZDCgVhKUyuGAGGQ1i
wxl0PMrkB8Tv94MAOw==}
