# !/usr/bin/ksh
# next line starts wish \
exec wish "$0" "$@"

# -------------------------------------------------------------------------
# (c) 2016, Johann Oberdorfer - Engineering Support | CAD | Software
#     johann.oberdorfer [at] googlemail.com
#     www.johann-oberdorfer.eu
# -------------------------------------------------------------------------
# This source file is distributed under the BSD license.
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#   See the BSD License for more details.
# -------------------------------------------------------------------------
#
# Revision history:
# 16-08-10: Hans, Initial release
# 16-08-11: Hans, copy "externals" down to the docu directory
#                 (as the template files creates some references
#                 in the html header / footer sections) ...
# -------------------------------------------------------------------------
# TO-DO:
#	-	add TkImg package for jpg support
# 	-	file selection dialog (maybe with d&d support ...)
#	-	there's still an error:
#	-   load SkiTE.html without internet connection:
#		there is an attempt to load images from the web, which causes
#		an error in the imagecmd  proc !!!???
# -------------------------------------------------------------------------


if {[catch {
	package require starkit
	if {[starkit::startup] eq "sourced"} { return } }]} {

	namespace eval ::starkit {
		if {[set this [info script]] == ""} {
			set this [info nameofexecutable]
		}
		variable topdir [file normalize [file dirname $this]]
	}
}

option add *tearOff 0 interactive

# -------------------------
# what packages do we need:
# -------------------------

set auto_path [linsert $auto_path 0 [file join $::starkit::topdir "lib"]]
set auto_path [linsert $auto_path 0 [file join $::starkit::topdir "lib3"]]
set auto_path [linsert $auto_path 0 [file join $::starkit::topdir "libbin"]]

package require Tk
package require tile

# Img is optional
catch { package require Img }

# requiring exactly 3.0 to avoid
# (maybe) to load the one supported from Activestate
package require -exact Tkhtml 3.0

# same is required for BWidget ...
package require BWidget 1.9.11
package require BWidget_patch
	Widget::theme 1

# D&D support is optional
# note: for Androwish/undroidwish tkdnd is not supported!
catch { package require tkdnd }

package require infowindow
package require savedefault
package require rframe
package require getfileordirectory

package require http
package require fileutil
package require inifile
package require Markdown
package require html3widget
package require helpviewer

# ----------------------
# Initialization section
# ----------------------

array set ::app {
	TITLE "HelpViewer"
	VERSION "V3.0.2"
	CFG_FILE "helpviewerapp.cfg"
	TESTMODE 0
}

foreach fname {
	"helpviewerapp.tcl"
	"helpviewerapp_about.tcl"
	"clean_up_temporary_files.tcl"
} {
	source [file join $::starkit::topdir "app" $fname]
}


# -during development-
if {$app(TESTMODE) == 1} {
	console show
	console eval {wm protocol . WM_DELETE_WINDOW {exit 0}}
}

if {[llength $argv] > 0} {
	set ::app(FNAME) [lindex $argv 0]
}

# start the help viewer
# application...
# --------------------------
wm withdraw .
helpviewerapp::helpviewerapp
# --------------------------

# EOF
