# Tcl package index file
namespace eval ::iwidgets {
    namespace export *
    variable library [file dirname [info script]]
    variable version 4.1
}
package ifneeded Iwidgets 4.0 {
    package require iwidgets 
    package provide Iwidgets 4.0
}
package ifneeded iwidgets $::iwidgets::version [list apply {{dir ver} {
    package require itk 4
    foreach file {
	colors.itcl roman.itcl buttonbox.itk
	calendar.itk canvasprintbox.itk shell.itk
	dialogshell.itk dialog.itk canvasprintdialog.itk
	labeledframe.itk checkbox.itk labeledwidget.itk
	entryfield.itk combobox.itk datefield.itk
	dateentry.itk disjointlistbox.itk extbutton.itk
	extfileselectionbox.itk extfileselectiondialog.itk feedback.itk
	fileselectionbox.itk fileselectiondialog.itk finddialog.itk
	scrolledwidget.itk hierarchy.itk hyperhelp.itk
	mainwindow.itk menubar.itk messagebox.itk
	messagedialog.itk notebook.itk optionmenu.itk
	panedwindow.itk pane.itk promptdialog.itk
	pushbutton.itk radiobox.itk regexpfield.itk
	scrolledcanvas.itk scrolledframe.itk scrolledtext.itk
	scrolledhtml.itk scrolledlistbox.itk selectionbox.itk
	selectiondialog.itk spindate.itk spinner.itk
	spinint.itk spintime.itk tabnotebook.itk
	tabset.itk timefield.itk timeentry.itk
	toolbar.itk watch.itk
    } {
	uplevel [list source [file join $dir $file]]
    }
    package provide iwidgets $ver
}} $dir $::iwidgets::version]
