MaterialIcons 0.2
=================

A Tcl/Tk package wrapping the
[Material Design Icons](https://material.io/tools/icons).

License
-------

BSD

Dependencies
------------

    package require Tk
    package require tdom
    package require tksvg

Usage
-----

    package require MaterialIcons
    MaterialIcons names ?pattern?
    MaterialIcons svg name ?color? ?opacity? ?stroke? ?strokewidth?
    MaterialIcons image name ?size? ?color? ?opacity?
    MaterialIcons image_nc name ?size? ?color? ?opacity?
    MaterialIcons image_ncg name imgname ?options?
    MaterialIcons flush
    MaterialIcons rebuild

Method `names` returns an alphabetically sorted list of icon names
matching the given `pattern`, or all, if `pattern` is omitted.

Method `svg` returns an SVG string for the icon `name` with optional fill
color `color` (defaults to black), optional fill opacity `opacity`
(defaults to 1.0), optional stroke color `stroke` (defaults to none),
and optional stroke width `strokewidth` (defaults to 1.0).

Method `image` creates and returns a photo image for the icon `name` with
optional fill color `color` (defaults to black) and optional fill opacity
`opacity` (defaults to 1.0). The `size` option specifies the integer icon
size. If it is negative, the size is in pixels, otherwise in points. The
default value for `size` is 16 points. The photo image is kept in an image
cache for later re-use.

Method `image_nc` is similar to method `image` except that no caching is
performed, i.e. a newly created image is returned.

Method `image_ncg` is similar to method `image_nc` but allows to provide
a specific image name and render options as keyword arguments `-size`,
`-fill`, `-opacity`, `-stroke`, and `-strokewidth`. Size and stroke width
can be specified as floating point numbers with an optional unit suffix:
d (density points), p (points), or m (millimeters). The stroke width is
scaled unless a unit suffix is used or a negative number is given.

Method `flush` deletes all cached icon photo images.

Method `rebuild` recreates all cached icon photo images which have a size
in points. This is useful when the tk scaling factor is changed at runtime.

A utility script named `show.tcl` demonstrates the usage of this package
and displays all icons in a canvas widget.
