package require pdf4tcl
package require pdf4tcl::graph

pdf4tcl::new mypdf -paper a4 -unit mm 
mypdf startPage
mypdf setFont 12 Courier

graph::setup pdf4tcl mypdf

set data1 {0 1.1  0.25 1.5  0.5 1.3  0.75 1.9  1 2.2}
set data2 {0 2.1  0.25 1.7  0.5 0.7  0.75 0.9  1 1.8}

if 1 {
  set g [graph::graph -title Kurven]
  $g element create line1 -label "Data 1" -data data1 -fill green -dashes ".,"
  $g element create line2 -label "Data 2" -data data2 -symbol square -fill red -smooth natural
  $g legend configure -position @5,-3
  $g grid configure -hide no -minor off -dashes .
  $g axis configure x -rotate 45 -minorticks {0.25 0.5 0.75}
  $g axis configure y -loose no -majorticks {0.5 1.0 1.1 1.2 1.3 1.4 1.5 2.0 2.5}
  $g axis configure y2 -min 0 -max 1
  $g marker create line -coords {0 1.25 1 1.25} -dashes "-"
  $g marker create text -coords {0.5 1.25} -anchor n -text "Lower Limit\ny = 1.25"
  $g marker create line -mapy y2 -coords {0.8 0 0.8 1} -dashes "-"
  $g marker create text -mapy y2 -coords {0.8 0.25} -anchor w -text "Max." -rotate 90
  $g axis configure x -title "X-Axis"
  $g axis configure y -title "Y-Axis"
  $g legend configure -hide no -position plotarea -anchor nw
  $g draw 15 15
  $g destroy
}


if 1 {
  set histidx {1   2   3    4    5    6    7    8   9   10 }
  set histval {0.5 3.3 12.3 28.2 39.6 34.2 18.2 5.9 1.2 0.1}
  set g [graph::graph -title Histogramm]
  $g element create hist1 -label "Distribution" -xdata $histidx -ydata $histval -type bar -fill blue
  $g grid configure -hide no -minor off -mapx {}
  $g draw 15 115
  $g destroy
}

mypdf write -file graph1.pdf
mypdf destroy
