# Setup of a custom ttk::style (PhotoFrame)
#
# Warning: on MacOS this does not work if the current theme is 'Aqua'
# You should set a different theme
#    ttk::style theme use classic
#
# Source: https://wiki.tcl-lang.org/page/Photo+Frames
# Author: ABU

package require Tk 8.6

namespace eval ::photoframe {

    variable img

    set img [image create photo -data {
iVBORw0KGgoAAAANSUhEUgAAAQQAAAEVCAYAAAAGgps0AAAFVmlUWHRYTUw6Y29tLmFkb2JlLnht
cAAAAAAAPD94cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQi
Pz4KPHg6eG1wbWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iWE1QIENvcmUg
NS41LjAiPgogPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIy
LXJkZi1zeW50YXgtbnMjIj4KICA8cmRmOkRlc2NyaXB0aW9uIHJkZjphYm91dD0iIgogICAgeG1s
bnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8xLjEvIgogICAgeG1sbnM6ZXhpZj0i
aHR0cDovL25zLmFkb2JlLmNvbS9leGlmLzEuMC8iCiAgICB4bWxuczp0aWZmPSJodHRwOi8vbnMu
YWRvYmUuY29tL3RpZmYvMS4wLyIKICAgIHhtbG5zOnBob3Rvc2hvcD0iaHR0cDovL25zLmFkb2Jl
LmNvbS9waG90b3Nob3AvMS4wLyIKICAgIHhtbG5zOnhtcD0iaHR0cDovL25zLmFkb2JlLmNvbS94
YXAvMS4wLyIKICAgIHhtbG5zOnhtcE1NPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvbW0v
IgogICAgeG1sbnM6c3RFdnQ9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNv
dXJjZUV2ZW50IyIKICAgZXhpZjpQaXhlbFhEaW1lbnNpb249IjI2MCIKICAgZXhpZjpQaXhlbFlE
aW1lbnNpb249IjI3NyIKICAgZXhpZjpDb2xvclNwYWNlPSIxIgogICB0aWZmOkltYWdlV2lkdGg9
IjI2MCIKICAgdGlmZjpJbWFnZUxlbmd0aD0iMjc3IgogICB0aWZmOlJlc29sdXRpb25Vbml0PSIy
IgogICB0aWZmOlhSZXNvbHV0aW9uPSIzMDAuMCIKICAgdGlmZjpZUmVzb2x1dGlvbj0iMzAwLjAi
CiAgIHBob3Rvc2hvcDpDb2xvck1vZGU9IjMiCiAgIHBob3Rvc2hvcDpJQ0NQcm9maWxlPSJzUkdC
IElFQzYxOTY2LTIuMSIKICAgeG1wOk1vZGlmeURhdGU9IjIwMjEtMDItMTBUMDA6NTU6NDArMDE6
MDAiCiAgIHhtcDpNZXRhZGF0YURhdGU9IjIwMjEtMDItMTBUMDA6NTU6NDArMDE6MDAiPgogICA8
ZGM6dGl0bGU+CiAgICA8cmRmOkFsdD4KICAgICA8cmRmOmxpIHhtbDpsYW5nPSJ4LWRlZmF1bHQi
PnBoMjwvcmRmOmxpPgogICAgPC9yZGY6QWx0PgogICA8L2RjOnRpdGxlPgogICA8eG1wTU06SGlz
dG9yeT4KICAgIDxyZGY6U2VxPgogICAgIDxyZGY6bGkKICAgICAgc3RFdnQ6YWN0aW9uPSJwcm9k
dWNlZCIKICAgICAgc3RFdnQ6c29mdHdhcmVBZ2VudD0iQWZmaW5pdHkgUGhvdG8gKEZlYiAgMSAy
MDIxKSIKICAgICAgc3RFdnQ6d2hlbj0iMjAyMS0wMi0xMFQwMDo1NTo0MCswMTowMCIvPgogICAg
PC9yZGY6U2VxPgogICA8L3htcE1NOkhpc3Rvcnk+CiAgPC9yZGY6RGVzY3JpcHRpb24+CiA8L3Jk
ZjpSREY+CjwveDp4bXBtZXRhPgo8P3hwYWNrZXQgZW5kPSJyIj8+j3cdiwAAAYJpQ0NQc1JHQiBJ
RUM2MTk2Ni0yLjEAACiRdZHPK0RRFMc/ZojxI4qFhcVLw8rIjxIbZSahpGmM8mvz5pk3o+aN13sz
abJVtlOU2Pi14C9gq6yVIlKyU9bEBj3nzaiRzLndcz/3e8853XsueKIpzbAre8BIZ6zIWFCZnZtX
qp/w4KOJCnyqZpsj4fAkZe39VuLErgNurfJx/1rdUtzWoKJGeFgzrYzwuPDkasZ0eUu4RUuqS8In
wl2WXFD4xtVjRX52OVHkT5etaCQEniZhJfGLY79YS1qGsLwcv5HKaj/3cV9SH0/PTMvaLrMNmwhj
BFGYYJQQA/QyJH6AAH10y44y+T2F/ClWJFcTb5LDYpkESTJ0iZqV6nFZddHjMlLk3P7/7aut9/cV
q9cHoerRcV47oHoTvvKO83HgOF+H4H2A83Qpf2UfBt9Ez5c0/x40rsPpRUmLbcPZBrTem6qlFiSv
TI+uw8sxNMxB8xXULhR79nPO0R1E1+SrLmFnFzolvnHxG8b5Z52UyWeRAAAACXBIWXMAAC4jAAAu
IwF4pT92AAAgAElEQVR4nOy9SbMkSXIm9qmaeyxvz70qK7OWrL16Q6Mb6MIIRghgFg44IzKXOVCE
Fx544Q/ghSce5sAb/wNvFKEIj1xnhJwhiCEBNLrR3VXVVZm15Z4v38uXb4vF3Ux5sMXNLcw9IrIK
mMOUdb/KCA93W1U//VRtceC79F36Ln2Xvkvfpe/Sd+m79F36Ln2XOhP9+67Af4Dp76rP5e+onFz6
Ntr477P+/8Gm7wDh20nfVj925fNtKMe3pWAv2tZvu23pc7n8vwOVNdO3Kci5AYrzl8w9L1JO+hfn
Hf+tmhcn1+Pnv0l91+nbtK9y/blu/3Xdu2oe35bip21L06p9vc6YrlJGV34U/UvJvd+GXKyb0vb8
rZZdfINnGYCK/gDAwFaYAQzcHwOoAcwAzN1n4+4n92yBpuHa/fl74vsGAIYARu5v4H6vAUwBTFwZ
VVSOJPkwgNLlM3R5KHefjp73/2rkwU65vMiV4//icorod59Prj6Fq1MR5Qt3bx21J25T2j8+L/+X
1ittR5eFTZUgzj9OfRbal18kbfPXff0rLI6VJHkw2n3XNRa+nAGafvf95+XOj2eXXPj6DqI6w93v
8/H17RtPhcX+FzT96H+X5Hdk7vN1ITTyOXefv/X0IlbAK9QWgL2yLC+IyEZd11IWxQxEtYiMmXlv
d2f7IitVHB+fnFVVdVjX9WMAzwCcw3bCAMAegF33eQ7g2P2dw3a82tzcHJ+dne0WRXFNRC5vjMcX
dvd293Z3dzYKpej58+Pp8+OTo7Ozs8P5fH4E4GA0Gh1Np9MTWCAysJ07HA6Hu8aYy0x0dTAcXhwN
h1vloBzoWuuz8/PJfDY708acaq2fAjgAcLy7uzu9dOmSOTo6krqui6qqxsaYzdlsNirLkoloppQ6
nUwmZ7u7u1LX9ZAV70wn0y0Aioim4/H4bDAYnA+Hw/np6Yk5OnqOzc3NoVJqazKZ7IrIRWbehshI
IoU2xkyI6Liu62cAjgCcAZhdvnxZP3361LjxGAIYA9hw/3qQM7Ageeb+ztEohxfAFNz8n47uUwAG
W1tb49PTU6ANnDEIehAYAhgPBoO9+Xy+p5TaU0qNtdZlWZaqqiqf94nW+sC1y4+VuDxGADbLshwS
UTWfz882NzenRVHMmdkAgNZaVVU1Lopiu67ri8boC0S8y0wjAGy0McaYiTbmrCzL56pQB0abo6Io
Ji+9dK1iVnJw8BSDwWBojGxNp9Pd09PTi8y8NxwOt4eDwRAAjJhqNptP6ro+NsY8I6KjoiiOy7Kc
XLl6RStWUlUVP3nyZHh6errpdEMBmI1Go7OyLM8uXbqkZ/NZMTmfbJ2fn2+JSDkYDGqt9enOzs75
xsbG7OzsrN7d3eX9/X1VVdW4rus9Zr7CTLt1rZXWeqK1fgzgIYDnbgw8KOUAe202sS4g0LVr1za0
1teV4ndfunblvddeu3nzvXduvXz79p3nd+/df17XWm9vb2788HvvvvJH/9Efvjub1/O79x8ffPzJ
7fv/71/8/PN79x7cnUwmBwDqsix3337rjdd//6c/fgsifPDs6OzO51/d//Kru1+fnJw8ATArimI4
HA4vv/rqjVd/9ns/fueD99569dWb165cvLizu729sUEgOjmdnn999/Hju3cfHHz51YOnv/zVb76+
d//BvcPDZw+J6Dms4I5Go+HF3Z2dl3/0w++/9dMf//Ctd95+5eXt7c0NpRTXta5PzqazZ8+OT2/f
+erJbz/9/OHtO1/ce/T4yVd1XT/e2NiY1HVNxphNxXzltddu3rx54/rVk9PT+vDZ8+N79x7cm06n
98qynBHR3s0br7z5ztu3bs1mM9y99/DwyZP9R5Pp9EFRFIfT6XRWVVU5GAwu7exsv/LyS9duvv/u
mzfeeP3mtc3N0Xg0HJYiIlrX9aMnB6ef3f760Z3Pv3y0v3/w4PTs7EFVVfvD4fDk7OysBrChlLp2
+fLFG9tbW1f29va2L13c2xgOBuV0Pq8ODp6d7D892D84OHygtX5kjHnCzKfT6XTqBGajLMudqqpK
AGVRFAMAIKLTqqqejcfjuTFmpLW+tre3e2M+n6u6rs+qqnoyGo2f1XV9NplMqvF4XF68eHH87Nmz
rfl8fmlzc+PVq1cu33zn7TdfefvN116+sLe9ORqNykFZqKqu9dn5bPbp7S+f/Po3n9x/+PDx/dOz
s4fT6XQfQLWxsbFbluW1733w3msEGT9+sv/8+fHp09PT0ydKqQNmnlRVRcy8tbm58dLu7s6NN2+9
9ur333/r5ssvXbx4YW9nRylW5+fT6dHx6cn+/vPnv/n49oPPv/z6wZMn+w+qqn6klHo2GAzmSqny
9PT0woW9vRs3b7588/1333zt/fdv3bh0YWuvKBRDIPNqXh8+Oz9+9Pjg6KOP79z/8qt7Dw6fHT04
Pz9/NBgOTgflwJydnQ0Hg/LqtatXb7791us3ikKVDx/tP7tz58t7z4+P7xPR+WBQbly//vJrr736
yusb4/Fwf//g5Nnzkyenp2f3jDH7w+Fwfnh4iLqudzfG4+s3b778xg++997rb7356vULO5sbX3z1
xcH/9q/+/G9+9evPfqGNuQPgKSyIAg2oG3dtioZJrAwM6wJCMR6PXv7Z7//eP/inf/on/+KD9157
9+WrF66MhjyqZlN9NplNq0rXG+PhYGtrc1yUhYIIwQCnk9nk/uNnjz/+7Zf3P/nkzuOqquu333z1
6k9+/O4bN69fvTaf1/W00rN7D/af/s2vb9/95JNPH09n8/nlyxc33n/vnesfvHfrlddvXn55c1yM
SEBEYFv9WgTgqpK5NiJ1PddPjyZHn96+d/8v/+pXX9299/AZEcne7s741hs3r3zvg7duvPHq1Zev
XNzeLZgLMQKlWIwYMRBTawOtoZ+fTs6++OrR4//vL3/95V//4jf3jk9OJ8PhoLh69fLWO2+9cfUP
P/zh2y9d3b04q021//T85Je/+u1X//P/8q8/PTufzD54762r//Sf/PEH3//erddgKjzef/7sr3/1
2b0//3c///Lruw8Oz8/P5pcvXxq//dYb1/7gp99/4923b16/cnljd1iqUtcig1KpWhsQjEznUk+m
Mtk/fH76yaf3Hnz0288f/s2vP7p/cPDsWVVV9euv37z6/Q/efuXvf/j9d65dvXBJFYrKgnlcjoaG
2Zyczc4fPT58/untrx/+9S8/+urR4/17k8l0/+jo2aExhvd2dy7/wz/58EcPHuzXR89P6jduvXqR
WMnHH995+OvffPLl+fnkaDAYbP0n/+Qf/M4f//3f+95kMpG7D/YP/+zP/+rOp5/d/vr05PSAlZqX
ZTnc3traGQ4Hl376uz944w8//Mnbb7557fqVi9s7O9uDUUHMIhAiZgHEEGQ2N/MnT0+P73xx7/Ff
/Py3X3/00W8fT6bT2ffef+vK3/vwx2+8eev6y+MRD/YPTk7uPzg4+PkvPrl35/ZXTw6Pjs6UYn79
tRsXfvD9t175wQe3btx4+eLV3a1yU5EuILoUMVCqEAM2tSmq5yfzk/2Ds6PPPr/78Fcf3b7/xRdf
7z97djwZj4flT37ng1d+8jsfvPHmrZdfurgz3h0OzUixKo2QNrU2zCwCI7VhfXJanzx8cvTsk9t3
H/zybz6++/jJwXFVVfWFCzubf+9nP3r9B9976/XrV7cvc0F8cDh7fueLR4/+r//7L28/fvz4+Pr1
l3b+4R///rvvvXn9VSKh49P52Se3Hz74619+/NVHH3/2pKrq+dbWxuD1165f/PCn37/17pvXX710
YevCeEgjBa2MGHz2xYN7//3/8H/82c9/8ennR8enj2fz6tQYI+PRaLC3tzuaz+vZ2fn5/vn55Iuq
qu7BMonqbwsQNi5evPDD/+I//8/+y//0X/zjf7a1VWwrSCEQIs8cSYFZwRgBkUBERIyBiAaREmNI
V3OpAAEzcVGqEiQwEGO0MVobXWujQQxASBVKjQeDkhUxjCYRISKCGFeeaPeZxVJJzbUABmyqmZ5P
p/WMFFFZqmJYYKCKohAhUcwATBNQFAOCQAQQCAwERpOZTurpyen0fKYrPRoVw9GoGA5KVgMiRUzM
RFLVZGpB9ejx8bPzyXx+5fL29oXd0U6pmMUAmjTmc12fnerJ0enp+XQyrbY2hoOLe9vbW5vFCCIs
EIEAIg7MiQAhEIkAhomE5nNUk7nMD47OTw+Ojs9Ojs+mb77+0uUrl8a7wwGVEIjWRgAChATEBIHM
KlOfTebzp4fHJ0+eHB7P5/V8Np/OyoKL7e2NzWuXd3erWkw1r+rt3c2xKkt6/OTk5Dcf3X64//TZ
5NrVixs//uG7r9x67eoVCOjp4eTks8/v7n/y6ef7B4dHE2bGjRvXN69cvri5szUav3R1b/flazt7
w4EalIqZCyLFiggMIiIATj7g+hvm+LyenZ7MzwRidraH453t0SZgoM0MWmtUNerzU31+ejqbTGbz
mlhod2e8ubs92FAsiomsbMCQrmcMEIhKkIIwKbHfieaVzM9mZjqZVdPT02qqFOiVq9tXBiWVxASI
gYhAoJltXQ1AIsKGCCBmNsaYqZZqcl5NqrlogqAouNjeGmwMSxoISBQzC0R0jfr0vDqvda3LgovN
jcGGYmKjjWEmVFqb0zNzdnI+OxcYKFa8szHYGg9oxGwUExgQMlbGQcTm+PT87O79J/v3H+4fam10
USh16eKFzc2t3fLkvDp/9OTZwZ/9+S//4n/93//N/zSdTj+GdcdWYgnrAAID2Lv1xht/9C//m//q
v/7xD1//waCgUowhwCs8gblwgNDESUQEIgbENpZCRDAmiomIWOGFwP1HIEIAiFkBZI0LdA2IgMAu
T4GggtY1iBTKshQBQ1uwIAiE/bMwsAJj4z5KFSF0Z4yBiAFDQr4QbbtHlDgBgcAQyDhFZbFVd3Bi
oKdVXWkNTax4OKRBycwQRQY1jFQAKYFoYgGYGSIEsQhg1R4CEiMgBiHoDrybLoak0kZXRoyAREQw
KKAKhgIJPBgQiJgVgcjKtzFSG2O0dtJOgNHGEIOUYqWYCGDXMguKRkh0rTUpAjOxUsQDpRgACQCt
oSfTelYbY4w2piwLNqKJxIBIVKmUKsqCS8XMioiZSDG7NhGMCBHEO7/CJGRBgkBcwhhthUG01HoO
Y+z92hgttdKswETCts4eQIUhFdV6Tkw2tsfMwlSAiIKMOpUX5pKMNloRCoC0AYgYJFY2iW3/iwhA
SoG8YBIRibGGQwyRk0k3biLsniQ7vgRrbEACERIiJjF2HFisRInTGDJW7glWFASGIAIiFoEmsobS
yR2J2OEgAsQYquaa6uOT2cmvfvnXT/7lf/c//rePnxz8a1jXIg5Cd6ZVZxm8ZJZb25sXrl3ZvTIo
UIgYsvLsmwMQKRAxmGFBgAjGGBDZQL7WNZgZBAn3QkAwNYwxUEoRWBFAEDG24aJJjAHDwAOKYraK
TAWUUhBhO4RKQRkDcoNqxA4eyOq/OLwh98mCGNtyHEg5nXGdbggkAmEw2IGDOEUmJ1okxhAUKwUY
IjIkGjDEDlgMGA4kiYWYyWhjASBMysB/JhFj6wSQVXAGWIEIKEgKRY5NwICsCJIYDSZFRAzFinxL
wVaMCmIulIgIC2BAg8IPrM0CCH1KYjVDCqVAAgLIiSlBBEwELlmVpRobY0Rrz6sKkBirJDBEZM0r
iws4ko1bMoNEa1tDqzRkDKGqpmClMGAGs1BdG9tmHqJGJTA1KSIlSlkUEQMRbbuHQmBelCqdjKnA
QojYKqgVNiIhElNDMSmAyIhhZgUiISh2Am/rBohAjFd4gjGBwbFVZgIJiMW1UtxoinXqNUPDoFAM
yzrI2j8ICEwsFYELYmERtmzAwICoJj8VoU3twFScnlnIYQI7xBKAuBBm6Hp09+vfTo6OjmPdXSkt
A4R0brwYDYcbo2FRitFkKYxnBfazRTAHtQ4MjBEYo6GUQlkWliZaK2ulkQTG4aLWGiICVRRQRQFj
BNAaIHKgQvBdDiYQiqasEDe3Km+MgccbgMDKmTdrk0PzfL2JrGYIG1hzYYGOACLRYoQCUAj5sLoD
BTJEABeKWZvaEhkPMGTLsw6AwIgBGGDLEMi6ViACQVgAYW8BoBQDbMsgxcRGYETIOKtEYWjcN0e0
jJC4GWBSRDBkQM4awRIKVzcBg0mcoDGUz06YiQRi7RCLk0GGMKBAMAApLgRsINoyQqICSoQkzIoZ
GCFiUR4ASLt+aYTLOWlkoEVgoKFIQSmGGENCQEEFRBXQWguUJhGbV+GMSjA8rIik8GIAkToqAWBW
gCiHhBCxYyEEAjnFDjPnAhArd6sDAWPraaABBzIkHCYcRWx/gVzxBOJCxD6qQVIQWzEQAkOoEiFN
rCznNEYA0jBGW4Ma95IIxGioYmCNhGgvg6JFBNAsYDo9eVR8/Nmje7N5dYY14gdAPyCkyEIAeHtn
ezQYDEpiJhuQs1kwKyilHAC0p8jtgHk6zu4+9ytZu0ikrPJq635ANCCeSRBAyimeg0W2lFBEnIUX
kPGMOJA0iKld/dgNYOOhMHG7eQTAWD1iEoCDz2OtgwEAH9EkEkAsAFp3RERIIChIWWCJRpNc/t4P
IMc9PW+xgCdgcUoNgFQBtqbEhgQACLEQC5RtnH3OiqplDEQQI87ye59IQ7ESMQKGcewL7tkAl7YP
CocG1rGwGRtrIKFsF7IjwNYoCxXCEEUNIxQJ1tkYDbBVHFMLDOYQaMvYiBpQY0ZRDGGttIIQQRUM
ra0/ZgsVYcUk4jTKgqswOSlzTM/mQURE0B7Z4Y2Bt7AAM5MxbDUXQiKGvKdtXRdL7+GEQGCs9hkA
wk6uvJ9rB5xJuc51iG6MDZaBQKpwnrAQwbBnqIQCMICQcdE0gak1jDHkDK0QEeq6ktPzYz0ajtV4
uEkAgYnEEjgDQJOI8OT8kE7PcAY70+CROdbnznhCDhByQAAAGI/HOD87n07nurJo61kBhS6Duy7O
z7EMgsDGxg2s+0AAK8vEHDF2DiPE5eeoZAABP4oCCwg2XoZg6UJl3XPe6ovocN3XzQOWccBg74Wr
D+IybfYMkLANZYBb5EIMYHwfOFfDC50bb0vB2X3wsVAGkXG00bMNxwjJ0XNWjHg4HLd3xNUvD5Dw
rHhmwQQWT5UFKEqI2FgPQ0EbCJPnD+S8DoRxIDhMImvVhQAKIG9FzymhdZ18XIU5sCZy48oOyI0Y
mLoi68czuHDEmkKDoVSzJiuWrbquobV1AZViGGPEs0xLwhum54AZRISyLKEUYzabEbMbY/iYEYHZ
CFmH0PVjU6b7Iy/XxmoyxOhGLkUAKGKPAW7qn9mpDQHEhY9FuPu190gdcjtA9IaiGY5QtvtNmEGF
Yq7mU2EqMCiHLtgIcuNkrPduUJQjKKVIa51zGRrfI0mrugy+stWjx08Ojo5On79ybesaxPDCA145
qCnR+91kKbIDhTaYWIHWzrfyrghbQXI+GxFBkbWHxit9h4tEZOm2MfHgNb8BCGDg60jkSIR4u2mC
bvv2MKyJFB9GgCUPvrHMdpwNrK8d8icDFrYugb/dCw4c5pAE/92CXtO9tk6+zQIx3j2QwHqE7OyL
tUH+50jb2fYHcagVPBp5YCXXF3B9w44LCzezMLZeVqbEiNV9RYGdBLQkAOwsnn/OWFvAUG7sxPW9
fc4OLwXD4f8S45MfdF93NIDCVKAoDIxjij4v+7uQiHd1CDYI2YxZrDP+Ejk2GpclEDB7OTIQF/gj
ULge8gFRECoiEuvmOAh17LNQVDoDBVjDZYWGZXtLcV1XYCpAzGCycS0bdBRhYmyMd7G1NdhUSg20
1n5VZLtBHaCQAgJlPpP7Y6VUfXBwePjbO1/ff/+9l99iafYBBKVndsrAET3z8VltBYYAiIEoBVJ2
VWYBgiELADb67pkaHIVvKL5xbkIzWORQXxwQqPCdOQ54xspvKW5z3Qm+LQzsYh/woWfLdEisVQRg
o9CiCMpRCxtvIIAFynW3AxpisJtIsUqlxGuhOCbjXH6ioIwIlxieljT3NdTXyorrJ2cJG4MuzaBG
jMhjmJPdwNB8v3gz5v/DrCwKetfKySh81dipN7OLjRgY8dFwgWLl4nIU9bebPiZpjYFPgU3GQkkU
xj4G+Xhc/ee6rkHEKMsSWntmKI41GutORHJhDYDjOORXgDtjZbxyusA2i3Wl0IBoADC/kl9snNq6
qw542Bq0wDKMm4EjBpOXLXKuuDhmZPtTKYZIibIoIN4wQsBcWNfMGKICNNq6aHZ3yi0RGcOuKvbL
v1NgWACFGBD6wMAzBDMYDCYff/zb+//8T38mBIbWujVIrdIiRYWxlJbIKQALGATtphK9/MaD7Dut
mQmwHUSKg2tQ1TUKpcIzsQARE0RUo3BRCyW5N33Woj63rhkTfEOA2U1Twk6hMaAcYDWg4QXA+90+
HuL9Zwp5WnbiLUuziriZEYmHzo2jca4N2VhYMwElYAKM9THDzAGzD8o2CuiBJ6Z64sBcQmtcHzil
t96AZW0MhTAbBMewSMEIA7oGjG25Mca6GY5dEFk3gkK/GhdqINjJz4htou1CpC5qygDbBsCEuJWX
0boGjKnbsuL6SWvtGETjYoR+iWXT2HBTIPfUgJUYifL1MuSMDXy0sTGWad5NaoBYGzRrbywlFTt1
CxgYQ2yBqK5rGm9umyuX9naJaBPNPogYDGIgaIFCEV1E8pmSPwaAsizNl1/dfT6Z1PPdzWFJ0C3F
zSUfxCMqbGaORRitYed8vR+ZdqL/HuVLTZ5aaxitLfRFfmTrZnIDYOzUozgLnCq7z9PnQcrGOPys
R1y2HQ5fN6u2nupqV47zBV3GCJaVQC5w6ZXZ30uN40iN5YZTWKBZlypkggthLbkJgEEOIHxEWgeA
aWINvq85NIsgJE7gfAzGlUkNRW65Z8TRkDma4EAkGAliUMEQLW4GyMUV2IGRnWePLD6FBUspm4v/
UqMRy4kf12CI0DANAoOYoZQPRJvs8zkG0jAH1w40IM+eEHiDBZWAlw88LxjktuYBiS418S1jAHHT
7oG+WWcBzERMbOdzoESxwtXLe7vMYQNgEB00AJAFha4YQg4M+Pj4mOfzOW9vbY4ctRQbMWnod6Lb
rUGKrT0B0MbO3SqmFkPgCBBi9GdmSz3dvaoonDI6qxj5d6GDgxjbNreExllxBKSPQMjFOmKQENOA
XvApHf22bMRafqtcvh6ekzfUnZqHbbkRONjp2PQ+aUZRrJ+mnYsGwFlfHy239Fa7fGGMdSc8MIb6
sjNxtr4e4QJwilM++P5v+g/R2BhEU2NswY5dxJIdqmliKEKQEXG+iiV2CqwYZKdTrVspEspvyRBs
vo17aMc1lpEWqDuZi+VCTNOeZvbLSUqYdcpZa0Qy7AHD52s3LNrfm3vbhs3V3ctcuMrhewp0jRtl
75zNZ1SoQlShCEISfrfT0HbqlBjMCoOSh4ViDwh+o5uvbCcoxNuOkXz2370zpQAUZVluvXbzxpXN
jXIkxs52BMIv1sdiO3/c6tbUIrMIqCxgjFdMTxcluKfGGEtTpe1PWnC0ZpQKbpTK+WOhc53y+IVQ
cTLGwJBFefLdIo0Sajd9Glso7xX5IJg4BsJEUe96CPKfnF+ORv/9s+SXCoCadQFRx1thdeyBYBXY
KYEHUTFeMST47EGMiCDc0H9x07hxMDJIhGM0pCwdhhfuUF/vQDDgqL4vy1suirwy4QY4mApvSz0a
AFEQEc5yBgcpYihEBHHrT7Q2qOsKRizdL4pmDUpsQLyF965Dw/C8v+7vRVOHMK5xXsauHSBpyW7M
UhoGQMFwU7Q2wucb2Ail5fhVt55tmsguNeChFGDMDDUMcbEhrOzshXh/PHQ9AcIQaEL7eAK/7duz
hQxd6Z52TNmB328+Gg6H2++//9YrAoFytCtU3wdK/Dx6QvPiWIDR4qyWgl0AJMkAUaB1cGUEUHCd
KlrDL+WEMcGqx4ykJRBxIynqD0mpmseYtp/nLYBbJuin1+HRP8wC+IVW4umxW0kngFuzgOBqsC+n
zWWaero+AewiohBgZLARiIILbjVWCgIUzA4wfHDPsobCW0v2YONcBkftbNaNixHiHg5c4/GGp7V2
tEK/gBxTEjQMDnY6TvwiPzd7JHBTnGG1KLBwXIEABhrz+Rnqeg6lxihLO0UZD23KRtnNqjTGsO1y
xEy2kQO7YpOVckFJ45S1mSGLZSIqPdB7oA1Qfnz99/hfLMhmmm/DiLa29jCbVRGhtas+AywbISK7
NrWu57Ehj8/YSBkCos6mXFAxBYM44xLAeGdna5OJOIgTtRE5TSkwWIWwLEYsxYA1gM10ZKizMPyC
m0bZ/dxtMNnhnzjA6TsyKDo39QgN9goOtAbRf0+BgsgGD+N87DRpM3jNsvFmLQaFAh0jCha66Xa3
nSPUp6mTVTTlApR+eMT598LifH3bV+KAh8EQViAxlrEZS/HZTf95xZRYgJ1QE/yMRgOGdoVlw2aa
OnpZixicQcMCoqk3Zh8iVW4Kz8VoyDI+KIISPysVKy6BqMSgKKDKgZWXJN7gx65lAMS5cs7lsFbc
tbUFPE6OxYIthKDYL7e3ca44xtA2MolcLYBFU7eYIbSuBxlQ0QPNlKgFZcZ4YwhthNwqTvHT6s71
ESJiY2o1m1cwxjcm/DXI6EqIBk6A7mnHhge1GYKazWbm8OBoorVA2eVyrc7xi1PgfU1vRimCJLvc
DWLcAMZFBj9M/P9Dp4lYWkwu9sDUjrIbY6mtp+ehTh6Mksb6oJr398O8vxg3KxKNTVAMuLY01tBP
J0LsZzEeJC3AeVCwg4uw4Dg8H/W6B6mm3Pj8Efi1x261pis2Jn+R7+1tPAEWGOCUGi5+E/wUiViB
5wUI91JwQW07Rdw4e1ck7otoqq7tpXLI1+91MUYgJG7KjMHsYxQMozWMWw4NJgzKEig5KJOIhj72
XJAAACAASURBVDYa7PfC+xkUNOtOvHFpKeACQ0gU07kVxrln7BRUjJcsnYBBGwC8GxC7h0QuvzC2
5AAzPBUBSiy4doApyLidlvcb41qMR+DYjJJqXmM+ndW62WHodThOsfUODeqaZUgZggKgBoNBUVWV
fP7lvWORn2kQCk9RY9+tsXoCGG33GhJHA2R/M3CLaTxyuqcs3TRufBsQY78gxg2A1pVdRecAwS4K
cUwD7amrICTKRoC11i4AxpZSQ1w8wS/r5bABJdDNqHcaRUcAG0Hj9jDbDVexPwz44GvMREy0WpKC
UsU0E/AKxmHqz89tm9q4oGJ8KpePwzhBiVyThh25SLzfYYg4XsJOAWxg0IjAiIYRDYabjoX7i6y/
P6JCnKcqfoG3k4WwvSLqVltvQHSF2liqboPFdk2w6MrKiohd/OTK1UZc8FSDbdTUumWJvw8Ayo25
X9oSM4UWqyXrYmlpFkUFRuDkvNZxENIrZZOFxdbIeMCvCbHusbht9ibMcMTxhHZQ0lsIr/BG15Hx
aZafAwpGjFtkVUqtK3n05Pkzrc0ENnbgXQaJ/mIzElLqMuT+AijM5/NyY2M8NloXgF1l1SyQcSjt
tMQqirPYntK7YhqA9fGN5ldfE6ZmiTHsBhMnuAwj2tE4uwbXbjtAUKhmcBoXxLMLuDiE1hqijQtM
uUVPcawgDLQ4lCbXrkahgvLFDCmqQ+wvphagsXTRqj3vXrg8tPH7Upp6BXCDnQg3jnITF2gHzOzK
ULduOhI+uHIABYYotw4gsJj2PL41eAQybCXbAKL9FKXNiJlAygcIOCwrVxyxMhHASJjdcHFLZ+k4
nKEBuGzcmGi3HDuuEytGwXZHo8/XA1bch42rQQEQWlCxoA722WZRW8NIyClnvN5m9dSOi9lApQeP
ZoozlpPYwPrftanBYOd2EfySeiZlN2GLgakhx8eH5ue/uvdVXesTIBwf6M8N9RbJ/7XchmWbm1oz
DADGr7568/rPPvzRTaXcls/YbxJn0MVZfsUN7ZdmMMIqRACWQJuW3+w7oKVE8UDbO5y758qPrHVj
IdoxABX5Z2VR2uW4nlI64W3Aq2EiNrbhFw952I/LSAJNBNR1HQbVC5m/J7bUfqdoWB0YprQAv4HG
Z+rLtspuNwGVRel+N6hrDT9FGdbPGw5gagOJbmRd38AYu9vcp2gmA7CzLX4jGHEZ+t4YDS01FNuN
am6Hn7PSaMAVjcQpu6Xbfbez5hADYwBFVk59DKZZqs3BSjb9pl0/stuIYAJLbQeTrXjEDDGWsjaP
QDQm3PruZw+a+3w8wpcZfnCkNo2lNUyCSNzmK27VNzUqaTwLAJSicPYHnNthf1ZWXo1dI/7g4ePz
T+7sP0RzMIrXYT/LELOEoJZAPobQxRIUgNHLL710+b23b15RTMQoIKKbXY6OCllwIMAo+Ai170in
dUBEJeHAxH/Xpj0YzHY5sgSqBbsgPlIY46gXo712AGK3r7PblmYZiwOWQkEbB0bGToUGEEFEG30P
ioRFN3Z3kuvL2oS1FTYSXcNvqmoG2PqmzKWzDu1ltuLA1M+kSIgHNUMTr++3z5lIqIx1IYxtpVKD
IKx+JsZEShXUtbUfwucPgOy6C0/zvTvk8yJmMMpW/cQAGhqKrRJr+NkLBKtmgY7g/WM7VAbaj6UA
YjRY2aXOEu0t8G2P+8HHkATKnsvmXBqvpUIEDbtd2W2QgrXU9hniwvWl0xzFzQYmNGwluD5cuPiK
NMDnmJ41GAwyfrWi58TR4igmNDNN9tgddi5bzNJiAPTyzKoESIXgOuDdIMfYWEFE4/Pbd59PptUp
7NmKDKvn/jTzeNrRVy9oX7oOAdFNMRgEpnB4eFhVc2Pq2khZMABQsxIsorWZTNvR34Y52H8ZNmCD
piNbFNkrUONm5KYTW4AXAY3Po69e8faJxRsblF94lhwgoVHS5l6/VNfSdw/LKXNYN+WmVO2Glziw
agU/+LAguD3ccXTCjZe1xvbQFQTXj6OpvYbBRms/IiFmdsBBsBTeaBDI7XgkaETsLfYQW9vQ4/bF
Muufa4DS66TPoyEnFOVj5aeuLVgqpZqYgiDkS5E74E/8agB1UUXSa81X69Jov2+Hyc7weCMgdjao
AQuBX+cg0UK4pg/axiOpA4kR8QflaKkxryf45M6DI/G7thanHlNj3yJNXXsZ4msBGIqikOfPjydH
R2fTqxd3NkWMXxwR+W1RgCSTYdNQag26/RjHFEKjW50TVzXsUcg2wbbVW2PrFjRUMEZeX4F463Uw
2aEOjSCnsQo4S+Wtij8tIeRlNcUBQdMHAgkuTxzuyW3qscmPZ5RHADO21pyacryo2MCr62TxC5Ua
6wUiR9HtyVbNlGOzYMYzgBgRGQJwHDQFiAoINEQTyB5h5naANlPMgAWvAFKLcgmKrnFQ3giAPNBH
z4Q1GtHMjKfXzHYdhJ9+NNqvaYn607gyXOuonXtrJGIM8wzPmQz7LAuCo6EIcIHuMNHpgcauRQfI
96NBaugaQOBIdn3rBUxERiBMBFUWGAxHqiiKsdbzMdrv+ogBAcm/zvlYRAz/kM8kvGzDGLMhIlc+
/P2fvP/6a9cuKgb5HYgxlQ1KjHS/QGNhRdoIHbog0Fk468LBH24H9Jqhax4lf9aXs/IU7SCL3P7o
/viz+PKJWr0GarqHKLL4cIPFlir6hzhuEzezK8RuBWcAlVTpySlrU4+Qqb+3rX0IsynhvEqEcvzO
utBrUf9JuObjPC6Q6vuRQnVa0h8zj2A93T0CvzBIuXsU3BmhkT309VbuPuWmqsn1k9uabM/StPWj
aAac3CwIGvlpDFHj2xu3LJvYHvrLbkmvN0S22jEgxYoWJobRKKEK9YtjVLaTEPIhsvt0yMUJwnpd
v6WeENwcENtFUMzNilmK29QYwpjBNHELsSxBBAQmQyLMA0AIP//Fbw/Pzmf7IvIMzXHsBvmX3gRF
SgEhXnsQU43S/Q2M0Rdu3Lxx6/d/+oNXShevCj5OpEjEjLAV36MmRQDlFtnYKS0JAw2wPZLKPRPW
9gejTFFLGoBpXBW/NsF1mMS/eV+4HcRpB6waNwDBP3RIHAX1WkEgJ/TeigrsoiGvJBQF0yxwNOst
vCL6IKY4QYGb6rIGpPnN3md/k+haKMOzFG76OuTt+44IAl8ny2C8ooKUZRtOGaC8UlK0aEmasWDl
dcKNkz+HwCkPI0yxEdnZATtdaffzh92PaNwoYdX0X9QHad+A7eFvXqbtbEdpp3G94itXhlfqMJXs
GQK3QMErdQM2Xm4d+4oMX3N/EAXHrDwjbAwaOfC2x2jZqVN2TAKecZJVObIHRkRA6QGhDDsymz0Y
Rvz0tWVdCrt7e+Xx8wP59Sdf3TPGPIF9QU/81qoUFIIwr3KEWmzGxBiZfPTxp/sn5+em3BpxoZqJ
aGsV3DSR8/lTt6EV8c3GAMKN4VltosVOEPj59cXqZb7HFJcIOjq1KQ7geasdf/f1DY2XNhikm7Ya
V6g969AKcq6Qcn5kml+aV7iP4rn/xa4I1Nt1oD2yi5rf4ZWbm2k6F3i06G8C6DA16y3gzwAkp94E
J7QMVoVz+D3wNO2JXR4/Vo0j2Z2a9tu4BwII20NRjNTBdWhcRufQKfvGt7AuwhgYbeCDqq3xailr
1ElREND78N5wNEvsG+biXVBGI0e2K2IVtHW0Fp9sX0fEsGFRFojYnrVJ4k/7dGWOxyP19huXr5VF
sVtV9QhtYx+NwGJa58QkAmC01vXXX987OT09n17cGmyjtdVTRZW3AtEIYTOIFF3MgYJEgxIKDwMR
Rcjh+UK8mi/Kj5x19V+J3LkA8cKfuG8ay9BEsuNtvqHPQ34+H/+cPxsgjjuk31dJcbDONybux/R3
/z0cZh/6wUfIfd97gXOBWk9jxfcGRTGGNqDB5xrcBHLrCRzj05Fl9kPs3APLMCIwbbXVxW9W7Js4
xmLZj1vc5Biohlul6KaZgwGAY6KeABMCeEuAQt9tUeyFCMbX2BsO32+ADby66IDdkIegBKEfPbty
gBzLUNwPEAO/f8K6Lh5cCX7NBpEKW8hF7AaGZsOZbUdB81LE+PdcxgsQU1Bodfu6L3stmHm4t7c7
ZlIksO88YGe5412L5HYYBgFcXRcWGITiIhKuJhzW5Nmsd7CgL0FgQd7PFjtfzmyXOfsOjESh1hKu
+UNKxHBwRYJv7cq27kdjMZvpQ3f0mN9zgSBZ8F/hBMMLoQ+42XzQ3OeUz6tRA4bRePoViZ7O+r6L
P3sIsD4DmnkRL7u+HkAsI7aa8dJfB5pkD2BBsHbRQTS+HH9wo9cc2LLDuEUsL9DpuItc9yxCRSRn
iK2tW27tlhk3wO+DpAg2gKKWGthYQwgyhe6lUOcWWARmELoYfnrfyn5S3WisJCoCsVzBgkGLOYc6
uD0r7qRnoiKsWFSKSGsj3l1jAPPZhAQVkw065AKJOVAQYDVAiB8ajkajK//4H/3Rre2tzcIICbEK
VMtIMz/sA3xEpkVhFym26+MO90HErkKjSDG8X9UgbwwgkSV1QhaGvsVWVAt47F98r+03A7/IhwLA
NC6FjwMIGjCwgCBk/URBxA6ivmmi+K5C0YEnIVgaL+CKhNACUkNVgtx4IeWmoS3L56iuBR0HfUm3
L5oNgiHd4lLBLXB5xiAW/G0Exu66zQKkX3/SssfBUjeum8RVDn3oQBceCHy7rQa2tguAoFt9FheI
oALe0Ahgt4onKQSwpcnAs4ZwxZn+3FSwz6MVd4jGzjMLMX5XbwN2Ddi7naQEkJQgdluyIaE/TTiK
DZhMjmkymWljN6PEB6MsNcvrMAQCsPk7P/r+m3/yx3/wqjY1QCOAlH2TDbAwG7Bu6gOF2G+O/yXy
4OYtk7RPaTah760gpRTNPUfRgGYbT9QqdwFIpGEIzXl8jcvRAsqWifTsqQEavyeFFvajyEJeaf08
MfA/Ndt//R+HvESaE4KbprsXyBCatWPegodvEcFxNQU1IOnvivEsvFOjs4Ojw1Pi+8iWYIL2Czy7
IUfL4/tDQNh/jjhlO9OozQ7U42IbAIhNetPeZO0iGq6JVnkeuBvD4PJ1n9mtGRK3aYqomRr1BiKO
zTUVkSC/ts0asG85JIjG87NqauzJsmstdFnnzU1FWZZbv/vjH7z20tWdrbJQihQTsX1bkH2dVbdS
r5pyAbO+exrf3HWO3w7oqm0pnV8X3gywVaD4LIdGibrK7PrefPZ5+6kqjq43f2kX+YGOp5qsLCeW
JrYyC4BPob3tZxrFiK1PY80aALG3cVNs2A1pl8batQ0NVfaHxIqjCBLFKoDGMlsr3a5YuieAya8Y
XJSfWPAb9yDu31x74/HMA4IH4XxKxzQVjpywSPJvU1YjrzEDgJtRA4i1PQMTRcSG6qgt1IAmzd21
AnAAYt8vUaAyGkW5IScn1RSgvzVAAAAuy3L08ktXdkoQDaCoKITsggoFgwoqChV5wx1bLtvINq1a
NuvQZQnT6yKSXdDj53z9fDAleaR1aVH6qH6pi+NnKdJ70jqldV+Y3sQiuOTa3PdvrrwUNO07MRqB
zdW1dWQ4+c6TlhAHtiXJrYFFNG3yzAdAa7lxV381lnCRfreveWVu90MKzM21xf5qXJx2f6XjnKac
3CwzgqnxarXbITKBobgEwbgNawYEA+WZqz9eXzRY/KpU64JpbSBiXXcGoSxGMp3O5sxUo3lRy0qp
70zFhVRVlZyfT+vpXNdKlaqEj9g6YTcRtY8FJmN6c8K8bkqFPlWUVCEXfLuMkncpW67sF6nvsrSs
r1Z1x9L7LGtZXAXXmW/kpvm1IIuU1V6LeUH7TEhGQ22Xt6lLIbtYQwzUi6CwpH2Z31e5x5exyjj0
5dnU0+9QEtgt6PbPGA3F+XozM1ShALGbnTwDFhHRxm73ns1qDwbeV1wprfMqN2O01tPZTG9sbhbD
QcHE0Twv2tYXlGxhTrJcIGArDlifVeyy7qvkm/vs84//TcvOpb7yVxWkVe5PwawvpRa7O6BrrXzs
UrTvySiDRMt0IWgOSF0vLpP2fXzIbY5BrsMyc6nLoCwb65wh6SpzKSCIXyfkXiYjTSyBqD2/QkSo
qspd96s+W+URkZHpZIrj0/MZ7ArFGt8SIETF2aqDoB8/eXo6nc50WSo1KEvlV2UJANHGbX9t+8l9
irHMasfX+xA3NwCrInlaRi6fNK1i7dctP1ePXF1yILXICBbrnyp3vq+7v9tb2z5wru723zaY9tXP
uwppm9L6566nDGFZyoFKvN25r6yca5lLq7ANm2c8s+Dz9vt5TMS+Q86oqjnKcoBa12BSVt+UIvt6
O7sXZTabmYPDs3OtzQyNy7ASU1hzHQLBaJGNQVmUqmCYwr2rjyCGYNx6bcpYIf89ZhAvSte77mFu
XhwTU8q0Lqk1yfmReYVafCauT5fvu+xQjVz58fe03nF709RnSeM8RaTF3trluO3K0lZsex8v3O/9
iVUsp693jsl1uQxpW17UrUtlIe3nLoaxrKyufPuYA/zskrP2BLvvg8TASA2JtoP7uIMYwWx6hlK5
HQWFjcuwMCA1GbAYCI6eP8LTw9OzqqrO0CxXXimtFVQEhIfDsiASFmToHBkXgWa0+Aw8yjUdl3b7
uv5bquzptVWFJQcUufu6Pq/LAFLft6tey+qagtbCkeOZ/LoEN39/HAuIxi1n7dGYnn4lWKyT/54D
2FXGMqfMOXbVd0/ctlXHNccCYkBbpR9cwYBzD/yyZt/3IsncDBGIS3vuQZIVcSEEQl2d4MGDz6tn
x9PnsG9//sazDH09QaPRqCCGPd5b12FegQH498z6F4fksk2Fu6vjVrESXRYmlz8RtZSmT3H6vues
y7LkI+zxkVyxcuWEKwW8lBmk5XcBXJpyQt/FSHJWM65vHxNLxyetQ5zS8VvGNPoApUuRc+3I9d06
AJ+Tw9y/fcm2F0Br9YJfXp4AeqEw3twBF25vCCJZsgdzyunpmdz5/MnRZFqfwx6QkgJCr8Cusw4B
EEAxExMRiSYxQG3sCzXJvwtPXEeIoA0CiWLSonKlHeWf7VO+HCjEz7e3jOZpYZcS9QniKsKTlpOz
4l3vLEzBoE/oc/nmDl7J9V8XTV9VMXLPr+I2pPXqMwzLACFXZqqsff33Im3vkoU+ucj1szWcGiFM
SOQWpOkGIgRWnwQYDkfu/ZMESHOas4igUAMolHL3/smxCGawOxyXW6worbN0WUDQ0/l8dnw+qS/s
bJbGVOTnS1kYLM2iCntuZ7yaD6HiuQ7qEqIXoaDx9XSAupSi796+/HPl9dW3fYDpcibUJaw5hpTW
qQv4cgC7jCGlZecAOMckcs+n17qAOpcvgGwQMGWIXUakS3b6ZLHPDehrV5ra+QJwqxHDYbgCiFDs
f9l/7MMQieNRdsrfu+4WHwxt7+zQzu6uUorLus6eiNaLdv3RrqQ9WpvpgwePn02m9VxrDWJGUZQo
ihJKFW0BM8lGDTTfu2juKvR7oVLRsyI2ULZsuqordVH0ZYCzShldeaZ5dOWZKtgq96T35X4Hul+w
k0s5pfPXPNtJWY8/yjz9S61qV1+mbkr8/DJ6nrKvvt/6mEFXHdJ6xHK4bGxb7c2MIxG1juhv1S8C
C8/IDTQGw5H68Y9+sDMoi21m3kbz9ueV0lqAAGD6m48+eXT33uMTLgvrG/tdgREDEJFQYX8tdhm6
/Lf433VSSpVzQvWi+S5jB+nA9glVDhBXAYM4dSlOyqpWpfzL2pkqQnw9VuouRe2rX5cVjeuTlp+W
G+e9itJ3pWX3dfVDWvf031WNRkIKbBkEt0R7cb1GAIJQF7GHwxLjw5/93qXf+91brynF1wCMsYae
rwsI1cOHj06e7D+b1jUBKIWoBNMAhBJ2iauBiHb+TZsed9G4XMpZ6/hV3Wk+OSvoT5fxrMHnm7NQ
aT5dgLJskHNt6xLyXH7+WjolmApizgLFv8XtTuuUs859bWfmcDBpbqozBYX43hQkumRgFSD0eef6
JCcvXawiLTNXVg4A09+6xiV9a3icR1ZmnJdgX11Ug9wbrJQQyFj2YN9/al+sY1/9bndrizvRyRBQ
FApMwKVLe4M//eOfvLm5ObqMBhAIKzCFeHRzN1P0LwEgZsJ4Y6js66fbnWh3/RHg3rrTRtL2wPSl
VYQj/nfVlFP83G995aVlr1uHXNm5OixjGstSX/1ywpp7dpUyuxjB31X6pmOySh+sm18KOl2fPZNu
nmmDpfUkGheEmaFNhaqe2Tujcji8acxGJi7slZuXLmztYE2XoevdjvHn+Jra2d4Zv3L9pU1FwqDo
CHaisLJK/ELWFiL6U2Bcg5Mqpp2eE9pc56aCumzwuiwTsLgBJ7WiqUvQhfh9KQWXLobRp5Srlper
c9yernLS656tpED+TUDx206+Drk3IS17Jv3cdy2XUlYSX0+ZS9Nn4SY3m+DjCJGsoZFLkIFojens
FEUxsO+tkJiJKPgzLqaziXz2+d3nB4enx7AzDSunLlOdi0wSAL585dJoYzQsDYwhNBTJKpM/ldae
ntPutKaTsgVmKGCX9VnFJ8ulZQxhHUbyosqwii/6baRl9esDnvjZlfzfFxiLbyv1Uft18ui79k3G
aZnraVr9mwbC2+yBAMzndq1RcI9dvkYbF29QeHpwUP/bf/fZ19PZ/BDABN/iSsXY7yAA5vzsfDY5
P68L7JGEN8jYaUUNdnuz3QtMxb6ijFzsI/WL+xF0cfFLjlLHsYE4dSl77t8c80jzS7/7duasUM5P
zjECEcn6tV2WPZdX2o5c+9Jyc6yrC3jjZ9MxyjGq1Frm6rTMaufqGpfdNza5PvfX04VhuXxyLCyV
0xyzyzHH+PnF/Nxn974Kdi/xQbRsQIczPgCAwYqhUNiD9IyGX59gjITT6rQGPvv4F9M7X+4/NkYO
YRcnrYzWqwYVfWvrR48fP/s//+3/c79PcW2j80LWyjTp5D5fMNfBfVM7udQFAl0pFW7PWlovAaXF
abW+1NXO3LV16tvVDzmF7KtTnF/6jO/zOHC2qouzyvik4JL+dc0uxJ9zABVf7wp0rlpGVzm5P99f
ubTamKbGjkJQVZxrEeTRCLSuMK9O5dM7n5+dnlUn7mWvax2S0rd0OafJdV3rs48+/uzpdDYz4+E4
K/0xiuY6hTxliO5v/Zb8m67EW6YofZZ1VWqbswpdeeaeXZZyoJdartw9q+SZs4Kr5JECcJ9lj/NP
mUOc1gXhVVJuXLosd/qMT80BrP1l+M/r1L2LjeXvcSwAgq4Tspr+b/TBaHfMnq8bEYgAowX7B5NT
bWRqjJmifUDK0kbExzN3JUp+N4fPns+11gZo08b4GHNXx7ZgkQeDRcofd0AXM/Dfu6ixH+TmZZiL
FreLJuYGPKW+OUqc1mEVwewCg9y1Pmralb9PXWxlVXDIUd3cUvBcPXPPpmPVVV7XWK2S+lhljpF1
1TeX0vzieufq0FdGox/unUUEhA2B1M47nAQmgDEaRXipWtRfRkCkoHggZ+cyJesq1HHxvY1zaZ11
CIB9i9PgwoXdkVIF+wbaOW/f4Q1++Mr6t/ESUXi9mP897bDc9fj33KB00dv4mXUGG2hTwjSta7H7
fotpaq683Pdl9+UEv6sdXW3sy3dZHsvAwV/LuR7x87nn+uh8V926ri0D51Xas4471M7PKX34H9y1
7viOGLEv0E1WhAYG7V5mq7XWRCTOvWgKQygk9xnAeoBAAAZKqZ0//IOfvqLrWtooL60g2+JA9NOn
ZWCQ3p9+7gOFvrJy31fJZ9X6xQqT9ssqwhl/71O69Pdcfn3gsqri9D2fYwRdShKDQfpv+rnL0i/r
t66UtqtrDHLAkC6Lz6V0YVJ//awBJeTlxH/m6FV9yLkkBIDs8uWioELs69S79DutePi+7jHsGz/5
3d95/Q8+/Ok1ZqYWA4B9T2Pu9WYifq41aURaqzVoYqq8Ofqao3Px8+m/vuwFZF4TEHIpJ8Spgsfl
xb+n/bIMDNI2pGXEdYjv6eqDXF5p6rPqXXVe9ntfHfrqGadVADgtM807Z0D6ZCMnxzn5tNcbNzp9
IUwWsEVA7n2Rfh2CzdPpoczpwu5wDGCgtfZ0PWUJnWkdQFCKefN733vnulJMXAzJiIFiBWaXTQ8L
IHg/x9EjD2xEC1H7VUAhFeJVlCx9NndfavFSYehD+1WUNs63yzLn8ngRhUrblysj99nn1RWHSfPu
AvJYCeJ8c/mloB4/0yUbq7LJdOYgbWuOhazKWLtkqatfFpiDAP5dKkQGRox7VT1Ayr6xjLiAEEEZ
cW+VJkDILl0OdSCIUTD1HC9d29omogGAQdodHZ9DKqIfu7TQowsNh8PhBx+8e3Vra3OglJ359DSq
61isVVOfYqzy7Dr3p4O9al07wa7Dksfl9dHetF591/uUb5W8uu7vYyMpaHSBWdzOPhBeRU5yQJJL
qQIua2euvqv2e1daNv75+jjAiGNu0T1EdgMAyBp4AsCKMRqNALB7NWVkvAAoKqBrjUt7GxubG+PR
+fl0rWXLQD9DWOgBbYw5ePrsbD6bm/FwIKzYvu7aoZZewkpaKL9EuVZV8D5KuNCgHjdhFUBaJlx9
ApyzOMtobs5qpVb3RVJKm/vob/pcF0vI5e8/p8qfA5wc6PUpa1yftMwUmNJ6dwFBXGYfWHSxyVUA
rKmnq3d8rKAR+Fe7AQSj7eIjSwAIhhhlMYLW9rQycNQuAuyLYBnj8bDY2hyP958+G2B5nLBV2Rwg
dLXG1HU1/+rrr08GgwEzM4uYsF/bGNNMKy7plFzKUdcXtdwvoizrMpq+57sEKaXMuZS7J2ep1mUE
ufqmn3N9kFPiXN1ybe47Ms4/syoL6Kp/Ttnj57r6elV3I723jyWuMjYLLoMRTwLCYqPQNgEACaBh
jAaz3bMgjjXYcgES+7br4WiM8XDEe7vbIwBDtF8DvzStGkMQAKK1qR8+2D/TWpvxUMl8jK2Q0AAA
IABJREFUZkhrDbgly+RQzif/tqR4EUg8kLkppy7Fyt3j80ivdQlaak3SZ3Mn8cSDm74ZqktQ0kUv
OSXropkpFU+tlf/Nny6dppw71MeCutqT3td3T5+Vj1P8ViaRxQVrXQwoF8tI+zAnM+nYdbVhFWbX
B+Jp3l33tl5j7+pplyzbV8BHUmDvE+ut+81NANz97sg1IXc0mUDAEJmBSdH2xZfo8uXtbWbeMsZ8
qwekpNFJvnBxb7i5tVloAVGhQEUBYYKGC3IwQdi+Oi1H3fznHH3v+wtdlQjDMkvZN9jxEtbcQpn4
2XhqLHfGQFpeWkf/p5RqZmWWnFSU64NUoeLP6fRdfH9aj2/KMNLnupRpnXxzwNM1zv6e3Bil5eY+
d13rcxXiFC/h7stnWRuafMQBQJzXomuWGoam3XMYqaCUopuvvK2+/97Na0VR7MGeh/CtMwQAIGYe
3Hjl+k6hFAkIRTFwFfesJB9UylnSLusfNz71I1Pl7qL5Xai+Dt1Ly87lm3smpbBpHfuo5bKUWpi4
zFzKWasc+PWNQy7PVcqJy1vVHcv1dXoqU/wv0A+qXWXmWNS6gNhlaLr6Yp0ywn3S1uQuObPMi2Bf
+kK4eOGS+uDta1cvX9y99ODR/gaw8BrxzrSOy4DhcDi4cuXipi1diTaGVBAugYhruPucU/rQEGoa
32XVc7sju35fqHCEpF4JUguUUvX4t7jMLqvRpXBpvXKnPOXq0qfcaR/k+iznasRlpf2wDJRzLKKr
n3ICH7errz1dbckpXVxWFwvoM0brGJ8+BV4GgGn+i880cYLABsjn4a9F7lNG/lv1BUEbDWJCORjT
pQsb4ytXtncePNofhMJWSF2AkOsJVsxqc3OjtMpMoLAZI6moEUjHtmTfkHgfeB+qxs8sYwhdwrdM
yXL1W/X+ZUqTq+c6aZVnV2EaOcDIfe5Kq7CILvazSv7x2K7LnFZNffWIQSGtR9dzfaCwrLxwL2AX
7YlAqAkgEhHSlx3FupIDZ3vdwIihyXSmT47P5ljU5d5KreMymKqutUMvgQiJ36XlG9dBpeNKh4Yh
b3XTlFL4vt/7wKCLhaRpFTBI/80FvV4kpW3IDbyvYx8w9VFs/3zu375708+5e+M69/2+LKXKuepY
9bmPaT6rjtEqrO3FxtuPjXs3gxEQml29Nl+E74AsyFucmAhCCkYEoFqeHR1Nnx6eHCP/spbOtA4g
SFVVs0ePnhxrrY3mgpVqd3i6TXmZlVhG4Vbp7GWAkOab1qur7Jzwx4rYV+6q4LNK6qLNKV1P743r
m/6tAsRp6nNV0nqtAszLmE8fU+hy35bl5e9JF9H1pT6DsqqMLjcy1iUgopaB9b/n3KOFMolAUFAM
PDl4JF98/fBkXtVnsK9z86+FD1l01WcthmCMmd6+/dXhbKbNaAgSAYh93AAwlW69tixuUCo4RO0g
WZcS5ixFDvX7rHPOl+5KXW5IejpQX/5pfl3l+Ge72plT8LT9ALLbvbvK6+rnXMr1c+pn58rJGYK4
H2PqGwt8Lm9/LbcjNGeA1gG6tJ455hSXnfbNMuDLAq+vv5BTIA2IW4sACv+6Upp2meisSBAoTOHa
3w0EUBqFlHhy77Z88unD/arSJ7CA0Pbte1IXIOQkRADMv/jyq8OT07P57s546Pcn+D0M/vjteNdj
V8fkhCpndXMDHM9nd73BeNWU88XSz33WquvZXP2XsaQUALryzOWRYwpp8v211NokzyxLKQh0AVmu
rv4eu55lsT+7ZGFVxY9lsM9Y5KxwWo/0LIi4visbA6Kw2ygt30UY48pl84rbwxEwaK0xn0/kydP7
5t6DyaGInALIxRE603rvdgTk7Ox8Np1MazEiShGROMpjBKTarGAZjUsbu0w442fT/LsGpov6d31P
n+kDiFRYc5aqD9jiOuTy6gKDXP597YlZWo5l9M3WrEOHc3XJ5RcDei6PPhqeKvcyOVslpXXJGYIc
q0nr7uvfC+IUwoYQMUHpCYAYuKXLNi28Ljnqm4X6uljEydnMTKd1fXQynRhjfPzgWwMEp+0A7Fxm
MRqNRoNBqYiJjBFb6WCpl6NtnLqoa86C9FbyBZhBXIc+yxF/ToViFfdkmTVeh+Z29UmXhe4qP732
ogq17LlVwKTLTYhTLoiWa0tfHZexoC7AXGYccvXpZQueISTV9gyBInJO9ocWYMeuYevlQ0SY1ZWo
YqS3N69W49FQRdmsrCCrvg6eAKiyLLfefPP1a2KMQDT8a9wC6vtly74zKS+cXYoRNzodyBzrWAUI
ljGGZfXJgZavi/fdc0KU0t1cWTkB7GMUKQtK8/Kf+9yoVAn76HRXf8R1W8W/TusY9126fDwnI2ms
KW1L2l9d4BiXk/ZFXH5a/2VMt6v92T4VAxA7t6EOJ5PDLQrOgVxgVNAwYo9btzOVEk4jM4bAUCA2
GO/e1Ldev3zx0zt3N40x8Qtf038XUt+ZiunD5Y0b11/65//sP357e2tjUFVGhgMVCFDq1wsAZPys
LmFdx8qnipD+9iL59DGFHOPJKd+L1CO2Kl1CmVOo+Hr62zI3xV/Pnf7TJdzx712f075ZpV9yCrsM
0PqYQReAp3XM/aVKvIzt5cpOx3OxL1JmYV99KPDBxcagCxrlsycm5QOf9l+3XpgVbW1t8btvXrr8
r/5NsTObzYdos4ReRVsWVAz1AVAUSo0Vk9J1LeSqm3ZMELIO+uQ7ySDvVqwCDDmrvErqYyU53y/e
G9BF0fsYy6psZhkwrgqW65TX1fdd1r3ruZxyLgOstJ4xCHQ9mytvFRaVA4OulAJzmu+qBqyPXaSP
2e++T/ysgSsPFNi23eDUZmbtMsSvVCAR4MLOaHMwKDZms3mJJhzRZ/gBrHliEoCS2RCRkCJFupq7
BhGYfYc3+7ntKcxi9223vKOmFrGAdFnIeMoppXg+j1UGqE+409T1EpLc574y07qmbekCqWWMxX/2
qWt/Ql/d0uBe133x51WUoovJxGPr+zdH31fJp6sOOcvcxebS3Ze5stPPaZ65unQxCm/9RSQQhaZt
/qVGjQtub7DBRwGS1b8EiJ2mZPIvDTIiUBAzoYLrgkAKVsdjhhCqm3wWYLVDVkNmRVGovb3tUTEc
KBERv3RZpL0DsPWm3SVEJWepVqWDffcuNGJFK5vmnYJC+vdtpTTPdcvKCXWc9yrX1mFbXXXIpa66
58DgRevQBwTr5LHutdy49dXPp/YCJKti9vWHSf3JaqpZ6BsPOu4PBLACUGN6+qS0L15eKKQprH0t
pCJ3seNmMUYqrcWQ28MNQuvEF+0atYCU7vcYFX1dUzRdpvQvIjCrCkYfsq868Lk69uWR5rOKD55T
nNSKLmNMKStLf+97dpXU1460f9cd3zjfNODYR9eX5dlV575r8TNp2Tl56iu/Se2AdWDF8f2Q5nxF
WIZRiwFDQ7TB+ayYzebzNMC1dPBWPYZdANTPj49Pvvzq3lFV1cYYuxrS0xtmRlEUKIoCrKKXtGYE
Pvc5vrbO9WVpFQXpeiZWGt/O9PMqqc8vjr93WZ4USFKL6in4ugqQKlLfa8xWbeey8csBwDdlB3Eb
+tjUsnv6rnU92zVGfSyiq17NkmpnYLUOwBK/JjB2m0N5RsACkBpitH1FF8MhFCv/RpdeVhCnZYAQ
P1wdHBwe/ubjz58oLoi5gKCAIYSDUZoGWyAQx2fIcp7ejsp1vE85BegSrLSM3HegfVpSqmhd9UtB
IVffnGXoshRpuX3vqoyFIPduwlw/xW1Nr6dglxP0+Peuvu+ru7/mBTstM/3clXJjEB9sswycfV1y
L4bJGagUHNP+zuUf90WOpaR92CQH5EIQq0iuPAVFbJXciH3BqyoALgAwjEHoV1cSYEiMrjDa3JML
W4Px9vbGGECJ5jyEnNvQSuusVDRVVZ1+evvOUwGBFaEoygXq73rBPbVITUMDkuq8iDXqrTD1Bw27
niGi1t6AuG6rCG/6TJq6qH6K+Ll7+8pIy+t7tgs4V0l9DC8GrC4qnctvFYaQ5rVq/rl6ptdTJe4y
Usv6NAf8q/TxYr7etzbw6w0gAgkg5WILDmwtWDFAQrWpTVEwjUeq3Nne2Hiyf9gXFlhIKSD0PWgA
zD/79M7T8/P5bHd7PAARmOz7HG2nRVMkWGItM7u6ulKfEnVZunSQV0ldQtdF+bosf/x7Kkjr0vq+
lApeF0vKldkHJsvqmbOucYpnEIiaNxaneayjOOnYdrWlT1ZWaUsfY+oCha765Fhurl3xv131D3UA
AOZwwGqbIWooRairSiCV8jN//vFsByRpnc1NBKCu6no6mc00F8rOeURbNXIKs6qApvd/0/SieXWt
s0+FY5W848HuoqZ94LWO1U/vWwVMllHgVcpdlal1leOfj1ctLlOwPpawisIuu54yg3gKOucW5PLt
/l0Qq1d2DHz5ERMgInvWgdifxZ/W7PZEaG2gtZG61nJ8fKSeH59M9p8eHWNxc1OvYKziMvgMBPbV
DLXWlbAYIiMA24oRAYQCAgGzPTK61Q0dg9zlW3ZZv5xViYU7NxjLLCSAVsCmiwnE9c3VbxXG0Odv
5toSp1hhlintKvQ7vm8VS7oKbc5dy7U150p2uTLx7+k6jmVlp+1O69M11qls9e0S7QOHPkNI5OIG
aBg2kT0TwRi7RDnNWsTONtgzVTQg7vRtBWgjUs1neLb/kfqr3zy5//z56VMA5/iGB6T0ug3n5+fT
g8PjKbESgV2wuEjV+60oWfQIDYz/Xbiv554uAepK61rcnHCkyrjMuqeCn6ZlitsHIOtS7lVTHyh1
lZ8DxK7+zilyFyPrcwGW0fBVU859yo1bV3m5FD/T7sc+Jtiw7fAsImPVhA9sLlG9WRQKGJJ6TpOz
SfVXf/PggRH5RicmLe1FpZSZTKbTr+8+PDEf/qCZz0iER1wgJD2iuiVoWBSK9HtK09J7X4RSr+K6
rPL7KhZ4mQVL8yOirAXsmlJcRltz93tr15eWMR2fYla1rPwcmOXANf2cglK87iDXL33sLpfWcZu6
WF1XWkce7b/L77fvPwEAyyBiwKGCqChGUOVuzcwCe1LSymAArLd0GQBgjJGnTw9nuiYpBnbdtIi4
Ay4k+stTNP/Zv8RlmbCnwJL+nnMzVkXxLgobuwBp+Tma2DWF2eVzruKLdjGRPkWPn+sCyy420/W7
aS2XzYNADDJ9zDAenzRe0KX06fNd7kSu7+OxSgEmZrXpmOaAa5lrkbYh/q3FFkDurUuuDkoBEMAd
HyBiTWVcLy99bOzZiba/ARENEYCYwaoAYYCt3ZK3dl+mD965cfHzL+5v1HW9zuLDlRcmAQC01qyU
Gt5647VtRUQEas0H+7MYlgnEsu99SpKmF7HGXWldqhk/1ydU36R+y4Bj3TqvW3Zch/RzWo8UpLvG
Zhm76lL6rjp1fV+njFVTn3sY16PbpYlDcjHrj++T8N/4Ki/Imf2zZYhdJ6yI9/Z2+d23rl0djYY7
WHwDdG9a60UtAMp33nnr4q3XX9ljEhFxB7K7SiqlGgawbFtwFEPooofZ55Zcb1GoJVQwvmcdVyJN
fXmklttfy1m2VIFWpfb/P2/v9nNJjtyJ/YLMc75rVXX1vWa6p2c0oxnoMhoJkow17F3DELAwDD+s
7WcD/tMMw35f+MEG1gtbWK3tlayL5ZU0Gs1opm/qmunp6rp913OSDD8wmRkZJ8hkftVyVH99zskk
g0EyGPELJpNcK18tXy1Eswy25YWt8EA+iiy175J8GiUtIaGlcvT3GgrTiKh0r0ZEhPyUgBqeAtYc
ZHqJEMIZAwCjcx29/fbb3fmJOyKCXKnYRGu3UNvcPz+/f3Z23PX7wBsikLeX1lq05ClKg1krZ+tA
L/E5qJxS6lc1CLLcJeWSPCxPI/nWyl66vsYjloyCht5a5hw6yLBL1kfXy5LPGmylAVyj2gCu8Vly
JEshXk3HslfPbyUs1UUjLkSJPFKajND72APw2HRHdHR07D777BfPb292O6R5hJGlVYz8serkJgD+
7N750b3z0w08E1NamJSNUAhxFJbza5uFRip5P31dKpdswJzOOpPR+l7yJpYxyIptDQStGCWDs2S0
suw142HtHFWqq4VAWpGAbGONWnT9ZXm6nLm3msuV21Reb90O3WrzVV658lvy1wihxTBY+mo5okle
RnrNGUjjZphPSHsRIkYevH8Es5qrGk53YnEeShxWM4IZcHv0e4/91RX/xV998kVk1gZhkaRBaGlh
Zo5McJRf1eQBAlnnDmayvIVueMubyLSWBwUO9y2QZRrCN11rTWN5wrW8akjCWj7dwtcqo2ZQtCFb
MmyynJY1/vm7VU4pb86j+9QyXjWy6pJ5lA5qrenjWrLqLUWmFD+A0uvKcI4QewzbnahNUFRVZ2MD
DuQBDgHPX/6cmAMx5weV7aQnFfU8hqbw4vnL6xcvL25zP+qdW7KXsAaoZa1ryiDTyWvSkJReNpL5
lkjCPWb7FGGdpvZ3V7K88JoyW8tf4qF5lQypLm9JjlYjXUv/qrQkt/XZys+qtzRi098U1k/5pjwx
Rux2u/kmqsP7CpMjPkSTaS2gQ99f+9/9wa+864iOkV5uaqaWsx1Z/IXHP//5xc3NTUiViMiTGzFO
K8kkiyLcdHXPqge4RATSM1k78sr8BxUTZWpjZnkM/V1fa/FSJblqBhHAgTxL3rqWtobANAzW+XSb
lfIvoRSL9xK60M5A6sJSSGXJVGsXTbUQZU2/W7qccybHn9sw8ew2G6Q9R+Y8vOuGrdQoLVLifuQR
uIdzGxA2fH72ZvzG+4/Oj0+OTvYv+w0OUUJR8NocgkYLEUB/c3N7G0HsEBDCHl13BmYH5xjMMiY8
nF1nGhg6G5Za8VjmIT9LCCR/WgpqxXSWp2j18JaSWPKWPLCONZe8koTJpTrla3puYqkea8KepScf
Full4bqs/HZpTQ69/kHWTd8rGabSQqoWQ1YyCrJe+rtFeeDnIZleQHIgjuM9AsH7LdIKJNnn+fUh
xu3NBcB7HB+fIz1MIIADAjOOzt6Ip2en3dHR5vjly+omSAfUJemqGaRhCPvdfvfixctbxnsgCoMx
8GCevPW06EQxUcpc63w5kEphgIZigD2gdNyZyXqZZgkZWFSSzzIGWlmsRTgWDy1TjoG/alht9VGp
beX1pTbUbVQybLpseb+UzkKQss315iJWfVoQzRqS5dSMis4zK5/m99Jx7+nx/mZ7hH6XQo0Yw/DI
n9CHPZx3xGGfOayqyNJTBh06oA993O9jIDh23hORQ9rs0c0UKIcSFlmebVZowXBY8wQ1PvLeEjS0
EEONWoxbDRlYPCzEU5L/VY+wK5Ee5Lr9l/pL/tZ1sAZGaZDXri2FByUkVUJhrX3eSiUktERaN9LT
B/kExyPEHjFGbLdH2LguGQqkM1V950DOcYzMYb+Lu91+D/spQ1GwNXMIAOBOT0+352fHW+q6aSFS
2k1xVOpkpW2WFrTSypE7VL9Xn9PUjIEFC0uoQZctO1IPuNrg1TxlHWoD2aq75G2dmyB518rW3sky
YBYPa/BbRqKEGjSCsQ6htcq2DEQNOem8NWOwZCDyd402NfoohWi1/rL0d5oUTKEDEQ3vJQDj7stu
kJkBgODIJ90Z9QqA60AEEHlQDGmf03iMyxef4Be/fHx7u9tfIL3c1GyZskGwwgaLiX/99YdnD+6f
b51zNO3WYiujphavXoPZVv41SEHK8SphQg06lwxNTRYrr9WGWtksJX9VtKBlKP22yHr0fFdvWZKr
Rq0Ir5RGG6OlMpeQSv5+2DfSx+Z0AKDRYxr4jjLy1xONDBClNQwM9CHwbnfBf/Knf/r8f/2jn/5w
t9v/HOn159UGYSZb5Zr/lW998+Gbb75xHEJA55OFykZBHmxy4CELXqUE4zS1KnpJka00ltdtURar
zJxGetG11GJE7jqwlsI0K73laUvnLMrvdzHSVrpaGGWVu8YYWMjMKrNEd+3f1I4Y3xLGMGlIyAv6
BkMgjAbTlNfBDYccxfGcBvBgKLjDR5/8zc1/9z/+65/87Y9//qMY+ReYv/682ECr5xBubm/7/X7P
3p8jcoTDHFJJK9j38pHWfBa5ZBT0HzA/4HJNR5RgrWUMSrv1aF5STqucpfjY4mvB51JIUoL7XyVJ
mGshhFooZNWndE3SkhG1DMOSEdek9exVUVVNv6xyp3Y4DMVQcwbZgmAKL1K0QWNYwYggHOH5s2fh
6bPLqz6EJwAukOYQSg10AFVali7LDOEfPv3s8urqdk8Ip8wMkB+EStBliqdUBZnBYbhWqrhBpbht
FCiEYsxXQh+WAap1oh7kJUXK97QX1c/uNdUMXs0ryphX12GNUZJ5SgYqk/XY0aqb5XmtdLVrOo+e
j7hrKKL7sBX6y/yl+9a9WRnpBGQAjBgDiFjsKZJQQppHEIZ3QBWgtO4nn+QUmdPSZQBgIPAtHr72
VvfWm68dffr4aekY+GqDrd0PIVxeXd3GyJz2P0ivcbu88IptizlKIq+Tca1AS1BaDoaap1mjPCWI
rfm3xJ1rIag1wOV1bchqnq4lfLHgs/agXwUiKXlUfa3Ul6U2sb63II67IjlLVit96feUncd/JBb5
TWkJoIAQGX44DlFSnlFg5vQ2EQEPXnvo337r9WPgZ1us3N4AWGcQGABdXV33+90uhsBMFIloepcg
RtkJZS+Tf5c8eFGAggdrMRQ1WSyZSgbBgtPa26wNaywFW6NoukxmPliF2SKHrtPSoFprYO3Q8lCG
UhmWTKXv8relL7KsFqNpyVRqo5qhTll5/IvDxig0nImqZU5lxGkBEyghBTCIxDkTYQ9mwvm9B+7R
u+9uvXPbEKPc7rqps9buh9B97dG798g7SgdLRkrTFbnC9kow6dkm6daHC0sdsET6yPo1SlAqy4Ke
NflK90qKX0NHUrHvUhdt3GqrAXV9Zbq15ZXu6UGqSSNBqx5ryrUWwNXmA5LTW7dS88DwzO8O9wFi
j+ms1EFHOYIoIMQAz5sBIQxzXUihReLCeXsUOEd0//79jUsG4R8VIZD3/vg73/nWmw8fnh9HZqYh
SAihB3OkrtsiTRck6ycbwjIIpVg/N6KO72U6PcBKA0d2tEYApRixqTEMjyrv1fJpspS5dJpzCSGU
yijBWw2BWxFBaZv6Up2scMSSR+erGQadXvKydKO0iKsptC3crxm3XI61HJtomARMIxrgtHty6m2v
eEZEjuDIw1xZOGgfDGeshhiGFcMRx0edd85555xba8DWGATnnNt87dG7r52dbrcAwEzDTo+gGJlj
jKQH34EhyNfInvRrDQfkfUk1C1/jrRVqiW/OUwodluS0ZNB8LcUrhTWt9Kpef02oV2pLWeZdUZpl
6GSoVDKEkocmy3AshZ1W/1lvAI98sv6nm6Nj5GGdwVTWsBiJGd3Go3MbRO7H+47S+w+EZFCICZvN
lgIC9X1g3GGDVWD9pKK7/+DekfPsYo+QniwQkaNh8cRQlYVBnBuk5rFrvHK+NS/xyLySr4UwWush
Yba8VkrbWscDmCkGj9z/wapXjUp1u+ugfFW6S7m67BLiqNWvZFBKZVjpSqFeieeUlibDkO6k/rTK
Gt4GTHqO4SWmBCwIQOgDmANC3AFIr0ZfXl72f/+zTy8YfBFj3B9UYoHWGgR+8fzidrdD7ykS4Igo
Vaf0WmwNLeR08jN/1yfdmsI0QF0rHCl53Hzf+pRySTio08jfS0qlr0uPquuUeZVCiVK4ZeWx5CwZ
tlJ/WXVZcgJSPj14SoZf16VEkq/u63wqVEkXrbouGXZLztJ9qx/TtbzjWAcWOx/N2kiEPd5PfRSZ
AeeHqcINuq7DxeVN/9//D//y4z/8t3/+U4C+QDq1ST5+lJ9mg659ytBfXV/f7nYhHm3IOc/JHBAo
xsjaq63xIiVlaMm3NABrIYmVfolqHW6VU/NiGqbWng5oha8ZSv271Dcl5ZZltBi4JaOt62BRKUzS
RqGEpvRnKwqwZK+FAVImXW7NoQDIgQFALE5mGpwfohimKaWjbMwimOf8IwhMDuQ6EDm8ePFi/4f/
9k+/2O32X8QYXwDoYRuDIq06yi3GePujH/3kF8+fv7x54+G9E0cEdmP4g2GqROZZZl5RjsSxzai0
GBCtAEvhiiWPtN41b74UasjyS2nWGFQLzmqyEJVVhn4C0+KhSzKVkFYNbtdCSe2NLSoN9DWIRqZf
GuS6vUsnh3PC/XmLVeSZAwxogXkuUz6sVfKTe0d4n5AFI/XXdrtx9++deU6oIP+x+qvSqscS3vv9
3/zwh08++fTxRQjMqeMi4vAj16XFy2bKSuO9H/8siFUi7Tn0YLXS63ytMtcUMMY4/klIKq/Ldz1K
B9TIfKV71gBtNaBW/a3BaJWz1ijkfQhq+y5m0m0k6yXrpkOPzD+3WQhh/CwhLJ1Xv6Cn20T+rqEA
fU/r4fQ9WQWidIBrHkel8CyPj3kfp8eMRB6OPAgOD+6fb/7Tf/b7b2w33X2Aj4DRVUvG8vcBalgy
CLJVKITQnZ2eHXe+ozyZyAwenjAAYuWVXGewBPGswZnvSWXSDWwptzXQNI+cR3fU2u3YdN30NctT
WUZDG7USNK8tca7xsMqylK+UJ8trhT56gAKpvb33B56yNLjl91J/lwZuzms5ESm77gerXSxHksuW
n7L+Ur6aERnLBIZRNwJvMEcgMhz0U5nyq9eyT9IfcLTduv/8n/+zd7/1wXtvOefPkLd1thGCGUKs
mUPwR0dH5//lv/gvvvvBB1+/33lHYAxLswnMzCFGdORJF2PBQ0J5omkJ6tWoltcyBmv5yrqUPKbl
VUseWZOl2LWBuFZ+zUPX51UQgSWn5F8atLXwAcAMARAdzrvUqMa3JFsLb8twWOWaRkE063TiGQHw
SO8xSKMtnqgNUcAUl6e9E/JWa0TAvfPTzfHR5gTgYymO8WfSmoNanHN0+r3vfuczFrdlAAAgAElE
QVSd89PttvPpVSZMkUJaT80MMMMRzU+IqCh6aRDnDlvroe9KuTyrzFr4sSSbNgYlb9TCU6aR8raS
Hnyla6V2aC1D8rXqqQ2RlaZF9lelmpNorbulxxaCqnAADZsalPo2xjRXEMVOZIwwBAX5WsTt7oZD
DC5GzpurloyBaRjWHAfvj46OT0/Pjo47T8TM5IhTXShNiBATYkiLk8g7yDaQnmAJIVgerNTAlnJb
vHJaDRElae9Y8nhaeUsDrBZO5O/WjkKZ1hx6qssveT89qFqNWiu1euGaE7Bk0GHFEr+SPC2y5TJq
dbd00kKRdhoaphQzH5tv+pS8HJzTTjIOiCmC4HC7u8WDe6fHzOzGBPNHj4BhCDLVEMJBSzpH3hHG
DaIJEcTDfi40WbmRgVBM7S01c5m2ZKmlJ5GDWiuLZVhk2UuQP9Nh50zXrbyyvFI51vqKkpey5C8N
glp4kb9bxrAkh1VnyUe3U8nASgO6FBosIcPSALRIOxsLrWmeln5pOUuyLRn/eXl5/BDGkUBI8wiV
x86OfDIjNN1PabLsADjSw9funziiTZjmCGvhwmwuIRuEFmxEAOC9pxiYvXcMRCcahyAmRdKSzKkR
ZspANLzdtQwr5fcWeFyy0pYS1ZTTbIAGGUoGMJM+Xl3LUPM8+bul4Pp6zePqfLLM0sSqzCflaCGN
qmqDfUluKcNSmfpzKV/rqtMlGWrGc+SNQ3RQkpXIXhFLROldh2GPhRB7bLYbHB1tHWPcft0KEYrz
CKvWIdzc3O6ePXtxu9uH3vnofJdWWiXZp8mPWS5B2grnazX4f1eqDay1MLjEX5JVh9qAznla7llG
oyST1a4lr2494lvKZ9W9RJYhAMpw3EIILQPZ4tHaZlrWkkOpUa0utgxlpzJvg7lspbInlACcnZ74
+/fOPRFJg1AKF1hfWzOpyLvdrr+8utoBOQQiZiKCS/YOkUkfumFVhJnH7aUtCKsbwPK20rsBMBXP
rEilca28tcEneZaUpzYjng1oi+GTxrZmfKy2Kw36loHS4glluVY/zByFIMsglsooGbV8T16rwfkl
5yM/S+0jUaCFYi2SaWOO6AnTbkkG8iICJDsZkhMNT1vGnZXSNe+29O47bx5777r9vvrY0aSSQSD1
icwwRmY4QkxfAIBzfbyw/LIiLdb5qyLdSVbZ+hVeK98SrZW5Nb2G/q351/BfyleSoYWswXiX/i0N
6iXUJfOXjE0VyhdClhIvK0SzeMy/z0dmupdG/9ywO+g9EmT44BwQYz6ExgEMREd47bV7PtsazMMG
oG4YeNXrz13X+Xv3zreEaVklpVcZAMIQPvBYaosnflVY2kLami+hhBay8kvvU/IgtfxSXs13CTFJ
r7UkV0mGpT5ZkrtGLf1pKb3Ou3T+Zs0Z6N/6zdGSMdDXdFtboZbFZ55u8uwxRhDi3IuijFJ0/4/1
GP75rgMD8N4hhHgQFhR+A1i5QUrXdf7k5HhDBPK+c0QEcg4uWTPKs6R6B96lAb8EHb8qBPGPcfSZ
JllnS0n09xKV8sr7LfC05fdSfk13RQ+tlJVclgcsH723xhisNXg1/dSGTCKsch9ORjoyg8DTIwHO
83GTTBkx5L1M81LmruvAfUAMEc53CDHy559/sQNjF0Lcw37bsUirXn+OMYa+j5HIDfEPjRs/EhEi
cUIO5EZrJxtCdug4U5kbt6B/JYhYSltSCh3f6nx3CR9KXsmStQRrNS2hGGlsls6FLD0xkCv/agNq
aT5C5iu111IsLu/JgSXL1+1Z6itLV2Q6zaNmFOQA1+08xu8NbXCAEnWRwzjCWHdg398i8h7b7hjO
dYIXwLwfyleH+nYAg/jq8jL81V//8GmI8QKA3A+hySi0nAyb45DQ9/3u88+fvOSYtk4jn9ZQDxVm
5xzJTpSNppVv1nkLg8/qPK0EB0IbEK/UYTLNkhxrrrfQGuSwZBQ1rxIqWBoQlizWYJNGtjQgSv3U
4okt2VvltO63OBWrThrpSqMleWkdstqGhy3UauScQ+xd2vNg9pg6ne/IiEhbsvP4pqMDg2OPTz75
6Oav/vann8cYn2HlMW5A/eUm3QNxt9td/83f/O0Xu12fAhPOaw5sS20poPWnYydNB+lhG4lcpvay
+WWbkvKuQQMtcq4lS+bagKkZg5JC1wZrTRbd5jpdy1+tHpJ37eSvou4ontbbpa19ousnX6iSJ0gv
GRkLxbTIkdJEeNdh0x2Pc3LTOOqRJg8dbm+vcXN7CSDtqxB7Rr/b888++uziiy9ePGfml5jvh9BE
azdIufnZhx8/ubnZhdcenIERwZy2bhos2DCXmD1yOd5CnmmdYodywQUYnr9LBZaf+bsFTSVZ8K8k
R40sg2jJaslplVWD20v5SwjBgruWp7Pua97yb2mwlHhmeUredymvvKb1xGr/JdJ9pPlotGkN/Bki
0OimKAKPaJvF+SbyjwjDUQdAiD2YGa738G4DQgcC8+Vlf9unPdVWb58GrHv9GQDi57/85fX17W2I
ROPt1CgMIkdA2rhhmkU9RAup+rIpbJhoWfgSpKxWYmHgWel0Ho12Wnjn+5bXbZWp5HVq3vegrReM
0hpEYRnbpf0OlhBKqY8tdFCiFpRnyW5RCX2sRRtm2pKYI1B2B/2TP51LW7UzM442JzjaHg07Laeo
OxJwen7unXMe03RALlF/mqQRgpVpZOq9715/+NrJ2elxRzEOLzC5YR0CU9/v4b1DjAzmsAjxDtqK
5nMPS4pS61RJSwbF8uwlHq2KZ3k1y2OXyikiq4LstXKt7xp9lJCLTiNl1+isJrtF1pOEUru16o+W
o2TYrbJ0uXkyUetvqZ6WzFZZ6bK4B4Dc4UR8Qgrl+Ym0bXtEjGHgEulXv/3+vbfffO3hxcXNvVg2
CkVa87Zj54hOfucH33/04P69I+fSS07zRo/j6U1pBxg7Vpw3x1RB3fglNCAVs2Xtfc1jtgzwu5Ks
kzWwlkITazDrdqp5XotXbjMLApfkKslprRVYGiy6nrpe1stfSwfxWjIuGU/rdylvno8ohUMlHmb6
AU1P824AMio7QIEAMPXLfN0EgWMcnG8cNmtleuet107+ye99+/0PP/78bYRwCuBpVVBF0iAsjQxH
zp18/7d+/Z2jI+85EsMnSYe5AHbk8nYIA7vDgTc2EuFAqdfCwpJ3rHneGk/LeOjrFj8L3ulBtiS/
5luSpVSXkrJankW3u35D1OKl0UGtDladLO9dqket7rUyl4xji7wlRGrp6hKPEqpMvIbj2IC5/2Yp
ZzbcKUEKxSdKmy4TYgQYAc536Lad+61f+/qjf3m8fbjb708wbFMiSqnS2oVJG+ZIkQMTd5SE5eHF
RU6wB4fKW1LQEiJYUoaSZ3xVKg2e1rxSJmu7MyL7+TWAgzZ51frVPHXroLZkqeWrtZ38rlcb1gZt
S/vLNq7JYG1+WiqnNeyxeMk8B3JxWp2Y580IDExjXvFNe4pYRpqZMc3Kp0NdmD023YZef/hWd3K8
PX3x8vIY5XlCU+i1TxliCDHGyNg4gDhSDAn2OEeUZ0etmG8JSsp4bVbpLP0KyF3inakUZpRm35fK
aUUqLQN9KVxoJcuYZdnWeHjv/YE8lswtddMIqiTTklGWiEPnlTxrMtTqomWQZWrZWvjl1YXAMAoz
j8buzGUeHkzk4Si9KEjUgWNE123cW+9+E9vt9ghA3jWpmVp3XSYAse/73T989vjFYNHS+5kxADES
h2mn27XGQKez0lrK/SqkFSrHr6XBXctvpbWut9Sf+XAF4V2p1kaW7LWBtQZq18qTbV16OlGSR5el
HU8JUdYMoRW6aNTaqr8lmvPKfNqQj/VdhhEJRbhhJPfo+1t+651H29dfu3+MZBBW7azeihAYAO92
t7u/+usfPd3tQui8c0iNTGMHOfulFNPzu7m3KEHKmRCqQ6zTokoTXZZySU+TZSGi0aK3xLI1b9vi
uSzlWxOm6HK0omtvqute4qllbumTUnii5ZLytaIK6aH1NUv2Un/Le0t9q/Pmtijpmc5n1ZHTrgEp
LdLGZx7pJCYXGRBl6LYlSkcmRgAxBuRwguET6nAdOdfRttv7+/fPjgB44OApQ3U+YdW7DM55Oj46
8mOFCGBprgTdBQ2stcAtqKFmFEr7GcoXtCwPsYQONElFKslfCpWW+GvlbkUjJT4lstqkdTAv3WtF
exq2lwyw5m0NWKt9lp5m1AxwjeTLfim9mD3M5XF+yalMzMlgTOVO8xJEaTXu6Ylzjrqu6zbVgV+i
ta8/H/32D37jzbOT442o0IgQsMK7aXoViNway5U8Ys1TWkp4F4OgZalB0pLCl/i2DqgayfZZMj53
5W/xW7ouZSptNiPbX08camRRKrMmj06jv9fCD5sHQEwgSnsaOKTH9HL8WLLMEZIDc0AOv4j88CLU
Dn24iU+fPd8hnQDdFp8MtMog3Lt3fvzo0TvnRCBK72iNG66midNx2rPq8XLlrMpmqnWaBYE1Tz3Y
LGWvQVxtALRX1MZgSZn0wK8pTwkSW2nuiggkyQndElSWv3O5NcTTKlOpXyzUqDe2KemQFZ5osupa
kqEkp/y9rv0JTDzuq8hiHqCmF33fDwZgvjYh1YXRdWk7w/1+H1+8vLxBWr686kj4VU8Zbm5udk+f
Pr/hGNkRU2AwpQcns9c6ddxpWWimQ+Uy07F9MnEJKgP1mFB7fFle/t0yMHRZJQ8rr1lGqmaUdJ2s
Qavl1UpcapfSvdpAb0UuVn1aEFzLtVy+1BH9vTY45YlHVp1rBqdGNf071KUc+9O4HTsGrw8MR9Dx
4RwZDQeyMNPIY9KrgP1+DwLhF59/fv35L58+B3CDVzAIrD41hdvb3e3nn39x0Yc0jwEQHBGlk6wn
i6c9uFbY1BjlyaEaWXBd3888829rELZAfGuQl7yO5qvrnz+XkIHFo2SIloxgrW5SnrV8rDao5bPq
8CqIptb/evJTT/7VUIPmt4QsSjq+JHviO1+ZKZE9ESXIrcZSjNL5WDoYwXD8v/yr/+Px5dX1cwBX
WGcQqAUh5FJjjPHqL/6fv3r85bOX12+9eX7qyRGB4D0AotHra687MhKW2Vo+Kxstpy9BuyXIbA3G
Vi9ipavl0R5lCUlYddVll+rZwrPGW+fX+aynCVrpS4OmRYavikqGUvdTa7hgpW1xGlKWNUaZDnZK
GeQCoE9xmvLI3ZjSRkhSjr7f8eXlbfi//+yvnzjnXoYQroFx2VNTR6x5RslEtPvo44+fPfny2TVh
OI2WHNilU93Gdeg4HCCWcudGlAuHlpS49d4otKEc1kBY8hiWt14a3CV+Jc+vDYHliXK6Fgi+pKBW
G+i/Vv6v4vHXUs1ByN93RSWvasR0H1t9Lo3I+Idpb5FooEq5m3mqi2z/NKN3u7uNz19c7I6OjvRp
TU206rFjCMGdn511joZNVmmC/rMOGd7c4mB7jCWrbcH7FktvKbIesC1Q0UprdaCUwRqwLR6zlqY0
8LVBba1PqcwajNbox7rfkmZJxru0Qwvas3RBG48lQ2E5hVq/tBIRgaMIQfKp0Aw4BjjOjUKeVBxy
D9djOtKAGY4cgUBnZydd1/kOyeHndxmaaNVTBgAn3/+t33j3vfcenctKTTFOHCZH5vdaFE13Uk5T
Un5tQGqeLafVpyZp+Uvy1RS9pgQlCCrrImUu8aopYY00X/lbt38rmtB9oK8vDfJMclVoizFYMjZL
4VyJLINWy1Pro1qeJTmVUAAv6wkzkkEYwosQIh9tj9wbr7925Jw73m63291uN1mQw9BB3mNgXcjQ
nZ6d3vved3/1nZPjoy7mGQ7Bv+s68t6n0KECtUtkQT/9qRuptl2WNhI6TWnAWsYqL7XVW2mVPJdG
F3KZ7to20e1j5V3iaymWltUyrFZ7la5b90pUM+Al51Ab9KX7S/es7yXvv4QU8m+tK+3GXPB1c15S
h1J90lwDufQ4cr/fAQA67+n7v/7t1/e7/alzLr/cpAsvzim0GISccfPonXff+P73f/Wt6/11uN3t
g5wVTYJ38K4DsQPxIbwGyt7Aalj920ITFmqowcAlJawpqi5nSZmXrq1VYJ1uibSBW2p7yyDma3qf
wyV0JOuiyyoZfl23Wl/VZM3X9bkLJdIy6f61ZG6tl84z1SfzFu/PMAB2YPKI5AFhDA7lnU58Touf
hzAdhN/57d98fbvdnDoi+bZjE7xcc5QbEZE/3h53nhwhOjATE6WCksL0IEoTHEsKuwb+Woql7+fr
+d7Scd6aTwvkXBoQlnHS11uUs5S2CW4u8KylsdoxX6/x0IjKurdWHp1fy7BWvyxn0trWpf6zDIdM
U+OR0gMY1/NZcztxfGZ4WF8ah7j3XT6UhbwHvfP2w2PnaBOZrXcZNI3hArDy5aaXL1/ePn32/DaE
d7kjUIyR02vPyVqE0A/KBNxRd+eSqg47bLDD2E8rcqkzayhDfs98rDcQax3fMpAsKg2qkids4dea
3mqfGrrRbVJ6Acoqozag8z29VFn2R41Hqb6WUanJYxkja2DrPDKktPRvQgjTCWimvCnxQXnOOUSe
DILzBHBECDt2jvDl02e3t7e7W0pLlzVVlWHNpGK4ubm5/PQfHj/7wfd/9R0i4r6PESB0nXPMkTkG
AjnATYsvUkXG6onait8VhbXeaCwttdU7/+S0+XdJGfJvi0qoYAlCauWV92rlyUEgtxPT1IIeLC9Z
S1eqnx6EFgy2yDKIpfqXeMp2rLXrUt3vksYyPpYsktcawwUDaZKUa3iUSMPcQn4LN03eA3lvlZx2
szki5p7/+E///ReXV9cviOgStlEo0ppJxf7lxcWzH/7tTz7nwODBwsWYZjdDDEBk5hCAEMEhgjmC
aIJGEJV15MY/MowWUXk339JA03Fc/m7FYdZJylbMqpWzFNdKaokvdTr5W5dTKrfEt1Z3LY82nJY8
mU9ut3xdTnjV5NQ8S95YIyFdH5m21N+W7DpdizGx+kr+1c58KNXlID3na4PTEn+O0sQiiNJWAY7G
s0WcE+MmMjhEkGPAOTx/edH/q3/9f30G4GWM8QYHnrhOaxBCH2O8/Nsf/t3Pf/GLJ5fvv//2fefZ
Oc8EMNGwDntUrDWw1khf8sAt3kHzsTzVGh4A5rverAwDLFoyKjmN/JSDV6OHFm9XKyN/r4UIdyGL
/5JxbCmv5oVb26RF5hLV0GEL8hSlTWC54CAyX0a5jThGhEi823O8vLrpiWjP2dKsoBJCYOM7e+9v
f/bhR798/IsnVxvnHCEQECjvFPmqHVEjy/O3llPy0hYSkB5A/ml+d6UaArHkKP3d5WSimjzWwLLa
XFNLX2iP2vIn+Vv8tOwldHeXtrhLHmuOaQ1iKi0Zz/W31tDIE8niwOf0ZOO/991vngO8xcrdkrAy
AxNR3/f9zeef//K6j4G98w4xPWIczqAj/YqqqN6cGYSlUX2+ZrAfCFlRKAs613gsrVsodXKL7CWe
lhw6XW3wtAzcJei8NCBLVCq7BrdbDNzStdZ+qZHVvjKkWsrb0p8AMhxOfxTH7zLEm/68eOU7IB1t
kM5hiBzHMcSZJzOc29A//Q9/7x1mnCNtoXYgbk28VUuXU4VjcC5NZ8RA0RFo3BFKNaCGoLN7037T
Rhnz+G9p0GjesjzgcNMMHUZI+Fmz6vK6TK9pyVvK75JPLZ8exFJh5f3W0Ogu8hOVj4GrGRkLlcn3
V3T97zrAdZu08FrDW37K9l7qx1na/NKzOoSF0mzibM+HxFOUzyKq4DSP5xyBYt6KPZ0L+cEH750h
GYM8vpstpDYI1Yx934MZ7vz8fLPb9cHDU+edw3guXaofkB6n8KyDlWGAPXin9OtId1RLWvl9CX7q
NK1l6fKseyXvUhvcS2lbZLL4tZZZap8lHlZ+PYhq7aXTLRnIEi0Z4KU80ghoQ1ZDnrUi9a1Uv+lu
2hVpeKwPAo2TuhF5L4W+73Hx8kU+5FXHIYsDa806BACgzWazOT4+6gggckTOySrSlJBccdAvDfi1
xqHWuTXvs6SopUkrnf9V5hTWzoXkckvzIi1UG+TWYK55v6XBW7pf6zML9ejvuo9KoWGr0VqikqGx
2t8qc0rDxYUArOSbDMjQzyyf6qTr4HQmg+s8vAvY7Xr+0U8+fIG0OYo8/bnUUbPrqw5qAeBOT0+2
985Pt9ujje86cmABmfIjqWTChn3jaNgXZporSNcOB+tYUMELyIbK9zJJCGodB6aNgmUkLENgQcPa
d81HkqW41hMD/d0iWYZVbouH1GQZTetwkxJykmVrY1BDNLW5B51mqW4lXaohu5Js2vBaRkjXo+Zk
iAiIBKYehJgg/nDuRR6XWl+ZAWYCUQfmMJST9ksIjPFtSYJDiHu+vr2Kf/bnP3wC4BppC7VVcHvt
HILbbrfdZrNxMUaODPaEdOjzeNyUnxomThhBTxy20JoBUsrXwrOVt2VAdCy8pNz505o1bpWlFRYv
8Witdy3EWipD529J35puCcG9ShmaWupbkmVm2FToPJMpO9MCSaQGpL0V828Go+8DQo/45bPnN0TY
Ma9blAQsG4SDFogh0GbTuQQCGAHMNBg/T/M3+pgOH2mNjaPqzcwzTzmv/JRGUw0qlmCpxVd3Tq2s
0hJdC75KXiUoWYPpVvm6DAvZlGQv8ZD3arK3DIxS2drj1+Rbw7OWxyrzVQypVb68VkJPM7SBYeHR
LD0DPGzFrvp21BGWTsipwRnBzLzpNrh3ftYBlLZxhrnrsnUNwPrnlLTdbjvnnGMGQogMEECO0+wo
Zs/tOQMHsgfhjLEBvbQxKeXV+WtKW1OQuyiKtRKwRhZU1n/WysoSD6AN6dTauyR3zRisCWnyp359
XFNr+9fgf6s8a6klZNHtZLaVcogyLTOnE51DfsSo2ziHEAl5E00Ti2lLdk/kHJ2fnXos9E+JagjB
4riJzBvnXHrN0fnB0qV6pm0QiJmZcmzMgzGSE4zMgx1piHXH9BWyoLzO2wIva15QKnHtTUqrvNrg
swaHzqeRRMkgtoQsVloLcdSU25JlCWGtNZSatyzTmhdYImt9TGu4ZjmMFuSp2zahA0JGAzybN+Bh
pm0wBNENzlQgCcZgKIbIgmk0MMkwAI6Ynr94uQehHwffMo1puuFHrbcyU7fZbI5/73d/+2v3zk+3
3jmi4XEjUkXZpX3V4Fx9UBJR0SBYXqlELXBbK7LMW0IdVpkyf2mg1wZBCyLK9dHb11syWMpZ81wl
76YNg5XXQne1/rGMx5q2sgzoUlig+93ivRYdLMlUk6eULg+2cVDPmYIo7Wsg843zVByGxVsRiIDz
UaxUjPCuo2cvXvaffvaLC4B2wGzpshU+HDTWqi3UiOj0N3/j1949O91uHNIebgzAkyMeN3zAYBTy
fICuMxUVxYq/SqTza6XQClvyoJYhaPH+UslK+UrIxap7i3w6rSxjCUFYctVkleVriF5rX5mvNhCt
szZq8pWuLxlyq59ayOqPuyLaWdkDMmBKKGG2TXyakwO54fF9nB5RMjM4pKeIkdPeRM45cAASWgfI
EZ49fXH77NmLC6THjqvjhpJBYOPTn5+f3f/6199+0HXeOfIgSlZiOMIJzNOzhFRRQlobYVjXisdY
goJyQFkdXUIZFlS2yn8VsuB3a1oLElsGT9ZFpi+Rbq9SHi23RCuyLi1QfY03XmMAtBzyc4l/a7+U
eJT46P6qGh+STppmSGGYbhyfREyHGXGOHsAMOOcTyogRAQk9dOhAncOP/u6nl9c3t7fDm459FrO1
nmvOZcBms3WnZ6ebGGMMznlPTJyMHQ2NwED6no+pzuuvId/qkswrg1enqymzpRw1r1sLIWQ+WXYN
HlvXSo8WZZklyuXl2HfpINIaBC+lL4VTlhz5e2kwAPO5lSXjo9OV+q9UP83DCumW8rYYBUsfl8Ik
md7Wv2xkaeYXp3GTLoZsjBPyhvOdMspxrmsx0PPnL/Z9HwKmVYqrLF/rpCID4Ovr692TL768jt95
nxHBPNiyGAM758dQIf1l61ewrHTYiJZS1zyh9lilTlkaeGuu67KX5JIDW3pcCwVYMqzxbq2IoRYm
tbRd6Z42sEvhjGWUWvrsVWht2GDJYjmd9Xyzzs51wdKH1C4YRmT6ktJM3yMT+v2e79877Trvul2M
HTQ0XyaWLz8sZe5vbm4uP/308bOw//57PQXqoouRIpxzlDZDcYgxLZ1ykcdXMqcK60Y53CarBrdq
SqU7RSuj9vI1xV8D+1tIdnQpXLHk0HWQM+WlcEd7yyWZlspfQkWWvFJm/V2WZxkjyyi8SvvXjGcr
35pOLvHRdU95MI64STcM3sC4V4hzaely5pkcbhzeL+K0IwkBv/Ubv/rau++89fDjTx/fh31UY5Ws
B8KljIGZrx///JfPdn0fgQgiR0Q0HgdPTAB7OEyPQafOFbGsWGElB0mLtZVpAbtDLMWsDaZ839o+
W/PQiq156l2eLFhtK8l8kBGlHXKsnYosWfRAymFGySMvtZdVd2v7ecuw6i3nJe/aGgud16qbJgui
l6jkPGqkDVfNGFvyynZwzqVdkikfUzC97i0Poc18KUYQM4jT7gLpFeiAGHv0/R4RDPIuLYKOPRxH
vP/BB6f/yX/8u18notcBHCGNcTkXKCcxDmjNwqS43++vf/zjv//84vLqliOAsaJEADF1Hn7jQd6l
05sgrf/EqNSgS51khQVrSRsgG54ddqaVx1JcK5+Wv1UxQwjFPQKs8qUM+rt1bwlFLPFszS+ptY9b
/lp5tlCpf1+VZ5bv0EDPjUz+bhmGfD3ITXt4WgAojDVtNh39k//gB28fHW0fIhmEVbTqOHgAu7//
6c+ePHtxsXv07lsucmSXVkeNsZC28jHmCTGxyorZnEPQ3w8EuIMilNCDHrxLMNjaNanmbS1lKqWv
wVGLd6lM/dtCYJp3re4y7dLgaE2TP3XfazmW+lbX8S5GQaLDWhkt8mi+OfYfi9kAACAASURBVL9G
GMkOTJ8l+ZmHR46irTxhXKEIHE5ahxDhfEfvvvPm6fnZ6b3dbn8SY2zZFW0kK7HVq3kGI8QYQwgh
hj5EYmKAEANzDBEhBI7JMgglnNBCrugSQigp5VeBEDJ/abys+1Z6nbeEENbI2WIMSt58LUIopVui
Utn58y6DRX+X16zB8VUghKV6lFDj2npUndDIuyIzz58gZJ4ztCgcMIHgElKHdx4cozs7OT5B2iQl
hwxNjZQRQskIzCiEQA8ePDh6+43Xz46OO5c2hHccw/CyBYNiCIjew3k/TIoSAAciQO/5mJUp/9U6
RKa1aEIkc8gl72eS5bV6Ssva5981Dy0/ZfosQ54b0PXTfGuezCLZnlZ9ZJm17d4tsuqrjXkplJLl
1+Su9bPmoa8tyZe/W692axmWEGv+tIyA7O/xO5AWKY86OOVJmytLI2AbntxnlJ9KguE8wXvPt9c3
/PEnn9467513wyT/Clq9H8LRdrv1nlzoA7vOgz2Q50gISGuqs9VyDiFMIYJsrJKUpU7W14pCFjxk
C6SteQc9mPVnqR4l+Vohb6snrymwVWbp/qsgr5JMFtXebF1CVxbfpdDrLojiVagqy7h12t14ZseX
vxMRQogg5xBi5C+++DIQiEM8eCt3seItBmEm9na7cZ3vCAz2nQNReicjbe2Utm6IIYznQ42CJ+kX
O866pj13S4feJRZeOv6tZhRKslr1suJlbcgsj14zPC2ebOn+mjCihWr8SkapJf0aA5zvrdWZVw1J
JQqdySFOTltrgDWCniEURHDPCCHwvXvnHkQUp4mv5kJKBoGMTwYQHj9+fHFx8XL/+sP7x+SI/HAW
FWEY72CAI2IcViYm3DPtmDRACYpTLCRnXPNni9dcCh8k1aCk9ThxqYwW0sZB87RCjqWwQCtaDapb
+WS5mUonYek6LBnL2u8SDx3DW2mXkIMMezSfmvxLIWrO04IuNZX7aJCBCcwkrtFBPhpGlmWwtdxE
HpEZne/oO9/+1pYcOedc948dMuyfPnv+9Ic/+vHTDz547753aSXCLJHLM556sxaeuEgRs7EAHyxS
0t9LA+pA0AWFaOncVq9ildNCtdhep6nJJ2PUUrolz9cS45fyWehGr+HQslj9Vxt0a8KmmkHQlNtP
zyXINr1LGGUZLttgZlkz/E8nmuW0aTzU9XsqdNx0he7fv9d1njbOOR9jXGXJVp3LAKAPIbz8w3/z
xx/fXN+GnH3pwJDlBp3Hj8z2wRdrqabU2mNbaWt/kp+WfYm0V7RkWQqf5DkGlrxL7VJK21JPqz61
zU+scpYQTav8liw1A9nKRxqttZO51m9tvKcdk6e203ogf2vjadUhBexAv98DAIQx0J9FWrunYiCi
qz/98//3Fx9/+tnl62882Oa3GmMMqeEG9JMrOSpuEr/Adh5XlQZqC3SrDfJa+tK9EqpoHSyl8mrz
C0tU86p3gbcyZNBlWGUuyVbipZVbf9Z4rim/VAdNLe3UEjpKj67ltEMxQjrzNBuaYYER0WzE6naT
q1YtdMUcEWLkJ0++jFdXN7cxxt1iBRWtPqgFaaNVf7TZULJ0HRxx2j2JWUwcxjRnMGzASnGYLxj+
wrCLklyglCupFaAG36wBZSnQYcxVjl3l/bHSg3ErUSkGX0pjnW5tx552yFRKy8zjjr7yUazVhhpi
lwZVyTiWjNJSX5XqppW9JK9VZ+bDx6i1EMLqf91ONcShjak2erq/GSk04CTMkHYY5ONrzmSGz8TR
lA0AIqd1QC8vLsLf//TD3YuXFy8B7HKROEQHZoVa90PItCGi+//8D/7pB994/+tnuW1HiyUOeo0h
gsU8Qs1W6w5eguDWwDYrUYGUNTksz1WCa2vJMm41D3kXSC3ly2Vp2FvyuC11ugsK0bxb+q1knCzI
LPvOWlX6Ku1Yk7e2BZ51bdB0zHcMs0/D0uV65w90UtY/hoBPPv4kfvLZF1fXN7vSJimWcRhpzUEt
BOD4e9/9zvv/1b/4z77TbTeOOcX63vskpPK6DpOljrNdFSsFLQy8knfSqGAJ4tU8ZUnhS8q5RtlK
LwhZXqwlvLhLXSTElZ8WlUIl656VN6dfe2BuzRC0trlOV6tLC5XaulS2/Bz7Axg3O5l04BChWUaM
B4Qg98iQsjiO9IvHv+R/ePz0SQjhEocIYanRqPb6s4USjr73vW8/2mw3rt/38eio8weVJ8BhWJwU
h7AgP4JspJpXBmwIaMEzi5Y8k2VMrBDGkquV/v9GCPK35nnXOqyV46tMvxQGyu+6bVv7rhZatIR5
NZ6MIVpYHJ7zOQVHMhRSY4MIIQa+vbmNXz57eRVCuMK0Y1KzElkIwaoRA4D3zp2enm2IPF/dXPfb
k40/8s7zOGU4DH5Ka6ujfJRIsykE5LXYpYbV17RHLcWzmUpxocVX8iwZIc3XUgBrskfnK0H0EszU
ylbynLXn8LWwQBqnpbQ6j06jeZXaqmQAdX9YbVHiJ3nItii1r9yBSuqXxdsKaS2DY+mibbAGnmkZ
XzHPNOzz9fRaAon3HHJd93EPcp5OTs85xhCcc3F4yjAVeogSDgRuOaglyxRDiPtPP338/Pr6pn9w
/+yYo634zIwQGZAKphpLr+HXDbLWm5VQhe7o1nxL6aSsshwpv6Xca0KM0qAoGQ+9HLiF51oZlgaA
Ja/+3pJXU83w6z4oGYxW/bEcx1clK7C8+KzEKyMDHieJp8e8jj242/A3vvkNd352ukUa26VQwTIM
DKw/7HX3dz/++y+urm/6zjs3LFI8iFedc+DBIIyW2GJaUXDN0woNtCLItGs6kXm+KKokTwus13JI
+UoKu0TyKcFSnvw0ZMmwablbaU3bLu0DWSvD0g2NOOT1fG06K3HOb0lOq7/y95p+WtRmvHJbVgRj
TmFDzpMuDs8i4kxeRx49Ih6+8cDdOzvZeu+7GKNsjKZOW3rKICkC6J88eXL5/NnL/enJqe+cJwIh
v6AVeXjdGYTxESsNGznwfPFSqdM1WZ1fUmo9GDWUzp9WmEBEVQVeO5C1QbNQSg2WyjT5mjX5p43j
GjSi05bCEVkfq5wSipP9YZ01YcPpsqy6DXW5Vqhg8S0hLO1QaiFAzTnU0kw8p7UD8nfeVg1Ewx7M
SEh7SDPRfEsBcgDI83bb0XbrPZGJEKxGHtEBcGgQ2Pg+q9VrD17bbLYbBGbaOqLQ91NFyWN80Do2
SDISkcuPVvLvkvIt5SspiYZoJUVooaV0ulzLkK0ha2AtISmZ1zJIOb02fDXDYMl1F2ShDbkFzUv5
7kIWb20oSvpQyltKV5LROi2qIG1CDBCGSfPl4TwGHI5qZkYfI/eBEUNgPy0dX914ehPGg7LEJwMg
3/nua4/ePSdQ3O/2zvv6OYRZ4Py51Dgt3j//rllxy9IvydkCyUv5ZLmlsiz+OhzKn2sHae23Jasu
r7WsVsSxNm9LeinvUmhoOQZtKJeo1fjpNPJE8Fq6fG2OFA+fYMhPIjJHOTMzgXjf9/Hi8jJyOjve
qmS1QmtXKrIjYu+dZ2bqui28T8dIUVppMaIDAtL72WHYFZbLz7qBuRfUA99S3CVe1qek2gnOVlnW
QC79vgtCKIVT+l5JZsv7LnlkyxBJY6rlk9fXTIxlGWVZmpYQQknWUh5tBLT8S8bfSl9La8ncWg7G
rdQObgJkGzaDEwHAj3/8s5vnL17uQ4g7pDBfJ64OorWnP8dnz59fP3ny5Q0ARPRp59d0yiTgaLAJ
aYckQpo7AAdTAWeMCy/r6Ben9GCTg8fqxJLiWkeJlQZM6ZoV0+pOk7913SwPWHtpySKLlzaulsJq
uUppSv1WagfZb5bRLaXVcsh0+r71t1Qf67FsPhexhERkX+gNSZbCuJqDmP9OY3Z0XswgZjgcGhYH
n9b4uGF8SV2PjLC/5p/+7MOb/S7umXmPhcFv0eqXm66uri7//V//8IvvfuebD7vNkXOOabTA6WQ6
7Pc7hNDD++5gUs9SLtnIFhQsfZdkXbeUvHRNK6+1WUoNcbTCyyUZS/fuwrvEbwlxSGrph5JBkd/X
3C8NstJ3+ad5WHW2DMoS1bzzEurR/ZhRAaDwu5KxFmJopEPOodsc0dtvv7Vhoh5pUVJ+d8CcD7Su
rTYIzrn9J5989vzJl892Z+fvejlIiAhhv8P+9hrkHPxw9JSMe0ow1pr4swag1enWPStNSdGWFLqG
CiwIugZe1lDTUv1aB7Uk65Fki7HR/WzJsdRfOo8F62t10vylLKX+kt6+hLrWtKNEJDVdXL6W22x+
P4+D2hOljFzysW9EBOoICJ7ee//97c3t7R7JGDBWHum2dht2dF2H8/PTzXazObTMkbHf78AccHS0
hZwgIdDsbYYajLVoSWklupgJbQxYi2cJldSg9FdBrciiFSFY/Ky6rJH/rmXrwdqKeJaQWckQlPjo
et/FEFh8auUvoYZxfIrsjKlO5nZ+BhKaMhOYAe87PH324so5t4sxaoQA8ZvVbwDrd0zyALo333h4
stl01Icem00nBj2w3Z6A6HS2F8Ig71hZK+bL95auZ9Kvh+b0cvmw7vwlHqV7+rqUx9odaKk+Mo11
L+cZXxqDrWCzo8QrSMVqBwuyl8rQbSPRnPaYsh+k57dk021Q8oqyLhY6sUJNq/9bwwNZrsyby7cc
ida5GnJhZiAvhiICUc4X07J/YQwkL0+Du3d+eK9BPD7uCZ2L+Ojjj65fXlxeALjFNKmo/0aRdL1b
DQIhTUBuAJwebTdHzoE6cRptVhLfeQB02FEgjIsuUFeOkhcuefBWL1tCD/n7Eg8L5kpZ8qdeJy/L
WvJamiRv6xzMUvpSPeVv7Yn0oLLqJlGhBcP14GxBDbJu1qAuGSSrzjq9ZQjugu5KuqGNackYWGWn
fIAel5aOpM2H5mONeTKkkSI4RP53/+4vv9jv9i+J6AZT2NBMaxHC8e/89m+8/93vfuu17XbTxbin
GKeZfOcVzGGxlFbtiFQaXDlNCZKVBqGV1qxEI/zVZA3ovEzWUjCpzFpZWiCs9uRFqFioWynk0elq
ewdYA7rk9fVAqJ3hKNFAqf7A4ZMB+afrkfPKZcgWStDpW0nX0epbXR8t7yztLP8URlgICEh7lPoh
vX7K4JzDPkZc39zEjz56fLXdbvfh+mY/Y/yPMIfgvHPnv/s7v/XNd954eHLst464I0cbOCKA52vu
nXMA5VVXKb6BuGcdqKIbt2RpR/6oD0ZLeS1+unyZxtoWK9/PnVFTLv2OhKVAVhvI9C1GzzKoGsqW
8tXap+aN5TXLcGmjputovT+iB5MMPSyy7pX2+LwLMsj5SkZLpznw6gYRDbMFlI44nOqRBr6FkBOK
6gGx/drs0S6lYxN3uz1vNht/cXmVC9chQs048CqEwMDma197+8GDB6en2yMPv9mMJzkPMh1aw+GG
7k65ycNBQYYBsJSsNlDHGhpe10pnUe2+5e3lvRbv9FUp7Nq8tbTSs5cGYkvbfRWyyPJqhkV755oB
fBU5LXRQ0kP52zRmxqWMbkpzCInXPM9oMBm4d++e/8H3v/vax5/98gGAY9TXGZkNtHbX5fjhh59e
wDswB0SKlBrffruu5pVKR4bLfBZUrP0VBW+w8DXZl3ivoZLC3kWBZd1L6KMGX3UddZ/o3yW4fhda
M3gtBFLSmbuW0Sqz/v6PZYBKZYynPw/GIy+u2nSOttuN+4M/+I/efuON194gonuYxndzyLDqOPgY
481f/OVfP754ub/pY5rkiNynly4ozsIAqajWSjP9PLx2X9+Tfy3GIJMVz9VoyZOWqDSArMHUatSW
SA/gmuyvWuarGoO1Mmhjp41aDSF8VQPWMrKWgXjVPgTsUErLksdIP7xc6B2hD4xvffsbp2++8doD
IjrHtCfCmHVJhrXrEPZfPHl2se9jdJ6pD4G7riM5uTaeWU8ubeQQI5ArJRuwsCbBgmY6TSYrziqF
IZJf7SmA5l+6xlzfkMSK6TXE1GlaniJYVEur66XTagNeyiPTyrpkKr3evGaAWMZz1CdhgPXbmjUD
aOmI9f0uSE/KYvFZqv9Up3JoNvs9zNOBCN5vwAyE0IMcIyJi03mcnxx377715mnX+eP9fu9xOG9Q
reiSQTiQsvOeiBBvb295e3Tk5CTIDBVwKBbNzGmbB9UhJS9g5S9d058laGlZ97uSpWSWsi51es2o
WNdrypbLrRmgNWW1lHcXqhms0oC3BrIVAun8tQFqtccSsmjVG208mQ/nAtLvsoHSfT69YxGGjY4d
mGPaujC9bJiPgTdFEp+zNNIgLPUoAejee//r909PTrfOeQYRExFZYULeOLHUkSjEd1qJdSMc8BH5
5HfLa+u0LUahBMF1B2llq6EczdNCEyUqlVdKK9vTUnpdnuXdS8a5hKrWhgFW/Ur8LT6Sn6U3FgrS
ZVlySGje4rxa5Bx+Dfqv54Hs16blCU9T+RFuOPNk3wdwiPB+g/2+5y+ePL0GQb7t2Ozx1pz+TM65
o0fvvnN/u+2c944638F3fg6HY8R+nx6BepfvHTaM1ZCt90q0pEBfJSoAbE+95N10en29hoyscmrp
S+XrsjLdpU2KBv8OVDNQugyrfa20NQdjlV/Kb9FdEcLAvVi+5UzydXIOMQSxrgeIMQBMcMT00w8/
vvjwo0+/jJEvkF5wKqIBi7RBoMJ3APDHx8ebb33w3gPmyCE6PhKBXYwRkdO+TeH2Cn3cw3VbOOpA
5A8m4fQKufxZi2lLnkfm0R7ZQh+lMuVvi79eKmzB0BIv65r1eGlJ+aQcJZRhDRB9oKmkkvcrDZBS
ebKc7FWtOQDN0xrUGuXleluDO1/TOxRpvSnVu2RkrAHZggxyWaU3fdNFmVY+6u1FOhKfBLhu+EhH
J2Zn2/mj4ZDlyH/8J3/x5dOnL5/1ff8MQF6c9MoIwTJn5JxzznUUA4O2hL7v0XUezABHhneMwEC3
OULcy4mfiBCUTG4+aEtK2EJLi4MkWZ6ixSjUoKaElDWFLXkqK6woHUdmfVpll0IV3RZ6QJYGaA1p
WPl0Xg27tYGV6bW8etWjvl8buLqNavJr/jpdCxrTf7X0Ok8KsaU+zdvWiTEz3AGRT/MHBMRIePHy
arfb76/7vr9BfYMUU6hVjx0vLi6u/uzP//LnF5dX++2mc/lw1/wkITNz3Qbd9gSbzcbcBTdXSv+V
yGpobYVbqMQj35OftfxWPawlwNZzfKsM6/fSn5XWyqvl1m1nXc+/W0MszauE6PQglacel860kDxL
7VxqD90HltzWp0Vr9VTmqdF8DMzlknydc3DDtuvJAHoQeQAufXcekQhHx0c+hBhhG4NFannKkKWL
AK5/+Ld/9/jZ88vbR4/ePAen9fwhJPgSBrgTI6dsnCHToWKVPKX1W18rDajSqsdap5S8iy6j5M1k
+ZJfyUNZoYZGJzVvVyIrj97lR6fPf9auVFZdpSxZSS0kZRmVEozPddePLa32sfpFv30q0+u66BBN
p6/xsPQkp9NobMmwuHFnMQDI+xqMUiKP4xjjLOxwLjlX7xkhBsClccbM6PuADW3w/te/dnp8fLTt
Q9jc3t6uhtut7pUGKfcffvTxk5/8/YfPHTkmR2Ck13Q3m83ALlks7zrIDRwOGBau34UsS9waQsi0
NYsuV4jVzkKs8b1rWGQpolWWVc5SO1vePBuTNSiuxtvKJ/nlQZQRQ/6T97SMLV69VHZJhlodW1GE
5lUKPUt8NMKRPGOMCCEM83UR+75HiGHY0ZzBkfn09LgDgPOzsw5pQK5SNgshlBgQgLjdbvDmm68f
xcgMisRRTgIOR03RFDcWaShlqQOWqKRsa3jqjrO8cqljazKVDKHlkTRfrRD6uy6vxstKqw2HFR7c
xcBY5a1Np5FHCT3p+7XySm2xVuaW+pSM2GT4aEQEUizLgJZCMTdsiIIwzDcweLff4fNffHkVQrgl
53pY58QtUDYIVg+Tcc+fn50fv/H6w5OEcpJQk0WfnxpUUlwNq9d6Hk2WNW71xhaUteguaKamnNY9
y3uUwqmWcnSYUzqIxjJ2NZhekqMkl8XDguz6njZANVhfk6HmCFrT6teqa1QynNP1yRDkT6sN7FfI
UzrvPDAgBgYD5HB5edX/T//z//b45cXFE4AucId5hDUbpBCA7uHD1843G09JaAciBlw62NVxhB/2
cWBmxApsYv37jhD/gK8Bza34X3rp/HvN04rMxzJwVn1qTw10ekuZtNfR9bc86lL7WPm0R6ulWWor
a9ekmiEs1VOSVU9dP51O9rf8Xeq3/DsPyGxIrQNia8hRD/IpTxQnMVEaQ8gLoOREr5xbYPCwECmE
AMS0KtE5h77vmQF8/svPbz/86LMXAF2GEPYHjddAazdZ9a+//vD04WsPTgAQIwKM4eg2AiKPJk9u
Ya0bpRV25fS6I9dSiyfR6dZA3TUetAbj9TWZ/quQv4QMrIFR4i0HU21wyuu19l9jDEr51tyTZa2l
GoKT37UBqsmT5Mh/VmiYjc980jww8/ACAMh3CP2eLy4vQowRm82mCyGsPWIBQHlSsTiPcHp62nWb
zk0CAzwsUY6Y/hiTFc0Vb+nk2p8mZj6Y7NMKuzYssfLfhWdJ5lJaSwaLX2nAS5mse/lPP1GwPmv1
lXxa2kDLrkOAUnqZr8ZXU+2VbcuQ1ShP4uk6WK+J68en8lqNrLaunUMh271nIDAjAvDdlr726N3j
3/6t77317jtvP/Len2H9uSurM/Bnnz2+evr06XVeO5mM2AS5p0byxQUlS7BPN7wpyB0s/BJ9lTxr
HrE0OPQAaPXCMn0pbw0x6AGvDydpKa8VEZW8rGUMXoWW+Cz1tTUIl/rNMhjT9/kE4lCKKCuF2jUH
FzlvRTi8BzFUIUZGDOA3H76x+W//m//6G2+/+frXjo+PHyLtgbqqIVcf5fb8xYt9KiMSDztAxRDg
HIFFIzEdLieeWb9Yj3k1srDiNuv5uUyXr+l8VpkaDo8VrsDoWcPwfHlzzcvrfPq3haaWvJxOL5fx
6vbS9ZXya166zQ4h7bxeLWtBakavVC9dfymz5pfLszaQLZ0EVkN+JVSm28LSP5kuH2eYbuV+BiBW
JM7zpzkGzgNtOAI+gsC8RwwM5x36ENgD6HvH3/zg6+cnx9t7p6cnDy4vL/3IvHFyca1B6N5//73z
s9OTbVolFQ+eGadXMdMuLnK9tm5Ma8WZRVIhliCUNeC0cZAKo68tGYWSbK1G4y5kGby1+ax7S2my
cZMGqobmLP5rZNaD3DJUOq3V3rI/S2WUri3JaQ1yrT8lI5m+t73JKnVwMgwAcRhHddjtKIQdNtsT
RiBEAhwR7p2f+tPT467f9xb6X+yINQbBe++Ov/H+e6+fnp52RI6dywc35Yaaz8YizgdtacNS63fp
eslKl5TDSifTy++116tboG8LtRrCLFuJlgbaUt5aHbUit8hY69eWNrL6SvNrNRpLBjyn0Xxk3pb+
lkhE6pN+opQ+l+cuJHqx2swRIYQIEOCdR0dHzAxw2IG6DiCPy6vL+Olnj692u92u6zru+37Vo8eS
QbAY+K7bnH/vVz9482gLHwO460DMcR5jpRZIjSUZisaQ27Jbnnrp/YTSUttaY1pylAwB0eGiKs3X
goWZVymdVEAtqw0xl/tRlmsNIgvFaK+v5chp9WNYa+DVwgGZriZ7TS6rn0syWIZE8tJlLxl+jYxK
6bXsc90h0DA/kHxn+sHjk4XyRHG6JpYvw6PruvTukCNmAkK/w+3tNft9h86Dvvzy6f6XX3x5wcBN
n/dXW0GtCIEBdG+9+ebD3/zNX3vbeeccEeclk7lRrK3JgEIjG4W0WHmdrnS/lMaSy1ojoMMKq1wL
yq9BDFZ9S562dM3iVxuA0oPla0vIyGqHJeSwRLX8VshWQkTW9TVhleZV+916b2Ygh0E/5cPwe369
xHumI2ncMBGBvIdzANEGm+2GdjdXMYYeP/q7H1/c3u5vnXPXSAe1WGc7FhtoVcjw1ltv3nvrrTfP
Y+8ieSYeDpfNCtZ13fioJm+tBhzGwUCCP/meTNMC1/O1kvfSiivLkaQVz1II6S1lGssAtAwQ3RZr
YtgaHZYt9eAQCUiqnXEheR8ah+zlRk4FGUyug1y5Tepe2PquKck2fxyaFs+VDc8S37V9qvkmiskQ
kG3QLEeT21e2fUiLkYgo90VkIsLR0TFud9e4unrBT774ckdEfQhBooMmYwCs3GT14vLy9vLiYrfb
9+GI0NHwtlWGq9bW6hb0TTWavt/VUutJL01LfLS3lPLqAVQ7sMSCviVa8vw15S95SIvyQR46rYUQ
aspcCxlehQ7LPAyzSm9rWt+lnrXKvLRztvXdkr+WF8P8AQhIKxJJ/C3lV0bSDe8vAPDOIYQUrt/e
3nBkz6cn9/Hg3vnm6Oi4u7y6AVbMHWRas3R5//HHn3z+v/+bP/noO7/y3htH5IczGcLYeZFdWn+Q
BzyXvXReuFSD2rXYLVPpldaxnAZjsRQq6LJK8b00Ii3eXs8paGRjeZpDHtbLQPN651sTX7kxLgAx
+51UVfST02goPyqzvH95t2tNxC7j53Tup5sewxEPhitLkjYNHWVgKZ9gneo9lZnrOsrPbjiFHIjM
CBygvfC8nlN7SfSTkh3OVQwlz68RAKZh3oBmbSfbUyPR3BZjnZnhyQ1rE5HWCHtPjgPHPrCLEf7o
Hh699/7RduO3IYT8tuMqWrNSsb+9vX36R3/0f/7s6ur2lijNeObXMZnT2oKYf8fygJBGwvqur5Xy
txiMnE5vlFHz1FqOnEc/xy/JII1GaTJL57UWYXnv4b2fhSsl2TTNV8+VPaxGJ0Q4aCstv3xFuaXt
7TRxGGh5Lw8pV0Q6rozh3KE8pXZY6o+prGn/kBY0qnWmBdHO/hxAjoY6FZvL4GmOE2aAmRmOAec8
nZyeuvN79713nr7x3tePz05PjgEcoQZDCrRmG/YA4OrvfvyTzz/+cnCWhwAAIABJREFU5LPLhw9O
zx0YsQ+Iblpvna05I73ctFTpUjydry2R9MrAcmdlspCDNQ+h71uy6jz1CcZDL+rG4/DmSiD5ZwUp
yaRpzsNum+m3nASj+e+CISmXtXw93ZOLdACQPMMxzgcOHx57XyOpE/OwQMx5EM9QR+lT69f0uRwe
jggAOVxoI4k2pE7Nlovz8CYRA94fE9AD3uH83mn3zttvnP3oJx8eYdoP4VAZCrR2YVJPRP30zHBo
NKRJQqKh+gQ4OMQZtJtju1EPRIWtwVgafJJqhiVvbZ2g9RSDWVRFHCPuHlpUwblDRRGJxok9ee2w
3Em2yRNJvmPewXbMwpOcVxY5KKO8LtNO0HuA5AMUzivqBqnHzOP/OS2dzZNko4y6boNtIZqCkElM
NyYxMsz4SoNmGbpck1m/DPXJIUKq5qGHlyWk/KIWY5cbyGPgTY5mfBgMjtLQEZyYO6hPbmt9meqa
zltIjUmDqlAcJmMd4GkDjpG2m44ePrx/hOnUpnkjHn6f0drj4Lt75+dHp6fHR947xD4oOAs4P+zv
xhEUD2fV04hJdda7GMvGkda5tmGGpJx3gvbpb1IkP8vb4m1G3jEMX5CWaNNU58Qv3bT4ywlX2Rc5
zdQ+QwEDzZfeYoytLRTEeQKRhWeS7TN4FcwGg0QOPPzHYAyHjhIBrDb3dKJ8FpyIxkE+UcTB6FLo
aZq7SKhgPuiz34ljWx/MZ8CBWTqYcbX/YIiyAUynG2W+RIDDgBIomz6aDf7siVNbZP5J2qldkdDG
KDKDyA08h3LcNMzSCc484zXVeToZPRtpJ/rQkVz+TIjZGQ21gwd4zyQmk6towKLWcxky4+6b3/rm
66+//mATQp/CA5pvjukoKweNnZLaSXjYAyh3ODjyAAohjI10GO9O9dUQMaWfLHUL9G2eOU4XirK0
UM2oye/z+yEVmz30+v42adiqzzybUyu7ngQbccMA9cskB8EwcMf+mXvuuqFW6EnF5aOazYzKHJ/Y
RlwM4MHgD8F6uu4mflrvcjuMbcaZ+YTAMjlHiFE7AoWTDL2Wzo6mQkCOBrsV4N2GnPf48svnt3iF
TVZLWqWvOwDbd999+7536JwHmK2XOyI4EpjssxcglQ1zJdQDQKMDmS8PfokodCPLdq41urym+ZTS
s0i/Bm3UwqGSXNN1HRod5msxTIdtcdjWMu08vX4pZ40x1AvWpBGwF7VZPGahEjBuPqrnkib+2iBM
KHoelmQjWK6/1edaxxNGmcajhW41Ep6QthuOZ5uj5PT24/QqNnMqgSitfSTvEPY9v3x50f/88y+u
0pYIYbJW888irZpDcM51iNEfn556ZgfngND3IKJhu3WXKuIG2CQnp4ZZaca8IaYGi6NSWGvB5ay2
fL6u3y60Dky1YGj2DpNyJwM35uUMPEVrSsVw0/eUb26AkvLn11RpQJCM9LRtMoYTD8PoZV2mOIbW
I1rnkKDi6Cn9jBc5+Zgry4NxGW2uN1E6EzAb0KxDk+Kz4uFnbZ2aP7eSm8kI6KPJJqOl35OY9+sc
JVlGRw9+2e55UlLr2CRbdiYTr2mfwxw+DdubZ8mp9Ph6Cl/SI85cz7HzBr0VIcjwlxjEYaykoMUN
bcFDyJCcrtxoaGhnpKNNUloQseMIxvNnL/bPn7+82W634ebmdmr0RjjZ+pSBAFCMMV5eXe9vrm/7
s5N7GxzsM8fDpEo8nNqkPLzmnnEKB+bFHhqMiay38PSAmhDCIcqweGa+k5VPXotEnpl1n+XMr6dm
2R3SI7VBYfK+ciPfQ4NY8/CTwmUlmzzeVMf8zH5qa9PRUpJXek8ZvlnvLxx+z14tFZi3C59Qw2Hb
ao/qnBtXs3rv1Tbsh4ayLZyYjKYNxzVqnMt3aLtkv8hHrCzuzeXN5U+DN8udDUIcB3hq+7khH8cI
oJybNLRSxGFdAgNMxNc3twGguOk2qzdYBVZOKnrv/bNnz/rrm9s90b2TXAkAQ6w/zLpSOoE2z+pm
a5ytqbbu6T7BuXymQ24EGvPL35Kyp5FIIX+fT1pOTxtG48XyJanUgTlPXvmp5zQGQTBDPzSXLZXj
Jo9ADIwDcF7vKf0hVHeUF+FoWbMyi7Ykns2yQy0FlvLF2Is2SAhH9su8LnrX33kfZGgrPa6sg3QY
cp5H11fezwOpPp9ikzw6LqGOMLXdYDhJtJs0stlTC6kwdblsh4wYcpnAYb8OW6MzibZmIEZwCGkS
mAghAN67Ye7NAWIhlT4Gb2qbnITzj3RWUmRcXt/2kXlPRGGxsQxaYxC6R48ePfz93/+9d8/PTjbM
0+KX2RxAVhi2d/3NeyVYsTqRg3M8bls1NcKUH5gvVNFvF0ply+hDHlmvLfakiICEtHIgHQzWdEPI
FYTiEJzbIA+2bDzGuorn7aWYfeSDZFhjzIZSG31S9cqTjdM9qx11nfLErSx7HjIIZMQy3KExPzPD
+w0s0mGBnryUz9eTzkxhQjZC1hOpUllSr3Jok64FyHNGs6FIOgQQHZ4yNsku2zAZ6PT0gOF9CpVz
uWnicEJ0CTEOB6+AEWOfDlbZpFeWp7AEAKZXAXS/pXYatjsfFHloR2Li2DPhw48fX8bIe+/9Hq+w
DfsSMYDurTffeOMHv/m9d+6dHW9Tn6WlyjH2AMW0gwsBfrMZ4YzseAvaZ8oDJMPPmZEpeIYxjfgu
If6UN6LvJ2UYIXhMKCDJOuTlZGn1MmVGQAgxLc32Ho6mNR8kZt5jTGmJAAePyPvhII2hnqNDSou6
mKa6yzIBIA5La6eFOt3YVhI1AICjzWjY0q6+UzyevXhuk/l4mrwXUZfHomjj6cQgHt5uzV6X0KHr
PPb7SxABHpTaLve1k4Z/miOKMcA5PzdMJI2qh3y8ph2HxM+Z76hPjhBDhAPGVbRZr2IkcCSEIb3j
5JX3HNAJ3yV1VBqpmPUle3MMaAEe3tMwGRgRwl7oO2Z9xUhnokYOcO4Y5DZj/RJ/8XCAYwIBzgPk
gPwEjcHMAQ7pCThzROgjOjD/5Mc/e7nv+8vLy6uriZE5f2AOqiWDIBl2t7vd9tGjd869dx7DXEFu
oDQD6sYYCIRx+XKCtPPGnsPfeVyfB0jf9zNvCkx7zk185/WyeE4ztslLhJCf2WuMGxDG5/mTEXOO
xkGd0QB5N8JI57tRLqIUbiTZ5rFwCiHCfPAP92Xok+Pr0PeqPhK1zNswsnos6yZlJpo7ihyiAWkS
TC5tlpOluSyJsAgOTIMCc4CHx9nZvdT/8TCsk2gthMkbH9Cwpf8MXo88pjmmQ8NGB9e8c+h3t8lQ
uG7kJZeBZ+TRh93A383ewD1ErxOSkeeV5jkPjjQYJiCEqHR6fFwIcoSjk9Ox70Pfj3LF0Kf5tyFv
DGlMefJpLUiSiWPMC844bXQOgncOL1++jD/76NMrALf7vs8nP2uqxl2rnjJsus553zlmRCJyMUbk
dWDeewxT6OMgdOP3vBLuUBZpIOaNPLfSVjwp0YG+N4/9HbrOoe/36aTcYTC5GUQcJkSzZ4ITXmA+
yQnk8Cfx6oMcuABoWNyjHnNN8NSG8sw8wu8se742wdq8MpFBMc9RABBPL2QasBtCnKmNvNskrxKB
ySPlJ0WpDWLMnlE9vYADwSOfJRBCGFbmdWCeHwUgB7Fz3TDoJ3QzpzSpFzkObS90IBs7GvAYAzQg
H5BL+wTk/mGAERFDjxgjtsfbItpkDujDDTbdEbzfjE/Asj5M0N1jCmUwDPwJxY6oTEwWaseXjXPg
AEce5ByY++F5AWbOYTS+zoHg4DyNTiLdplTLzJcciNxQDNPx0dHm8vJq9TFuQPvbUAyg/+UXXzz/
+JN/eOFcmu4a907MzxSIErQZGzS/TYbBuqVTomlkyeMquExZYRKs1M9hJ2hYm2CKLM/BC3AO6Pc7
XF1dIvT9JFNudOdGCDuMutHQjJ+DN8Lw2AfjmgBO/+U4nwnO530mpazpL4csE9QfisTQRmI/iQkN
pbwx8vjKq94hiWNIqymHNnbk4JDe7nPijM3s0USLD4+waEidqjQ+JhXGF8A46UtIK1K97zAukE5v
8QxtSuPjNRrkI8rzTt7ovxx+0aBK6klTrl+cdIgw6VT+IwAcArwjdN00uSznrjLtdrcI+z3y3I61
/bkkuX9opoOBf/CiFkbPz8OEYgwBHBk0hGIhBOx3u3R96GeQQ9dt4Ds/9t9UZhyGzzA5iYTWTo6P
/e/+9q8/PDs7fQ3AMe5gENLigUnTs7Zn1+CRUMQGwHHfhwfvvff1X/n93/nNr3lil73TqPy+E42W
vcBkcbPw6RGZ8KgA5AwvkVxPME0w5U6R0C83fp4/wFCJCTkQOPaIcYcYeYR7qfMGaw4ejMIGeZ4h
xnTCboLGwwBzHkTpWG4Qhphxin3HwgfK6GRCGjxA9MkopGfX+c07iFnx+XoK7z0c+cmL5YGQWylO
m+MQYXjVN89wxOExJI335YPTyZUkD0vDo1NHDmJpxij/GMb5oT2cg/OTAUwMeTAQJFp5LsN8K7zD
R68S6cT/r70va5LkOM50j4jMrLOrqu+e6TmBGRIgKK5MEKGLkC33YU1mK9Of1IMe9S7bi1rq4IIL
cgAQmAMz0z3Tc/RZfdSVGRGuh4jIjIzOquoeYtdk2Pa2tMzOyorT/fMjPLKIALRnbYKDDwuy+ThY
wLS/jsR4lM+D62UeR1IZMCDgUQwoIlNPbsEVVloB7oWbWB4TfxVIlXgZiACUtENiwREIODPgyUpz
R0DAcqWUg6GVGfM7SIVFYeZXApLd50AIzUaN/9O/Ptg96p9sSykPAGAMABkASCjeoOQE0x05XcZl
kGmann722ec7B4d/PVpf6zRJKkQsfDMqmfdOo5w3kX3zyI2Ze6TkF+cWQaHhpqF36DZou1LhzF/S
HOKYlxNiAtT1lzzNRqgyg5bq0zK3gNzKgSmnvJXZPxthMUFHq9+AvICfy1Dzx8qdzfg6c1TZBCMv
DgPWx0S7vMaLMXG+a85MUpk4B7hwdQHa5y2w8ngTFT9TjmSANB//3MBigCDs+wbceJXfZOR2/5Xa
OMXqQ86BA4BGmYOCn6hG58pxeq5QCi4W5NjEgIiG0XgErbhmLMeStgeP5/J4XuXc5IrnnBtUjJ97
XikFmY0NACPg5wSccovNfNt8lmUZII9AG/PBgDUBAFj+JvM+ks0b12uL3XZLiKk/1ELBuUSX3f48
fv3mzdFgNMoIegBoNJlSCoQwRRVLg2UUDf1op3mKAFm5zf5A5wLhTVg+WbowF93n+a/tMDtJ1hx0
qwF+uxyFwUpuNQtjzAit95zRsAqAFOQbY3JAM0tDYWzEHwMf3M6/dMVvUyEkMnd1TB+UUqU3cjmd
xpx7BvZHQD13w9UtGAetNAibEKSBPM3HAKgAYUJVAoTyOxAK8DDjl4HJ7jPWlJ/5Ccyty7uy5r/R
OR8HMtF5RA7ENLASs5QF0y0tIpjIPIHj0cIidXEZJWUOBEZLF3wW5rKU3JfAjcpdWpfros8DiyuD
MQYRw5JkYcE84AK9SuO5AK+vKIEQQCMhotFtZLZDa0RMswyU0iCEACllpeBPoxAQps1Ori6UDcPb
MJQGQCTSqJTKdwECgDW3Zc7eDHnJdC62v+aiZgenMLGN3xe6E5BrZsaYNaM92PMYHwGBtEFbcsuj
DF3jrcaFwlcGT1i1szCsIFOxFOb7iQgYCMh55gGvXJeP7tpP5OdcmDIcQ2rnH9oRL8Uj0Kx8cOfC
5MBjYg7KCnUxc+Y7RAAaDJBp0IAcQUBihgS9Nwmh06LFurhLT/e1V77SwpjdjWcsFG1N51xQtXVd
LBjkbkfVfpcguIdkAtTG7GGgtLTz5wTJs5a4BWc3/wSlVRJXrNYaAI0fr5QEwQWQzStwysxvj5sX
R0YHFS4xYyZmQ6RBkvK+C/bVZ8ZxQyGAAyv4NR9LbtxAsLajVkDarGC5RrPcfVJAykoMISCan1pm
RKAmI318fDrW5sdeK92CWTTNQqjyigUA1JeXlzqddismpY19bCNqUpmuuQk2uQm+tjPoVwiGZzXk
8QZjSgoR5cjq0loL7e2sD2f22ybmbkrZ3XDBSfOd8r4H807IAuFDIQYAQLtPgRvV632nACrzXWfC
mvhJ6Gf6wxlqxVBJ5u1DFxk33yu5CIiei1a8qtuVl4OzAxEqrCOlAYgxUGDA0qwiG7+NuSCp+wus
GM8VN6NNdK79xRyoYuUCzVu0ygBYTkzK+2X7nlubwbwwp4HtGzfQt+dNqAHMUmu5bWE9otaCOq8D
4wKQiXysyq6pA8Ny/MHtASnxCho3UwiR85TVEBY8MWdTv+/FfRvxIWeRljKQTHDSusNEQGT4j0iT
22mO+/uH6e7ewRkgplLKS2cr+oCAwdknrNVqtWazufo3/+Wv7icR51pJjYiIpBDcPm0y5hKBjYJD
sbYOnlnqI7WrEJm/jFNG43CzkxO+MJZAQIFroYFAgZQEyGyCTW4UmIE97zMXVI6HuK3HhVYoTEEb
NSe7pAn6XJt9IffLD+sNf9Rm2ueufjQdL7k74VEEKZ37xQtnAhEsrJvxw8LKknbjWklwSxaPGWMd
5B/4fc433OXLcu6FvOFafmGmm9UU5QlLsQRo+usCqwDAy6a99tuA2rgOlsIsVsYSEJEN5AZKNOTB
IpWdgcuoZTYQbXJbVKnf+apYoByYDSbmgOGNV/4UFRehokJEZMiIAFBZLWqgnBCQwWA4VJlUChFc
ltO5UmfRhYKKcRxzxljr/fffu/Mnn/zRjSgWgvKMQm2BlUxaks3mYghAWPhfzFMtLgUzHwzr97pn
/cCaS3fmnJ9jEv+Zkn/lRsBqL5dIY17FVag3Z+6f18ihyeglJIVvCUIHNMY8JzDuRpXwu+fDAGgV
TYs5nANB8t0u71mvLAfAOfDZdNnzlgrafhYA4I+N34ZSxqcFTWcxFOWZzzQRcHT+Oxh3RZetGr8N
oRuBHiAAIqBw6b42L8JTNLlpj9KC4Hngyf8nZ3EyUEpW5vmey1i1Lo/vQpj6i6Xgc8lzpTiHczXK
fXbADWRXFJQDC+3nIIDbRKbdko1zp6wp0Ww0eKtZj0bjSbH+fwm60AtS2u12nCTJ0p/+9ON766u9
JjAGmjITZQbDEgCAxhp0WgjAJY2A9WXJYzCGCgiE2QmICJgH4lgudCbjj1lt4kzAYq+DENbMY6zQ
GlCgtFtqYqgBUFvT0yR6KK3zfAX3PcOkImd2H1yM4Wu+kzOsFRRFmWXu6VZO8QtXPDdjtVbAeGT6
5n7ZlzFgVKxAlPc7MOA8gmJzkgkNKABA54Ixq/Ft36LI7C9ANBmHzoQvC7jTbg44uPFTwcRxSqBl
/WPSGrS3CmOhHpxSIgLgTJjgplJAzPCAEJEZdyU9a6Fs7REV7WfM+NvIOSCz94ADszkQyqYLG3Cw
bzZCACAOiLz0sl9/Pq1GKF7zhyz37NH+b1wkZgPX5ZiSGSfK58LNr8lSLJ5T2vChsnEvjmVLTitZ
uCHMpFW7elw6NSkyPMFMWjQwhsgYCHBhBwSNRIQAC52FKEkSgcj8ty5TcJ5KcwEhSRIGAKxerzXu
3r21EgnkoAmUQiKOgEQEGlEwDsCt84rm5VTA0AqQRXLG8gHTjAAwA4QIIp7kKZtOEI3fz+ykW6S1
ATTOtM3SUnZizpvnbtANQJkoNSFBJlNgxMDteis0C4HLSDQBuEIYtNaAjIEmY6Fq0iaJh5l+upUW
X+G6QFYRRNOgSQKoQrsaQUjB7b1nYF6OIe133TJZoZEZ+KsYpVWR2AafSj5ukSrsLAStzZJk6NI4
qnJpStraM1+Lbc/lWEceDCUqAnpWseZpz+YNvOi2vvumvDsXgGU1OXBAjoDA8/FgqEHlgGSCopyx
PIfEtdctzZklcuPiheneYJdmlTbzyxg3dg8V2rlQFpS7Si55LMyN8fdSCCFyHjFAaGMSnuJBsi91
Q2Y2TLl5YAAIDAQKUEzZsYU8FcXwMgOGAI16jUeR4MysvV7KOgC4oMswGo204DzbPzgYSaW02bpJ
mKYKlBxjOjlFmY5AqxS1JIyiBBqNFoikAbV6A6MoBuIMjXY2UWqlORANgWQKUiEhZ7k7wBhDlbur
RnsqINAyBaUVpJOJ+Ql6ziCKapDENdCkifMI/UBhbvYCWPRWRJpAEpHJDNOoSQFnHLgQwEUEgjOT
BmzWdfKytBVGBgzS8Rg4RxBxAgqweNmFjWFIKclpEeOHO82DSGByDRgTZoVESUIk0EqSYTJFaNAP
JDOMAcBQawQweqBkvjohde/tK2I2ULRdey/hQCwlZ7mzHy8xFhn6TE2O8UwwGIDbKFvZXTMXBABa
ERFNAFCTljLP79dExJAh2RAAIiLnRumVXUK3vm7axLldqyMGyJj1MxGUJFBSkbE6FEmVAecCmP2J
IyYEMGRo9q9orMo2VNpukCKkyWQMpIiIjDUDAMAQkQkDsEJwdFaDG0vOY9v/LFBG+Y5b8jftZZm0
/XFui7eEzszPGwgugKSkLEthkk50lqYEwICLGJNaglEc2wAvgdJk1qg1kJKKLM9fGgwALgYIBADq
5PT0+Isvf7f1809/er9RY8lk1Mdn3z5Knz9/nu0f7uvxeKz2+5Ps5GyiugttcfvWZv3HP/qgcePm
ZrLQ7kBSb0KtVmMIDLgQkA734fnW1/rgYI96vTVsdzdoodPFWpJgFEfoBnSUpjA6PoW3u3v08tVr
/WZvT56eDrMskzqOY+x0umx1dUUsLLTZtfU1trSyyOOIA2OI3IEkAQwGY7335q3eeflK7x/21Zu3
+6nUWrdbLd5sNjBJEkzqdVxfWxHra8u81a6zSAjkjKPWEiAya/cnZ2f65YttdTYY0Pq1a6zTW0TG
I0RAjDiCUkPaffNKPn/xahgnDbp5Y7Pebi8IBoCMM0RGoFQGnGsaDEb6+PBEHR0dycPjvppMJkoI
DkmSYKvVYu2FNu+026LdavMkjhmPOGNcoNbWp2QMUBOpTIHORjSepGQCy0hKK4ijCLhgIHiEtVoN
gQHLJEGMGZpgG4KIBEiFwBFgPBlSNpE6jusASKjAYD/JjMbDMw2kqdbsMM4FKNKotcR8pyEgKMlI
64yINB0dHqtXL7bTg6P+5Gw4TJXWulZL+NLiYr3ZbIhmsw2NZpM3agkzgU3CWAgGSKAmQ9jbf6XG
WUq97jVsNBd4EscICMg5Z+YHkDWNRye6f9hXO69eyzdv9+XZYCizLAMRcazV6qzZbPBer8fX1pZ5
p93g9UaNIWpGlIEQHDgwJAI6Ozqhp1sv0mdPX2QHh0dqPElVppTWWkOSxLi+uhLdvH0jXl7u8ZXF
Lm+2mi4iApokIGiQmYT+0SEcHh6CEEhLyyuAjJFR1IhEGfWP9uH1zgtNxPXq6hrr9tosihtgwRcZ
F4AAkI7PaOfljvrqd1+Nv3m8NXqxsz8+OR1ljDFaWuyIH//ofvOnH/+4dW1jI0riOkRxHRljSFpT
//gsG48nEyI9bXPT7w0IIKVUWuuj3/72ywd/+3d/v9Jps/Xtp4/1Z799vN8/Ho3STMlMKsoyqYgI
EVEIweutZrO5ubnR/oOPftD+5OM/WLi5uZowGLPtFy+yX3/+1eDLr58N+ifjrNvp8g8+uF/bvLZR
63Y7otVoMMEYY5zhy5c76nffPB492349ODjsj49PB8PJeJIqrTOGiPV6jS8vLzfW11brN25ca9x7
/3bj5o2N2trKkkgizjRpOD4+pqdPt7KH33w7fPhkq7/18vVR//jkWGvKojiCRr0uWq1W3G43a+tr
q817799auP/+ndb62krSWWiKJOZsMpnAt0+fTX71q9/sP/jyYT9TWv7sz3+6+Jef/tlSr1uL63GE
k+Ehe7HzRP33X/z61X/9x4dPlWbD+/fudv7Tf/xk88cf3FtMYiGiWp2NRkP96PHz9Om3W/2nz1/t
7e4d9U/OBsdK6XEkhI6iiDebzfrGxkr33nu3V394/+bq5rXlRrvVjdoLTYFMMQYAaSbp7Zs9/XL7
tXyzv3e6u3t0PBylwyyVGSDTtVoSra8vtVZXVlora4u19bXF2tr6Sn2cchaLBkdkMJ6MKR0PaXB2
Sg+/eaCTWiLXNm7JRm2BJfU6TtIR7Ww/yl5sPZoQKGq1l/li7zo1mguiUW9zziMkIEgnE8yyPp2c
HOHOq73sf//68fYv//m3j/onp7vjSXastFJRFMXX1teWVlaWl3vddnNjY637w3t3l1ZWlmpxFDHO
gO3tvVUvnj1UB/29yclQDTfWbyUfffRht9ttxc1GzBlD3Ns/yH79+RfHr1/tTXZ3j4Y7r/ZPD49P
j8fjdCilzACRxVGUNJuNRrfTad/Y3Oh+8MHd7vt3b7TWVpbjZrPJ40jwbDyGJ0+eyf/2i385+D8P
vt5/u3d4nGZyrLXOnLXDGItarWbj1s3r3fv37y788P07zZub67W11ZWoVo9RSonDwQnuvt2Dly/f
pl989eTsdDhIb9/ajD79i0+aG+tLsZwM8LS/j9vbz+U//ONvjrZ3joa9Xo/96MP36j/56H5judeO
kgRRyRT7R0f68y++Gf7yX7/ub+8cnozGciClGhJRSkQEBOwf/sfntfdu/3Lx0599vPyHP/mwvbqy
EMdxDTnn+p9/9flRlqkTABiAWzwqFDtUXJcIAayqKO9hEPaIwfwCTAMAFgDgmhDiVhSJVSKqKaWU
UlppY8/65UT2SACgzjlr1mv15traUjuJuHi7dzAZDCcDpdRQSpUREXHOYiGiOI6iOIqEYMwYfVmW
ydF4PFRKDZTSQyIaA0AKJpZGtj7BOa8JIRq9Xreztrra3Vhfa3Y7CwlpCTuvXo2eb708OuwfH0wm
k0MiONJanwLABEyOt2t/LARvJEnS6XW7S9evbSyvri61k1jE/cOj8eOnW7v7B0dvMqn2tVKTOInb
d+/c3vyLP/nD26vLnUWthvjl14/e/M9/+vLB6enooda6zxi9imHtAAAJ+klEQVSrrSz3bn/yxz/5
aPP6yvpwNFYvd96ePHy09WJv/3BrMknfKKUOAeDM6xcCQMI5X1hYaK/fvHH9zg9+cPfux//hw5ud
dtwDmAgtM+wfnU0e/G779We/+ebJ7t7hy8kk3c+kPEPEFACIIca1eq29ef36xnt3b97+y599fO8n
P7q1zjm11lfX+NnpGXvy7fPR429f7b99u38Sx5wtrixjq92BO5urS+PhUW37xdP+//qXL598/Xjn
pVQ02Vhdad68sbm4eX1tcWW52asnLCHIRJqO6Ow0Gz/b2j344puXTx8+2vpqNJ48BYA9y5wu5N/g
nDcZY20heLfX6633ep3FREStyWQMw9EoHY3H4+FwdDZJs3ESJ40ffnDv5p1b1zfqNdEYnJ2ore1X
/a3tN2/HqTycTNK+lOpEaz3SWo9sPY4H6wDQEpz36vX66sbG2rX3795Zu7ax1iFN7NnWs8HDx88O
Dw/7u2mW7Smlji1P6KCcGmOsJTjvtNqtpeWlpe7G2vJCu91KarUkAg248/rN6NtnWydH/eNTKWXK
ORM3Nq93P/3zP1q9c2Ot1T8eqF/88rP9L795sptl8gQAtBC81mo2mr1uq9lqJrFSEo5PhpOj/uA0
zeSJ1nqglB5BsRfBCTgHgJoQotHptNtrK4utZrMRaa0n/ePT18fHgy/2Dw4eAMAuAJwCwMj2K7M8
Jr0+lvY1VAECg2JDUwRm11TNA4UOALQBoGkBwx2RByZuY5QDmMg7OCJT1qRJvQYhnN9sRbbxqdeh
zAqNv87qno9sW+oAkDDGIhuwGVumPLEDdAblTR9uQFwbHAg2GGMNAIgZY6nWuo+Ifcs4yta3wBhb
qtVqXaUUZll2qLV+YSdjZPvT5pyvCCE6WinMpBwAwJE9Tr22uAly/RF2nLsAsNpo1Dd6ve6K4KyZ
pqk6Pjnrj8eTfa31GzCCdwplsHR9aQHA+mKve/+v/vPP/+yjH1z7ME1T9eCrh3ufff7w2eHR2etM
ZgdEkAIANJuNxsb6ak+rNH6ze3BwdjZ8QZp2pVJj26YG57wTR9GCiESLiAQRKaX0OEvTY6X1WwB4
CwCHdt5ce9z45hvm7FzVbTuZEIKk2cvvTN4YABbiOO7FcdTIsoyklAOl9Ikd31BBgMd3jjeblmcX
GWOLnPOW1jomohQAzrTWx5YnHG/5ZbhyXFsbdjybiNhgjMWWx6RVVq6/HACanPOFRqPe1JpgOBye
EJGbb/DKtnKBaMtJoRBcx5/aO/s84g5lyz20vLcHht8H9v7Elul4fi4gOFCoshDcYDSDw4FFYp8V
XhmuPAgaDl4Dwl1XvonjGqu8Iwv+9zvkKKxL2wFwA+KOLCjPByZHrj/oPe8OB0a+RQR28H3GyK0Y
KFw0V69j5Km7z6DM3G6sXV0TW9cICnANk1HcHNcAoAcAa3EcrRNRDRHPGGOH4/FkHwCGdpx8hSBs
uQNbh9OaDuT9OXfg7YA+FFJH6J19qzRUBI5cXa5Njm/C+XflsqBcXyE5Po69+nyhc+W4w5cF3+qN
vesIzm8iCi1l93MHjtcoeC7se8gL4T1fNnyFOQIDbKdg5mwAZl4dPzreDQEhX9C4yBuT/Eb5AprZ
jmZeRxwyhuhVVWYICjq4VlCuT1acQ5Sb1mbpHVlwdnVUTULY5lB4Q+ELJywU8GkTHH7mkxvrMZiJ
dsxTBag+UUUZQwDYS9PskS3HMVP4/j0fzAHK4+soBHv3XFUffPIBwblHGHyOwbWvsFzfQ74Kyw5B
wT+cFVtVVqgcq0ChZPF6R2hpczgPeH77/LP/2TQKeczxdAqFIvKVXJWyrZKTnETFgIQV+wzuo5IT
qhAMfMSb16EQDELk9wHAr9ff2z1NmGe12x1+fdOEt2o85g3wRYR9GlDMo6r89It8z2lwCUaTzKoX
oQwQ09oxi3lntcPVATOu551DmgUioYD6wjitDP95HxD8s+8eh8Lv1xWCQtiGKmCY1VdfQTlL0ym4
ae89AJjNJwRQmLA+KFQxvCvcVZZBGWF9MLiIZRCaKyEIhK5CFRiooIx5bQ/Lq/ShqgYpKDusp+q5
afem/T/t3rvQRcHhXT6vmtN3JR8YqgBpWp3zQCjkP58nQ/N8FiiFVoJvKVSBwTRA8M8hQIXHNMu6
Cgx9UHBuWggKVe7oLMV3btmxSgBCgXJg4NBVQeFHhpbBNBM5LLMKDEIhljBdqGdp7GkWyDyTu2o8
qs6znp1V3jT6roDh/wZ9l23zFdC0eqrAYlo5Vfd9SycUtiql5ZdXZV1MO6oskCpLIbQaMLjnWwqz
2uyPi68s/WDkvFhb5biK4IEwqFEFBr4fNw0MZpnbF7EMpmn1qmfmgUFYt38dPjuNvithf5dnv680
awxmgcVFyvEFJhSu8N6s+kNLYZbg+8+Fgh4CwSwLocpSCGMoYXzHWe9VAfMqt3qqC1FlIYSHr6Fd
w11DJJSthXllzXMXLnvPF3KYcp4HFpUDU9GXy9CVwP9+9K7jN00h+Z+F19PKcNfucDGTKgGedT1L
8C8KCFXl+5ZCuOLguw/zQKFEfgzBH4xQcGXFZ2HcwKdpWtkvN7RAqgKMVQAyrVy/H1Bxr+q5K0H/
ftG0+Qldj4tYJ/7/zvUIBXTe/7OChxcNMM77ji8PLtDvLy+G1vS0FTkAOL/KUKXNw6Uhv/LQfKkq
Y5aVUHVdda4CgIuAwazrWfeu6PtF09yKiz7ry0gIDqErEsYBwqDmPEGf5SpUWSiOQtfeX1p31kGV
NV26DmMI7uwHYvzPfZCoMl385y4CCrOsiHnmfthmn+b9P+3eFf3/QxeZ/2lBzRAg3HlaMNC/NytG
MOuY5Vb4cuHn6YQWwjS5yqkqMakKGNz/BAUYTHMV/GdnCfRFjqoyw3vT2j/v3hVd0TxyfBMqPAw+
u+h5Fmhc5LMqa8Kn0M0Pg/BTgcD1LcxD8B+sAgOC8+gEFc+F33mXzwDK7ZnnGlTRFRBc0XdBofDP
shrmAUV476LX0yyMsA1hzG1evk2pL2GhVY2o8nuqOjpNe09rwEWfm3Ud0hUAXNH/C5oWfwg/C5+b
Z0VM+2yW5eDTNLf8IgFFApj9PgT3cBhACRGw6jvzhPmymv/KEriif090ERm4zPengcg89yN8fppr
7lsHM9tYVeisiqc979NFNfsVAFzR940uajnMuv8u4OBomtU9L/6WX7+LeVP1rE/zhHtqQGNGmRf5
/Iqu6N8TzZKRec9cFiRCumg8LryeWfFF/p9F34WvfwUCV/R9oMvIzbuARBW9kyvOwxtTKrpMh0K6
rFBfgcAVfd/psvL0LvI3LxBfKWcXRaNpFC5VvgtdAcAVXdF3Y0WEdGn3/Pfxcy5LV4J/RVd0Ofqu
ZM/RXBl8lwovE1C8oiu6ou+WLiuzVzJ5RVd0Re9G/wbLUUwca+edAAAAAABJRU5ErkJgggo=
    }]

    ttk::style element create PhotoFrameElement image $img \
	-sticky nsew -border {80 40 80 100} -padding {25 20 27 35}

    ttk::style layout PhotoFrame {
	PhotoFrameElement -sticky nsew
	    -children {Label.label -sticky nsew}
    }
}

package provide photoframe 1.0
