#!/usr/bin/tclsh
#
# This code is in the public domain.
# Originally written by Brad Lanam 2014-08-23

package require Tk 8.5-

source ./scrolldata.tcl

variable vars

proc configureLine { w r didx } {
  variable vars

  # Quick and dirty method to differentiate heading from data.
  # I wouldn't recommend this for real.
  if { [regexp {^\d+$} $vars($didx)] } {
    $vars(sd$w) reconfWidget sl $w.l$r \
        [list ttk::label $w.l$r -width 5]
    $vars(sd$w) reconfWidget sl $w.e$r \
        [list ttk::entry $w.e$r -width 10]
    grid {*}$sl -in $w -row $r -padx 5 -sticky w
  } else {
    $vars(sd$w) reconfWidget sl $w.h$r \
        [list ttk::label $w.h$r -style Heading.TLabel]
    grid {*}$sl -in $w -row $r -padx 5 -sticky w -columnspan 2
  }
  return $sl
}

proc populateLine { w r didx winlist } {
  variable vars

  lassign $winlist lab ent
  if { $r == 1 && [string match {.c*} $w] } {
    set didx 0
  }

  set c [llength $winlist]
  if { [regexp {^\d+$} $vars($didx)] } {
    if { $c == 1 } {
      set winlist [$vars(sd$w) reconfigure $r $didx]
      lassign $winlist lab ent
    }
    $lab configure -text $vars($didx)
    $ent configure -textvariable vars($didx)
  } else {
    if { $c == 2 } {
      set winlist [$vars(sd$w) reconfigure $r $didx]
      lassign $winlist lab
    }
    $lab configure -text $vars($didx)
  }
}

proc main { } {
  variable vars

  set maxdisp 20
  set max 100

  font create bigfont
  font configure bigfont -size 16
  ttk::style configure Heading.TLabel -font bigfont

  set col 0
  foreach {f} [list .l .r .c] {
    ttk::frame $f
    set lab [string trim $f .]
    set sbnm .sb$lab
    ttk::scrollbar $sbnm -style Vertical.TScrollbar -orient vertical
    grid $sbnm -in . -sticky ns -row 0 -column [expr {$col*2+1}]

    ttk::label .h1$lab -text Label
    ttk::label .h2$lab -text Entry
    if { $f eq ".r" } {
      .h2$lab configure -text "pageadjust -2"
    }
    if { $f eq ".c" } {
      .h2$lab configure -text "reserved line"
    }
    grid .h1$lab .h2$lab -in $f -row 0

    # do this last so it shrinks first
    grid $f -in . -row 0 -column [expr {$col*2}] -sticky news
    grid columnconfigure . [expr {$col*2}] -weight 1
    grid rowconfigure . 0 -weight 1

    set c 0
    for { set i 0 } { $i < $max } { incr i } {
      if { [expr {$i%10}] == 0 } {
        set vars($c) "[expr {int($i/10)*10}] group"
        incr c
      }
      set vars($c) $i
      incr c
    }
    set max $c

    set vars(sd$f) [scrolldata new $f $sbnm configureLine populateLine $maxdisp]
    $vars(sd$f) display $max
    bind $f <Configure> [list $vars(sd$f) resize %w %h]
    $vars(sd$f) bindWheel [list $vars(sd$f) wheelHandler]
    if { $f eq ".r" } {
      $vars(sd$f) setPageAdjust -2
    }
    if { $f eq ".c" } {
      $vars(sd$f) setReserved 1
    }
    bind .h1$lab <Button-1> [list $vars(sd$f) chkScroll 11]
    bind .h2$lab <Button-1> [list $vars(sd$f) chkScroll 12]

    incr col
  }
}

::main
