# icons.tcl --
#
#	A set of stock icons for use in Tk dialogs. The icons used here
#	were provided by the Tango Desktop project which provides a
#	unified set of high quality icons licensed under the
#	Creative Commons Attribution Share-Alike license
#	(http://creativecommons.org/licenses/by-sa/3.0/)
#
#	See http://tango.freedesktop.org/Tango_Desktop_Project
#
# Copyright (c) 2009 Pat Thoyts <patthoyts@users.sourceforge.net>

namespace eval ::tk::icons {}

image create photo ::tk::icons::warning -data {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}

image create photo ::tk::icons::error -data {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}

image create photo ::tk::icons::information -data {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}

image create photo ::tk::icons::question -data {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}
