# icons.tcl --
#
#	A set of stock icons for use in Tk dialogs. The icons used here
#	were provided by the Tango Desktop project which provides a
#	unified set of high quality icons licensed under the
#	Creative Commons Attribution Share-Alike license
#	(http://creativecommons.org/licenses/by-sa/3.0/)
#
#	See http://tango.freedesktop.org/Tango_Desktop_Project
#
# Copyright (c) 2009 Pat Thoyts <patthoyts@users.sourceforge.net>

namespace eval ::tk::icons {}

image create photo ::tk::icons::warning -data {
iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAYAAABw4pVUAAAABHNCSVQICAgI
fAhkiAAAAAlwSFlzAAAc1gAAHNYBTCInoQAAABl0RVh0U29mdHdhcmUAd3d3
Lmlua3NjYXBlLm9yZ5vuPBoAAAAUdEVYdFRpdGxlAERpYWxvZyBXYXJuaW5n
kfmgLwAAABZ0RVh0QXV0aG9yAEFuZHJlYXMgTmlsc3Nvbivv5KMAAAAYdEVY
dENyZWF0aW9uIFRpbWUAMjAwNS0xMC0xNHqTN8EAAABJdEVYdENvcHlyaWdo
dABQdWJsaWMgRG9tYWluIGh0dHA6Ly9jcmVhdGl2ZWNvbW1vbnMub3JnL2xp
Y2Vuc2VzL3B1YmxpY2RvbWFpbi9Zw/7KAAAUsUlEQVR4nO2d+XMc1bXHP6dn
H2m0W7LGshZL3rCNLeNVxublGUggGF7CVjw2g01iAo7xCjwIECCQf+AlP1Hp
qqTC+y2/pJIqiqLiAHaA2NgG22wGDDayI+/WNut9P3T3aGa6R9uMpHFF36ou
6d4+t/ve/urc5Zx7rkQpxSSKB9pEV2ASmZgkpMgwSUiRYZKQIsMkIUWGSUKK
DJOEFBkmCSkyTBJSZHBPdAXyhS4yF7gFCAFvAv9Yr1R0Yms1esiVajrRRR4D
tgEzsm71AL8HHluvVHLcK5YnrkhCdJFNwG8BvKEQ1eEwmggXzp2j51//ssR+
B2xYf4U18IrrsnSRu4H/RYTZq1czvaMDEQHzu5/7/HMO/vnPxCORhzC0ZfNE
1nekuKI0RBepAb4EQm3Ll9Oydi0oRayzExWL4QmHERG6DhzgwBtvWMWWr1fq
/Ymr9chwpWnI/wCh8qoqWq67DoBLb7xB7759AHibmqi6+25qrr6aqR9/zKnv
vgP4NfCfE1XhkeKKmfbqItOBnwHMvflmcLuJHDuWIgMgevw4vYcOAdB2441o
mgbwPV3kxgmo8qhwxRACvAD46q+6ilBjIyoS4dJf/mIT6v7b30j29uKvrqbp
6qut7Fd1ERnHuo4aVwQhusgc4EHRNFrXrAGl6N6zh8TlyzbZZH8/PXv3glI0
Ll+O2+MBWAzcNc7VHhWuCEKAlwHX9IULCVRWkuzupveDD3IK9x48SOLiRTzB
IDPa21PP0EWKfswsekJ0kaXA7ZrbTcu11wLQ/c47qHg8d6Fkku49e1BKMW3J
Enx+P0AbsHEcqpwXip4Q4BWA5iVL8JaWkjh/nt6DB4cs1P/JJ8TPnEHzeGhd
utTKfk4XCY5hXfNGUROii6wFrnf7fDStXGmMHW+/DclhWESUoufdd0Eppi5Y
QKC0FKAe2DK2tc4PRU0IpnbMWL4ct99PvKuLviNHbEJaOIw2fbotP/LVV8RO
nkRcLmYuX25l79JFKsey0vmgaAnRRX4ELPMGgzQsWwZKcXn37pSJxIIEApS+
/jqlf/oTUltre073nj2gFDWzZ1NWWQlQATw1Hm0YDYqSEF3EBfwKoG3VKlxu
N9ETJ4h88YVN1vfAA2jTpqFVVOB//HHb/VhnJ5GvvgIR2lassLI36yLTxrAJ
o0ZREgLcD8z1l5dTv2gRAN27d9uEJBTC+8gjqbTvrrvQGhttcj1790IySUVL
C1V1dQAB4PmxqXp+KDpCdBEf8EuAWatXo7lcRI4dI/rttzZZ34YNaBUVqbR4
PAS2brXJxc+do//TT0EpWgfGkod0kdlj0YZ8UHSEAJuAxtKaGmrnzTNmVn//
u01IqqrwP/zwQNq0jHhvuQXXnDk2+Z7330fF44TCYeqMCYAbY8FZVCgqQnSR
UuAZgJlr1iBA/9GjxE6ftsn6H30UgsaSIsNMpWkEtm2zySe7u+k/fBiUomXZ
Miv7Dl1kSYGbkReKihAMl+yUinCY6pkzUckkl99+2yakTZ2K7957gSwyTHiv
vx734sW2/N79+0lGowSqq5nW2mpl/7qA9c8bRUOI6XzaDjDzuusQoO+jj0ic
P2+T9W/eDF6vIxlWXmDHDtu9ZH8/fQcPglI0LVlimefX6iLXF7It+aBoCAGe
BspqmpupaGxExePGSjsLWnMz3jvuGJQMAM+KFXhWr7bJ9H30Ecm+PnyhENNn
p8b0XxeLeb4oCEl3PrVddx0oRe/+/Y7mdf+WLYjbbrR1+p7BnTshK1/FYvTu
3w9KMX3RIlzGs64B7ihEW/JFURCCsSbwT509m9DUqSQjEWPtkAXXnDn41q2z
5efSFveCBXh/8APbvf5PPiFx+TKeQICWefOs7KIwz084IeZaYL2I0Lp6taEd
H3xAsr/fJhvYts32Fz9U1xXcvh1xuTIFkkl69+1DKUV4/nx8Ph/ALOBhJhgT
Tgim86lh/nyCVVUke3vpcXA+udrb8axdm5E3FBkArtZWvD/+sU0ucuwYiXPn
0DweWhYssLKf10UCo21IITChhOgi1wC3i8tFs+V82rsXFYvZZINZs6bhkGHl
lWzdCl6v7V7vvn2gFHVz5hAw1jRh4OejaUuhMNEa8iogze3t+EMhEhcv0nfg
gE3Is2oV7gHD4IjIAMM8HzDXLemInjhB7NQpRNOYsXChlf2kLlJhEx4nTBgh
usj3gBtcXi+NK1agzI0LKpGwyfq3b0/9PlIyLAQffxwJ2p2F1oyrZsYMSsvL
ASqZQPP8RGrIqwAzli7FEwiQOHuWvo8/tgl5brgBt/nXO1oyAKS6msCGDbb8
eFeXYbgUoXVAS36ui4RH0phCYUII0UX+C1juCQRoWGKYkrrfecfmfEq3S+VF
hggiQvCnP82wDlvo/fBDwzzf0EBldTUY5vnnRtquQmDcCdFFNCzn04oVuLxe
Yp2d9H/2mU3We+utuGbNcvzIp06d4siRIxnX0aNHOXLkCJ2dnSm59LISChF4
9FHbsxIXLxL58ksAWkz/C7BBF5mZR1NHhYlYCN0PXOUPhQi3tw9sXMiG203g
iSdy/sX/5je/4Q9/+IPjC+677z5efvllx7KB9evpe+01kgNhCwD0HTqEt6mJ
0JQpTKmvp6uz0zLP3z2KNo4a46ohuogX0/k0c9UqRNOIfvMN0ePHbbK+u+7C
5eD9sz5ySUlJzveUlpY6kgGgBQKUbLFvPEn29hIxtbR5YAvqnebUfNww3l3W
JqCppKrKcD6Bo3aI309gsz2sI/0jlxrbehyR617KEnzPPY5k9x05Ypjny8up
N+4L5uRjvDBuhGQ4n669FhEh8vnnxNL6ewu+++9HM3zfKWT/xY+UkIzybjel
DuZ5FYnQ/8knADTOm4dmlLlBFxm3cIbx1JCtQG15XR01s2YZ2z3feccmJCUl
+Ddtysxz6H4GIyS7O8suLyL4b7sNt4OrN/Lpp4Z5vqSEhhmp8MVxc2KNCyG6
SDWwA2CmaUDsO3KE+NmzNln/xo1olQP72HIN6oMREgqFUnJOZACgaZTu2mUr
qxIJ+o8eBWDanDm4DMPkUl3k9kEbWSCMl4Y8DZRVT59ORXMzKpGgZ88ee2Uq
K/FvHNgPPdg6YygNGc4axX/jjXgcXL2RY8dIdHfj9vlobGuzsn9l7hcbU4w5
IbpIA/AYQJulHYcOkbh0ySbr37QJMbuboT7ocDQkV9n0dOgpByuJUsaGCCA8
cyYewzA5G3go50sLhPHQkOcAf11bG6H6elQ0Ss8//mGvSF0dvgceAIa3Ah9q
2jtY2fS0t6MD35o1tmdEv/2WxIULaG43zbNmWdkv6CL+nC8uAMaUEF1kFvAQ
IrSuWgWYOz96e22y/scfR3y+YZtDnLTAQjohg5FhpR21BFJaUtfSgj8QAJjG
GIdZj7WGvAS4G+bOJVhTY4SbOTiftMZG/HffPSLb1HCmvcMhA8CzcCGBH/7Q
9pzY6dPEz5xBRGgZ2BDxlC5SnvPleWLMCNFFFgN3iqbR3NFhxGu89x4qaj+G
JPjEE4gRC5iBwQgarMtyGtQzbFpZsy8RIbRrl93VC/SZWlLV0ECJQXQV8GTO
l+eJsdSQVwBpXLgQf1kZyZ4eR+eTa9YsfLfdZssfSltcLheBgN3bGggEcGft
Ssn++E733DNnErjDvvEkcf48sc5OBGgZWLds0UXqbcIFwJgQoov8B/B9l8dD
k7m5uXvvXse4wOD27aBlVmO4XZeTlgy2KByqCyvbsQMcNLXv6FFQioq6OioM
832QMTLPj5WGvArQsngx3mCQxIULjs4n98KFeG/MjOkfyTjiNLCn542EDBHB
1dBAqTnTS0eyu5voiRPGjseBsWSjLtJmE84TBSdEF7kNWOHx+WhYujQVU+4U
FxjcuTMjPVInlJOGOA3owx3cAUq3bHF09UY++wyVTBKqqqJmyhQwXBcv2QTz
REEJMZ1PLwO0LluG2+Mh1tWVMtilw7NyJR5zKgyj8wg6aUi26X0kZAC4a2sJ
/eQntucm+/qIHj+OUorGmSm/1d26SLtNOA8UWkPuBeb7SkqoNwP2nfbnQqZ2
jNY9O5iGOMkPN136s58h5faZbeSLLyAeJxAKMbW+HsbAPF8wQkzn04tgumZd
LqInTxrxfVnwrF2L2yQsH195Lg1xkh9JWisro8zBH6NiMaM9StHQ2mqZ57+v
GztoCoJCashPgOaSigrq5s83tvU4aYcIJaYvIt+NC06LQydv4UjS1holtHEj
riyfDED0669RkQi+QIDwtFTcaMG0pCA+dV2kBHgWoK2jA03TUjHi2fCtW4dr
zpxRk5GeXrJkCRcvXsy4v3Tg1IYhy2enM34PBCjfto1zT2auAVUiQeTLL/HP
nk24pYXOzk4SicRyXeRH65X6k60BI0RBTpTTRZ4BXi6bMoWl994LSnHuj38k
3tWVKehyUfnmm7haWuwVGSEZhU473VOxGJ0dHcSzff4ilHZ0IH4/J48d4/jX
XwMcBRasV8q+028EyLvL0kWqgJ1gbFwAY4poIwPw3XnnFUMGgHg8VDzpYCVR
isixY8axHY2NeIzF5FzgQbvwyFCIMeQpoLwqHKaiudlwzTrEduD1EnTY7ZEP
GQcOHOCBBx6gvb2dRYsW8eCDD3L48OGCkGGh5Pbb8c6da6tj7NQpkt3duFwu
GpuarOy8zfN5EaIbpyE8DtBm7l7v+/hjEhcu2GQD99+Pqz7T/JMPGbt37+bW
W2/lrbfeoquri66uLt58801uvvlmDqTZzPIhQ0RA0yh/+mlbPYGUltSGw/iN
GJPpmM640SJfDXkOCNS2tBAKhyEep+e992xCUlJC8LHMeubbTb3wwgskHVb/
8XicF198ccjyI3lX8Kab8F1j354VP3uWxIULiAiNzc1W9tN6Hub5UROiG9ss
HwYM55NS9B44QLKnxyYb2LABqapKpfMlo7u7m88//zxn3fbt20c0y8yfz+pd
RKh89lnHd0W+/BKlFFW1tQQNk0s15pg6GuSjIS8B7mmzZxOsrkZFo/T+85/2
F1RUEEg7j6QQA3gkEhm0YrFYjEumz97J9zGad/tXryZgHk2bjsSlS4YTC2ge
0JIndJGpg1YyB0ZFiGm/uUs0jeaVKwEjGskpLtC/aROSti0nG6P5QDU1NUyd
mru9VVVVTJkypeAzscpf/MLxfdGvvwalKK+spMxoawngLDwERqshrwAyfd48
/OXlJHt7jS392Q+vrSXwoDETLPTUdufO3L3C1q1bx2Ra7GtvJ3jLLbb3JXt7
U8d/NA3MuB7RRVptwkNgxIToImuAH2hut+F8MqNmHeMCN29GAoExWWfcc889
PP/883jTYgfdbje7du1iQ1ZgTiHXKNXPPGNzqAFEv/kGlUxSWlZGpeHE8jAK
8/yIV+q6yLtAx4xrrqHl2mtJXLzIud//3haKpjU0UL17NwwjyD+f9OXLlzl8
+DBKKebNm2d59Ary7Fz3uh57jMuvv042vM3NeOrr6evp4aBxwrYCFq9Xyu67
zoERaYgusg7ocHu9TF+yZGDjgkNcYMnWrWNOhohQVlbGypUr6ejoGBcyACqf
fBJxiOqNnThhmOeDQaYYkViCeW7kcDFsQvS0yKfWa67B7fMZB4M5OJ9cbW34
HWLDx8PcMR7P9jQ1Ufag3Uqi4nGi331nmOcbGqxyN+ki9ulZDgxJiIi4RMTb
C+uBBb5g0Dh2T6nUkd7ZKNmxY8iNC1cqGVa6YscOR1dvrLMTFY3i83qZarh6
YQS753MSYhLhAwJzoMxv7rJoXboUl8dD7PRpw3SQBfeCBfhuumlYjRpNutDP
Gu2z3bW1VDjEK5JMEjXdDuFwGJfxh7niNeOU1SHhSIiIeAAf4Af8j8AjGjT5
fT7qrrrK0A6H/bkAgbRj94Zq1FDpQi3qCv0sK+1ICEaodTISwe12M9UYS9Dg
lYXGH/igyCDErLQXg4zUVQ4/BWiZPx/N7SZ+5gzRb75xfKC1+y/7Awy3kaOR
He9npdKaBg5TepQiduqUYZ6vq8MFCMy5DzrM75sT2dMgr3l5rJ9roM4FTSJC
rRkM2euwA9HCpS1b8Pzud4h/9FZop3XLeJUfdlml6P/wQ8cxFCB+5gye+nrc
Xi8VlZWcPX8ePywH3hcRpZSyL9xII0SMYBS3eXnMy7sMlgBUNzfjLi3NiFbN
VdGYw6r93w7JJPGuLjx1dZSWl3P2/Hm8xkFpbiApIknl4F1M77JcaZdFjLsM
WgA8fj8oRbyry3HdMQk7VDwOSlm7UxDjmPP072yDBiCGnmoOl+tTOABw6fx5
FOAJh3GbA9UkBoFI6jtdNI8qvAS7MYjQAE0c+kery5Jc1//BZ9+Dcz2nTlVd
OHmSivp6Km6/nfipUyT7+1HRKMlIxLBlpTuMrL41rY9VDnmOvw+3TI7njEcZ
5ZAnLhe4XIjLheb3Ix4PfbEYF8yTVfcb/xrW+raYPzMGofRBXaXdTAklIHkO
3poCdxz6619ZtG4dZTU1eMJhUCqzIdZlplVW2rqGVSZLxrFM+sfJVWYC398X
jfLp8eMkEwki8O7rcCLXd7YgSilrZmFNc71pP72ArwyCv4RfVZj/D7Csupry
6mp8Hg/idqOZPweoVcabhvMXlkPGsbyTTPpHyvWOHDIZ73CQcdKCDPKy0/G4
YT6Jx7kcj9Pb04NSiigc+i389wE4D0SBCBBRDv9EOWXtFeNETidCvIA3AL4X
4dka+CEDKjeJwaH64f3X4NF/whkMMixCokopW8BMOiFCFglkrkncgGcOVK6B
RQ2wwAsVAiQn/qjACYOYXZA5MCQFVAIun4b9f4f39g0QEWOAkCgGIc5dViph
WHSzyfAwsDZxkzltszRlzAPqixhJDFKS5pUwrzgGCXEGCEmRonL8a/GMlbpS
KikiVr/m9JJ0MjQmCYEBQqzvlU5IggFSUoTkIgNw9hia3ddgmmGtU6xp24Sf
CD2BSDAwW3LSktTlNIhnY1AXrtmFWav2bDKscUP49yYkjp0QGymDaUU6huVT
NzXGIsMaOyYJMZBuJEwnJOk0ixoKowpHMNct6Sv6SUJAOc2aRoqCxIdMonD4
t10/FCsmCSkyTBJSZPh/fvInlsRcV50AAAAASUVORK5CYII=
}

image create photo ::tk::icons::error -data {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}

image create photo ::tk::icons::information -data {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}

image create photo ::tk::icons::question -data {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}
