# tkfbox.tcl --
#
#	Implements the "TK" standard file selection dialog box.  This dialog
#	box is used on the Unix platforms whenever the tk_strictMotif flag is
#	not set.
#
#	The "TK" standard file selection dialog box is similar to the file
#	selection dialog box on Win95(TM).  The user can navigate the
#	directories by clicking on the folder icons or by selecting the
#	"Directory" option menu.  The user can select files by clicking on the
#	file icons or by entering a filename in the "Filename:" entry.
#
# Copyright (c) 1994-1998 Sun Microsystems, Inc.
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#

namespace eval ::tk::dialog {}
namespace eval ::tk::dialog::file {
    namespace import -force ::tk::msgcat::*
    variable showHiddenBtn 0
    variable showHiddenVar 1
    variable dpi 100
    variable updirImage
    variable folderImage
    variable fileImage

    if {$::tk::sdltk} {
	set dpi $::tk::dpi
    }

    # Create the images if they did not already exist.
    if {![info exists updirImage]} {
	if {$dpi < 140} {
	    set updirImage [image create photo -data {
iVBORw0KGgoAAAANSUhEUgAAABkAAAAWCAYAAAA1vze2AAAABHNCSVQICAgI
fAhkiAAAAAlwSFlzAAAHQAAAB0AB1ax7xgAAABl0RVh0U29mdHdhcmUAd3d3
Lmlua3NjYXBlLm9yZ5vuPBoAAAAUdEVYdEF1dGhvcgBKYWt1YiBTdGVpbmVy
5vv3LwAAACF0RVh0U291cmNlAGh0dHA6Ly9qaW1tYWMubXVzaWNoYWxsLmN6
aWbjXgAAAEl0RVh0Q29weXJpZ2h0AFB1YmxpYyBEb21haW4gaHR0cDovL2Ny
ZWF0aXZlY29tbW9ucy5vcmcvbGljZW5zZXMvcHVibGljZG9tYWluL1nD/soA
AAP6SURBVEiJtZY7jFRlFIC/8997Z2Z32RcCK+7C0qihsMBHlBCJhYl2Vtra
YKMN0U1QsKCAQCIaGzojIXbaGKLGQgseGysbEiMkRiEsC7IuLMM87v88FjM7
7DiLxoKTnNzkzz3nO6//3CuqysMW89AJQA5w5MiR92ZnZ/cbY0RVWVUAVSWE
oNeuXTt9+PDhD9ca75krJK9xRiOHzh3zFx8EMQAi8vzMzMxMSmnaez9dluV0
u92ebjab041GY9p7PzMxMfH6P42LIU6MbjWv5kNyas9cMfyvmTjnyrIssdbi
vSeEQIyRlBIpJVSVGOPUgQMHPk4p/RxjZKGY3zW8pXgrq8R8w5Q8nbmR74CX
HggJIbS991hriTESQhgAicj46Ojou2NjYwTa/NG6TjEWARADtS1u78sfbDz6
w7Hbh9YtVwihZa0lhID3HudcT621OOcoy5KyLFlaWuL88mfEjUv9joaCZJOt
fXsPFs8+qFxN5xzeey7e28bk+AhasKb5qWdw035BmFzAyGBZapO6Rfz2s/s+
+ebyjaX407fHXnunB4kxtqy1WOeY3baVTY9uJa29P12Hf65cwP11HlNJg4Su
VDYtDFt7ctf4yP7bfZlYaxvOOdpOGapVudO0A8Y+rPDL4nHM5AoiYDJBjCDd
ADRBSkpCuZtdoF1WH4NX+nrSdM7RckpeqawTn/Lr4vvIxFWyXCiqhqJmqNQ6
z55WDXnFYGoOM3Zux96DxYs9iHPunnOOtjcUxSDk6q1TtMJv0NpMajxCVhiK
atYBDWUUtawHUTeCtDYBMQGf75krslVIp1ypIM+zAcj2zW/y3I4zPLX5S6by
t0GFvGp6ziurWVQNNJ9g9/TXlIvHP4qOZ+ZP+JgDlGXZcM6pTSOiMjg2IhmZ
DJMZyLMNZIVQVIWsMBgDqhCDIiZhTEaKNYLdeHn+U1/vNT6lVMYYgqMo1u7k
pBCjEpMSu/us7SLGCFneqX+WC6qKOEUVRKBZBm9TWuibLu+9dc6HZPLCB8WF
ROg6X09EOrfcGMgrQgwgRnuT1ixtU1NY7oM450rvnc/y6tBK01O6xKD7+1tZ
VUlJiVHBps74RkVTJ5t6w7VDTj8kxui8DynlhoYNhNiPWHsvfYT23USKEZN3
SqcKGpUQFO9L7jRa/snl2n2IiJjZ2dmJnTt3qq9ltGw3i57jfmCleIG0chJd
gUhH174ynk2yeK8Rf/zqjSkRbqiq5kClXq/HpXYtCxPDNJvlun3ol8fXPRWg
dD42679fB2pAAbhcVUsRuXllcfloXj+7+/Yl7X2SVwP8r/8A6Xa8laqXvPO3
rsyf/h6oq6oDkFUHIpJ36VV6K/F/iwIWaKtqXD38G+YoZo+bFhjvAAAAAElF
TkSuQmCC
	    }]
	} elseif {$dpi < 240} {
	    set updirImage [image create photo -data {
iVBORw0KGgoAAAANSUhEUgAAACIAAAAeCAYAAABJ/8wUAAAABHNCSVQICAgI
fAhkiAAAAAlwSFlzAAAJ4wAACeMBla+h+wAAABl0RVh0U29mdHdhcmUAd3d3
Lmlua3NjYXBlLm9yZ5vuPBoAAAAUdEVYdEF1dGhvcgBKYWt1YiBTdGVpbmVy
5vv3LwAAACF0RVh0U291cmNlAGh0dHA6Ly9qaW1tYWMubXVzaWNoYWxsLmN6
aWbjXgAAAEl0RVh0Q29weXJpZ2h0AFB1YmxpYyBEb21haW4gaHR0cDovL2Ny
ZWF0aXZlY29tbW9ucy5vcmcvbGljZW5zZXMvcHVibGljZG9tYWluL1nD/soA
AAW+SURBVFiFzZddiF1XFcd/a5+POx937iTXTJmZKETUSCxFaPtQSyXm3fpc
xffQF8FREAZRBkM1UesH+OBDwRfpQ0HBIkgUNC/WB6NtGg1RCB0zk1Qzc9OZ
O/fjnL33Wj7cj7mTe2cawaILFnfffc5Z+3f+e+29zhYz4//B3P8aYGDpoLG6
uroQY/zQQz63c/HixRtH3XBuTdLfft3Cw4KImbG2tpamaXrz9OnTj5gZZoaq
Mjpto+3d3d2wubn5zQsXLlyaFPTpFaknefqmM/valYvhpYcBGUxNXq/XpxcX
F6tpmladc1URqQLVGGPVe1/13lfLsqwWRVFdWlo6JiKfPyxoWkl/Pv8Bt+wq
svbMV6Y++p+AdIuikGazSaPRoNFocP/+/QM+6G80GqyvrzM1NVU/f/589mDA
T65m35g5IU8kOcyddCddoj97ekWm3w1EBpJfunRp88yZM8sbGxvEGIeuqkMf
TJuZISKdra2tW8DdQbAdtz5/u3b549NLZT7oCx2x8s7cn379rXtPHgUyTNay
LFVESJJk4o0D4D4EwPTCwsKjtVrt0dnZWbx2eHXjFaYWy4MDTJvo8e7jn1qd
/dLvXmh9911BQgjRe09RFIQQDqgSYzyQwAMH6HQ6ALwRX8ZO3sPJ+CB5vZSi
w5fPrlQuX3mxePNIEO+9hhDodrsUPrLTdagaMRqqoGqYMXSQvjqwlf2ecuEu
eXb45lhdYvGdMv3FJ55/4XMxnuqoyMYff/zZrUkgEcA5x63WPDMLH+bYXM4w
tBmjwwwUaXZv0tz9C5V5fygEgDioLcdTbvqXVz62/J3m1b/eaQAfGQMpy1JV
lRgjLZ9w9rFTNNoj+5GMN33Y49r1b5M/0jgSYmBJxQgzNzLLflWfnX7ywEMH
cqQoCtrtNp2wQJI4dtrleLQRe/3WCnL8H0ifTATEyfA/0FOxP7UAaa3F9c2X
KIsZgWeH9w1rjfd+qHypCWl6dBla/+dPKCvXSHJDHCSZkOZu3yv77STvXXNJ
jzCp36PMfnDyqS9IbQykLMuoqj3qNCPq4YnXbN/k7t7LZHMtXCIkmRt6mj8A
NADMhDQTkkxwCcwtN6byavrKGEiMMQyWb56lhKgTIVQ7XHtrhWRuCwuCKQjS
H7APlUsfaADhSHKHSx0WBVNBnFGpyjNnV7OvwkiOqGrhvSeEQD6T4uNhijiW
65/GYsRihNL4153fsPDYNi7pve0wT/pLXdWQCJ2tKWg8xeLxRW68df0q6dUr
onbrQZCOqiJphdnpCmWYrIhzFT64+PyBvt3un0nSBi4VkkSQZBTE0ChEURBY
rD/HmeUnuHb9jZ++9qPnvjeIMbpqirIsaRVGnmeUfjLIJBPo5Urac5cI4gTM
UBVEDHCIExITdltdDWW8PRpjVJG2956Oh1olx0/IETOIakQ1tP+2Rq+vNy19
kNThEjATJI7UKCc4FXZaZcecbE8ECSF0VJUoFbJ8H0QVfNQhwKGqOHCuNy0D
ZcwgoFgEddJTToTdvW4JtjX6/BAkxtgJIeDJcWlGt1S6Ph45+JHWz5FJtrtX
eA3JZEVijK2iKOhaFTXY6/a298MxbP/HwPq7p4tCdP3qbKDRegVTe9MY1Gi2
C23Ozk8GMbO2qhJkCq8QD5a4caCRDmV/iUZRzAR10gNR68FEsGj4oHSLEP/+
w2eLMRARyc+dO2cxRjw5ZQRl8qqxCTIlssTbr7f2a4zIsDAaNlQt+ED9RI2y
7KiIHDOzd4YgIuKA+aIoLMZIqQlFnDDaSNeDV07U1iZCTzI18OFmBOZFJJjZ
HvQUSYGsKIpusxCVtOLey8NfY/t+7DbvvQZkjKTGQMH3VavVpcc/88VXdfb9
y3DwHDPJjrouMv69GMm2VZJuubf9h79d/v6L7e3bbwMNM2tD/yu+Pz3HgFlg
Ckj6/t+2AHigDewOIIYgI28i9CTLeW/OxSUQzMaPov8GH39Z0OfIX9cAAAAA
SUVORK5CYII=
	    }]
	} elseif {$dpi < 320} {
	    set updirImage [image create photo -data {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	    }]
	} elseif {$dpi < 400} {
	    set updirImage [image create photo -data {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	    }]
	} else {
	    set updirImage [image create photo -data {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	    }]
	}
    }
    if {![info exists folderImage]} {
	if {$dpi < 140} {
	    set folderImage [image create photo -data {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgI
fAhkiAAAAAlwSFlzAAAEnQAABJ0BfDRroQAAABl0RVh0U29mdHdhcmUAd3d3
Lmlua3NjYXBlLm9yZ5vuPBoAAAARdEVYdFRpdGxlAEZvbGRlciBJY29uXjg7
WQAAABR0RVh0QXV0aG9yAEpha3ViIFN0ZWluZXLm+/cvAAAAIXRFWHRTb3Vy
Y2UAaHR0cDovL2ppbW1hYy5tdXNpY2hhbGwuY3ppZuNeAAAASXRFWHRDb3B5
cmlnaHQAUHVibGljIERvbWFpbiBodHRwOi8vY3JlYXRpdmVjb21tb25zLm9y
Zy9saWNlbnNlcy9wdWJsaWNkb21haW4vWcP+ygAAAa1JREFUOI2lkrtuU0EQ
hr/ZHNvHRMglRUQdiZaKDokyD0DJO9BbdJbl9kgUFLwBFg9AQUE6CpoUgIUR
NzuIKHbwue1taKyDSYJceKTRFrvz6f//WVFVdqkEYDAYHAEHIYTNu5N+v3+8
DSCqyng8/gLc9t7jvSfGSJ7np9Pp9HA4HC63KiiKwhVFgbUWay1rJbe63e6L
LMtyEcEYI0mS6GQyeTIajd5dBsTVakVVVVhrGxXAg/l8jjGGVqtFmqaIyBug
AYiqkmXZyYez1p2Dw7tYF7guWBEBERCTY5L823z5+tnj+w8TgLIsvY0d0ps9
qtxe63UDuQ/s3+i2agAD4JyrW+0OPmxfqQuKKuSVXTSAsizd3l4bF+J/B6NC
7SKVDbQTw8Vvt2hCtNZ6em2cj6hCVCUqxLh56gZMOb8ozhpAXdfORiGvAyFE
thkpa48L8XsDcM65woKp/JXHlxeiwKrwWtbVFMCISLosQ68kpbTxSlfu365d
5Mfs5+z9q6cBIFHV6t7Ro+epfxtOYxTVtV9Vov4N1YgBEbx0vv6afX65+Hj8
CdYfaZcyO00DfwAW+CYt+UA37AAAAABJRU5ErkJggg==
	    }]
	} elseif {$dpi < 240} {
	    set folderImage [image create photo -data {
iVBORw0KGgoAAAANSUhEUgAAABYAAAAWCAYAAADEtGw7AAAABHNCSVQICAgI
fAhkiAAAAAlwSFlzAAAGWAAABlgBH4cC6gAAABl0RVh0U29mdHdhcmUAd3d3
Lmlua3NjYXBlLm9yZ5vuPBoAAAARdEVYdFRpdGxlAEZvbGRlciBJY29uXjg7
WQAAABR0RVh0QXV0aG9yAEpha3ViIFN0ZWluZXLm+/cvAAAAIXRFWHRTb3Vy
Y2UAaHR0cDovL2ppbW1hYy5tdXNpY2hhbGwuY3ppZuNeAAAASXRFWHRDb3B5
cmlnaHQAUHVibGljIERvbWFpbiBodHRwOi8vY3JlYXRpdmVjb21tb25zLm9y
Zy9saWNlbnNlcy9wdWJsaWNkb21haW4vWcP+ygAAAqdJREFUOI3Vlc+LHEUU
xz9V3TPZZBzCwmIUBGFY9CTiRXL2lqt4ECGXIPgf7NFhTsv+A3oQxJvevSoe
PIgBQRLISQgxuIesmZnYs/3j1av3POzMZmeTDbtCDn6hm6a6+HS9b3/rVXB3
XobiS6ECJcDu7u6HW1tbnwKYGe7OqhIR8fl8PhmPx7cvDB4Ohx+NRqMb0+kU
VUVVMTPMjMFggIhcBj64MLhpGq2qiul0SkrpGJxzxt0RkdHOzs7nZjaLcd29
EMK9vb29H88CJ1Wl6zpUlZQSOWdyzpgZIYQ3Nzc3J4PBgKIoiDFSFAW9Xo/9
/f0Hk8lkNB6P7Rlw13VJVZGkzGpHFXI+uszA3YCOMBdijMfgsiw5rK3/2+PX
3v3+s2+bwrT79aub94/BdV2riPDgnz7X3rpOv1cA4JwdxUAA4CpceyOWPxPg
0eOqff/Wd+/d/vrjhyWAqjYiwkIK3t68yt9Vd5H/FMkMzOCVKxtNu2GLo0FA
RBoRocuRIv63aDcpo5rl7pefzI/BKaVF27bEskd2ezHhlNyhkaP0ZLPWl/5F
AFU9TCnR611C8/m3uBnUktHs9MtIl/Lh6t0qFQsRoShLOn12xe7gsNyRkM1R
c8yeLqKIgepQqjWwiCxSEuJGj5QMd1BzcnayOXaORhVCYNGmdXDXdZVIwi4X
LDpF1V4QtOfL3akbWbci57zI2WgV6i4vZ3IG/ES6T0wIIVA1abEGPjg4uNIk
y53Fok12kvG8x1OfObqJJtpqbiGE0t21DCH0t7e341/pdetdGhZ1I+er/ZSq
J1U9/fPuL8AQmJXuLiGE31995+E3xezJKGeNAO7LjrzszyvXw9PSPYSAu1vj
gzv17NG9P3764gegAgirhh5CCEB/Zc8FZYC4e14NhP/dmfcvCrbBBSh+OBEA
AAAASUVORK5CYII=
	    }]
	} elseif {$dpi < 320} {
	    set folderImage [image create photo -data {
iVBORw0KGgoAAAANSUhEUgAAACQAAAAkCAYAAADhAJiYAAAABHNCSVQICAgI
fAhkiAAAAAlwSFlzAAAKYQAACmEB/MxKJQAAABl0RVh0U29mdHdhcmUAd3d3
Lmlua3NjYXBlLm9yZ5vuPBoAAAARdEVYdFRpdGxlAEZvbGRlciBJY29uXjg7
WQAAABR0RVh0QXV0aG9yAEpha3ViIFN0ZWluZXLm+/cvAAAAIXRFWHRTb3Vy
Y2UAaHR0cDovL2ppbW1hYy5tdXNpY2hhbGwuY3ppZuNeAAAASXRFWHRDb3B5
cmlnaHQAUHVibGljIERvbWFpbiBodHRwOi8vY3JlYXRpdmVjb21tb25zLm9y
Zy9saWNlbnNlcy9wdWJsaWNkb21haW4vWcP+ygAABFVJREFUWIXtmM+LHEUU
x7+vq6dnZmciy0oCRgKB4MlTboqIf4I5eRBvouDB5J5bDsEccoog7M2TxKt/
gBdBhIT8ATmJZsXMuGQ3u91dVa/eex5me9LzK7sxsyQHv1BMdXd1vU+/9/pV
9ZCZ4XVS9qoB5vXaAeVNh4jo+vXr74qIO+G9T27duvXHuoGoyaEbN27cPn/+
/Of9ft8AQFUBAO0ca/pEhL29PRuNRrdv3rz5zTqBph4ys48uX768OR6PwcwQ
EZgZRASqCjOb/poZLl26hPF4/AWA0wFKKXnvPXZ2dqCqEJEpTNMaGDPD7u4u
NjY2BlevXu3euXMnrB3IzOqUEohoZsD8cQMUQoCZDTqdzt1r1679fJwhM0sh
hB+2t7f3TwSUUqqZeWq00Xy42p4qimKwtbV1ZTAYXBkOh3DOgYimLcuy6a+I
6L179z4D8MGJgESkDiGgLEuklJBSWgjZfOgaVVWF8Xg8A5Jl2RTQOYder5ep
6lvHeXJah1S1ijEuPOW8x5rjVa2t5k1t+iJybN1rh6xqcsjM8OvoHLzkLYA2
kLb6sxOuykEiQszefPvDr398OHfH/V++/eTTBSBVPfTeoyxLVFUN172Irz5+
Dz6m1r3tLq04/1zlAN5pDorc4fufHgznBwAAmLlkZmRZhgSHQb/AaN/j0W71
fBMvoYvnBqhj4va5aUyZ+ZCZJ64Vh+GghyS6OMuaFJPCZYQ6pJkaNgVKKR3G
GFHXNfYrxqDXRZLT2ZqIGgIrCIAkq5cCiUjFzOqcQ7IOhsM+4il4SA3wUY9s
KijDP+3rM0tHjDEBKCIKbPTX76EkBs8yfTNFFGb2uD2mHTIfY0zee1Q8SerI
6/NQTIo6PoNxGSFwgil2lgKpqo8xap7nYOqi08kg+vJAqkAdFWHu4Touw2HF
EE1/ts+365BnZun1emAUAAgvEjAzwACoToqomkF00pYpd4SnleeU7K+lQCLi
QwjS6eQIkkFteYlTA0QmhvSogpvZC8EDQEaE/TJ6wFYnNTNrljlkLge3EjqJ
gcUgqgtLxX8VEfC0DAG2AoiZfYxRJ6t0jpoFgRUs64NoywDsl16pK8uBAPgY
o4UYASIcVGkhEVdz2fTiSdlZFGUZTFPcXQqkqiGlZEoFnHOogsyEbQFgmfEl
w1fNEJMhJJH721/OrGU5MNkaXLhwoTh79qxL6CDPc/goSNo2fPyznyS0zZA6
CmJkIaIzZnYwAwTgjdFo1BdJWRkM2nOoWVdCPNfuCUMnKtDJUrBJRGZmhwCQ
02QHVYQQnIjigLbQHbwBPeVv/oP9ymL15AGALoCiOZ+bmRFRApCehOLhztPN
93vVI3u80/5CbE81t51dYXCxihEAIyV3CGTC0f/9+293vwOQjtpklJmBiByA
TQBnAGwcEbul87689KhFACWAAwB7drQvpvbGnIh6AHqY5FZ+SkCGZ16pzCy2
L9L8l8Kr1mv3d8z/QMfpX9oJIb1+t7MXAAAAAElFTkSuQmCC
	    }]
	} elseif {$dpi < 400} {
	    set folderImage [image create photo -data {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	    }]
	} else {
	    set folderImage [image create photo -data {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	    }]
	}
    }
    if {![info exists fileImage]} {
	if {$dpi < 140} {
	    set fileImage [image create photo -data {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgI
fAhkiAAAAAlwSFlzAAAEnQAABJ0BfDRroQAAABl0RVh0U29mdHdhcmUAd3d3
Lmlua3NjYXBlLm9yZ5vuPBoAAAASdEVYdFRpdGxlAEp1c3RpZnkgTGVmdOI3
kz4AAAAWdEVYdEF1dGhvcgBBbmRyZWFzIE5pbHNzb24r7+SjAAAAGHRFWHRD
cmVhdGlvbiBUaW1lADIwMDUtMTAtMjkvDxi/AAAASXRFWHRDb3B5cmlnaHQA
UHVibGljIERvbWFpbiBodHRwOi8vY3JlYXRpdmVjb21tb25zLm9yZy9saWNl
bnNlcy9wdWJsaWNkb21haW4vWcP+ygAAASdJREFUOI2VkTFug0AQRf9alGnA
HXaFoEmUDiEZEI3PlSpnSXKKNGvHaSLlBlRJbsH8FANhFxxk0+zMiv//m1lD
Esc3+7iJt3tc8X3/fL3WVfMQAMAm3u7jON5dKiYJkgCgBtcKSYIgAMAzsNYu
iPWsqrI3wdygaZrFVBFCRBSfFxDoP2NalmVYr6P/RxgI3ERSJgR6h3MjWGtn
qf22EUUR0jTtjWROQBJ1XXupWmvvzi8yISD08nA4eqnDORCRRJ7nGuAR9K5l
uVskGGo1dgyEgIjgdHqfpYdhiCRJPKE+I+YERVE4Gx+3r+KxV7VDQCjBiOk/
n4r8fthOAABd162mBooqZ3to4AoAAmNM8Pzy9Jll2Y2IGPdZgT9St4BZGWnb
9uPu9h6/rU1qjsN9iWAAAAAASUVORK5CYII=
	    }]
	} elseif {$dpi < 240} {
	    set fileImage [image create photo -data {
iVBORw0KGgoAAAANSUhEUgAAABYAAAAWCAYAAADEtGw7AAAABHNCSVQICAgI
fAhkiAAAAAlwSFlzAAAGWAAABlgBH4cC6gAAABl0RVh0U29mdHdhcmUAd3d3
Lmlua3NjYXBlLm9yZ5vuPBoAAAASdEVYdFRpdGxlAEp1c3RpZnkgTGVmdOI3
kz4AAAAWdEVYdEF1dGhvcgBBbmRyZWFzIE5pbHNzb24r7+SjAAAAGHRFWHRD
cmVhdGlvbiBUaW1lADIwMDUtMTAtMjkvDxi/AAAASXRFWHRDb3B5cmlnaHQA
UHVibGljIERvbWFpbiBodHRwOi8vY3JlYXRpdmVjb21tb25zLm9yZy9saWNl
bnNlcy9wdWJsaWNkb21haW4vWcP+ygAAAehJREFUOI2lk01rE0EYx//7lqxC
LkswEJIIaSPYY/RiL9LechD9AB4Uj55F8AMI6tkv0pIPUQ8aEKE0UHOr5yay
08zu/D0k+zY7mxQzsOzMw7O/+T3Pzlgk8enLxzuDwYOvfs33scMQSyGm04u3
7999CN117P7R0+OXjUbD2wU8n8/ldHrxGcB5AkYUR4zj+L+AJEESUkomMXsX
wzyUZCHu6omXl78h5fIWQAAggiBAEAQgk1gFWAixFZxASUBKmTPOyCXwwcHD
DUAaHkCpbF4JPjv7hpsbYTBMV+m61bqHfr9/O+O9vT6iKNIsE2DRzPf9nO0W
42azqZWt/3m9FaqweSV4PB5jsfirh0uj3W5jOByW+m0Ek8RoNDKamo1VIc9s
vE64vp5DqdhoYtqoVqvB87zVhiYwSSilMJlMEIZhGtMr0kev10On01mbbWjF
4eGTkq35/ObborKyy8argz6bzbTblJk6jo1ut1cCZ2+j8WpnIcI1uFg+STiO
A6WUBgTyP7TSeH9/UFE2jJaF+SbjbccsX7YeB61q4zJML3VTf3Ngy7Kc5y+e
dV+/emPX63WDzQqcVZWt9UuxXEr7x/dJC8C5SzJ+9Hj48/T05MR1vbuKtNLk
9Bv9/LIUsmyLURwtrq7+/AKAf1z4R18ssp3yAAAAAElFTkSuQmCC
	    }]
	} elseif {$dpi < 320} {
	    set fileImage [image create photo -data {
iVBORw0KGgoAAAANSUhEUgAAACQAAAAkCAYAAADhAJiYAAAABHNCSVQICAgI
fAhkiAAAAAlwSFlzAAAKYQAACmEB/MxKJQAAABl0RVh0U29mdHdhcmUAd3d3
Lmlua3NjYXBlLm9yZ5vuPBoAAAASdEVYdFRpdGxlAEp1c3RpZnkgTGVmdOI3
kz4AAAAWdEVYdEF1dGhvcgBBbmRyZWFzIE5pbHNzb24r7+SjAAAAGHRFWHRD
cmVhdGlvbiBUaW1lADIwMDUtMTAtMjkvDxi/AAAASXRFWHRDb3B5cmlnaHQA
UHVibGljIERvbWFpbiBodHRwOi8vY3JlYXRpdmVjb21tb25zLm9yZy9saWNl
bnNlcy9wdWJsaWNkb21haW4vWcP+ygAAAtlJREFUWIW9mM9qE1EUxr97Z6KQ
dmGZjknFKm4k1aTpA4iCL5BVl7VPIYIPIIgv1EpWIi3uKhRchSgYiCUI0qlZ
tDPHRTqTO/ff3HGanM3M3D9zf/nOd+4dwogIabz/8O4hgEdYbgzfvH77I33w
xZ6NjXtfnj97cWeZNJ+PPv0B0NAChevhrc3NB7eTJF4KDOccd8NGTWzz1WGE
JEkWCjK3CVP6NECLBAEAEoBIGbM0oBSCiAQwFWnhQCKIDKQLI1AURRgMBhVh
sjsQAdvbHQmMFDAr0MnJ10pAcnQ6bY2P8mEEajab2N9/VXrRvEfM6crSJnHd
mIfsixsMrRHpRoDmfrCrIQKajG0EGo/HODz8eBO8aLfbaLefSurofWQEWl1d
xc5OV9snVo/8nF9j9hyGoUWxEkDdrgpUxiPyNS3z/9qHbCDmxe1g+XeUTJm4
MepTYk8XEYExYGvriRFMeI0bUNWN0fM8tFpbRqBSCjUaDezt7cHdIy5pkn3k
cLiKJVndI8VgDgpRBmRe3KWa8mBqmhzLPp08Hv9Cv99XZ1SIXq+Xg0/BrEAz
KMLKygo6nU42yVZN8tziPv2nhwJEwuB6va7d7t3SJB8NeVVMnx4K0Gxw8QHp
4hGdeWVAx7KfDb64iDAcfpcm2dJFCIJ1BEEgjdXBOCs0J4+iCKenp8aJumi1
WgiCwKpKvr1E2YdhiN3dXdjSpEpPGhg7mB2IVA+V23ndVTF9pBmOjvLmLaPK
fAzZjw7KyN3UKFalaIwaxo2xOE1pf9FeY1NODZ7eMMY4JHXmVxLUEeTWmlm9
16XcFP41zBqAtSRJPM45fN8v2OAyLTUqQFHIVFWe54Fi8hhj9wH8JqK/PmOM
AfAAeJPJJB6Nfl4S9C8obtZ0aprY9b8w5+cRziZnV+n6AODT7KdMGGPRwcHB
y+Pjo8dXcezFcezpl64enPOEc061Wu1yOp1+AzAioisA+Afe69paBLvOuQAA
AABJRU5ErkJggg==
	    }]
	} elseif {$dpi < 400} {
	    set fileImage [image create photo -data {
iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAABHNCSVQICAgI
fAhkiAAAAAlwSFlzAAAOawAADmsBVP4NBgAAABl0RVh0U29mdHdhcmUAd3d3
Lmlua3NjYXBlLm9yZ5vuPBoAAAASdEVYdFRpdGxlAEp1c3RpZnkgTGVmdOI3
kz4AAAAWdEVYdEF1dGhvcgBBbmRyZWFzIE5pbHNzb24r7+SjAAAAGHRFWHRD
cmVhdGlvbiBUaW1lADIwMDUtMTAtMjkvDxi/AAAASXRFWHRDb3B5cmlnaHQA
UHVibGljIERvbWFpbiBodHRwOi8vY3JlYXRpdmVjb21tb25zLm9yZy9saWNl
bnNlcy9wdWJsaWNkb21haW4vWcP+ygAABDBJREFUaIHdWk1v20YQfUNRSmRJ
NdCkMUAmQoUGMBrHN5/kvxOgQE4BChSFf0FRoEAvaYO2vyg9pMfkIMSAD64d
nWzVSuSIkwMla7k7u1ySkiL0XWzMkrPvcb6WpomZ8X9AqBt+/uWnpwT8ysz0
OQjlgYiYgWc/fP/jb6rdEFKvhUdPnnxXb2211seuAK6urvDnXy+OALiFgIBG
vYHpdArmZF38csEMBAGh0WgAQq6YQha3YlPqZ84jSQhEgXiNbN0QMC8eZt5D
dUTk80IXwJz+TpYWtHFC1CdviiEAcmQ2SogUhTlxVzSADRFiI67bbNEAPIUM
BgOcn78rSTMPKuEU9+/HiOPYEJPWiezFS8jp6b8YDAZV2BZCs9lEFEVahBa/
S/AS0u120em0qzOE/kTNaACMe/e+ykTBuE7Q4ynkAbrdB4UIS5BmgpQ+KVM2
bK5ZspZid7dUwFXgWTF2rFxIceK2CLnhJWQ4HOLycuRJfQ5b+mTX1bU7d75E
q9WGHA2GS5CXkNev36ylax0cHODhw2+sqZWKrjDZt7e3sbOzU5KeFA35umaz
KRT4Yt3lw0vI/v5j7O8/dtMoUAv2YlY7UzExlYu9KnFZjE7cPdUrCXHNgqJi
bMSz+yjvJmWFTCYTTKdTgbjPYHMRT1GvhwiCmocYO7yEvHz590q7Vr/fRxxH
lijoNhkbcYwHzAleVEyuEGbG4WEfh4f9pXWmosQrp9bqiPsWeJZDqYikN9qJ
FxXj35nsNttUzxEikVsO8bJiSswRBkA3jl69+gcnJyd2LxYfHqktotfrodfr
aX4YpSKiOhiPx7i4uCjHqgQmkwmklFIzQIezRubOHj36Fr3e19oTzksf8zo5
7/U1YGuraZAuNUdutpvd3Ol8gU6n42yfRfNe6kxyFFQBRVOL7a13GbNAng/m
26DqLw/OrmW24OyGfp2pehQqFvuC+Nu3xxgOh4Jz5Niya3t7ewjDxZbSE9dt
2SiVeh9ZFPvZ2RmOj4/tl3pid3d3JqRIFHSbDK/UiuMYrdb8U5xvNExbGNaW
FAVTkSlEyPsoihBFUcZWtMB9inllxb7OliqLzq6XODTyTVr5HuiWEwX5gJi9
RxZT6Bi/mpZqt8miZciTveAsWHYU7KlXYo6ow9BeJ+uKQoVin9eJjaxNjB+h
MqLduPnOTkQBEbWZk0DdOPuqqXcPFgjr63pamEcOvZjzRDAnARHdUm3hTMQW
gDaAdpJwbWYDUQCi1DFR+qJFRMpmBKJsIZLy6TW9T5oF5aIw/9tXwhwAuEtE
IwAjZp6GlO4cAqgDaDASur6+Rru9nE9ty8ZodAlOQABuAfiAlPc0ZGYmojFS
McHp6dnvL/54fgTxX1c2AAw+H757DuA/AGNmfg8ApIaXiEKkSm8DaACoIRVU
MxyuFx8BJLOfHwC8BzBhhfwnq61KCuZOLqEAAAAASUVORK5CYII=
	    }]
	} else {
	    set fileImage [image create photo -data {
iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAABHNCSVQICAgI
fAhkiAAAAAlwSFlzAAASdAAAEnQB3mYfeAAAABl0RVh0U29mdHdhcmUAd3d3
Lmlua3NjYXBlLm9yZ5vuPBoAAAASdEVYdFRpdGxlAEp1c3RpZnkgTGVmdOI3
kz4AAAAWdEVYdEF1dGhvcgBBbmRyZWFzIE5pbHNzb24r7+SjAAAAGHRFWHRD
cmVhdGlvbiBUaW1lADIwMDUtMTAtMjkvDxi/AAAASXRFWHRDb3B5cmlnaHQA
UHVibGljIERvbWFpbiBodHRwOi8vY3JlYXRpdmVjb21tb25zLm9yZy9saWNl
bnNlcy9wdWJsaWNkb21haW4vWcP+ygAABD9JREFUeJzlW01PFEEQfTW7C8tG
Je7CCbksCWdC0Av8DUk0EY8mxosHD5wI8eAvMCb+FcMFDB6N7A9AMHpSTkZh
d3bKw+7AzNDd0z3TPTOLL5nQ9PZXvXpdVQxAzIz/GXVR5+7ubr3Zqr8heItF
H8gFGMG38z/+9s7Ojp/8TEhAs1V/077bebmyslpzfzz3+HL0efgLPwHgVfIz
IQEEb3FlZbV2f+2B67MVAs/zant7H4RqFhIQxcXFuf0TFYAwtjWbM8pxXhGH
KRomgT1VAZOEqOGjZjoRN4aAuPH/kQJkhscUoOBjogmQG3/DFaDj9RsZA3SN
va4AORETQ4CO3GWkqHRgTMD+/r7plFxQX2fGxsaG3HCNUGBMwPHxV9MpTrG+
vgG58TcsBojBxSrg6dMt0ylG0LvrGvd+0hSQx0Cx1znWlqF0AnTTWS4FVLUS
tOt1lQLkKIUAWxLXnaNC4XWA3CtJUuTjlpeX0enMQe11RwqoQh2wsHAPnY7M
WMeVYDUgyv3R/mRbDqd1gOvUpmN42o/GzhTgoqDJTooc1gkoLrXlMzyENQJ0
01FZ10IGKwSUL3H1vbeaBaJ1QFq+Th+jO44xPz+Pbnfp8vvSYkBZdYDn1dDt
drNFfgURE1QHmHrdgQKYGVtbTy7b0X5xe3QQs3by8Ob33vpr8Wob6FgB1Spo
KqGA0ebZ28nD5zNQbXg6EdoKqEpBY34t1FAQIF784OCjYjn93K9zQJmUo/1r
a2uK/R0o4OTkJHXRInFFgKL0zVIHxATFyZ4qIakms2BorIDHjx8Z3+HofN05
elWe2Ot2fjka2zR5+HKjvUruyXFpyJQFyi1odLxuvQ64WrQaqS3d67pxKzUN
FqWAtIJG1+smKRDIEAMODz8JB+bJ/cyMdruNpaUly15nwcw4DGMAcHp6mjYl
M7rdbrhrbE89r+upJgnjGOAeZqlN5HWHlSCwufnQYWoTR3LbXo8itRLMkppc
FzS6XrdSCYo2qE5q040Vchi8EMmbzvIVNDa9HoUjBbj1epJI1fw0FKiA5Bo6
QS4+LlusUEPrhYgrr9tIbXnKYEArC5h5WtebeVObfqxQw2IMmByvRyEkgMEU
rmUj2svGjfriY66vkSVW6OPyn6ZohBYRtfsX/eb1A7GgneZ1vhwTna/2Okf6
RfMhmJ9ufH/Qnyai20QUc3p9bHwDQAvADICW7/sNkYHlFzTZ5T626Q6ABhH9
YeZz4OoKNMbPFICpIAhq4QZzc3NGG1UNRAQACAKuAZgGMATgE9GAmYchAcPI
4/cH/R+9Xi/wajUv09WSxADlsIx3WAe93lEwGPR/APAjzxAAKJTY+BrMAGjO
zs7eev7i2Xaj3lhgZo+ZCQDCr1UGEYUGMRGxRxT4Q//7u7fvX5+dnf0G8DeU
PxAhILKAh/FVwOiK1HEVLCfh7wmCxOMD6AO4YOZhcvA/bXKSdB0jCjQAAAAA
SUVORK5CYII=
	    }]
	}
    }
}

# ::tk::dialog::file:: --
#
#	Implements the TK file selection dialog.  This dialog is used when the
#	tk_strictMotif flag is set to false.  This procedure shouldn't be
#	called directly.  Call tk_getOpenFile or tk_getSaveFile instead.
#
# Arguments:
#	type		"open" or "save"
#	args		Options parsed by the procedure.
#

proc ::tk::dialog::file:: {type args} {
    variable showHiddenBtn
    variable selectFilePath
    set dataName __tk_filedialog
    upvar ::tk::dialog::file::$dataName data

    Config $dataName $type $args

    if {$data(-parent) eq "."} {
	set w .$dataName
    } else {
	set w $data(-parent).$dataName
    }

    # (re)create the dialog box if necessary
    #
    if {![winfo exists $w]} {
	Create $w TkFDialog
    } elseif {[winfo class $w] ne "TkFDialog"} {
	destroy $w
	Create $w TkFDialog
    } else {
	set data(ent) $w.contents.f2.ent
	set data(typeMenuLab) $w.contents.f2.lab2
	set data(typeMenu) $w.contents.f2.menu
	set data(hiddenBtn) $w.contents.f2.hidden
	SetSelectMode $w $data(-multiple)
    }
    if {$showHiddenBtn} {
	$data(hiddenBtn) configure -state normal
	grid $data(hiddenBtn)
    } else {
	$data(hiddenBtn) configure -state disabled
	grid remove $data(hiddenBtn)
    }

    # Make sure subseqent uses of this dialog are independent [Bug 845189]
    unset -nocomplain data(extUsed)

    # Dialog boxes should be transient with respect to their parent, so that
    # they will always stay on top of their parent window.  However, some
    # window managers will create the window as withdrawn if the parent window
    # is withdrawn or iconified.  Combined with the grab we put on the window,
    # this can hang the entire application.  Therefore we only make the dialog
    # transient if the parent is viewable.

    if {[winfo viewable [winfo toplevel $data(-parent)]]} {
	wm transient $w $data(-parent)
    }

    # Add traces on the selectPath variable
    #

    trace add variable data(selectPath) write \
	    [list ::tk::dialog::file::SetPath $w]

    # Initialize the file types menu
    #
    if {[llength $data(-filetypes)]} {
	# Default type and name to first entry
	set initialtype     [lindex $data(-filetypes) 0]
	set initialTypeName [lindex $initialtype 0]
	if {$data(-typevariable) ne ""} {
	    upvar #0 $data(-typevariable) typeVariable
	    if {[info exists typeVariable]} {
		set initialTypeName $typeVariable
	    }
	}
	foreach type $data(-filetypes) {
	    set title  [lindex $type 0]
	    # [string first] avoids glob-pattern char issues
	    if {[string first ${initialTypeName} $title] == 0} {
		set initialtype $type
	    }
	}
	SetFilter $w $initialtype
	$data(typeMenu) configure -state readonly -values \
		[lmap type $data(-filetypes) {lindex $type 0}]
	$data(typeMenu) current 0
	$data(typeMenuLab) configure -state normal
    } else {
	set data(filter) "*"
	$data(typeMenu) configure -state disabled -takefocus 0
	$data(typeMenuLab) configure -state disabled
    }
    UpdateWhenIdle $w

    # Withdraw the window, then update all the geometry information
    # so we know how big it wants to be, then center the window in the
    # display (Motif style) and de-iconify it.

    ::tk::PlaceWindow $w widget $data(-parent)
    wm title $w $data(-title)

    # Set a grab and claim the focus too.

    ::tk::SetFocusGrab $w $data(ent)
    $data(ent) delete 0 end
    $data(ent) insert 0 $data(selectFile)
    $data(ent) selection range 0 end
    $data(ent) icursor end

    # Wait for the user to respond, then restore the focus and return the
    # index of the selected button.  Restore the focus before deleting the
    # window, since otherwise the window manager may take the focus away so we
    # can't redirect it.  Finally, restore any grab that was in effect.

    vwait [namespace current]::selectFilePath

    ::tk::RestoreFocusGrab $w $data(ent) withdraw

    # Cleanup traces on selectPath variable
    #

    foreach trace [trace info variable data(selectPath)] {
	trace remove variable data(selectPath) {*}$trace
    }

    return $selectFilePath
}

# ::tk::dialog::file::Config --
#
#	Configures the TK filedialog according to the argument list
#
proc ::tk::dialog::file::Config {dataName type argList} {
    upvar ::tk::dialog::file::$dataName data

    set data(type) $type

    # 0: Delete all variable that were set on data(selectPath) the
    # last time the file dialog is used. The traces may cause troubles
    # if the dialog is now used with a different -parent option.

    foreach trace [trace info variable data(selectPath)] {
	trace remove variable data(selectPath) {*}$trace
    }

    # 1: the configuration specs
    #
    set specs {
	{-defaultextension "" "" ""}
	{-filetypes "" "" ""}
	{-initialdir "" "" ""}
	{-initialfile "" "" ""}
	{-parent "" "" "."}
	{-title "" "" ""}
	{-typevariable "" "" ""}
	{-nativeonly "" "" 0}
    }

    # The "-multiple" option is only available for the "open" file dialog.
    #
    if {$type eq "open"} {
	lappend specs {-multiple "" "" "0"}
    }

    # The "-confirmoverwrite" option is only for the "save" file dialog.
    #
    if {$type eq "save"} {
	lappend specs {-confirmoverwrite "" "" "1"}
    }

    # 2: default values depending on the type of the dialog
    #
    if {![info exists data(selectPath)]} {
	# first time the dialog has been popped up
	set data(selectPath) [pwd]
	set data(selectFile) ""
    }

    # 3: parse the arguments
    #
    tclParseConfigSpec ::tk::dialog::file::$dataName $specs "" $argList

    if {$data(-title) eq ""} {
	if {$type eq "open"} {
	    set data(-title) [mc "Open"]
	} else {
	    set data(-title) [mc "Save As"]
	}
    }

    # 4: set the default directory and selection according to the -initial
    #    settings
    #
    if {$data(-initialdir) ne ""} {
	# Ensure that initialdir is an absolute path name.
	if {[file isdirectory $data(-initialdir)]} {
	    set old [pwd]
	    catch {cd $data(-initialdir)}
	    set data(selectPath) [pwd]
	    cd $old
	} else {
	    set data(selectPath) [pwd]
	}
    }
    set data(selectFile) $data(-initialfile)

    # 5. Parse the -filetypes option
    #
    set data(origfiletypes) $data(-filetypes)
    set data(-filetypes) [::tk::FDGetFileTypes $data(-filetypes)]

    if {![winfo exists $data(-parent)]} {
	return -code error -errorcode [list TK LOOKUP WINDOW $data(-parent)] \
	    "bad window path name \"$data(-parent)\""
    }

    # Set -multiple to a one or zero value (not other boolean types like
    # "yes") so we can use it in tests more easily.
    if {$type eq "save"} {
	set data(-multiple) 0
    } elseif {$data(-multiple)} {
	set data(-multiple) 1
    } else {
	set data(-multiple) 0
    }
}

proc ::tk::dialog::file::Create {w class} {
    variable updirImage
    set dataName [lindex [split $w .] end]
    upvar ::tk::dialog::file::$dataName data

    toplevel $w -class $class
    if {[tk windowingsystem] eq "x11"} {wm attributes $w -type dialog}
    pack [ttk::frame $w.contents] -expand 1 -fill both
    #set w $w.contents

    # f1: the frame with the directory option menu
    #
    set f1 [ttk::frame $w.contents.f1]
    set data(dirMenu) $f1.menu
    bind [::tk::AmpWidget ttk::label $f1.lab -text [mc "&Directory:"]] \
	    <<AltUnderlined>> [list focus $data(dirMenu)]

    if {![info exists data(selectPath)]} {
	set data(selectPath) ""
    }
    set var [format %s(selectPath) ::tk::dialog::file::$dataName]
    ttk::combobox $data(dirMenu) -state readonly
    bind $data(dirMenu) <<ComboboxSelected>> \
	"set $var \[$data(dirMenu) get\]"
    set data(upBtn) [ttk::button $f1.up]
    $data(upBtn) configure -image $updirImage

    pack $data(upBtn) -side right -padx 4 -fill both
    pack $f1.lab -side left -padx 4 -fill both
    pack $f1.menu -expand yes -fill both -padx 4
    pack $data(dirMenu) -expand yes -fill x -padx 4

    # data(icons): the IconList that list the files and directories.
    #
    if {$class eq "TkFDialog"} {
	if { $data(-multiple) } {
	    set fNameCaption [mc "File &names:"]
	} else {
	    set fNameCaption [mc "File &name:"]
	}
	set fTypeCaption [mc "Files of &type:"]
	set iconListCommand [list ::tk::dialog::file::OkCmd $w]
    } else {
	set fNameCaption [mc "&Selection:"]
	set iconListCommand [list ::tk::dialog::file::chooseDir::DblClick $w]
    }
    set data(icons) [::tk::IconList $w.contents.icons \
	    -command $iconListCommand -multiple $data(-multiple)]
    bind $data(icons) <<ListboxSelect>> \
	    [list ::tk::dialog::file::ListBrowse $w]

    # f2: the frame with the OK button, cancel button, "file name" field
    #     and file types field.
    #
    set f2 [ttk::frame $w.contents.f2]
    bind [::tk::AmpWidget ttk::label $f2.lab -text $fNameCaption -anchor e]\
	    <<AltUnderlined>> [list focus $f2.ent]
    # -pady 0
    set data(ent) [ttk::entry $f2.ent]

    # The font to use for the icons. The default Canvas font on Unix is just
    # deviant.
    set ::tk::$w.contents.icons(font) [$data(ent) cget -font]

    # Make the file types bits only if this is a File Dialog
    if {$class eq "TkFDialog"} {
	set data(typeMenuLab) [::tk::AmpWidget ttk::label $f2.lab2 \
		-text $fTypeCaption -anchor e]
	set data(typeMenu) [ttk::combobox $f2.menu]
	bind $data(typeMenu) <<ComboboxSelected>> \
	    "::tk::dialog::file::SetFilter $w \
	    \[lindex \[list $data(-filetypes)\] \[$data(typeMenu) current\]\]"
	bind $data(typeMenuLab) <<AltUnderlined>> [list focus $data(typeMenu)]
    }

    # The hidden button is displayed when ::tk::dialog::file::showHiddenBtn is
    # true.  Create it disabled so the binding doesn't trigger if it isn't
    # shown.
    if {$class eq "TkFDialog"} {
	set text [mc "Show &Hidden Files and Directories"]
    } else {
	set text [mc "Show &Hidden Directories"]
    }
    set data(hiddenBtn) [::tk::AmpWidget ttk::checkbutton $f2.hidden \
	    -text $text -state disabled \
	    -variable ::tk::dialog::file::showHiddenVar \
	    -command [list ::tk::dialog::file::UpdateWhenIdle $w]]
# -anchor w -padx 3

    # the okBtn is created after the typeMenu so that the keyboard traversal
    # is in the right order, and add binding so that we find out when the
    # dialog is destroyed by the user (added here instead of to the overall
    # window so no confusion about how much <Destroy> gets called; exactly
    # once will do). [Bug 987169]

    set data(okBtn)     [::tk::AmpWidget ttk::button $f2.ok \
	    -text [mc "&OK"]     -default active];# -pady 3]
    bind $data(okBtn) <Destroy> {::tk::dialog::file::Destroyed %W}
    set data(cancelBtn) [::tk::AmpWidget ttk::button $f2.cancel \
	    -text [mc "&Cancel"] -default normal];# -pady 3]

    # grid the widgets in f2
    #
    grid $f2.lab $f2.ent $data(okBtn) -padx 4 -pady 3 -sticky ew
    grid configure $f2.ent -padx 2
    if {$class eq "TkFDialog"} {
	grid $data(typeMenuLab) $data(typeMenu) $data(cancelBtn) \
		-padx 4 -sticky ew
	grid configure $data(typeMenu) -padx 0
	grid $data(hiddenBtn) -columnspan 2 -padx 4 -sticky ew
    } else {
	grid $data(hiddenBtn) - $data(cancelBtn) -padx 4 -sticky ew
    }
    grid columnconfigure $f2 1 -weight 1

    # Pack all the frames together. We are done with widget construction.
    #
    pack $f1 -side top -fill x -pady 4
    pack $f2 -side bottom -pady 4 -fill x
    pack $data(icons) -expand yes -fill both -padx 4 -pady 1

    # Set up the event handlers that are common to Directory and File Dialogs
    #

    wm protocol $w WM_DELETE_WINDOW [list ::tk::dialog::file::CancelCmd $w]
    $data(upBtn)     configure -command [list ::tk::dialog::file::UpDirCmd $w]
    $data(cancelBtn) configure -command [list ::tk::dialog::file::CancelCmd $w]
    bind $w <KeyPress-Escape> [list $data(cancelBtn) invoke]
    bind $w <Alt-Key> [list tk::AltKeyInDialog $w %A]

    # Set up event handlers specific to File or Directory Dialogs
    #
    if {$class eq "TkFDialog"} {
	bind $data(ent) <Return> [list ::tk::dialog::file::ActivateEnt $w]
	$data(okBtn)     configure -command [list ::tk::dialog::file::OkCmd $w]
	bind $w <Alt-t> [format {
	    if {[%s cget -state] eq "readonly"} {
		focus %s
	    }
	} $data(typeMenu) $data(typeMenu)]
    } else {
	set okCmd [list ::tk::dialog::file::chooseDir::OkCmd $w]
	bind $data(ent) <Return> $okCmd
	$data(okBtn) configure -command $okCmd
	bind $w <Alt-s> [list focus $data(ent)]
	bind $w <Alt-o> [list $data(okBtn) invoke]
    }
    bind $w <Alt-h> [list $data(hiddenBtn) invoke]
    bind $data(ent) <Tab> [list ::tk::dialog::file::CompleteEnt $w]

    # Build the focus group for all the entries
    #
    ::tk::FocusGroup_Create $w
    ::tk::FocusGroup_BindIn $w  $data(ent) [list \
	    ::tk::dialog::file::EntFocusIn $w]
    ::tk::FocusGroup_BindOut $w $data(ent) [list \
	    ::tk::dialog::file::EntFocusOut $w]
}

# ::tk::dialog::file::SetSelectMode --
#
#	Set the select mode of the dialog to single select or multi-select.
#
# Arguments:
#	w		The dialog path.
#	multi		1 if the dialog is multi-select; 0 otherwise.
#
# Results:
#	None.

proc ::tk::dialog::file::SetSelectMode {w multi} {
    set dataName __tk_filedialog
    upvar ::tk::dialog::file::$dataName data
    if { $multi } {
	set fNameCaption [mc "File &names:"]
    } else {
	set fNameCaption [mc "File &name:"]
    }
    set iconListCommand [list ::tk::dialog::file::OkCmd $w]
    ::tk::SetAmpText $w.contents.f2.lab $fNameCaption
    $data(icons) configure -multiple $multi -command $iconListCommand
    return
}

# ::tk::dialog::file::UpdateWhenIdle --
#
#	Creates an idle event handler which updates the dialog in idle time.
#	This is important because loading the directory may take a long time
#	and we don't want to load the same directory for multiple times due to
#	multiple concurrent events.
#
proc ::tk::dialog::file::UpdateWhenIdle {w} {
    upvar ::tk::dialog::file::[winfo name $w] data

    if {[info exists data(updateId)]} {
	return
    }
    set data(updateId) [after idle [list ::tk::dialog::file::Update $w]]
}

# ::tk::dialog::file::Update --
#
#	Loads the files and directories into the IconList widget. Also sets up
#	the directory option menu for quick access to parent directories.
#
proc ::tk::dialog::file::Update {w} {
    # This proc may be called within an idle handler. Make sure that the
    # window has not been destroyed before this proc is called
    if {![winfo exists $w]} {
	return
    }
    set class [winfo class $w]
    if {($class ne "TkFDialog") && ($class ne "TkChooseDir")} {
	return
    }

    set dataName [winfo name $w]
    upvar ::tk::dialog::file::$dataName data
    variable showHiddenVar
    variable folderImage
    variable fileImage
    unset -nocomplain data(updateId)

    set folder $folderImage
    set file   $fileImage

    set appPWD [pwd]
    if {[catch {
	cd $data(selectPath)
    }]} then {
	# We cannot change directory to $data(selectPath). $data(selectPath)
	# should have been checked before ::tk::dialog::file::Update is
	# called, so we normally won't come to here. Anyways, give an error
	# and abort action.
	tk_messageBox -type ok -parent $w -icon warning -message [mc \
	       "Cannot change to the directory \"%1\$s\".\nPermission denied."\
		$data(selectPath)]
	cd $appPWD
	return
    }

    # Turn on the busy cursor. BUG?? We haven't disabled X events, though,
    # so the user may still click and cause havoc ...
    #
    set entCursor [$data(ent) cget -cursor]
    set dlgCursor [$w cget -cursor]
    $data(ent) configure -cursor watch
    $w configure -cursor watch
    update idletasks

    $data(icons) deleteall

    set showHidden $showHiddenVar

    # Make the dir list. Note that using an explicit [pwd] (instead of '.') is
    # better in some VFS cases.
    $data(icons) add $folder [GlobFiltered [pwd] d $data(-nativeonly) 1]

    if {$class eq "TkFDialog"} {
	# Make the file list if this is a File Dialog, selecting all but
	# 'd'irectory type files.
	#
	$data(icons) add $file \
	    [GlobFiltered [pwd] {f b c l p s} $data(-nativeonly)]
    }

    # Update the Directory: option menu
    #
    set list ""
    set dir ""
    foreach subdir [file split $data(selectPath)] {
	set dir [file join $dir $subdir]
	lappend list $dir
    }

    $data(dirMenu) configure -values $list
    $data(dirMenu) current end

    # Restore the PWD to the application's PWD
    #
    cd $appPWD

    if {$class eq "TkFDialog"} {
	# Restore the Open/Save Button if this is a File Dialog
	#
	if {$data(type) eq "open"} {
	    ::tk::SetAmpText $data(okBtn) [mc "&Open"]
	} else {
	    ::tk::SetAmpText $data(okBtn) [mc "&Save"]
	}
    }

    # turn off the busy cursor.
    #
    $data(ent) configure -cursor $entCursor
    $w configure -cursor $dlgCursor
}

# ::tk::dialog::file::SetPathSilently --
#
# 	Sets data(selectPath) without invoking the trace procedure
#
proc ::tk::dialog::file::SetPathSilently {w path} {
    upvar ::tk::dialog::file::[winfo name $w] data

    set cb [list ::tk::dialog::file::SetPath $w]
    trace remove variable data(selectPath) write $cb
    set data(selectPath) $path
    trace add variable data(selectPath) write $cb
}


# This proc gets called whenever data(selectPath) is set
#
proc ::tk::dialog::file::SetPath {w name1 name2 op} {
    if {[winfo exists $w]} {
	upvar ::tk::dialog::file::[winfo name $w] data
	UpdateWhenIdle $w
	# On directory dialogs, we keep the entry in sync with the currentdir.
	if {[winfo class $w] eq "TkChooseDir"} {
	    $data(ent) delete 0 end
	    $data(ent) insert end $data(selectPath)
	}
    }
}

# This proc gets called whenever data(filter) is set
#
proc ::tk::dialog::file::SetFilter {w type} {
    upvar ::tk::dialog::file::[winfo name $w] data

    set data(filterType) $type
    set data(filter) [lindex $type 1]

    # If we aren't using a default extension, use the one suppled by the
    # filter.
    if {![info exists data(extUsed)]} {
	if {[string length $data(-defaultextension)]} {
	    set data(extUsed) 1
	} else {
	    set data(extUsed) 0
	}
    }

    if {!$data(extUsed)} {
	# Get the first extension in the list that matches {^\*\.\w+$} and
	# remove all * from the filter.
	set index [lsearch -regexp $data(filter) {^\*\.\w+$}]
	if {$index >= 0} {
	    set data(-defaultextension) \
		    [string trimleft [lindex $data(filter) $index] "*"]
	} else {
	    # Couldn't find anything!  Reset to a safe default...
	    set data(-defaultextension) ""
	}
    }

    $data(icons) see 0

    UpdateWhenIdle $w
}

# tk::dialog::file::ResolveFile --
#
#	Interpret the user's text input in a file selection dialog.  Performs:
#
#	(1) ~ substitution
#	(2) resolve all instances of . and ..
#	(3) check for non-existent files/directories
#	(4) check for chdir permissions
#	(5) conversion of environment variable references to their
#	    contents (once only)
#
# Arguments:
#	context:  the current directory you are in
#	text:	  the text entered by the user
#	defaultext: the default extension to add to files with no extension
#	expandEnv: whether to expand environment variables (yes by default)
#
# Return vaue:
#	[list $flag $directory $file]
#
#	 flag = OK	: valid input
#	      = PATTERN	: valid directory/pattern
#	      = PATH	: the directory does not exist
#	      = FILE	: the directory exists by the file doesn't exist
#	      = CHDIR	: Cannot change to the directory
#	      = ERROR	: Invalid entry
#
#	 directory      : valid only if flag = OK or PATTERN or FILE
#	 file           : valid only if flag = OK or PATTERN
#
#	directory may not be the same as context, because text may contain a
#	subdirectory name
#
proc ::tk::dialog::file::ResolveFile {context text defaultext {expandEnv 1}} {
    set appPWD [pwd]

    set path [JoinFile $context $text]

    # If the file has no extension, append the default.  Be careful not to do
    # this for directories, otherwise typing a dirname in the box will give
    # back "dirname.extension" instead of trying to change dir.
    if {
	![file isdirectory $path] && ([file ext $path] eq "") &&
	![string match {$*} [file tail $path]]
    } then {
	set exists 0
	catch {set exists [file exists $path]}
	if {!$exists} {
	    set path "$path$defaultext"
	}
    }

    if {[catch {file exists $path}]} {
	# This "if" block can be safely removed if the following code stop
	# generating errors.
	#
	#	file exists ~nonsuchuser
	#
	return [list ERROR $path ""]
    }

    if {[file exists $path]} {
	if {[file isdirectory $path]} {
	    if {[catch {cd $path}]} {
		return [list CHDIR $path ""]
	    }
	    set directory [pwd]
	    set file ""
	    set flag OK
	    cd $appPWD
	} else {
	    if {[catch {cd [file dirname $path]}]} {
		return [list CHDIR [file dirname $path] ""]
	    }
	    set directory [pwd]
	    set file [file tail $path]
	    set flag OK
	    cd $appPWD
	}
    } else {
	set dirname [file dirname $path]
	if {[file exists $dirname]} {
	    if {[catch {cd $dirname}]} {
		return [list CHDIR $dirname ""]
	    }
	    set directory [pwd]
	    cd $appPWD
	    set file [file tail $path]
	    # It's nothing else, so check to see if it is an env-reference
	    if {$expandEnv && [string match {$*} $file]} {
		set var [string range $file 1 end]
		if {[info exist ::env($var)]} {
		    return [ResolveFile $context $::env($var) $defaultext 0]
		}
	    }
	    if {[regexp {[*?]} $file]} {
		set flag PATTERN
	    } else {
		set flag FILE
	    }
	} else {
	    set directory $dirname
	    set file [file tail $path]
	    set flag PATH
	    # It's nothing else, so check to see if it is an env-reference
	    if {$expandEnv && [string match {$*} $file]} {
		set var [string range $file 1 end]
		if {[info exist ::env($var)]} {
		    return [ResolveFile $context $::env($var) $defaultext 0]
		}
	    }
	}
    }

    return [list $flag $directory $file]
}


# Gets called when the entry box gets keyboard focus. We clear the selection
# from the icon list . This way the user can be certain that the input in the
# entry box is the selection.
#
proc ::tk::dialog::file::EntFocusIn {w} {
    upvar ::tk::dialog::file::[winfo name $w] data

    if {[$data(ent) get] ne ""} {
	$data(ent) selection range 0 end
	$data(ent) icursor end
    } else {
	$data(ent) selection clear
    }

    if {[winfo class $w] eq "TkFDialog"} {
	# If this is a File Dialog, make sure the buttons are labeled right.
	if {$data(type) eq "open"} {
	    ::tk::SetAmpText $data(okBtn) [mc "&Open"]
	} else {
	    ::tk::SetAmpText $data(okBtn) [mc "&Save"]
	}
    }
}

proc ::tk::dialog::file::EntFocusOut {w} {
    upvar ::tk::dialog::file::[winfo name $w] data

    $data(ent) selection clear
}


# Gets called when user presses Return in the "File name" entry.
#
proc ::tk::dialog::file::ActivateEnt {w} {
    upvar ::tk::dialog::file::[winfo name $w] data

    set text [$data(ent) get]
    if {$data(-multiple)} {
	foreach t $text {
	    VerifyFileName $w $t
	}
    } else {
	VerifyFileName $w $text
    }
}

# Verification procedure
#
proc ::tk::dialog::file::VerifyFileName {w filename} {
    upvar ::tk::dialog::file::[winfo name $w] data

    set list [ResolveFile $data(selectPath) $filename $data(-defaultextension)]
    foreach {flag path file} $list {
	break
    }

    switch -- $flag {
	OK {
	    if {$file eq ""} {
		# user has entered an existing (sub)directory
		set data(selectPath) $path
		$data(ent) delete 0 end
	    } else {
		SetPathSilently $w $path
		if {$data(-multiple)} {
		    lappend data(selectFile) $file
		} else {
		    set data(selectFile) $file
		}
		Done $w
	    }
	}
	PATTERN {
	    set data(selectPath) $path
	    set data(filter) $file
	}
	FILE {
	    if {$data(type) eq "open"} {
		tk_messageBox -icon warning -type ok -parent $w \
			-message [mc "File \"%1\$s\"  does not exist." \
			[file join $path $file]]
		$data(ent) selection range 0 end
		$data(ent) icursor end
	    } else {
		SetPathSilently $w $path
		if {$data(-multiple)} {
		    lappend data(selectFile) $file
		} else {
		    set data(selectFile) $file
		}
		Done $w
	    }
	}
	PATH {
	    tk_messageBox -icon warning -type ok -parent $w \
		    -message [mc "Directory \"%1\$s\" does not exist." $path]
	    $data(ent) selection range 0 end
	    $data(ent) icursor end
	}
	CHDIR {
	    tk_messageBox -type ok -parent $w -icon warning -message  \
		[mc "Cannot change to the directory\
                     \"%1\$s\".\nPermission denied." $path]
	    $data(ent) selection range 0 end
	    $data(ent) icursor end
	}
	ERROR {
	    tk_messageBox -type ok -parent $w -icon warning -message \
		    [mc "Invalid file name \"%1\$s\"." $path]
	    $data(ent) selection range 0 end
	    $data(ent) icursor end
	}
    }
}

# Gets called when user presses the Alt-s or Alt-o keys.
#
proc ::tk::dialog::file::InvokeBtn {w key} {
    upvar ::tk::dialog::file::[winfo name $w] data

    if {[$data(okBtn) cget -text] eq $key} {
	$data(okBtn) invoke
    }
}

# Gets called when user presses the "parent directory" button
#
proc ::tk::dialog::file::UpDirCmd {w} {
    upvar ::tk::dialog::file::[winfo name $w] data

    if {$data(selectPath) ne "/"} {
	set data(selectPath) [file dirname $data(selectPath)]
    }
}

# Join a file name to a path name. The "file join" command will break if the
# filename begins with ~
#
proc ::tk::dialog::file::JoinFile {path file} {
    if {[string match {~*} $file] && [file exists $path/$file]} {
	return [file join $path ./$file]
    } else {
	return [file join $path $file]
    }
}

# Gets called when user presses the "OK" button
#
proc ::tk::dialog::file::OkCmd {w} {
    upvar ::tk::dialog::file::[winfo name $w] data

    set filenames {}
    foreach item [$data(icons) selection get] {
	lappend filenames [$data(icons) get $item]
    }

    if {
	([llength $filenames] && !$data(-multiple)) ||
	($data(-multiple) && ([llength $filenames] == 1))
    } then {
	set filename [lindex $filenames 0]
	set file [JoinFile $data(selectPath) $filename]
	if {[file isdirectory $file]} {
	    ListInvoke $w [list $filename]
	    return
	}
    }

    ActivateEnt $w
}

# Gets called when user presses the "Cancel" button
#
proc ::tk::dialog::file::CancelCmd {w} {
    variable selectFilePath

    set selectFilePath ""
}

# Gets called when user destroys the dialog directly [Bug 987169]
#
proc ::tk::dialog::file::Destroyed {okBtn} {
    variable selectFilePath

    bind $okBtn <Destroy> {}
    set selectFilePath ""
}

# Gets called when user browses the IconList widget (dragging mouse, arrow
# keys, etc)
#
proc ::tk::dialog::file::ListBrowse {w} {
    upvar ::tk::dialog::file::[winfo name $w] data

    set text {}
    foreach item [$data(icons) selection get] {
	lappend text [$data(icons) get $item]
    }
    if {[llength $text] == 0} {
	return
    }
    if {$data(-multiple)} {
	set newtext {}
	foreach file $text {
	    set fullfile [JoinFile $data(selectPath) $file]
	    if { ![file isdirectory $fullfile] } {
		lappend newtext $file
	    }
	}
	set text $newtext
	set isDir 0
    } else {
	set text [lindex $text 0]
	set file [JoinFile $data(selectPath) $text]
	set isDir [file isdirectory $file]
    }
    if {!$isDir} {
	$data(ent) delete 0 end
	$data(ent) insert 0 $text

	if {[winfo class $w] eq "TkFDialog"} {
	    if {$data(type) eq "open"} {
		::tk::SetAmpText $data(okBtn) [mc "&Open"]
	    } else {
		::tk::SetAmpText $data(okBtn) [mc "&Save"]
	    }
	}
    } elseif {[winfo class $w] eq "TkFDialog"} {
	::tk::SetAmpText $data(okBtn) [mc "&Open"]
    }
}

# Gets called when user invokes the IconList widget (double-click, Return key,
# etc)
#
proc ::tk::dialog::file::ListInvoke {w filenames} {
    upvar ::tk::dialog::file::[winfo name $w] data

    if {[llength $filenames] == 0} {
	return
    }

    set file [JoinFile $data(selectPath) [lindex $filenames 0]]

    set class [winfo class $w]
    if {$class eq "TkChooseDir" || [file isdirectory $file]} {
	set appPWD [pwd]
	if {[catch {cd $file}]} {
	    tk_messageBox -type ok -parent $w -icon warning -message \
		    [mc "Cannot change to the directory \"%1\$s\".\nPermission denied." $file]
	} else {
	    cd $appPWD
	    set data(selectPath) $file
	}
    } else {
	if {$data(-multiple)} {
	    set data(selectFile) $filenames
	} else {
	    set data(selectFile) $file
	}
	Done $w
    }
}

# ::tk::dialog::file::Done --
#
#	Gets called when user has input a valid filename.  Pops up a dialog
#	box to confirm selection when necessary.  Sets the namespace variable
#	"selectFilePath", which will break the "vwait" loop
#	in ::tk::dialog::file:: and return the selected filename to the script
#	that calls tk_getOpenFile or tk_getSaveFile
#
proc ::tk::dialog::file::Done {w {selFilePath ""}} {
    variable selectFilePath
    upvar ::tk::dialog::file::[winfo name $w] data

    if {$selFilePath eq ""} {
	if {$data(-multiple)} {
	    set selFilePath {}
	    foreach f $data(selectFile) {
		lappend selFilePath [JoinFile $data(selectPath) $f]
	    }
	} else {
	    set selFilePath [JoinFile $data(selectPath) $data(selectFile)]
	}

	set ::tk::Priv(selectFile) $data(selectFile)
	set ::tk::Priv(selectPath) $data(selectPath)

	if {($data(type) eq "save") && $data(-confirmoverwrite) && [file exists $selFilePath]} {
	    set reply [tk_messageBox -icon warning -type yesno -parent $w \
		    -message [mc "File \"%1\$s\" already exists.\nDo you want\
		    to overwrite it?" $selFilePath]]
	    if {$reply eq "no"} {
		return
	    }
	}
	if {
	    [info exists data(-typevariable)] && $data(-typevariable) ne ""
	    && [info exists data(-filetypes)] && [llength $data(-filetypes)]
	    && [info exists data(filterType)] && $data(filterType) ne ""
	} then {
	    upvar #0 $data(-typevariable) typeVariable
	    set typeVariable [lindex $data(origfiletypes) \
		    [lsearch -exact $data(-filetypes) $data(filterType)] 0]
	}
    }

    set selectFilePath $selFilePath
}

# ::tk::dialog::file::GlobFiltered --
#
#	Gets called to do globbing, returning the results and filtering them
#	according to the current filter (and removing the entries for '.' and
#	'..' which are never shown). Deals with evil cases such as where the
#	user is supplying a filter which is an invalid list or where it has an
#	unbalanced brace. The resulting list will be dictionary sorted.
#
#	Arguments:
#	  dir		 Which directory to search
#	  type		 List of filetypes to look for ('d' or 'f b c l p s')
#	  nativeonly	 When true only native files (no mounts)
#	  overrideFilter Whether to ignore the filter for this search.
#
#	NB: Assumes that the caller has mapped the state variable to 'data'.
#
proc ::tk::dialog::file::GlobFiltered {dir type nativeonly {overrideFilter 0}} {
    variable showHiddenVar
    upvar 1 data(filter) filter

    if {$filter eq "*" || $overrideFilter} {
	set patterns [list *]
	if {$showHiddenVar} {
	    lappend patterns .*
	}
    } elseif {[string is list $filter]} {
	set patterns $filter
    } else {
	# Invalid list; assume we can use non-whitespace sequences as words
	set patterns [regexp -inline -all {\S+} $filter]
    }

    set opts [list -tails -directory $dir -type $type -nocomplain]

    set result {}
    catch {
	# We have a catch because we might have a really bad pattern (e.g.,
	# with an unbalanced brace); even [glob -nocomplain] doesn't like it.
	# Using a catch ensures that it just means we match nothing instead of
	# throwing a nasty error at the user...
	foreach f [glob {*}$opts -- {*}$patterns] {
	    if {$f eq "." || $f eq ".."} {
		continue
	    }
	    if {$nativeonly} {
		if {"native" ni [file system [file join $dir $f]]} {
		    continue
		}
	    }
	    # See ticket [1641721], $f might be a link pointing to a dir
	    if {$type != "d" && [file isdir [file join $dir $f]]} {
		continue
	    }
	    lappend result $f
	}
    }
    return [lsort -dictionary -unique $result]
}

proc ::tk::dialog::file::CompleteEnt {w} {
    upvar ::tk::dialog::file::[winfo name $w] data
    set f [$data(ent) get]
    if {$data(-multiple)} {
	if {![string is list $f] || [llength $f] != 1} {
	    return -code break
	}
	set f [lindex $f 0]
    }

    # Get list of matching filenames and dirnames
    set files [if {[winfo class $w] eq "TkFDialog"} {
	GlobFiltered $data(selectPath) {f b c l p s} $data(-nativeonly)
    }]
    set dirs2 {}
    foreach d [GlobFiltered $data(selectPath) d $data(-nativeonly)] {
	lappend dirs2 $d/
    }

    set targets [concat \
	    [lsearch -glob -all -inline $files $f*] \
	    [lsearch -glob -all -inline $dirs2 $f*]]

    if {[llength $targets] == 1} {
	# We have a winner!
	set f [lindex $targets 0]
    } elseif {$f in $targets || [llength $targets] == 0} {
	if {[string length $f] > 0} {
	    bell
	}
	return
    } elseif {[llength $targets] > 1} {
	# Multiple possibles
	if {[string length $f] == 0} {
	    return
	}
	set t0 [lindex $targets 0]
	for {set len [string length $t0]} {$len>0} {} {
	    set allmatch 1
	    foreach s $targets {
		if {![string equal -length $len $s $t0]} {
		    set allmatch 0
		    break
		}
	    }
	    incr len -1
	    if {$allmatch} break
	}
	set f [string range $t0 0 $len]
    }

    if {$data(-multiple)} {
	set f [list $f]
    }
    $data(ent) delete 0 end
    $data(ent) insert 0 $f
    return -code break
}
