'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\" Copyright (c) 2018 Christian Werner <chw at ch minus werner dot de>
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
.TH snap7 n 8.6 Tcl "Tcl Extension Commands"
.\" ---- man.macros begin ----
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.\" ---- man.macros end ----
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
snap7 \- Tcl interface to the Snap7 library
.SH SYNOPSIS
package require \fBTcl 8.6\fR
.sp
package require \fBsnap7\fR
.sp
\fBsnap7::new\fR \fIcmd\fR
.sp
\fIcmd\fR \fBdestroy\fR
.sp
\fIcmd\fR \fBconnect\fR \fIaddr port rack slot\fR
.sp
\fIcmd\fR \fBdisconnect\fR
.sp
\fIcmd\fR \fBconntype\fR \fItype\fR
.sp
\fIcmd\fR \fBparam\fR ?\fIname\fR? ?\fIvalue\fR?
.sp
\fIcmd\fR \fBisconnected\fR
.sp
\fIcmd\fR \fBpdulength\fR
.sp
\fIcmd\fR \fBdbread\fR \fIdb start count\fR
.sp
\fIcmd\fR \fBdbreada\fR \fIdb start count\fR
.sp
\fIcmd\fR \fBdbwrite\fR \fIdb start data ...\fR
.sp
\fIcmd\fR \fBdbwritea\fR \fIdb start bytes\fR
.sp
.BE
.SH DESCRIPTION
This package provides a Tcl interface to the Snap7 library (see
http://snap7.sourceforge.net) using Ffidl and TclOO.
.SH COMMANDS
.TP
\fBsnap7::new\fR \fIcmd\fR
Creates a new command \fIcmd\fR which implements a Snap7 connection
object. Further operations on that object are carried out by invoking
methods on \fIcmd\fR.
.TP
\fIcmd\fR \fBdestroy\fR
Destroys the connection object \fIcmd\fR, releases resources and closes
communications links.
.TP
\fIcmd\fR \fBconnect\fR \fIaddr port rack slot\fR
Connects the connection object \fIcmd\fR to its peer using the IP
address \fIaddr\fR, the TCP port number \fIport\fR and further
address information (\fIrack\fR and \fIslot\fR numbers).
.TP
\fIcmd\fR \fBdisconnect\fR
Closes the connection of the connection object \fIcmd\fR.
.TP
\fIcmd\fR \fBconntype\fR \fItype\fR
Sets the connection type of the connection object \fIcmd\fR. Must be called
before a connection is made using the \fBconnect\fR method. Valid values
for \fItype\fR are 1 (PG), 2 (OP), and 3 (basic).
.TP
\fIcmd\fR \fBparam\fR ?\fIname\fR? ?\fIvalue\fR?
If invoked without arguments, returns a list of parameter names which
can be queried or set on the connection object \fIcmd\fR. If \fIname\fR
is provided, a query of this named parameter is performed. If both,
\fIname\fR and \fIvalue\fR are provided, the named parameter is set
to the value given.
.TP
\fIcmd\fR \fBisconnected\fR
Returns true or false depending on connection state of the
connection object \fIcmd\fR.
.TP
\fIcmd\fR \fBpdulength\fR
Returns a two element list made up of requested and negotiated PDU
length of the connection object \fIcmd\fR.
.TP
\fIcmd\fR \fBdbread\fR \fIdb start count\fR
Reads \fIcount\fR bytes beginning at \fIstart\fR from the data block
\fIdb\fR using the connection object \fIcmd\fR. Data is returned
as a list of integer numbers.
.TP
\fIcmd\fR \fBdbreada\fR \fIdb start count\fR
Reads \fIcount\fR bytes beginning at \fIstart\fR from the data block
\fIdb\fR using the connection object \fIcmd\fR. Data is returned
as a byte array.
.TP
\fIcmd\fR \fBdbwrite\fR \fIdb start data ...\fR
Writes the numbers specified by \fIdata\fR and following arguments
as bytes beginning at \fIstart\fR into the data block \fIdb\fR using
the connection object \fIcmd\fR.
.TP
\fIcmd\fR \fBdbwritea\fR \fIdb start bytes\fR
Writes the byte array \fIbytes\fR beginning at \fIstart\fR into the
data block \fIdb\fR using the connection object \fIcmd\fR.
.SH KEYWORDS
Ffidl, PLC, S7
.SH COPYRIGHT
.nf
Copyright (c) 2018 chw at ch minus werner dot de
.fi
