# -*- tcl -*-
# ### ### ### ######### ######### #########
## Terminal packages - ANSI - Control operations
## (Unix specific implementation).

## This was originally taken from page 11820 (Pure Tcl Console Editor)
## of the Tcler's Wiki, however page 14693 (Reading a single character
## ...) is the same in a more self-contained manner.

# ### ### ### ######### ######### #########
## Requirements

namespace eval ::term::ansi::ctrl::unix {}

# ### ### ### ######### ######### #########
## Make command easily available

proc ::term::ansi::ctrl::unix::import {{ns ctrl} args} {
    if {![llength $args]} {set args *}
    set args ::term::ansi::ctrl::unix::[join $args " ::term::ansi::ctrl::unix::"]
    uplevel 1 [list namespace eval ${ns} [linsert $args 0 namespace import]]
    return
}

# ### ### ### ######### ######### #########
## API

proc ::term::ansi::ctrl::unix::raw {} {
    fconfigure stdin -inputmode raw
}

proc ::term::ansi::ctrl::unix::cooked {} {
    fconfigure stdin -inputmode normal
}

proc ::term::ansi::ctrl::unix::columns {} {
    lassign [fconfigure stdout -winsize] cols rows
    return $cols
}

proc ::term::ansi::ctrl::unix::rows {} {
    lassign [fconfigure stdout -winsize] cols rows
    return $rows
}

# ### ### ### ######### ######### #########
## Package setup

namespace eval ::term::ansi::ctrl::unix {
    namespace export columns rows raw cooked
}

# ### ### ### ######### ######### #########
## Ready

package provide term::ansi::ctrl::unix 0.2.1

##
# ### ### ### ######### ######### #########
