#
# gui_temp_sys.tcl
#
# GUI for interactively driving hardware described in temp_sys.tcl.
#

package require Tk
package require tfirmata

# gui element variables
set greenTemp 0
set yellowTemp 0
set redTemp 0
set lamp 0
set heartbeat 0
set bd ""

proc buildGui {} {
    # gui elements
    wm title . Temperature
    ttk::frame .f
    ttk::label .f.greenLedLabel -text "Green temp LED: "
    ttk::label .f.yellowLedLabel -text "Yellow temp LED: "
    ttk::label .f.redLedLabel -text "Red temp LED: "
    ttk::entry .f.greenLedEntry -width 4 -textvariable greenTemp
    ttk::entry .f.yellowLedEntry -width 4 -textvariable yellowTemp
    ttk::entry .f.redLedEntry -width 4 -textvariable redTemp
    ttk::checkbutton .f.lampLedChkBtn -text Lamp -variable lamp \
            -command lampEvent
    ttk::checkbutton .f.heartBeatLedChkBtn -text "Heartbeat" \
            -variable heartbeat -command heartBeatEvent
    ttk::label .f.lampEnLabel -text "Lamp enable: "
    ttk::label .f.lampEnValLabel -text -
    ttk::label .f.tempLabel -text "Temp: "
    ttk::label .f.tempValLabel -text -
    ttk::label .f.ldrLabel -text "LDR: "
    ttk::label .f.ldrValLabel -text -

    # layout gui
    grid .f -padx 10 -pady 10
    grid .f.greenLedLabel .f.greenLedEntry 
    grid .f.yellowLedLabel .f.yellowLedEntry -pady 2
    grid .f.redLedLabel .f.redLedEntry
    grid x .f.lampLedChkBtn -pady {10 0}
    grid x .f.heartBeatLedChkBtn
    grid .f.lampEnLabel .f.lampEnValLabel -pady {5 0}
    grid .f.tempLabel .f.tempValLabel 
    grid .f.ldrLabel .f.ldrValLabel
    foreach slave [grid slaves .f -column 0] {
        grid $slave -sticky e
    }
    foreach slave [grid slaves .f -column 1] {
        grid $slave -sticky w
    }

    # bind return to each of the temperature LED entries
    bind .f.greenLedEntry <KeyPress-Return> {ledEvent green}
    bind .f.yellowLedEntry <KeyPress-Return> {ledEvent yellow}
    bind .f.redLedEntry <KeyPress-Return> {ledEvent red}
}

# event handler for lamp checkbutton
proc lampEvent {} {
    $::bd dset 12 $::lamp
}

# event handler for heartbeat checkbutton
proc heartBeatEvent {} {
    $::bd dset 13 $::heartbeat
}

# event handler for temperature LED entry update
proc ledEvent {colour} {
    set var ${colour}Temp
    global bd $var
    set val [set $var]
    if {![string is integer $val] || $val < 0} {
        set $var 0
    } elseif {$val > 255} {
        set $var 255
    }
    $bd aset [dict get {green 3 yellow 5 red 6} $colour] $val
    focus .f
}

# open connection to board and configure
proc configureBoard {} {
    global bd
    set bd [tfirmata::open /dev/ttyUSB0]
    $bd mode 2 in 3 5 6 pwm 12 13 out
    $bd aset 3 0 5 0 6 0
    $bd dset 2 1 12 0 13 0
    $bd period 500
    $bd dstream 0 on
    $bd astream 0 on
    $bd dcommand bdEnEvent
    $bd acommand bdLdrEvent
    $bd twiconfig
    $bd twiset 0x48 0xee
    $bd twiget -repeat 0x48 0xaa 2 -command {bdTempEvent [lindex [list %D] 0]}
}

# board lamp enable event handler
proc bdEnEvent {} {
    .f.lampEnValLabel configure -text [$::bd dget 2]
}

# board LDR event handler
proc bdLdrEvent {} {
    .f.ldrValLabel configure -text [$::bd aget 0]
}

# board temperature event handler
proc bdTempEvent {temp} {
    .f.tempValLabel configure -text $temp
}

buildGui
update
configureBoard

