#
# ia_servo.tcl
#
# Provides commands for setting servo limits and angle for use with an
# interactive shell
#

package require tfirmata

set low 1000
set high 2000
set angle 0

set bd [tfirmata::open /dev/ttyUSB0]
$bd servolimits 10 [list $low $high]
$bd mode 10 servo
$bd aset 10 $angle

proc low {args} {
    global low high bd
    if {$args == ""} {
        puts $low
    } else {
        set low $args
        $bd servolimits 10 [list $low $high]
    }
}

proc high {args} {
    global low high bd
    if {$args == ""} {
        puts $high
    } else {
        set high $args
        $bd servolimits 10 [list $low $high]
    }
}

proc angle {args} {
    global angle bd
    if {$args == ""} {
        puts $angle
    } else {
        set angle $args
        $bd aset 10 $angle
    }
}

puts "\n"
puts "low ?l?   get/set low limit"
puts "high ?h?  get/set high limit"
puts "angle ?a? get/set angle"
puts ""

