#
# ia_temp_sys.tcl
#
# Script for interactively driving hardware described in temp_sys.tcl.
#

package require tfirmata

set bd [tfirmata::open /dev/ttyUSB0]

# configure board
$bd mode 2 in 3 5 6 pwm 12 13 out
$bd period 1000
$bd dstream 0 on
$bd astream 0 on
$bd twiconfig
$bd twiset 0x48 0xee
$bd twiget -repeat 0x48 0xaa 2 -command {set ::temp [lindex [list %D] 0]}

set temp 0
set green 0
set yellow 0
set red 0
set lampOn 0
set hb 0

proc en {} {
    return [$::bd dget 2]
}

proc temp {} {
    return $::temp
}

proc ldr {} {
    return [$::bd aget 0]
}

proc green {{val ""}} {
    setLedValue green $val
}

proc yellow {{val ""}} {
    setLedValue yellow $val
}

proc red {{val ""}} {
    setLedValue red $val
}

proc setLedValue {col val} {
    global bd $col
    if {$val == ""} {
        return [set $col]
    } else {
        set $col $val
        $bd aset [dict get {green 3 yellow 5 red 6} $col] $val
    }
}

proc lamp {{val ""}} {
    setDigOut lampOn $val
}

proc hb {{val ""}} {
    setDigOut hb $val
}

proc setDigOut {out val} {
    global bd $out
    if {$val == ""} {
        return [set $out]
    } else {
        set $out $val
        $::bd dset [dict get {lampOn 12 hb 13} $out] $val
    }
}

proc help {} {
    puts ""
    puts "en     get lamp enable switch state"
    puts "temp   get temperature"
    puts "ldr    get LDR reading"
    puts "green  get/set green LED analog setting (?val?)"
    puts "yellow get/set green LED analog setting (?val?)"
    puts "red    get/set green LED analog setting (?val?)"
    puts "lamp   get/set lamp output (?val?)"
    puts "hb     get/set heartbeat LED (?val?)"
    puts ""
}

$bd dset 2 1 12 $lampOn 13 $hb
$bd aset 3 $green 5 $yellow 6 $red

help

