#
# serial.tcl
#
# Configures a SW serial port on pins 2 (RX) and 4 (TX)
# and sends a periodic message
#

package require tfirmata

proc print_serial {chan value} {
    puts "RX $chan: $value"
}

set bd [tfirmata::open /dev/ttyUSB0]

$bd sercommand {print_serial %C %V}

$bd serconfig 8 115200 2 4
$bd serread 8 0 0
$bd serlisten 8

while {1} {
    puts "TX 8: Hello World!"
    $bd serwrite 8 "Hello World!\r\n"
    tfirmata::sleep 1000
}

