#
# servenc.tcl
#
# Configures servo on pin 10 and encoder on pins 2, 3,
# then controls the servo using the encoder position
#

package require tfirmata

set bd [tfirmata::open /dev/ttyUSB0]
$bd eattach 0 2 3
$bd mode 10 servo
$bd servolimits 10 {1800 2800}

# set callback
$bd ecommand [list handle_encoder $bd %C %V]

# enable reports
$bd ereport on

# callback function
proc handle_encoder {bd enc val} {
    if {$val >= -90 && $val <= 90} {
        $bd aset 10 [expr {$val + 90}]
    }
}

# main loop
$bd ereset 0
while {1} {
    tfirmata::sleep 10000
}
