#
# stepper.tcl
#
# Configures stepper on pins 9-12, then repeatedly 
# moves the stepper between two positions with a
# short pause in between
#

package require tfirmata

set bd [tfirmata::open /dev/ttyUSB0]
$bd stepconfig 0 1 4 2050 10 12 9 11

puts RUN
while {1} {
    puts CW
    $bd step 0 4100 150 120 120
    if {[$bd stepwait 1 10000] == 0} {
        puts HALT
        $bd step 0 0 0
    }
    puts STOP
    $bd stepoff 0
    tfirmata::sleep 3000
    puts CCW
    $bd step 0 -4100 150 120 120
    if {[$bd stepwait 1 10000] == 0} {
        puts HALT
        $bd step 0 0 0
    }
    puts STOP
    $bd stepoff 0
    tfirmata::sleep 3000
}

