#
# twi_ads1115.tcl
#
# Enables TWI pins, and reads AIN0..AIN3 from a ADS1115 A/D converter
# every second.
#

package require tfirmata

proc print16b {text hi lo args} {
    set v [expr {($hi << 8) | $lo}]
    if {$v > 0x7fff} {
        set v [expr {-(0x10000 - $v)}]
    }
    # single ended measurement with FSR=6.144V
    set u [expr {$v * 0.0001875}]
    puts [format "%s: %2.4fV" $text $u]
}

set bd [tfirmata::open /dev/ttyUSB0]
$bd twiconfig

set addr 0x48
while {1} {
    # input mux AINn=GND, single ended, FSR=6.144V,
    # continuous conversion mode, 128 SPS
    $bd twiset $addr 1 0xc0 0x83
    tfirmata::sleep 20
    print16b AIN0 {*}[$bd twiget $addr 0 2]
    $bd twiset $addr 1 0xd0 0x83
    tfirmata::sleep 20
    print16b AIN1 {*}[$bd twiget $addr 0 2]
    $bd twiset $addr 1 0xe0 0x83
    tfirmata::sleep 20
    print16b AIN2 {*}[$bd twiget $addr 0 2]
    $bd twiset $addr 1 0xf0 0x83
    tfirmata::sleep 20
    print16b AIN3 {*}[$bd twiget $addr 0 2]
    tfirmata::sleep 1000
}

