#
# twi_ads1115.tcl
#
# Enables TWI pins, and reads all AINs from a ADS1115 A/D converter
# using a repeat twiget construct.
#

package require tfirmata

proc print16b {bd hi lo args} {
    set v [expr {($hi << 8) | $lo}]
    if {$v > 0x7fff} {
        set v [expr {-(0x10000 - $v)}]
    }
    # single ended measurement with FSR=6.144V
    set u [expr {$v * 0.0001875}]
    puts [format "AIN%d: %2.4fV" $::mux $u]
    # switch input mux to next pin
    if {[incr ::mux] > 3} {
        set ::mux 0
    }
    $bd twiset $::addr 1 [expr {0xc0 | ($::mux << 4)}] 0x83
}

set bd [tfirmata::open /dev/ttyUSB0]
$bd twiconfig
$bd period 500

set addr 0x48
set mux  0

# input mux AINn=GND, single ended, FSR=6.144V,
# continuous conversion mode, 128 SPS
$bd twiset $addr 1 [expr {0xc0 | ($mux << 4)}] 0x83

# read conversion register with repeat
$bd twiget -repeat $addr 0 2 -command [list print16b $bd %D]
while {1} {
    tfirmata::sleep 2000
}

