#!/usr/bin/env tclsh

package require upnp
package require didl

set dir [file dirname [info script]]
upnp advertise $dir/mediaserver/MediaServerDevDesc.xml

namespace eval MediaServer {
    variable mimetypes {
	.gif	image/gif
	.png	image/png
	.jpg	image/jpeg
	.mp3	audio/mpeg
	.wma	audio/x-ms-wma
	.mp4a	audio/mp4
	.ra 	audio/x-pn-realaudio
	.flac	audio/x-flac
	.ogg	audio/ogg
	.mpg	video/mpeg
	.avi	video/avi
	.mp4	video/mp4
	.mp2	video/mpeg2
	.m4v	video/x-m4v
    }
    
    namespace eval ContentDirectory {
	namespace eval Control {
	    namespace path ::MediaServer
	    variable globcache {0 .}
	    variable docroot \
	      [file normalize [file join $dir mediaserver library]]
	    variable updateid 0
	    namespace ensemble create -subcommands {
		GetSearchCapabilities
		GetSortCapabilities
		GetSystemUpdateID
		Browse
		Search
		QueryStateVariable
	    }
	}
    }
    namespace eval ConnectionManager {
	namespace eval Control {
	    namespace path ::MediaServer
	    namespace ensemble create -subcommands {
		GetProtocolInfo
		GetCurrentConnectionIDs
		GetCurrentConnectionInfo
		QueryStateVariable
	    }
	}
    }
}

proc MediaServer::mime {name} {
    variable mimetypes
    set ext [file extension $name]
    if {[dict exists $mimetypes $ext]} {
	set mime [dict get $mimetypes $ext]
    } else {
	set mime *
    }
    return http-get:*:$mime:*
}

proc MediaServer::mimetypes {} {
    variable mimetypes
    return [lmap n [lsort -unique [dict values $mimetypes]] {
	format http-get:*:%s:* $n
    }]
}

proc MediaServer::ContentDirectory::Control::GetSortCapabilities {argdict} {
    return [dict create SortCaps dc:title,dc:date]
}

proc MediaServer::ContentDirectory::Control::GetSortCapabilities {argdict} {
    return [dict create SearchCaps dc:title]
}

proc MediaServer::ContentDirectory::Control::GetSystemUpdateID {argdict} {
    variable updateid
    return [dict create Id $updateid]
}

proc MediaServer::ContentDirectory::Control::Browse {argdict} {
    # Input args:
    # ObjectID BrowseFlag Filter StartingIndex RequestedCount SortCriteria
    variable globcache
    variable docroot
    variable updateid
    dict with argdict {}
    set len [string length $docroot]
    set path \
      [file normalize [file join $docroot [dict get $globcache $ObjectID]]]
    set sock [namespace tail [info coroutine]]
    set host [format {%1$s:%3$d} {*}[fconfigure $sock -sockname]]
    set didl {}
    set cnt 0
    foreach n [glob -nocomplain -dir $path $Filter] {
	if {$n in {. ..}} continue
	set cont [dict create dc:title [file tail $n]]
	file stat $n stat
	set id $ObjectID,$stat(ino)
	# This strips off one more character than $docroot on purpose: the /
	set name [string replace $n 0 $len]
	dict set globcache $id $name
	set attr [dict create id $id parentID $ObjectID restricted 1]
	if {$stat(type) eq "directory"} {
	    dict set attr searchable 1
	    dict set attr childCount [llength [glob -nocomplain -dir $n *]]
	    dict set cont upnp:class object.container
	    dict lappend didl container \
	      [dict create attributes $attr contents $cont]
	} else {
	    dict set cont upnp:class object.item
	    set res [dict create protocolInfo [mime $n] size $stat(size)]
	    set value http://$host/library/$name
	    dict set cont res [list [dict create attributes $res value $value]]
	    dict lappend didl item \
	      [dict create attributes $attr contents $cont]
	}
	incr cnt
    }
    dict set rc Result [didl build $didl]
    dict set rc NumberReturned $cnt
    dict set rc TotalMatches $cnt
    dict set rc UpdateID $updateid
    return $rc
}

proc MediaServer::ContentDirectory::Control::Search {argdict} {
    # Input args:
    # ContainerID SearchCriteria Filter StartingIndex RequestedCount SortCriteria
}

proc MediaServer::ContentDirectory::Event {args} {
}

proc MediaServer::ConnectionManager::Control::GetProtocolInfo {argdict} {
    try {
	puts [info level 0]
	set src [mimetypes]
	set sink {}
	return [dict create Source [join $src ,] Sink [join $sink ,]]
    } on error {err info} {
	puts [dict get $info -errorinfo]
    }
}

proc MediaServer::ConnectionManager::Control::GetCurrentConnectionIDs {argdict} {
    return [dict create ConnectionIDs {}]
}

proc MediaServer::ConnectionManager::Control::GetCurrentConnectionInfo {argdict} {
}

proc MediaServer::ConnectionManager::Event {args} {
}

vwait forever

# Cleanup
upnp revoke
exit
