# android.tcl
#
# Display accelerometer values in stripchart items etc.

package require vu

array set V { 1 0 2 0 3 0 }

proc resize {c} {
    set coords {0 0}
    lappend coords [winfo width $c] [winfo height $c]
    foreach tag {Axis1 Axis2 Axis3} {
	eval .c coords $tag $coords
    }
}

proc addpoint {c axis value} {
    set ::V($axis) $value
    if {$axis == 3} {
	foreach axis {1 2 3} {
	    set ::V(Axis${axis}) $::V($axis)
	    $c itemconfigure Axis${axis} -values [expr {$::V($axis) + 32768.0}]
	    set v [expr {0.8 * ($::V($axis) + 32768.0) / 65536.0}]
	    $c itemconfigure st_Axis${axis} \
		-rely [expr {0.9 - $v}] -relheight $v
	}
    }
}

wm attributes . -fullscreen 1
catch {borg screenorientation landscape}

canvas .c -background black -borderwidth 0 -highlightthickness 0

foreach y {20 140 260} tag {Axis1 Axis2 Axis3} color {red green blue} {
    set item [.c create stripchart 0 0 100 100]
    .c itemconfigure $item -fill {} -jumpscroll 0 -outline {} \
	-scaleline {} -stripline $color -tags $tag -scalevalue 65536.0
    set item [.c create sticker 20 $y 70 [expr 100 + $y]]
    .c itemconfigure $item -anchor center -bar $color -color black \
	-fill white -outline {} -relheight 0 -relwidth 0.8 -relx 0.1 -rely 0.1 \
        -space 0 -tags [list st st_$tag] -text $tag -width 0 -orient vertical \
	-minwidth 0 -minheight 0 -maxwidth 32767 -maxheight 32767
    ::vu::dial .c.d$tag -label $tag -from -32768.0 -to 32768.0 \
	-resolution 512.0 -minortickinterval 0 -tickinterval 0 \
        -beginangle -20 -endangle 260 -variable ::V($tag) \
	-font {{DejaVu Sans} -16}
    set item [.c create window 120 $y -anchor nw -window .c.d$tag]
}

.c raise st

bind .c <Configure> {resize %W}
bind all <Key-Break> exit
bind . <<Accelerometer>> {addpoint .c %s %x}

pack .c -fill both -expand 1

sdltk accelerometer on
